<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of reports
 *
 * @author USER
 */
class Reports extends Admin_Controller{
    
    private $error;
    private $success;
    
    function __construct() {
        parent::__construct();
        
        $this->form_validation->set_error_delimiters('<dd class="error">', '</dd>');  
        
    }

    //put your code here
    private function handle_error($err) {
        $this->error .= $err . "\r\n";
    }

    private function handle_success($succ) {
        $this->success .= $succ . "\r\n";
    }
    
    //put your code here
    function index(){
        $this->data['siteTitle'] = 'Reports';
        
        $config = array();
        $config["base_url"] = base_url() . "reports/index";
        $config["total_rows"] = $this->report->reservation_count();
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_link'] = '&gt;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';

        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $config['first_link'] = '&lt;&lt;';
        $config['last_link'] = '&gt;&gt;';
        
 
        $this->pagination->initialize($config);
 
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        
        $this->data["results"] = $this->report->fatch_reservation($config["per_page"], $page);
        $this->data["links"] = $this->pagination->create_links();
        
        $this->load->view('reports', $this->data);
    }
    
    function view($id){
        $this->data['result'] = $this->report->fatch($id);
        
        $this->load->view('viewReport', $this->data);
        
    }
    
    function generate(){
        
        $this->load->view('generateReport', $this->data);
    }
    
    function pdf()
    {
        $this->load->library('mpdf');
        
        $data['results'] = $this->report->get_report($this->input->post('date'));
        
        $this->load->view('pdf',$data);
        
        /*$data['student']=$this->person->get_persons();
        $this->load->view('pdf',$data);*/
    }
}
