<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Dashboard
 *
 * @author Hasib
 */
class Dashboard extends Admin_Controller{
    
    private $error;
    private $success;
    
    function __construct() {
        parent::__construct();
        
        $this->form_validation->set_error_delimiters('<dd class="error">', '</dd>');  
        
    }

    //put your code here
    private function handle_error($err) {
        $this->error .= $err . "\r\n";
    }

    private function handle_success($succ) {
        $this->success .= $succ . "\r\n";
    }
    
    //put your code here
    
    function index(){
        
        $config = array();
        $config["base_url"] = base_url() . "dashboard/index/";
        $config["total_rows"] = $this->login->user_count();
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_link'] = '&gt;';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';

        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $config['first_link'] = '&lt;&lt;';
        $config['last_link'] = '&gt;&gt;';
        
 
        $this->pagination->initialize($config);
 
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        
        $this->data["users"] = $this->login->fatch_user($config["per_page"], $page);
        $this->data["links"] = $this->pagination->create_links();
        
        $this->load->view('dashboard', $this->data);
    }
    
    function editUser($id = NUll) {
        
        $this->data['siteTitle'] = 'Edit User';
        
        if ($id) {
            $this->data['user'] = $this->login->get($id);
            count($this->data['user']) || $this->data['errors'][] = 'User could not be found';
            
            $rules = $this->login->rules_admin;
            $id || $rules['password']['rules'] .= '|required';
            $this->form_validation->set_rules($rules);

            if ($this->form_validation->run() == TRUE) {
                $data = $this->login->array_from_post(array('name', 'email'));
                $this->login->save($data, $id);
                redirect('dashboard');
            }            
        }
        
        $this->data['errors'] = $this->error;
        $this->data['success'] = $this->success;
        
        $this->load->view('editUser', $this->data);
        
    }
    
    function deleteUser($id = NULL){
        
        $this->login->delete($id);
        redirect('dashboard');
        
    }
    
}
