<?php
class User_m extends MY_Model
{
	
    protected $_table_name = 'tbl_user';
    protected $_order_by = 'id';
    public $rules_admin = array(
        'user_name' => array(
            'field' => 'name', 
            'label' => 'User Name', 
            'rules' => 'trim|required|xss_clean'
        ), 
        'email' => array(
            'field' => 'email', 
            'label' => 'Email', 
            'rules' => 'trim|required|valid_email|xss_clean'
        ), 
        'password' => array(
            'field' => 'password', 
            'label' => 'Password', 
            'rules' => 'trim|matches[password_confirm]'
        ),
        'password_confirm' => array(
            'field' => 'password_confirm', 
            'label' => 'Confirm password', 
            'rules' => 'trim|matches[password]'
        ),
    );
    
    
    public function get_new(){
        $user = new stdClass();
        $user->name = '';
        $user->user_name = '';
        $user->email = '';
        $user->password = '';
        $user->user_type = '';
        return $user;
    }
    
    function get_waiter(){
        $this->db->select('*');
        $this->db->where('user_type','waiter');
        $query_result = $this->db->get('tbl_user');
        $categorys = $query_result->result();

        // Return key => value pair array
        $array = array(
                0 => 'Select Waiter'
        );
        if (count($categorys)) {
                foreach ($categorys as $category) {
                    $array[$category->name] = $category->name;
                }
        }

        return $array;
    }

    public function hash ($string)
    {
        return hash('sha512', $string . config_item('encryption_key'));
    }
}