<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of login
 *
 * @author Hasib
 */
class Login_m extends MY_Model{
    
    protected $_table_name = 'tbl_user';
    protected $_order_by = 'id';
    public $rules_admin = array(
        'name' => array(
            'field' => 'name', 
            'label' => 'Full Name', 
            'rules' => 'trim|required|xss_clean'
        ), 
        'email' => array(
            'field' => 'email', 
            'label' => 'Email', 
            'rules' => 'trim|required|valid_email|xss_clean'
        )
    );
    
    public $rules_login = array(
        'user_name' => array(
            'field' => 'user_name', 
            'label' => 'User Name', 
            'rules' => 'trim|required|xss_clean'
        ), 
        'password' => array(
            'field' => 'password', 
            'label' => 'Password', 
            'rules' => 'trim|required'
        )
    );
    
    public $rules_server_login = array(
        'id' => array(
            'field' => 'id', 
            'label' => 'User ID', 
            'rules' => 'trim|required|xss_clean'
        ), 
    );
    
    function __construct() {
        parent::__construct();
    }
    
    //put your code here
    public function login ()
    {
        $admin = $this->get_by(array(
            'user_name' => $this->input->post('user_name'),
            'password' => $this->hash($this->input->post('password')),
        ), TRUE);

        //var_dump($admin); exit();
        
        if (count($admin)) {
            // Log in user
            $data = array(
                'email' => $admin->email,
                'name' => $admin->name,
                'user_name' => $admin->name,
                'user_type' => $admin->user_type, 
                'id' => $admin->id,
                'loggedin' => TRUE,
            );
            $this->session->set_userdata($data);
            return TRUE;
        }

        // If we get to here then login did not succeed
        return FALSE;
    }
    
    public function server_login ()
    {
        $admin = $this->get_by(array(
            'id' => $this->input->post('id'),
        ), TRUE);

        //var_dump($admin); exit();
        
        if (count($admin)) {
            // Log in user
            $data = array(
                'email' => $admin->email,
                'name' => $admin->name,
                'user_name' => $admin->name,
                'user_type' => $admin->user_type, 
                'id' => $admin->id,
                'loggedin' => TRUE,
            );
            $this->session->set_userdata($data);
            return TRUE;
        }

        // If we get to here then login did not succeed
        return FALSE;
    }
    
    public function loggedin ()
    {
        return (bool) $this->session->userdata('loggedin');
    }

    public function logout ()
    {
        $this->session->sess_destroy();
    }

    public function hash ($string)
    {
        return hash('sha512', $string . config_item('encryption_key'));
    }
    
    public function user_count() {        
        return $this->db->count_all_results('tbl_user');        
    }
    
    public function fatch_user($limit, $start){
        
        $this->db->select('*');
        $this->db->group_by('tbl_user.id');
        $this->db->order_by("tbl_user.id", "DESC");
        $this->db->limit($limit, $start);     
        return parent::get();
        
    }
    
}
