<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends Frontend_Controller {

    private $error;
    private $success;
    
    function __construct() {
        parent::__construct();
        
        $this->form_validation->set_error_delimiters('<dd class="error">', '</dd>');  
        
    }

    //put your code here
    private function handle_error($err) {
        $this->error .= $err . "\r\n";
    }

    private function handle_success($succ) {
        $this->success .= $succ . "\r\n";
    }
    
    //put your code here
    function index(){
        $this->data['siteTitle'] = 'Reservation';
        
        $this->load->view('barview1', $this->data);
    }
    
    function loadMap(){
        $date = $this->input->post('date');
        
        echo '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="821.845px" height="577.171px" viewBox="0 0 821.845 577.171" enable-background="new 0 0 821.845 577.171"
	 xml:space="preserve">
<g class="disabled">
	<path class="disabled" d="M-16.805-69.913c-0.084-0.508-0.157-1.173-0.157-2.019c0-1.039,0.242-1.801,0.677-2.284
		c0.387-0.447,0.979-0.713,1.704-0.713c0.737,0,1.317,0.218,1.74,0.628c0.592,0.557,0.895,1.463,0.895,2.49
		c0,0.313-0.012,0.604-0.072,0.846h3.263v1.052H-16.805z M-12.877-70.964c0.061-0.229,0.085-0.52,0.085-0.87
		c0-1.27-0.617-2.043-1.74-2.043c-1.076,0-1.596,0.762-1.596,1.922c0,0.459,0.037,0.81,0.085,0.991H-12.877z"/>
	<path class="disabled" d="M-12.78-76.113c-0.688,0-1.281,0.012-1.825,0.048v-0.931l1.148-0.036v-0.048c-0.785-0.267-1.281-0.907-1.281-1.62
		c0-0.12,0.012-0.205,0.036-0.302h1.003c-0.024,0.108-0.036,0.218-0.036,0.362c0,0.75,0.568,1.281,1.366,1.426
		c0.145,0.024,0.314,0.049,0.495,0.049h3.118v1.052H-12.78z"/>
	<path class="disabled" d="M-12.333-89.528c-1.136,0.06-2.501,0.133-3.517,0.12v0.036c0.955,0.278,1.97,0.617,3.094,1.027l3.952,1.438v0.798
		l-3.879,1.316c-1.148,0.387-2.199,0.714-3.166,0.943v0.023c1.015,0.024,2.381,0.085,3.601,0.157l3.493,0.218v1.003l-8.146-0.567
		v-1.342l3.94-1.39c1.003-0.339,1.897-0.616,2.743-0.822v-0.036c-0.822-0.205-1.716-0.495-2.743-0.857l-3.94-1.45v-1.342
		l8.146-0.508v1.027L-12.333-89.528z"/>
	<path class="disabled" d="M-8.756-95.656l-0.737,0.085v0.036c0.459,0.326,0.87,0.954,0.87,1.788c0,1.185-0.834,1.789-1.68,1.789
		c-1.414,0-2.188-1.257-2.175-3.517h-0.121c-0.483,0-1.354,0.133-1.354,1.329c0,0.544,0.169,1.111,0.435,1.522l-0.701,0.242
		c-0.314-0.483-0.52-1.185-0.52-1.922c0-1.788,1.22-2.224,2.393-2.224h2.188c0.507,0,1.003-0.024,1.402-0.097V-95.656z
		 M-11.741-95.499c-0.024,1.16,0.181,2.478,1.317,2.478c0.689,0,1.016-0.459,1.016-1.003c0-0.762-0.483-1.245-0.979-1.414
		c-0.109-0.036-0.23-0.061-0.338-0.061H-11.741z"/>
	<path class="disabled" d="M-13.022-98.242c-0.604,0-1.1,0.012-1.583,0.048v-0.942l0.967-0.061v-0.024c-0.556-0.29-1.1-0.967-1.1-1.934
		c0-0.81,0.483-2.066,2.489-2.066h3.493v1.063h-3.372c-0.943,0-1.728,0.351-1.728,1.354c0,0.701,0.495,1.245,1.087,1.426
		c0.133,0.049,0.314,0.073,0.496,0.073h3.517v1.063H-13.022z"/>
	<path class="disabled" d="M-8.756-108.188l-0.737,0.085v0.036c0.459,0.326,0.87,0.955,0.87,1.788c0,1.185-0.834,1.789-1.68,1.789
		c-1.414,0-2.188-1.257-2.175-3.517h-0.121c-0.483,0-1.354,0.133-1.354,1.329c0,0.544,0.169,1.112,0.435,1.522l-0.701,0.242
		c-0.314-0.483-0.52-1.185-0.52-1.922c0-1.788,1.22-2.224,2.393-2.224h2.188c0.507,0,1.003-0.024,1.402-0.097V-108.188z
		 M-11.741-108.031c-0.024,1.16,0.181,2.478,1.317,2.478c0.689,0,1.016-0.459,1.016-1.003c0-0.762-0.483-1.245-0.979-1.414
		c-0.109-0.036-0.23-0.061-0.338-0.061H-11.741z"/>
	<path class="disabled" d="M-14.605-115.814c0.423,0.024,0.894,0.049,1.607,0.049h3.396c1.341,0,2.163,0.266,2.67,0.834
		c0.532,0.567,0.701,1.39,0.701,2.127c0,0.7-0.169,1.474-0.483,1.945l-0.81-0.266c0.242-0.387,0.459-0.991,0.459-1.716
		c0-1.088-0.568-1.886-2.042-1.886h-0.652v0.024c0.544,0.326,0.979,0.954,0.979,1.861c0,1.449-1.232,2.489-2.852,2.489
		c-1.982,0-3.106-1.293-3.106-2.635c0-1.015,0.532-1.571,1.015-1.825v-0.023l-0.882-0.049V-115.814z M-12.297-114.714
		c-0.181,0-0.338,0.013-0.483,0.061c-0.616,0.193-1.124,0.713-1.124,1.486c0,1.016,0.858,1.74,2.212,1.74
		c1.148,0,2.103-0.58,2.103-1.728c0-0.652-0.411-1.245-1.087-1.475c-0.181-0.061-0.387-0.085-0.568-0.085H-12.297z"/>
	<path class="disabled" d="M-11.487-118.123c1.438-0.024,2.03-0.942,2.03-2.006c0-0.762-0.133-1.221-0.302-1.619l0.761-0.182
		c0.169,0.375,0.363,1.016,0.363,1.946c0,1.8-1.185,2.876-2.949,2.876c-1.764,0-3.154-1.04-3.154-2.743
		c0-1.91,1.68-2.417,2.755-2.417c0.217,0,0.387,0.023,0.495,0.036V-118.123z M-12.249-121.241c-0.677-0.012-1.728,0.278-1.728,1.475
		c0,1.076,0.991,1.547,1.728,1.632V-121.241z"/>
	<path class="disabled" d="M-12.78-123.584c-0.688,0-1.281,0.012-1.825,0.048v-0.931l1.148-0.036v-0.048c-0.785-0.267-1.281-0.906-1.281-1.62
		c0-0.12,0.012-0.205,0.036-0.302h1.003c-0.024,0.108-0.036,0.218-0.036,0.362c0,0.749,0.568,1.281,1.366,1.427
		c0.145,0.023,0.314,0.048,0.495,0.048h3.118v1.052H-12.78z"/>
	<path class="disabled" d="M-13.638-127.393c-0.447,0-0.761-0.302-0.761-0.725s0.314-0.701,0.761-0.713c0.423,0,0.75,0.277,0.75,0.725
		C-12.889-127.682-13.215-127.393-13.638-127.393z M-9.372-127.393c-0.447,0-0.762-0.302-0.762-0.725s0.314-0.701,0.762-0.713
		c0.423,0,0.749,0.277,0.749,0.725C-8.623-127.682-8.949-127.393-9.372-127.393z"/>
	<path class="disabled" d="M1.783-75.303c2.429,0,4.097,0.979,4.097,2.985c0,2.03-1.825,2.925-4.048,2.937c-2.272,0-4.073-0.967-4.073-2.997
		C-2.241-74.481-0.368-75.303,1.783-75.303z M1.832-71.23c1.801,0.012,2.659-0.423,2.659-1.137c0-0.713-0.895-1.1-2.683-1.1
		c-1.74,0-2.659,0.375-2.659,1.112C-0.852-71.677,0.007-71.218,1.832-71.23z"/>
	<path class="disabled" d="M-0.477-78.553v0.023l0.713,1.499l-1.378,0.302l-0.967-2.078v-1.523h7.855v1.777H-0.477z"/>
	<path class="disabled" d="M-0.803-87.931c-0.012,0.205,0,0.423,0.024,0.713c0.133,1.631,0.967,2.356,1.885,2.562v-0.036
		c-0.399-0.387-0.628-0.931-0.628-1.668c0-1.317,0.931-2.429,2.562-2.429c1.559,0,2.84,1.196,2.84,2.9
		c0,2.091-1.559,3.118-3.432,3.118c-1.474,0-2.707-0.544-3.493-1.39c-0.713-0.786-1.1-1.801-1.16-3.033
		c-0.024-0.339-0.024-0.557-0.012-0.737H-0.803z M3.137-86.928c-0.725,0-1.354,0.387-1.354,1.172c0,0.496,0.302,0.906,0.701,1.088
		c0.097,0.048,0.241,0.072,0.459,0.072c0.834-0.036,1.583-0.435,1.583-1.269C4.526-86.518,3.935-86.928,3.137-86.928z"/>
	<path class="disabled" d="M-0.803-97.08c-0.012,0.205,0,0.423,0.024,0.713c0.133,1.631,0.967,2.356,1.885,2.562v-0.036
		c-0.399-0.387-0.628-0.931-0.628-1.668c0-1.317,0.931-2.429,2.562-2.429c1.559,0,2.84,1.196,2.84,2.9
		c0,2.091-1.559,3.118-3.432,3.118c-1.474,0-2.707-0.544-3.493-1.39c-0.713-0.786-1.1-1.801-1.16-3.033
		c-0.024-0.339-0.024-0.557-0.012-0.737H-0.803z M3.137-96.077c-0.725,0-1.354,0.387-1.354,1.172c0,0.496,0.302,0.906,0.701,1.088
		c0.097,0.048,0.241,0.072,0.459,0.072c0.834-0.036,1.583-0.435,1.583-1.269C4.526-95.667,3.935-96.077,3.137-96.077z"/>
	<path class="disabled" d="M4.418-99.352c0.024-0.229,0.024-0.435,0-0.797c-0.037-0.557-0.193-1.124-0.483-1.547c-0.351-0.508-0.858-0.847-1.45-0.991
		l-0.012,0.036c0.362,0.351,0.568,0.857,0.568,1.571c0,1.329-0.931,2.453-2.453,2.453c-1.535,0-2.828-1.233-2.828-2.961
		c0-2.019,1.547-2.973,3.384-2.973c1.632,0,2.828,0.52,3.613,1.377c0.677,0.75,1.052,1.776,1.1,2.997
		c0.024,0.314,0.012,0.629,0,0.834H4.418z M0.478-100.463c0.677,0,1.257-0.363,1.257-1.112c0-0.495-0.242-0.846-0.52-1.015
		c-0.109-0.061-0.23-0.097-0.459-0.097c-0.834,0-1.655,0.313-1.655,1.147C-0.899-100.911-0.344-100.452,0.478-100.463z"/>
	<path class="disabled" d="M3.946-105.805c0.169-0.326,0.483-1.075,0.483-1.824c0-0.955-0.459-1.438-1.051-1.438c-0.773,0-1.124,0.773-1.124,1.583
		v0.749H0.938v-0.713c-0.012-0.616-0.242-1.401-0.907-1.401c-0.471,0-0.822,0.387-0.822,1.16c0,0.641,0.278,1.316,0.472,1.644
		l-1.33,0.374c-0.302-0.471-0.592-1.414-0.592-2.429c0-1.68,0.882-2.61,1.958-2.61c0.834,0,1.486,0.471,1.825,1.438h0.024
		c0.169-0.942,0.882-1.703,1.91-1.703c1.39,0,2.405,1.221,2.405,3.214c0,1.016-0.266,1.874-0.556,2.333L3.946-105.805z"/>
	<path class="disabled" d="M4.418-115.208c0.024-0.229,0.024-0.435,0-0.797c-0.037-0.557-0.193-1.124-0.483-1.547
		c-0.351-0.508-0.858-0.847-1.45-0.991l-0.012,0.036c0.362,0.351,0.568,0.857,0.568,1.571c0,1.329-0.931,2.453-2.453,2.453
		c-1.535,0-2.828-1.233-2.828-2.961c0-2.019,1.547-2.973,3.384-2.973c1.632,0,2.828,0.52,3.613,1.377
		c0.677,0.75,1.052,1.776,1.1,2.997c0.024,0.314,0.012,0.629,0,0.834H4.418z M0.478-116.319c0.677,0,1.257-0.363,1.257-1.112
		c0-0.495-0.242-0.846-0.52-1.015c-0.109-0.061-0.23-0.097-0.459-0.097c-0.834,0-1.655,0.313-1.655,1.147
		C-0.899-116.766-0.344-116.307,0.478-116.319z"/>
	<path class="disabled" d="M-0.598-126.579v3.045l1.208,0.169c-0.024-0.169-0.024-0.313-0.024-0.507c0-0.75,0.169-1.511,0.568-2.067
		c0.399-0.592,1.051-0.954,1.97-0.954c1.462,0,2.755,1.257,2.755,3.371c0,0.955-0.217,1.753-0.447,2.188l-1.377-0.326
		c0.169-0.351,0.387-1.063,0.387-1.776c0-0.762-0.363-1.571-1.196-1.571c-0.81,0-1.305,0.641-1.305,2.212
		c0,0.435,0.024,0.737,0.072,1.063l-4.121-0.52v-4.326H-0.598z"/>
	<path class="disabled" d="M-2.108-133.672h1.16l6.695,3.238v1.945l-6.32-3.238h-0.024v3.602h-1.511V-133.672z"/>
	<path class="disabled" d="M5.747-134.749H4.635l-0.918-1.015c-1.535-1.716-2.417-2.55-3.335-2.574c-0.641,0-1.148,0.387-1.148,1.293
		c0,0.677,0.338,1.269,0.652,1.68l-1.317,0.52c-0.447-0.592-0.81-1.511-0.81-2.574c0-1.776,1.04-2.755,2.465-2.755
		c1.317,0,2.369,0.955,3.384,2.091l0.604,0.725h0.024v-2.961h1.511V-134.749z"/>
	<path class="disabled" d="M-51.779-56.291c2.804,0,4.29,1.703,4.29,3.782c0,2.151-1.667,3.661-4.133,3.661c-2.586,0-4.278-1.606-4.278-3.782
		C-55.9-54.853-54.196-56.291-51.779-56.291z M-51.646-49.97c1.74,0,3.299-0.943,3.299-2.599c0-1.668-1.535-2.61-3.384-2.61
		c-1.62,0-3.311,0.846-3.311,2.599C-55.042-50.84-53.435-49.97-51.646-49.97z"/>
	<path class="disabled" d="M-49.217-62.551c0.604,0,1.136-0.013,1.595-0.049v0.942l-0.955,0.061v0.024c0.471,0.278,1.087,0.895,1.087,1.934
		c0,0.919-0.507,2.019-2.562,2.019h-3.42v-1.063h3.239c1.112,0,1.861-0.339,1.861-1.306c0-0.713-0.496-1.208-0.967-1.401
		c-0.157-0.061-0.351-0.097-0.544-0.097h-3.589v-1.063H-49.217z"/>
	<path class="disabled" d="M-55.151-65.597h1.68v-1.522h0.81v1.522h3.154c0.725,0,1.136-0.205,1.136-0.798c0-0.278-0.037-0.483-0.073-0.616
		l0.797-0.049c0.085,0.206,0.146,0.532,0.146,0.943c0,0.495-0.157,0.895-0.447,1.147c-0.314,0.303-0.834,0.411-1.523,0.411h-3.19
		v0.906h-0.81v-0.906h-1.402L-55.151-65.597z"/>
	<path class="disabled" d="M-56.202-68.316v-1.063h8.58v1.063H-56.202z"/>
	<path class="disabled" d="M-50.354-71.761c1.438-0.023,2.03-0.942,2.03-2.006c0-0.762-0.133-1.221-0.302-1.619l0.761-0.182
		c0.169,0.375,0.363,1.016,0.363,1.945c0,1.801-1.185,2.877-2.949,2.877c-1.764,0-3.154-1.039-3.154-2.743
		c0-1.91,1.68-2.417,2.755-2.417c0.217,0,0.387,0.023,0.495,0.036V-71.761z M-51.115-74.878c-0.677-0.013-1.728,0.277-1.728,1.474
		c0,1.076,0.991,1.547,1.728,1.632V-74.878z"/>
	<path class="disabled" d="M-55.151-78.504h1.68v-1.522h0.81v1.522h3.154c0.725,0,1.136-0.206,1.136-0.798c0-0.277-0.037-0.483-0.073-0.616
		l0.797-0.048c0.085,0.205,0.146,0.531,0.146,0.942c0,0.495-0.157,0.894-0.447,1.147c-0.314,0.303-0.834,0.411-1.523,0.411h-3.19
		v0.906h-0.81v-0.906h-1.402L-55.151-78.504z"/>
	<path class="disabled" d="M-51.199-90.687c-1.136,0.061-2.501,0.134-3.517,0.121v0.036c0.955,0.278,1.97,0.616,3.094,1.027l3.952,1.438v0.798
		l-3.879,1.317c-1.148,0.387-2.199,0.713-3.166,0.942v0.024c1.015,0.023,2.381,0.084,3.601,0.156l3.493,0.218v1.003l-8.146-0.567
		v-1.342l3.94-1.39c1.003-0.339,1.897-0.616,2.743-0.822v-0.036c-0.822-0.205-1.716-0.495-2.743-0.857l-3.94-1.45v-1.342
		l8.146-0.508v1.027L-51.199-90.687z"/>
	<path class="disabled" d="M-47.622-96.814l-0.737,0.085v0.036c0.459,0.326,0.87,0.955,0.87,1.788c0,1.185-0.834,1.789-1.68,1.789
		c-1.414,0-2.188-1.257-2.175-3.517h-0.121c-0.483,0-1.354,0.133-1.354,1.329c0,0.544,0.169,1.112,0.435,1.522l-0.701,0.242
		c-0.314-0.483-0.52-1.185-0.52-1.922c0-1.788,1.22-2.224,2.393-2.224h2.188c0.507,0,1.003-0.024,1.402-0.097V-96.814z
		 M-50.607-96.657c-0.024,1.16,0.181,2.478,1.317,2.478c0.689,0,1.016-0.459,1.016-1.003c0-0.762-0.483-1.245-0.979-1.414
		c-0.109-0.036-0.23-0.061-0.338-0.061H-50.607z"/>
	<path class="disabled" d="M-51.888-99.4c-0.604,0-1.1,0.012-1.583,0.048v-0.942l0.967-0.061v-0.024c-0.556-0.29-1.1-0.967-1.1-1.934
		c0-0.81,0.483-2.066,2.489-2.066h3.493v1.063h-3.372c-0.943,0-1.728,0.351-1.728,1.354c0,0.701,0.495,1.245,1.087,1.426
		c0.133,0.049,0.314,0.073,0.496,0.073h3.517v1.063H-51.888z"/>
	<path class="disabled" d="M-47.622-109.346l-0.737,0.085v0.036c0.459,0.326,0.87,0.954,0.87,1.788c0,1.185-0.834,1.789-1.68,1.789
		c-1.414,0-2.188-1.257-2.175-3.517h-0.121c-0.483,0-1.354,0.133-1.354,1.329c0,0.544,0.169,1.111,0.435,1.522l-0.701,0.242
		c-0.314-0.483-0.52-1.185-0.52-1.922c0-1.788,1.22-2.224,2.393-2.224h2.188c0.507,0,1.003-0.024,1.402-0.097V-109.346z
		 M-50.607-109.189c-0.024,1.16,0.181,2.478,1.317,2.478c0.689,0,1.016-0.459,1.016-1.003c0-0.762-0.483-1.245-0.979-1.414
		c-0.109-0.036-0.23-0.061-0.338-0.061H-50.607z"/>
	<path class="disabled" d="M-53.471-116.972c0.423,0.024,0.894,0.049,1.607,0.049h3.396c1.341,0,2.163,0.266,2.67,0.834
		c0.532,0.567,0.701,1.39,0.701,2.127c0,0.7-0.169,1.474-0.483,1.945l-0.81-0.266c0.242-0.387,0.459-0.991,0.459-1.717
		c0-1.087-0.568-1.885-2.042-1.885h-0.652v0.024c0.544,0.326,0.979,0.954,0.979,1.86c0,1.451-1.232,2.49-2.852,2.49
		c-1.982,0-3.106-1.293-3.106-2.635c0-1.016,0.532-1.571,1.015-1.825v-0.023l-0.882-0.049V-116.972z M-51.163-115.873
		c-0.181,0-0.338,0.013-0.483,0.061c-0.616,0.193-1.124,0.713-1.124,1.486c0,1.016,0.858,1.74,2.212,1.74
		c1.148,0,2.103-0.58,2.103-1.728c0-0.653-0.411-1.245-1.087-1.475c-0.181-0.061-0.387-0.085-0.568-0.085H-51.163z"/>
	<path class="disabled" d="M-50.354-119.281c1.438-0.023,2.03-0.942,2.03-2.006c0-0.762-0.133-1.221-0.302-1.619l0.761-0.182
		c0.169,0.375,0.363,1.016,0.363,1.945c0,1.801-1.185,2.877-2.949,2.877c-1.764,0-3.154-1.039-3.154-2.743
		c0-1.91,1.68-2.417,2.755-2.417c0.217,0,0.387,0.023,0.495,0.036V-119.281z M-51.115-122.398c-0.677-0.013-1.728,0.277-1.728,1.474
		c0,1.076,0.991,1.547,1.728,1.632V-122.398z"/>
	<path class="disabled" d="M-51.646-124.743c-0.688,0-1.281,0.012-1.825,0.048v-0.931l1.148-0.036v-0.048c-0.785-0.267-1.281-0.907-1.281-1.62
		c0-0.12,0.012-0.205,0.036-0.302h1.003c-0.024,0.108-0.036,0.218-0.036,0.362c0,0.75,0.568,1.281,1.366,1.426
		c0.145,0.024,0.314,0.049,0.495,0.049h3.118v1.052H-51.646z"/>
	<path class="disabled" d="M-52.504-128.55c-0.447,0-0.761-0.302-0.761-0.725s0.314-0.701,0.761-0.713c0.423,0,0.75,0.277,0.75,0.725
		C-51.755-128.839-52.082-128.55-52.504-128.55z M-48.238-128.55c-0.447,0-0.762-0.302-0.762-0.725s0.314-0.701,0.762-0.713
		c0.423,0,0.749,0.277,0.749,0.725C-47.489-128.839-47.815-128.55-48.238-128.55z"/>
	<path class="disabled" d="M-37.083-54.72c2.429,0,4.097,0.979,4.097,2.985c0,2.03-1.825,2.925-4.048,2.937c-2.272,0-4.073-0.967-4.073-2.997
		C-41.107-53.898-39.234-54.72-37.083-54.72z M-37.035-50.647c1.801,0.012,2.659-0.423,2.659-1.137c0-0.713-0.895-1.1-2.683-1.1
		c-1.74,0-2.659,0.375-2.659,1.112C-39.718-51.094-38.859-50.635-37.035-50.647z"/>
	<path class="disabled" d="M-39.343-57.97v0.023l0.713,1.499l-1.378,0.302l-0.967-2.078v-1.523h7.855v1.777H-39.343z"/>
	<path class="disabled" d="M-34.448-62.914c0.024-0.229,0.024-0.435,0-0.797c-0.037-0.557-0.193-1.124-0.483-1.547
		c-0.351-0.508-0.858-0.847-1.45-0.991l-0.012,0.036c0.362,0.351,0.568,0.857,0.568,1.571c0,1.329-0.931,2.453-2.453,2.453
		c-1.535,0-2.828-1.233-2.828-2.961c0-2.019,1.547-2.973,3.384-2.973c1.632,0,2.828,0.52,3.613,1.377
		c0.677,0.75,1.052,1.776,1.1,2.997c0.024,0.314,0.012,0.629,0,0.834H-34.448z M-38.388-64.025c0.677,0,1.257-0.363,1.257-1.112
		c0-0.495-0.242-0.846-0.52-1.015c-0.109-0.061-0.23-0.097-0.459-0.097c-0.834,0-1.655,0.313-1.655,1.147
		C-39.766-64.472-39.21-64.013-38.388-64.025z"/>
	<path class="disabled" d="M-39.464-76.726v3.045l1.208,0.169c-0.024-0.169-0.024-0.313-0.024-0.507c0-0.75,0.169-1.511,0.568-2.067
		c0.399-0.592,1.051-0.954,1.97-0.954c1.462,0,2.755,1.257,2.755,3.371c0,0.955-0.217,1.753-0.447,2.188l-1.377-0.326
		c0.169-0.351,0.387-1.063,0.387-1.776c0-0.762-0.363-1.571-1.196-1.571c-0.81,0-1.305,0.641-1.305,2.212
		c0,0.435,0.024,0.737,0.072,1.063l-4.121-0.52v-4.326H-39.464z"/>
	<path class="disabled" d="M-34.448-78.769c0.024-0.229,0.024-0.435,0-0.797c-0.037-0.557-0.193-1.124-0.483-1.547
		c-0.351-0.508-0.858-0.847-1.45-0.991l-0.012,0.036c0.362,0.351,0.568,0.857,0.568,1.571c0,1.329-0.931,2.453-2.453,2.453
		c-1.535,0-2.828-1.233-2.828-2.961c0-2.019,1.547-2.973,3.384-2.973c1.632,0,2.828,0.52,3.613,1.377
		c0.677,0.75,1.052,1.776,1.1,2.997c0.024,0.314,0.012,0.629,0,0.834H-34.448z M-38.388-79.88c0.677,0,1.257-0.363,1.257-1.112
		c0-0.495-0.242-0.846-0.52-1.015c-0.109-0.061-0.23-0.097-0.459-0.097c-0.834,0-1.655,0.313-1.655,1.147
		C-39.766-80.328-39.21-79.869-38.388-79.88z"/>
	<path class="disabled" d="M-37.083-90.697c2.429,0,4.097,0.979,4.097,2.985c0,2.03-1.825,2.925-4.048,2.937c-2.272,0-4.073-0.967-4.073-2.997
		C-41.107-89.875-39.234-90.697-37.083-90.697z M-37.035-86.624c1.801,0.012,2.659-0.423,2.659-1.137c0-0.713-0.895-1.1-2.683-1.1
		c-1.74,0-2.659,0.375-2.659,1.112C-39.718-87.071-38.859-86.612-37.035-86.624z"/>
	<path class="disabled" d="M-34.92-94.371c0.169-0.326,0.483-1.075,0.483-1.824c0-0.955-0.459-1.438-1.051-1.438c-0.773,0-1.124,0.773-1.124,1.583
		v0.749h-1.317v-0.713c-0.012-0.616-0.242-1.401-0.907-1.401c-0.471,0-0.822,0.387-0.822,1.16c0,0.641,0.278,1.316,0.472,1.644
		l-1.33,0.374c-0.302-0.471-0.592-1.414-0.592-2.429c0-1.68,0.882-2.61,1.958-2.61c0.834,0,1.486,0.471,1.825,1.438h0.024
		c0.169-0.942,0.882-1.703,1.91-1.703c1.39,0,2.405,1.221,2.405,3.214c0,1.016-0.266,1.874-0.556,2.333L-34.92-94.371z"/>
	<path class="disabled" d="M-33.119-100.751h-1.112l-0.918-1.015c-1.535-1.716-2.417-2.55-3.335-2.574c-0.641,0-1.148,0.387-1.148,1.293
		c0,0.677,0.338,1.269,0.652,1.68l-1.317,0.52c-0.447-0.592-0.81-1.511-0.81-2.574c0-1.776,1.04-2.755,2.465-2.755
		c1.317,0,2.369,0.955,3.384,2.091l0.604,0.725h0.024v-2.961h1.511V-100.751z"/>
	<path class="disabled" d="M-33.119-110.709h-1.873v3.48h-1.196l-4.786-2.973v-2.248h4.604v-0.942h1.378v0.942h1.873V-110.709z M-36.37-110.709h-1.74
		c-0.471,0-0.955-0.023-1.462-0.06v0.048c0.507,0.254,0.967,0.459,1.462,0.726l1.716,1.051h0.024V-110.709z"/>
	<path class="disabled" d="M-39.343-116.509v0.023l0.713,1.499l-1.378,0.302l-0.967-2.078v-1.523h7.855v1.777H-39.343z"/>
	
        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.8573" stroke-miterlimit="10" x1="-72.039" y1="-33.426" x2="-72.039" y2="-138.89"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.8573" stroke-miterlimit="10" x1="-24.694" y1="-46.383" x2="-24.694" y2="-151.847"/>
</g>
<g>
    <path focusable="false" id="s1" onClick="reply_click(this.id)" data-id="s1"';

        $result = $this->get_table_stat("s1", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" d="M325.933,378.149
            c0,4.173,5.566,7.559,12.436,7.559c6.869,0,12.44-3.386,12.44-7.559c0-4.176-5.571-7.563-12.44-7.563
            C331.5,370.586,325.933,373.973,325.933,378.149z"/>

    <ellipse id="s2" onClick="reply_click(this.id)" data-id="s2"';

        $result = $this->get_table_stat("s2", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" cx="338.371" cy="342.551" rx="12.438" ry="7.561"/>

    <path id="s3" onClick="reply_click(this.id)" data-id="s3"';

        $result = $this->get_table_stat("s3", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" d="M325.933,306.422
            c0,4.175,5.566,7.561,12.436,7.561c6.869-0.001,12.44-3.386,12.44-7.562c0-4.172-5.571-7.556-12.44-7.556
            C331.5,298.866,325.933,302.25,325.933,306.422z"/>

    <ellipse id="s4" onClick="reply_click(this.id)" data-id="s4"';

        $result = $this->get_table_stat("s4", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" cx="338.371" cy="270.292" rx="12.438" ry="7.561"/>

    <ellipse id="s5" onClick="reply_click(this.id)" data-id="s5"';

        $result = $this->get_table_stat("s5", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" cx="338.371" cy="234.936" rx="12.438" ry="7.561"/>

    <ellipse id="s10" onClick="reply_click(this.id)" data-id="s10"';

        $result = $this->get_table_stat("s10", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" cx="368.729" cy="378.149" rx="12.438" ry="7.559"/>

    <ellipse id="s9" onClick="reply_click(this.id)" data-id="s9"';

        $result = $this->get_table_stat("s9", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" cx="368.729" cy="342.551" rx="12.438" ry="7.561"/>

    <path id="s8" onClick="reply_click(this.id)" data-id="s8"';

        $result = $this->get_table_stat("s8", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" d="M356.291,306.421
            c0,4.176,5.567,7.561,12.437,7.561c6.868,0,12.439-3.385,12.439-7.561c0-4.172-5.571-7.556-12.439-7.556
            C361.858,298.866,356.291,302.25,356.291,306.421z"/>

    <ellipse id="s7" onClick="reply_click(this.id)" data-id="s7"';

        $result = $this->get_table_stat("s7", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" cx="368.729" cy="270.292" rx="12.438" ry="7.561"/>

    <ellipse id="s6" onClick="reply_click(this.id)" data-id="s6"';

        $result = $this->get_table_stat("s6", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7419" stroke-miterlimit="10" cx="368.729" cy="234.936" rx="12.438" ry="7.561"/>
        
    <path class="disabled" d="M50.766,356.631l-24.317,7.809l0.103,0.363c0.009,0.031,8.38,29.718,33.464,62.914
            c25.081,33.192,66.892,69.895,133.731,83.89l0.159-0.769c-66.626-13.953-108.263-50.512-133.265-83.596
            c-12.5-16.54-20.836-32.209-26.046-43.74c-2.604-5.768-4.428-10.5-5.6-13.787c-0.585-1.644-1.009-2.926-1.285-3.799
            c-0.133-0.422-0.23-0.74-0.297-0.963l-0.365,0.117l-0.119-0.373l0.378-0.105c0,0,0.035,0.125,0.106,0.361l23.529-7.557
            C50.882,357.142,50.83,356.888,50.766,356.631z"/>
    <path class="disabled" d="M26.928,364.698l0.119,0.373l0.365-0.117c-0.071-0.236-0.106-0.361-0.106-0.361L26.928,364.698z"/>
    <path class="disabled" d="M83.84,346.834l17.122-5.5l-0.239-0.746l-17.018,5.466C83.752,346.314,83.797,346.574,83.84,346.834z"/>

    <rect class="disabled" x="312.143" y="495.747" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="312.637" height="3.919"/>

    <rect class="disabled" x="318.02" y="508.872" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="65.034" height="65.035"/>

    <rect class="disabled" x="386.189" y="508.872" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="65.035" height="65.035"/>

    <rect class="disabled" x="453.968" y="508.872" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="65.031" height="65.035"/>

    <rect class="disabled" x="522.526" y="508.872" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="65.035" height="65.035"/>

    <rect class="disabled" x="331.731" y="537.079" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="35.26" height="33.302"/>

    <line class="disabled" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="366.89" y1="570.489" x2="331.831" y2="536.973"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="331.731" y1="570.38" x2="366.991" y2="537.079"/>

    <rect class="disabled" x="400.292" y="537.079" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="35.259" height="33.302"/>

    <line class="disabled" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="435.45" y1="570.489" x2="400.393" y2="536.973"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="400.292" y1="570.38" x2="435.552" y2="537.079"/>

    <rect class="disabled" x="468.46" y="537.079" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="35.262" height="33.302"/>

    <line class="disabled" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="503.62" y1="570.489" x2="468.562" y2="536.973"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="468.46" y1="570.38" x2="503.722" y2="537.079"/>

    <rect class="disabled" x="538.198" y="537.079" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="35.258" height="33.302"/>

    <line class="disabled" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="573.356" y1="570.489" x2="538.296" y2="536.973"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="538.198" y1="570.38" x2="573.456" y2="537.079"/>
    <polygon class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" points="300.389,576.78 595.396,576.78 
            638.886,576.78 638.886,499.666 300.389,499.666 	"/>

    <rect class="disabled" x="193.826" y="497.38" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="115.706" height="79.399"/>

    <path id="dom1" onClick="reply_click(this.id)" data-id="dom1"';
        
        $result = $this->get_table_stat("dom1", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" d="M284.002,426.735
            c6.41-18.004,9.976-28.021,16.387-46.021c-16.982-0.342-43.099-0.342-61.904-5.045c-5.277,15.161-9.562,31.174-16.049,45.851
            c-0.396,0.896,30.827,5.038,33.75,5.118C265.449,426.883,274.733,426.661,284.002,426.735z"/>

    <path id="dom7" onClick="reply_click(this.id)" data-id="dom7"';

        $result = $this->get_table_stat("dom7", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" d="M284.002,159.428
            c6.41,18.003,9.976,28.021,16.387,46.022c-16.982,0.346-43.099,0.346-61.904,5.046c-5.277-15.162-9.562-31.176-16.049-45.854
            c-0.396-0.896,30.827-5.037,33.75-5.113C265.449,159.281,274.733,159.504,284.002,159.428z"/>

    <path id="vip4" onClick="reply_click(this.id)" data-id="vip4"';

        $result = $this->get_table_stat("vip4", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" d="M204.792,319.875l33.806-13.527
            c-5.667-7.666-5.695-19.646-0.088-27.358l-33.778-13.514C197.481,282.366,197.501,303.006,204.792,319.875z"/>

    <rect x="279.103" y="294.176" id="vip1" onClick="reply_click(this.id)" data-id="vip1"';

        $result = $this->get_table_stat("vip1", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" width="36.173" height="41.348"/>

    <rect x="279.103" y="249.575" id="vip2" onClick="reply_click(this.id)" data-id="vip2"';

        $result = $this->get_table_stat("vip2", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" width="36.173" height="41.469"/>
	
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="264.165,304.823 264.165,303.255 
            262.598,303.255 	"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="260.769,303.255 259.202,303.255 
            259.202,304.823 	"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="2.9206,2.9206" x1="259.202" y1="307.741" x2="259.202" y2="335.487"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="259.202,336.948 259.202,338.515 
            259.229,338.515 259.202,338.542 260.32,339.641 	"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="3.0533,3.0533" x1="262.5" y1="341.777" x2="274.489" y2="353.538"/>
    <polyline fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="275.578,354.608 276.697,355.704 
            278.264,355.689 	"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="3.0929,3.0929" x1="281.357" y1="355.655" x2="310.738" y2="355.34"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="312.283,355.325 313.85,355.309 
            313.775,353.742 	"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="313.687,351.915 313.611,350.349 
            312.044,350.366 	"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="2.8858,2.8858" x1="309.158" y1="350.397" x2="281.745" y2="350.688"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="280.301,350.704 278.734,350.721 
		277.616,349.625 	"/>
	
    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="3.4513,3.4513" x1="275.15" y1="347.209" x2="266.517" y2="338.758"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="265.284,337.553 264.165,336.456 
            264.165,334.889 	"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="3.3409,3.3409" x1="264.165" y1="331.547" x2="264.165" y2="306.491"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="264.165,282.542 264.165,284.108 
            262.598,284.108 	"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="260.769,284.108 259.202,284.108 
            259.202,282.542 	"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="2.9207,2.9207" x1="259.202" y1="279.622" x2="259.202" y2="251.874"/>
    <polyline fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="259.202,250.415 259.202,248.846 
            259.229,248.846 259.202,248.817 260.32,247.72 	"/>
	
    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="3.0533,3.0533" x1="262.5" y1="245.582" x2="274.489" y2="233.822"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="275.578,232.753 276.697,231.655 
            278.264,231.673 	"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="3.0929,3.0929" x1="281.357" y1="231.705" x2="310.738" y2="232.019"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="312.283,232.037 313.85,232.053 
        313.775,233.618 	"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="313.687,235.447 313.611,237.012 
        312.044,236.995 	"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="2.8858,2.8858" x1="309.158" y1="236.964" x2="281.745" y2="236.672"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="280.301,236.658 278.734,236.64 
        277.616,237.735 	"/>
	
    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="3.4513,3.4513" x1="275.15" y1="240.151" x2="266.517" y2="248.601"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" points="265.284,249.808 264.165,250.906 
            264.165,252.472 	"/>

    <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="3.341,3.341" x1="264.165" y1="255.812" x2="264.165" y2="280.87"/>
    <path class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" stroke-dasharray="3.1342" d="M232.217,217.524
            c-66.254,24.573-66.254,126.088,0,150.662c1.307-4.133,2.614-8.268,3.921-12.403c-55.345-20.529-55.345-105.327,0-125.857
            C234.831,225.792,233.523,221.657,232.217,217.524z"/>
	
    <path id="dom2" onClick="reply_click(this.id)" data-id="dom2"';

        $result = $this->get_table_stat("dom2", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" d="M207.134,435.704
            c6.944-17.803,13.889-35.607,20.837-53.409c-14.636-5.71-26.907-14.14-36.717-24.353l-37.656,43.551
            C168.249,415.725,186.13,427.509,207.134,435.704z"/>

    <path id="dom3" onClick="reply_click(this.id)" data-id="dom3"';

        $result = $this->get_table_stat("dom3", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" d="M143.831,392.596l42.463-38.723
            c-8.217-10.014-14.369-21.449-18.28-33.58l-56.169,12.304C118.054,354.434,128.848,374.995,143.831,392.596z"/>

    <path id="dom6" onClick="reply_click(this.id)" data-id="dom6"';

        $result = $this->get_table_stat("dom6", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" d="M207.134,152.3
            c6.944,17.804,13.889,35.608,20.837,53.41c-14.636,5.71-26.907,14.14-36.717,24.353l-37.656-43.551
            C168.249,172.28,186.13,160.497,207.134,152.3z"/>

    <path id="dom5" onClick="reply_click(this.id)" data-id="dom5"';

        $result = $this->get_table_stat("dom5", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" d="M145.661,196.287l42.289,38.92
            c-8.265,9.979-14.469,21.383-18.436,33.498l-56.112-12.563C119.712,234.335,130.598,213.824,145.661,196.287z"/>
                

    <path class="disabled" fill="none" stroke="#000000" stroke-width="1.5671" stroke-miterlimit="10" d="M222.49,369.398
            c0,0-44.596-19.849-44.596-76.788c0,0-0.367-17.24,6.477-31.081"/>
    <path class="disabled" fill="none" stroke="#000000" stroke-width="1.5671" stroke-miterlimit="10" d="M188.08,252.65
            c0,0,18.273-34.159,50.405-42.153"/>
    <path id="s34" onClick="reply_click(this.id)" data-id="s34"';

        $result = $this->get_table_stat("s34", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M446.923,388.749
            c5.52,0,9.994-4.475,9.994-9.99c0-5.518-4.475-9.99-9.994-9.99c-5.516,0-9.99,4.473-9.99,9.99
            C436.933,384.274,441.407,388.749,446.923,388.749z"/>
                
    <circle id="s38" onClick="reply_click(this.id)" data-id="s38"';

        $result = $this->get_table_stat("s38", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="431.04" cy="225.912" r="9.99"/>

    <circle id="c1" onClick="reply_click(this.id)" data-id="c1"';

        $result = $this->get_table_stat("c1", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="429.487" cy="354.852" r="15.083"/>

    <circle id="c2" onClick="reply_click(this.id)" data-id="c2"';

        $result = $this->get_table_stat("c2", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="427.915" cy="257.127" r="15.083"/>

    <rect x="356.544" y="442.532" id="f5" onClick="reply_click(this.id)" data-id="f5"';

        $result = $this->get_table_stat("f5", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="45.967" height="53.803"/>

    <rect x="422.595" y="442.532" id="f4" onClick="reply_click(this.id)" data-id="f4"';

        $result = $this->get_table_stat("f4", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="45.967" height="53.803"/>

    <rect x="490.269" y="442.532" id="f3" onClick="reply_click(this.id)" data-id="f3"';

        $result = $this->get_table_stat("f3", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="64.775" height="53.803"/>

    <rect x="573.356" y="438.352" id="f2" onClick="reply_click(this.id)" data-id="f2"';

        $result = $this->get_table_stat("f2", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="76.236" height="57.982"/>

    <rect x="664.876" y="424.248" id="f1" onClick="reply_click(this.id)" data-id="f1"';

        $result = $this->get_table_stat("f1", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="69.352" height="63.206"/>
                

    <rect class="disabled" x="638.886" y="499.666" width="81.229" height="3.46"/>
    <rect class="disabled" x="712.802" y="501.396" width="3.133" height="75.383"/>
    <rect class="disabled" x="638.886" y="573.907" width="51.977" height="2.873"/>
    <rect class="disabled" x="707.577" y="573.907" width="8.357" height="2.872"/>
    <rect class="disabled" x="720.114" y="452.978" fill="#FFFFFF" width="47.018" height="79.4"/>
    <path class="disabled" d="M793.247,453.761h12.535v-1.567h-12.535C793.247,452.717,793.247,453.24,793.247,453.761z"/>
    <path class="disabled" d="M719.329,452.194v50.932h1.568v-49.364h53.541c0-0.521,0-1.044,0-1.567H719.329z"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="1.5671" stroke-miterlimit="10" points="714.366,559.019 805.782,559.019 
        805.782,529.765 	"/>
    <rect class="disabled" x="805.782" y="332.934" width="4.703" height="170.19"/>
    <polygon class="disabled" points="810.485,143.932 810.485,303.059 805.782,303.059 805.782,145.824 	"/>
    <path class="disabled" d="M810.485,143.932c-0.031-0.015-30.012-12.936-69.975-27.456c-39.975-14.52-91.184-31.271-136.352-40.205l-1.064,5.382
        c44.68,8.828,95.721,25.508,135.541,39.979c19.916,7.235,37.027,13.915,49.156,18.79c6.064,2.435,10.885,4.418,14.186,5.79
        c1.65,0.688,2.926,1.222,3.779,1.584c0.857,0.361,1.297,0.549,1.297,0.549L810.485,143.932z"/>
    <path class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M454.815,246.062
        c-14.186,15.957-21.289,37.21-21.336,58.474h-0.004v0.193v0.001v0.195h0.004c0.047,21.265,7.15,42.516,21.336,58.475
        c14.227,16.005,35.572,26.675,64.006,26.673h0.195v-0.195c0-4.701,0-23.513,0-28.214v-0.173l-0.17-0.021
        c-35.768-4.746-56.236-30.695-56.945-56.739c0.709-26.044,21.178-51.992,56.945-56.737l0.17-0.023v-0.171
        c0-4.701,0-23.514,0-28.216v-0.195h-0.195C490.387,219.385,469.041,230.055,454.815,246.062z"/>
        
    <path id="svip1" onClick="reply_click(this.id)" data-id="svip1"';

        $result = $this->get_table_stat("svip1", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="1.5671" stroke-miterlimit="10" d="M480.356,262.853
            c-13.113,10.643-18.855,25.014-18.85,39.789c0,0.723,0.014,1.444,0.041,2.169c-0.027,0.721-0.041,1.444-0.041,2.164
            c-0.006,14.779,5.736,29.148,18.85,39.789c13.113,10.643,33.561,17.554,62.953,17.554c3.279,0,6.68-0.085,10.186-0.263l0.369-0.02
            v-0.376c0-10.377,0-25.616,0-35.994c0-3.369,0-6.741,0-10.112v-12.353v-0.784v-12.352c0-3.369,0-6.742,0-10.114
            c0-10.378,0-25.613,0-35.994v-0.375l-0.369-0.02c-3.506-0.176-6.906-0.261-10.186-0.263
            C513.917,245.301,493.47,252.212,480.356,262.853z"/>
                
    <path class="disabled" d="M482.005,310.764c0.91,0.559,2.238,1.025,3.638,1.025c2.075,0,3.288-1.096,3.288-2.682c0-1.469-0.84-2.309-2.961-3.123
            c-2.565-0.91-4.15-2.238-4.15-4.453c0-2.449,2.027-4.268,5.082-4.268c1.609,0,2.775,0.373,3.475,0.77l-0.561,1.656
            c-0.512-0.281-1.562-0.746-2.984-0.746c-2.145,0-2.961,1.281-2.961,2.354c0,1.469,0.957,2.191,3.125,3.031
            c2.658,1.025,4.01,2.309,4.01,4.617c0,2.424-1.795,4.523-5.502,4.523c-1.516,0-3.172-0.443-4.01-1.004L482.005,310.764z"/>
    <path class="disabled" d="M497.231,313.235l-5.129-15.715h2.191l2.447,7.742c0.677,2.121,1.26,4.033,1.68,5.875h0.047
            c0.442-1.818,1.096-3.801,1.795-5.852l2.658-7.766h2.168l-5.619,15.715H497.231z"/>
    <path class="disabled" d="M508.82,297.52v15.715h-2.028V297.52H508.82z"/>
    <path class="disabled" d="M512.364,297.708c0.98-0.164,2.262-0.303,3.895-0.303c2.005,0,3.474,0.465,4.406,1.305
            c0.863,0.746,1.375,1.889,1.375,3.287c0,1.424-0.419,2.543-1.212,3.357c-1.072,1.143-2.821,1.727-4.803,1.727
            c-0.606,0-1.166-0.023-1.632-0.141v6.295h-2.029V297.708z M514.394,305.286c0.443,0.115,1.002,0.162,1.678,0.162
            c2.449,0,3.941-1.189,3.941-3.357c0-2.074-1.469-3.078-3.707-3.078c-0.887,0-1.563,0.07-1.912,0.164V305.286z"/>
    <path class="disabled" d="M533.442,299.993h-0.046l-2.635,1.422l-0.396-1.563l3.311-1.771h1.749v15.154h-1.982V299.993z"/>
    <path class="disabled" d="M768.075,350.75c-0.152-1.007-0.267-2.203-0.267-3.515c0-2.374,0.551-4.065,1.596-5.187
        c1.045-1.139,2.527-1.805,4.598-1.805c2.09,0,3.8,0.646,4.978,1.844c1.196,1.196,1.843,3.172,1.843,5.66
        c0,1.178-0.058,2.166-0.152,3.002H768.075z M779.397,349.098c0.076-0.418,0.095-1.026,0.095-1.672c0-3.533-1.976-5.453-5.434-5.453
        c-3.021-0.018-4.938,1.691-4.938,5.188c0,0.854,0.075,1.5,0.171,1.938H779.397z"/>
    <path class="disabled" d="M767.904,335.48v-1.653h8.567c3.4,0,4.445,1.672,4.445,3.876c0,0.608-0.133,1.349-0.304,1.767l-1.349-0.246
        c0.133-0.343,0.246-0.836,0.246-1.388c0-1.481-0.664-2.355-3.172-2.355H767.904z"/>
    <path class="disabled" d="M778.694,323.25c0.456-0.741,0.836-1.823,0.836-2.964c0-1.69-0.893-2.678-2.185-2.678c-1.197,0-1.881,0.684-2.546,2.412
        c-0.741,2.09-1.823,3.381-3.628,3.381c-1.995,0-3.477-1.652-3.477-4.141c0-1.311,0.304-2.261,0.627-2.83l1.349,0.455
        c-0.229,0.418-0.608,1.273-0.608,2.432c0,1.748,1.045,2.412,1.919,2.412c1.197,0,1.786-0.778,2.47-2.545
        c0.836-2.166,1.881-3.268,3.762-3.268c1.976,0,3.686,1.463,3.686,4.483c0,1.235-0.361,2.583-0.817,3.268L778.694,323.25z"/>
    <path class="disabled" d="M769.31,311.227v3.895h-1.405v-9.48h1.405v3.914h11.398v1.672H769.31z"/>
    <path class="disabled" d="M776.681,303.573l4.027,1.33v1.709l-12.804-4.35v-1.995l12.804-4.37v1.768l-4.027,1.367V303.573z M775.389,299.374
        l-3.686,1.254c-0.836,0.285-1.596,0.476-2.337,0.666v0.037c0.761,0.189,1.539,0.398,2.318,0.646l3.704,1.254V299.374z"/>
    <path class="disabled" d="M780.138,284.56c0.267,0.74,0.703,2.203,0.703,3.932c0,1.938-0.494,3.533-1.69,4.787c-1.064,1.103-2.773,1.786-4.769,1.786
        c-3.818-0.02-6.611-2.641-6.611-6.934c0-1.482,0.323-2.641,0.589-3.191l1.35,0.398c-0.305,0.684-0.552,1.539-0.552,2.831
        c0,3.114,1.938,5.147,5.148,5.147c3.249,0,5.168-1.957,5.168-4.938c0-1.083-0.152-1.824-0.343-2.204h-3.818v2.603h-1.329v-4.217
        H780.138z"/>
    <path class="disabled" d="M774.705,275.405v4.978h4.616v-5.547h1.387v7.2h-12.804v-6.915h1.387v5.262h4.046v-4.978H774.705z"/>
    <path class="disabled" fill="#FFFFFF" d="M762.95,384.025"/>
    <path class="disabled" fill="#FFFFFF" d="M732.521,384.025"/>
    <polyline class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" points="808.132,302.875 808.132,220.524 
        734.228,220.524 734.228,408.577 808.132,408.577 808.132,333.355 	"/>
    <path class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M808.132,302.875"/>

    <rect class="disabled" x="741.593" y="266.492" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="19.727" height="72.087"/>
	
    <rect x="352.597" y="95.156" id="jaggerbar" onClick="reply_click(this.id)" data-id="jaggerbar"';

        $result = $this->get_table_stat("jaggerbar", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="47.959" height="71.302"/>

    <rect x="423.364" y="95.156" id="w6" onClick="reply_click(this.id)" data-id="w6"';

        $result = $this->get_table_stat("w6", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="47.956" height="71.302"/>

    <rect x="482.821" y="95.156" id="w5" onClick="reply_click(this.id)" data-id="w5"';

        $result = $this->get_table_stat("w5", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="47.957" height="71.302"/>

    <rect x="554.501" y="119.103" id="w4" onClick="reply_click(this.id)" data-id="w4"';

        $result = $this->get_table_stat("w4", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="31.791" height="47.268"/>

    <path id="w3" onClick="reply_click(this.id)" data-id="w3"';

        $result = $this->get_table_stat("w3", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M650.739,180.169
            c-25.959-5.875-47.645-10.167-47.645-10.167c2.418-21.131,4.832-42.261,7.25-63.395c0,0,41.529,1.104,59.652,12.729
            C663.577,139.617,657.157,159.898,650.739,180.169z"/>

    <polygon id="w1" onClick="reply_click(this.id)" data-id="w1"';

        $result = $this->get_table_stat("w1", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" points="785.411,220.524 785.411,159.408 
            738.397,139.819 738.397,220.524"/>

    <path id="w2" onClick="reply_click(this.id)" data-id="w2"';

        $result = $this->get_table_stat("w2", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M664.876,184.952l21.023-61.588
            l34.215,12.536l-0.785,77.082C719.329,212.982,687.769,191.692,664.876,184.952z"/>
                
	<path class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M284.002,426.735l-22.592,39.824
		c-21.422,0.293-44.729-7.43-64.196-15.439c-43.82-18.029-79.251-54.439-93.521-99.981c-13.206-42.144-12.103-94.438,8.564-133.816
		c16.482-31.401,41.8-60.737,74.445-75.747c25.072-11.527,56.436-17.658,83.912-18.995l13.388,36.849"/>
	
        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="51.48" y1="359.475" x2="46.778" y2="343.711"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="84.912" y1="349.547" x2="80.472" y2="332.934"/>
	<path class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M353.997,166.458h-17.302V64.335
		c0,0,193.615-8.812,274.783,13.443"/>
	
        <rect class="disabled" x="282.549" y="356.862" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" width="19.603" height="23.482"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" x1="297.19" y1="380.344" x2="297.19" y2="356.862"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" x1="292.349" y1="356.862" x2="292.349" y2="380.344"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" x1="288.047" y1="356.862" x2="288.047" y2="380.344"/>

        <rect class="disabled" x="282.549" y="205.598" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" width="19.603" height="24.891"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" x1="297.19" y1="230.489" x2="297.19" y2="205.598"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" x1="292.349" y1="205.598" x2="292.349" y2="230.489"/>
	
        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" x1="288.047" y1="205.598" x2="288.047" y2="230.489"/>
	<rect class="disabled" x="313.85" y="230.489" width="2.406" height="124.82"/>
	<rect class="disabled" x="313.85" y="120.621" width="22.845" height="3.917"/>
	<rect class="disabled" x="332.778" y="53.103" width="3.917" height="71.433"/>
	<rect class="disabled" x="332.778" y="4" width="3.917" height="13.973"/>
	<path class="disabled" fill="none" stroke="#000000" stroke-width="1.5671" stroke-miterlimit="10" d="M334.736,5.568
		c0,0-98.599,11.23-109.307,14.366v64.25"/>
	<path class="disabled" d="M224.39,79.484"/>
	<path class="disabled" fill="none" stroke="#000000" stroke-width="1.5671" stroke-miterlimit="10" d="M225.429,79.484
		c0,0-145.219,29.072-224.619,71.997c0,0-0.522,70.334,3.003,96.525l93.092,18.389"/>
	
        <line class="disabled" fill="none" stroke="#000000" stroke-width="1.5671" stroke-miterlimit="10" x1="32.021" y1="193.099" x2="117.799" y2="207.424"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="1.5671" stroke-miterlimit="10" x1="32.021" y1="171.159" x2="34.781" y2="135.402"/>
	<path class="disabled" d="M76.467,156.924c0.63,0.388,1.55,0.71,2.519,0.71c1.437,0,2.276-0.759,2.276-1.856c0-1.017-0.581-1.598-2.051-2.163
		c-1.775-0.63-2.873-1.55-2.873-3.083c0-1.695,1.404-2.955,3.52-2.955c1.113,0,1.921,0.258,2.405,0.533l-0.388,1.146
		c-0.355-0.194-1.082-0.517-2.066-0.517c-1.485,0-2.051,0.888-2.051,1.63c0,1.017,0.662,1.518,2.164,2.099
		c1.84,0.71,2.776,1.598,2.776,3.196c0,1.679-1.243,3.132-3.81,3.132c-1.05,0-2.196-0.307-2.777-0.694L76.467,156.924z"/>
	<path class="disabled" d="M86.684,148.949h-3.31v-1.194h8.057v1.194h-3.326v9.687h-1.421V148.949z"/>
	<path class="disabled" d="M101.502,153.082c0,3.746-2.276,5.731-5.053,5.731c-2.873,0-4.892-2.228-4.892-5.521c0-3.455,2.147-5.715,5.053-5.715
		C99.581,147.577,101.502,149.854,101.502,153.082z M93.06,153.26c0,2.325,1.259,4.407,3.471,4.407c2.228,0,3.487-2.05,3.487-4.52
		c0-2.164-1.131-4.423-3.472-4.423C94.222,148.724,93.06,150.871,93.06,153.26z"/>
	<path class="disabled" d="M103.323,147.9c0.711-0.145,1.728-0.226,2.696-0.226c1.502,0,2.47,0.274,3.148,0.888c0.549,0.484,0.855,1.227,0.855,2.066
		c0,1.437-0.904,2.389-2.051,2.777v0.048c0.84,0.291,1.34,1.065,1.599,2.195c0.355,1.518,0.613,2.567,0.84,2.987h-1.453
		c-0.178-0.307-0.42-1.243-0.727-2.599c-0.323-1.501-0.904-2.066-2.18-2.115h-1.323v4.714h-1.405V147.9z M104.729,152.856h1.437
		c1.501,0,2.454-0.824,2.454-2.066c0-1.405-1.018-2.018-2.503-2.034c-0.678,0-1.162,0.064-1.388,0.129V152.856z"/>
	<path class="disabled" d="M113.847,155.213l-1.13,3.422h-1.453l3.697-10.881h1.695l3.713,10.881h-1.502l-1.162-3.422H113.847z M117.415,154.115
		l-1.065-3.132c-0.242-0.71-0.404-1.356-0.565-1.985h-0.032c-0.161,0.646-0.339,1.308-0.549,1.969l-1.065,3.148H117.415z"/>
	<path class="disabled" d="M130.005,158.151c-0.63,0.226-1.873,0.597-3.342,0.597c-1.646,0-3.003-0.419-4.068-1.437
		c-0.937-0.904-1.518-2.357-1.518-4.052c0.017-3.245,2.244-5.618,5.893-5.618c1.259,0,2.244,0.274,2.712,0.5l-0.339,1.146
		c-0.581-0.258-1.308-0.468-2.405-0.468c-2.647,0-4.375,1.646-4.375,4.375c0,2.761,1.663,4.391,4.197,4.391
		c0.92,0,1.55-0.129,1.873-0.291v-3.245h-2.212v-1.13h3.584V158.151z"/>
	<path class="disabled" d="M137.784,153.534h-4.229v3.923h4.714v1.179h-6.119v-10.881h5.877v1.178h-4.472v3.439h4.229V153.534z"/>
	<path class="disabled" d="M44.329,216.468h-3.063v-1.105h7.454v1.105h-3.077v8.963h-1.314V216.468z"/>
	<path class="disabled" d="M51.142,215.363v10.068h-1.299v-10.068H51.142z"/>
	<path class="disabled" d="M60.449,225.102c-0.478,0.239-1.434,0.479-2.658,0.479c-2.839,0-4.975-1.793-4.975-5.095c0-3.151,2.136-5.288,5.258-5.288
		c1.255,0,2.047,0.27,2.391,0.448l-0.314,1.061c-0.492-0.238-1.194-0.418-2.031-0.418c-2.36,0-3.929,1.509-3.929,4.153
		c0,2.465,1.419,4.048,3.869,4.048c0.792,0,1.599-0.164,2.121-0.418L60.449,225.102z"/>
	<path class="disabled" d="M62.079,215.363h1.299v4.854h0.045c0.27-0.389,0.538-0.747,0.792-1.075l3.077-3.779h1.613l-3.645,4.272l3.929,5.796H67.65
		l-3.316-4.945l-0.956,1.105v3.84h-1.299V215.363z"/>
	<path class="disabled" d="M75.39,220.71h-3.914v3.63h4.362v1.091h-5.661v-10.068h5.438v1.09h-4.139v3.183h3.914V220.71z"/>
	<path class="disabled" d="M79.679,216.468h-3.063v-1.105h7.454v1.105h-3.077v8.963h-1.314V216.468z"/>
	<path class="disabled" d="M42.417,233.426c0.657-0.135,1.598-0.209,2.494-0.209c1.39,0,2.286,0.254,2.913,0.821c0.508,0.448,0.792,1.136,0.792,1.912
		c0,1.329-0.837,2.211-1.897,2.569v0.045c0.777,0.269,1.24,0.986,1.479,2.031c0.329,1.404,0.568,2.376,0.777,2.764H47.63
		c-0.164-0.283-0.389-1.15-0.672-2.405c-0.299-1.389-0.837-1.912-2.017-1.956h-1.226v4.361h-1.299V233.426z M43.716,238.012h1.33
		c1.389,0,2.271-0.762,2.271-1.912c0-1.3-0.941-1.867-2.315-1.882c-0.628,0-1.075,0.06-1.285,0.119V238.012z"/>
	<path class="disabled" d="M59.104,238.221c0,3.466-2.106,5.304-4.676,5.304c-2.659,0-4.526-2.062-4.526-5.109c0-3.197,1.986-5.288,4.676-5.288
		C57.326,233.127,59.104,235.234,59.104,238.221z M51.291,238.385c0,2.151,1.165,4.078,3.212,4.078c2.062,0,3.227-1.896,3.227-4.183
		c0-2.001-1.046-4.093-3.212-4.093C52.367,234.188,51.291,236.174,51.291,238.385z"/>
	<path class="disabled" d="M69.398,238.221c0,3.466-2.106,5.304-4.676,5.304c-2.659,0-4.526-2.062-4.526-5.109c0-3.197,1.986-5.288,4.676-5.288
		C67.62,233.127,69.398,235.234,69.398,238.221z M61.585,238.385c0,2.151,1.165,4.078,3.212,4.078c2.062,0,3.227-1.896,3.227-4.183
		c0-2.001-1.046-4.093-3.212-4.093C62.661,234.188,61.585,236.174,61.585,238.385z"/>
	<path class="disabled" d="M79.572,238.938c-0.074-1.404-0.164-3.092-0.149-4.347h-0.045c-0.343,1.18-0.762,2.435-1.27,3.824l-1.777,4.885h-0.986
		l-1.628-4.795c-0.479-1.419-0.882-2.719-1.165-3.914h-0.03c-0.03,1.255-0.104,2.942-0.194,4.451l-0.269,4.317h-1.24l0.702-10.068
		h1.658l1.718,4.87c0.419,1.24,0.762,2.346,1.016,3.391h0.045c0.254-1.016,0.613-2.121,1.061-3.391l1.793-4.87h1.658l0.627,10.068
		h-1.27L79.572,238.938z"/>
	<path class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" stroke-dasharray="3.1342" d="M3.03,252.65
		c0,0,1.568,54.399,11.361,80.284"/>
	<path class="disabled" d="M25.312,303.942H21.65v3.396h4.082v1.02h-5.297v-9.42h5.087v1.02H21.65v2.978h3.662V303.942z"/>
	<path class="disabled" d="M27.312,308.358v-9.42h1.328l3.02,4.766c0.698,1.104,1.244,2.098,1.691,3.062l0.027-0.015
		c-0.111-1.258-0.141-2.403-0.141-3.871v-3.941h1.146v9.42h-1.229l-2.991-4.779c-0.656-1.049-1.285-2.125-1.762-3.145l-0.041,0.014
		c0.07,1.188,0.098,2.32,0.098,3.885v4.025H27.312z"/>
	<path class="disabled" d="M38.3,299.972h-2.865v-1.034h6.975v1.034h-2.879v8.386H38.3V299.972z"/>
	<path class="disabled" d="M43.458,299.063c0.615-0.125,1.496-0.195,2.334-0.195c1.301,0,2.139,0.238,2.727,0.77c0.475,0.419,0.74,1.062,0.74,1.789
		c0,1.244-0.783,2.068-1.775,2.403v0.042c0.727,0.252,1.16,0.923,1.384,1.9c0.308,1.314,0.531,2.223,0.728,2.586h-1.258
		c-0.154-0.266-0.364-1.076-0.629-2.25c-0.28-1.3-0.783-1.789-1.888-1.831h-1.146v4.081h-1.217V299.063z M44.675,303.354h1.244
		c1.299,0,2.123-0.713,2.123-1.789c0-1.215-0.88-1.746-2.166-1.761c-0.587,0-1.006,0.056-1.201,0.112V303.354z"/>
	<path class="disabled" d="M52.574,305.395l-0.979,2.963h-1.258l3.2-9.42h1.468l3.215,9.42h-1.301l-1.006-2.963H52.574z M55.662,304.445l-0.922-2.712
		c-0.21-0.615-0.35-1.174-0.489-1.719h-0.028c-0.14,0.559-0.293,1.132-0.475,1.705l-0.923,2.726H55.662z"/>
	<path class="disabled" d="M59.605,308.358v-9.42h1.328l3.02,4.766c0.698,1.104,1.244,2.098,1.691,3.062l0.027-0.015
		c-0.111-1.258-0.141-2.403-0.141-3.871v-3.941h1.146v9.42h-1.229l-2.991-4.779c-0.656-1.049-1.285-2.125-1.762-3.145l-0.041,0.014
		c0.07,1.188,0.098,2.32,0.098,3.885v4.025H59.605z"/>
	<path class="disabled" d="M75.386,308.051c-0.447,0.223-1.342,0.447-2.488,0.447c-2.655,0-4.654-1.678-4.654-4.767c0-2.949,1.999-4.948,4.92-4.948
		c1.174,0,1.915,0.252,2.236,0.42l-0.293,0.992c-0.462-0.224-1.118-0.392-1.901-0.392c-2.208,0-3.676,1.412-3.676,3.886
		c0,2.307,1.328,3.788,3.62,3.788c0.74,0,1.495-0.153,1.984-0.392L75.386,308.051z"/>
	<path class="disabled" d="M81.79,303.942h-3.662v3.396h4.081v1.02h-5.297v-9.42H82v1.02h-3.872v2.978h3.662V303.942z"/>
	<path class="disabled" d="M101.532,430.151c-0.07-1.314-0.154-2.894-0.141-4.068h-0.041c-0.322,1.104-0.713,2.279-1.188,3.578l-1.663,4.571h-0.922
		l-1.523-4.487c-0.447-1.327-0.825-2.543-1.091-3.662h-0.028c-0.027,1.175-0.098,2.754-0.182,4.166l-0.252,4.039h-1.16l0.658-9.42
		h1.551l1.607,4.556c0.391,1.16,0.713,2.194,0.95,3.173h0.042c0.238-0.95,0.573-1.984,0.992-3.173l1.678-4.556h1.551l0.588,9.42
		h-1.188L101.532,430.151z"/>
	<path class="disabled" d="M106.048,424.868v9.42h-1.216v-9.42H106.048z"/>
	<path class="disabled" d="M108.174,424.993c0.614-0.125,1.494-0.195,2.334-0.195c1.299,0,2.139,0.237,2.725,0.769
		c0.476,0.419,0.741,1.063,0.741,1.789c0,1.244-0.782,2.068-1.774,2.404v0.042c0.727,0.252,1.159,0.922,1.383,1.9
		c0.308,1.314,0.531,2.223,0.727,2.586h-1.258c-0.153-0.266-0.363-1.076-0.629-2.25c-0.279-1.301-0.783-1.789-1.887-1.831h-1.146
		v4.081h-1.215V424.993z M109.389,429.284h1.244c1.301,0,2.125-0.713,2.125-1.789c0-1.216-0.881-1.747-2.166-1.761
		c-0.588,0-1.007,0.056-1.203,0.111V429.284z"/>
	<path class="disabled" d="M115.694,424.993c0.615-0.125,1.496-0.195,2.335-0.195c1.3,0,2.138,0.237,2.726,0.769c0.475,0.419,0.74,1.063,0.74,1.789
		c0,1.244-0.782,2.068-1.775,2.404v0.042c0.728,0.252,1.16,0.922,1.385,1.9c0.307,1.314,0.531,2.223,0.727,2.586h-1.258
		c-0.154-0.266-0.363-1.076-0.629-2.25c-0.279-1.301-0.783-1.789-1.887-1.831h-1.146v4.081h-1.217V424.993z M116.911,429.284h1.244
		c1.3,0,2.125-0.713,2.125-1.789c0-1.216-0.881-1.747-2.167-1.761c-0.587,0-1.007,0.056-1.202,0.111V429.284z"/>
	<path class="disabled" d="M131.309,429.479c0,3.243-1.972,4.963-4.375,4.963c-2.488,0-4.236-1.93-4.236-4.781c0-2.99,1.859-4.947,4.375-4.947
		C129.645,424.713,131.309,426.684,131.309,429.479z M123.999,429.633c0,2.013,1.09,3.815,3.005,3.815
		c1.929,0,3.019-1.774,3.019-3.913c0-1.873-0.979-3.83-3.004-3.83C125.004,425.706,123.999,427.565,123.999,429.633z"/>
	<path class="disabled" d="M132.889,424.993c0.615-0.125,1.496-0.195,2.335-0.195c1.3,0,2.138,0.237,2.726,0.769c0.475,0.419,0.74,1.063,0.74,1.789
		c0,1.244-0.782,2.068-1.775,2.404v0.042c0.728,0.252,1.16,0.922,1.385,1.9c0.307,1.314,0.531,2.223,0.727,2.586h-1.258
		c-0.154-0.266-0.363-1.076-0.629-2.25c-0.279-1.301-0.783-1.789-1.887-1.831h-1.146v4.081h-1.217V424.993z M134.106,429.284h1.244
		c1.3,0,2.125-0.713,2.125-1.789c0-1.216-0.881-1.747-2.167-1.761c-0.587,0-1.007,0.056-1.202,0.111V429.284z"/>
	<path class="disabled" d="M95.381,442.677h-2.865v-1.034h6.975v1.034h-2.879v8.386h-1.23V442.677z"/>
	<path class="disabled" d="M101.756,441.643v5.576c0,2.111,0.937,3.006,2.194,3.006c1.397,0,2.292-0.923,2.292-3.006v-5.576h1.23v5.492
		c0,2.895-1.523,4.082-3.564,4.082c-1.929,0-3.383-1.104-3.383-4.025v-5.549H101.756z"/>
	<path class="disabled"  d="M109.584,451.063v-9.42h1.328l3.02,4.766c0.699,1.104,1.244,2.098,1.691,3.062l0.027-0.015
		c-0.111-1.258-0.139-2.403-0.139-3.871v-3.941h1.146v9.42h-1.229l-2.992-4.779c-0.656-1.049-1.285-2.125-1.761-3.145l-0.042,0.014
		c0.07,1.188,0.098,2.32,0.098,3.885v4.025H109.584z"/>
	<path class="disabled" d="M118.784,451.063v-9.42h1.328l3.02,4.766c0.698,1.104,1.244,2.098,1.691,3.062l0.027-0.015
		c-0.111-1.258-0.141-2.403-0.141-3.871v-3.941h1.146v9.42h-1.229l-2.991-4.779c-0.656-1.049-1.285-2.125-1.762-3.145l-0.041,0.014
		c0.07,1.188,0.098,2.32,0.098,3.885v4.025H118.784z"/>
	<path class="disabled" d="M132.861,446.647h-3.662v3.396h4.081v1.02h-5.297v-9.42h5.088v1.02h-3.872v2.978h3.662V446.647z"/>
	<path class="disabled" d="M134.86,441.643h1.217v8.4h4.025v1.02h-5.242V441.643z"/>
	
        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="211.063" y1="468.911" x2="229.487" y2="468.911"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="211.063" y1="490.067" x2="229.487" y2="490.067"/>

        <line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="222.432" y1="497.38" x2="222.432" y2="490.067"/>

        <line class="disabled" fill="#FFFFFF" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="222.49" y1="468.911" x2="222.49" y2="460.227"/>
	<path class="disabled" d="M620.29,278.936c1.236-0.187,2.705-0.326,4.314-0.326c2.914,0,4.988,0.676,6.363,1.958c1.4,1.283,2.217,3.102,2.217,5.643
		c0,2.564-0.793,4.664-2.262,6.109c-1.469,1.469-3.895,2.262-6.949,2.262c-1.445,0-2.658-0.07-3.684-0.188V278.936z
		 M622.319,292.833c0.512,0.092,1.258,0.115,2.051,0.115c4.338,0,6.691-2.424,6.691-6.667c0.023-3.707-2.074-6.063-6.365-6.063
		c-1.049,0-1.842,0.094-2.377,0.21V292.833z"/>
	<path class="disabled" d="M638.034,289.497l-1.631,4.943h-2.1l5.34-15.714h2.447l5.363,15.714h-2.168l-1.68-4.943H638.034z M643.187,287.913
		l-1.537-4.524c-0.35-1.025-0.584-1.958-0.816-2.867h-0.047c-0.232,0.933-0.49,1.888-0.793,2.844l-1.539,4.547H643.187z"/>
	<path class="disabled" d="M649.765,294.44v-15.714h2.215l5.035,7.951c1.166,1.842,2.076,3.498,2.822,5.105l0.045-0.023
		c-0.186-2.098-0.232-4.01-0.232-6.458v-6.575h1.912v15.714h-2.053l-4.988-7.973c-1.096-1.75-2.145-3.544-2.938-5.247l-0.07,0.023
		c0.117,1.981,0.162,3.87,0.162,6.481v6.715H649.765z"/>
	<path class="disabled" d="M676.089,293.928c-0.746,0.373-2.238,0.746-4.15,0.746c-4.43,0-7.766-2.799-7.766-7.951c0-4.919,3.336-8.253,8.207-8.253
		c1.959,0,3.195,0.419,3.73,0.699l-0.488,1.655c-0.77-0.373-1.865-0.653-3.172-0.653c-3.684,0-6.131,2.355-6.131,6.482
		c0,3.848,2.215,6.318,6.039,6.318c1.234,0,2.494-0.256,3.311-0.652L676.089,293.928z"/>
	<path class="disabled" d="M686.769,287.073h-6.109v5.666h6.809v1.701h-8.838v-15.714h8.488v1.702h-6.459v4.966h6.109V287.073z"/>
	<path class="disabled" d="M620.29,306.708h8.463v1.701h-6.434v5.223h5.945v1.68h-5.945v7.111h-2.029V306.708z"/>
	<path class="disabled" d="M631.646,306.708h2.029v14.012h6.715v1.703h-8.744V306.708z"/>
	<path class="disabled" d="M655.173,314.401c0,5.41-3.289,8.277-7.299,8.277c-4.15,0-7.064-3.217-7.064-7.975c0-4.988,3.102-8.252,7.299-8.252
		C652.397,306.452,655.173,309.739,655.173,314.401z M642.978,314.659c0,3.357,1.818,6.363,5.014,6.363
		c3.217,0,5.035-2.961,5.035-6.527c0-3.125-1.631-6.389-5.012-6.389C644.657,308.106,642.978,311.208,642.978,314.659z"/>
	<path class="disabled" d="M671.237,314.401c0,5.41-3.287,8.277-7.297,8.277c-4.15,0-7.064-3.217-7.064-7.975c0-4.988,3.102-8.252,7.297-8.252
		C668.464,306.452,671.237,309.739,671.237,314.401z M659.044,314.659c0,3.357,1.818,6.363,5.012,6.363
		c3.219,0,5.037-2.961,5.037-6.527c0-3.125-1.633-6.389-5.014-6.389C660.724,308.106,659.044,311.208,659.044,314.659z"/>
	<path class="disabled" d="M673.874,306.917c1.025-0.209,2.494-0.326,3.895-0.326c2.168,0,3.566,0.396,4.545,1.283
		c0.793,0.699,1.236,1.771,1.236,2.984c0,2.074-1.305,3.449-2.961,4.01v0.07c1.213,0.42,1.936,1.539,2.309,3.17
		c0.512,2.191,0.885,3.707,1.213,4.314h-2.1c-0.256-0.443-0.605-1.795-1.049-3.754c-0.467-2.168-1.307-2.984-3.148-3.055h-1.91
		v6.809h-2.029V306.917z M675.903,314.075h2.074c2.168,0,3.543-1.189,3.543-2.984c0-2.027-1.469-2.914-3.613-2.938
		c-0.979,0-1.678,0.094-2.004,0.186V314.075z"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="774.438" y1="459.116" x2="774.438" y2="446.187"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="793.247" y1="459.116" x2="793.247" y2="446.187"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="801.079" y1="529.765" x2="821.845" y2="529.765"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="802.647" y1="503.125" x2="821.845" y2="503.125"/>
	<rect class="disabled" x="812.835" y="529.765" width="4.701" height="11.754"/>
	<path class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" d="M331.731,4c0,0,214.694-27.946,457.596,67.647
		"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" x1="323.113" y1="53.103" x2="341.822" y2="53.103"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" x1="323.113" y1="17.973" x2="341.822" y2="17.973"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="313.709" y1="132.375" x2="313.709" y2="108.175"/>
	<path class="disabled" d="M689.922,450.008h5.688v1.145h-4.324v3.51h3.996v1.129h-3.996v4.779h-1.363V450.008z"/>
	<path class="disabled" d="M703.383,451.668h-0.031l-1.771,0.957l-0.266-1.051l2.225-1.189h1.176v10.186h-1.332V451.668z"/>
	<path class="disabled" d="M744.841,191.458l-2.68-10.563h1.441l1.254,5.344c0.313,1.316,0.596,2.633,0.783,3.651h0.031
		c0.173-1.05,0.502-2.304,0.862-3.667l1.41-5.328h1.426l1.285,5.359c0.298,1.254,0.58,2.508,0.736,3.62h0.031
		c0.22-1.159,0.518-2.335,0.847-3.651l1.395-5.328h1.395l-2.993,10.563h-1.426l-1.332-5.5c-0.329-1.348-0.549-2.383-0.689-3.448
		h-0.031c-0.188,1.05-0.423,2.084-0.815,3.448l-1.504,5.5H744.841z"/>
	<path class="disabled" d="M762.204,182.557h-0.031l-1.771,0.956l-0.267-1.05l2.226-1.19h1.175v10.186h-1.332V182.557z"/>
	<path class="disabled" d="M680.169,168.318l-2.68-10.563h1.441l1.254,5.344c0.313,1.316,0.596,2.633,0.783,3.651h0.031
		c0.172-1.05,0.502-2.304,0.861-3.667l1.41-5.328h1.426l1.285,5.359c0.299,1.254,0.58,2.508,0.736,3.62h0.031
		c0.221-1.159,0.518-2.335,0.848-3.651l1.395-5.328h1.395l-2.994,10.563h-1.426l-1.332-5.5c-0.328-1.348-0.549-2.383-0.689-3.448
		h-0.031c-0.188,1.05-0.422,2.084-0.814,3.448l-1.504,5.5H680.169z"/>
	<path class="disabled" d="M694.538,168.318v-0.847l1.082-1.05c2.602-2.476,3.777-3.792,3.793-5.328c0-1.034-0.502-1.99-2.021-1.99
		c-0.926,0-1.693,0.471-2.164,0.862l-0.438-0.972c0.705-0.596,1.707-1.034,2.883-1.034c2.193,0,3.119,1.505,3.119,2.962
		c0,1.881-1.363,3.4-3.512,5.469l-0.814,0.752v0.032h4.576v1.144H694.538z"/>
	<path class="disabled" d="M617.684,148.59l-2.68-10.563h1.441l1.254,5.344c0.313,1.316,0.596,2.633,0.783,3.65h0.031
		c0.173-1.049,0.502-2.303,0.862-3.666l1.41-5.328h1.426l1.285,5.359c0.298,1.254,0.58,2.508,0.736,3.619h0.031
		c0.22-1.158,0.518-2.334,0.847-3.65l1.395-5.328h1.395l-2.993,10.563h-1.426l-1.332-5.5c-0.329-1.348-0.549-2.383-0.689-3.449
		h-0.031c-0.188,1.051-0.423,2.084-0.815,3.449l-1.504,5.5H617.684z"/>
	<path class="disabled" d="M632.383,147.006c0.392,0.252,1.301,0.643,2.257,0.643c1.771,0,2.319-1.127,2.304-1.975
		c-0.016-1.426-1.301-2.037-2.633-2.037h-0.768v-1.033h0.768c1.003,0,2.272-0.518,2.272-1.725c0-0.814-0.518-1.535-1.787-1.535
		c-0.814,0-1.598,0.359-2.037,0.674l-0.36-1.004c0.533-0.391,1.567-0.783,2.664-0.783c2.006,0,2.915,1.191,2.915,2.43
		c0,1.049-0.627,1.943-1.881,2.396v0.033c1.254,0.25,2.272,1.189,2.272,2.615c0,1.631-1.27,3.057-3.714,3.057
		c-1.145,0-2.147-0.361-2.648-0.689L632.383,147.006z"/>
	<path class="disabled" d="M560.337,148.338l-2.68-10.563h1.441l1.254,5.344c0.313,1.316,0.596,2.633,0.783,3.651h0.031
		c0.173-1.05,0.502-2.304,0.862-3.667l1.41-5.328h1.426l1.285,5.359c0.298,1.254,0.58,2.508,0.736,3.62h0.031
		c0.22-1.159,0.518-2.335,0.847-3.651l1.395-5.328h1.395l-2.993,10.563h-1.426l-1.332-5.5c-0.329-1.348-0.549-2.383-0.689-3.448
		h-0.031c-0.188,1.05-0.423,2.084-0.815,3.448l-1.504,5.5H560.337z"/>
	<path class="disabled" d="M578.97,148.338v-2.773h-4.732v-0.909l4.544-6.503h1.489v6.33h1.426v1.082h-1.426v2.773H578.97z M578.97,144.483v-3.4
		c0-0.532,0.016-1.065,0.047-1.598h-0.047c-0.313,0.595-0.564,1.034-0.847,1.504l-2.491,3.463v0.031H578.97z"/>
	<path class="disabled" d="M498.882,137.223l-2.68-10.563h1.441l1.254,5.344c0.313,1.316,0.596,2.633,0.783,3.65h0.031
		c0.173-1.049,0.502-2.303,0.862-3.666l1.41-5.328h1.426l1.285,5.359c0.298,1.254,0.58,2.508,0.736,3.619h0.031
		c0.22-1.158,0.518-2.334,0.847-3.65l1.395-5.328h1.395l-2.993,10.563h-1.426l-1.332-5.5c-0.329-1.348-0.549-2.383-0.689-3.449
		h-0.031c-0.188,1.051-0.423,2.084-0.815,3.449l-1.504,5.5H498.882z"/>
	<path class="disabled" d="M519.332,128.196h-3.886l-0.392,2.617c0.234-0.031,0.454-0.063,0.83-0.063c0.783,0,1.567,0.172,2.194,0.549
		c0.799,0.455,1.457,1.332,1.457,2.617c0,1.99-1.583,3.479-3.792,3.479c-1.113,0-2.054-0.313-2.539-0.627l0.345-1.049
		c0.423,0.25,1.254,0.563,2.179,0.563c1.3,0,2.413-0.846,2.413-2.209c-0.016-1.316-0.894-2.256-2.931-2.256
		c-0.58,0-1.034,0.063-1.41,0.109l0.658-4.889h4.873V128.196z"/>
	<path class="disabled" d="M432.907,136.957l-2.68-10.563h1.441l1.254,5.344c0.314,1.316,0.596,2.633,0.783,3.65h0.031
		c0.174-1.049,0.502-2.303,0.863-3.666l1.41-5.328h1.426l1.285,5.359c0.297,1.254,0.58,2.508,0.736,3.619h0.031
		c0.219-1.158,0.518-2.334,0.846-3.65l1.395-5.328h1.395l-2.992,10.563h-1.426l-1.332-5.5c-0.33-1.348-0.549-2.383-0.689-3.449
		h-0.031c-0.189,1.051-0.424,2.084-0.816,3.449l-1.504,5.5H432.907z"/>
	<path class="disabled" d="M453.093,127.742c-0.283-0.016-0.643,0-1.035,0.063c-2.162,0.361-3.307,1.943-3.541,3.619h0.047
		c0.484-0.641,1.332-1.174,2.459-1.174c1.803,0,3.072,1.301,3.072,3.291c0,1.863-1.27,3.588-3.385,3.588
		c-2.178,0-3.604-1.693-3.604-4.34c0-2.006,0.721-3.59,1.723-4.592c0.846-0.832,1.975-1.348,3.26-1.506
		c0.408-0.063,0.752-0.078,1.004-0.078V127.742z M452.7,133.619c0-1.457-0.83-2.336-2.1-2.336c-0.83,0-1.6,0.518-1.975,1.254
		c-0.094,0.156-0.156,0.361-0.156,0.611c0.031,1.678,0.799,2.914,2.24,2.914C451.901,136.063,452.7,135.076,452.7,133.619z"/>
	
	<path class="disabled" d="M601.108,461.022h5.689v1.145h-4.326v3.51h3.996v1.129h-3.996v4.779h-1.363V461.022z"/>
	<path class="disabled" d="M611.577,471.584v-0.847l1.082-1.05c2.601-2.476,3.775-3.792,3.791-5.328c0-1.034-0.501-1.99-2.021-1.99
		c-0.924,0-1.691,0.471-2.162,0.862l-0.438-0.972c0.705-0.596,1.708-1.034,2.884-1.034c2.193,0,3.118,1.505,3.118,2.962
		c0,1.881-1.364,3.4-3.511,5.469l-0.814,0.752v0.032h4.576v1.144H611.577z"/>
	<path class="disabled" d="M514.174,462.088l5.683,0.259l-0.053,1.144l-4.32-0.197l-0.159,3.507l3.991,0.182l-0.051,1.128l-3.992-0.182l-0.217,4.774
		l-1.362-0.063L514.174,462.088z"/>
	<path class="disabled" d="M524.552,471.549c0.38,0.269,1.271,0.701,2.225,0.744c1.77,0.081,2.369-1.021,2.392-1.867
		c0.049-1.426-1.206-2.095-2.537-2.155l-0.768-0.034l0.047-1.033l0.768,0.034c1.001,0.046,2.293-0.412,2.348-1.618
		c0.037-0.814-0.447-1.559-1.715-1.616c-0.814-0.036-1.613,0.288-2.066,0.581l-0.313-1.019c0.55-0.366,1.601-0.711,2.697-0.661
		c2.004,0.091,2.856,1.322,2.801,2.559c-0.048,1.049-0.715,1.913-1.988,2.31l-0.001,0.032c1.241,0.307,2.217,1.293,2.152,2.717
		c-0.074,1.628-1.407,2.996-3.851,2.885c-1.142-0.052-2.127-0.459-2.614-0.811L524.552,471.549z"/>
	<path class="disabled" d="M437.399,463.913h5.688v1.145h-4.324v3.51h3.996v1.129h-3.996v4.779h-1.363V463.913z"/>
	<path class="disabled" d="M452.13,474.475v-2.773h-4.732v-0.91l4.545-6.502h1.488v6.33h1.426v1.082h-1.426v2.773H452.13z M452.13,470.62v-3.4
		c0-0.533,0.016-1.066,0.047-1.598h-0.047c-0.314,0.594-0.564,1.033-0.846,1.504l-2.492,3.463v0.031H452.13z"/>
	<path class="disabled" d="M369.711,464.304h5.688v1.144h-4.324v3.511h3.996v1.128h-3.996v4.779h-1.363V464.304z"/>
	<path class="disabled" d="M386.26,465.84h-3.887l-0.393,2.617c0.235-0.032,0.455-0.063,0.831-0.063c0.784,0,1.567,0.173,2.194,0.549
		c0.799,0.454,1.457,1.332,1.457,2.616c0,1.99-1.583,3.479-3.793,3.479c-1.112,0-2.053-0.313-2.538-0.627l0.345-1.05
		c0.424,0.251,1.254,0.564,2.178,0.564c1.301,0,2.414-0.847,2.414-2.21c-0.016-1.316-0.894-2.257-2.931-2.257
		c-0.58,0-1.034,0.063-1.411,0.109l0.658-4.889h4.875V465.84z"/>
	<path class="disabled" d="M244.837,397.983c0.615-0.092,1.347-0.162,2.148-0.162c1.451,0,2.484,0.337,3.17,0.976c0.696,0.639,1.103,1.544,1.103,2.81
		c0,1.277-0.395,2.322-1.126,3.043c-0.732,0.731-1.939,1.127-3.461,1.127c-0.72,0-1.323-0.035-1.834-0.094V397.983z
		 M245.847,404.905c0.256,0.046,0.627,0.058,1.021,0.058c2.16,0,3.333-1.208,3.333-3.321c0.012-1.846-1.033-3.02-3.17-3.02
		c-0.522,0-0.917,0.047-1.185,0.105V404.905z"/>
	<path class="disabled" d="M260.416,401.711c0,2.693-1.638,4.122-3.635,4.122c-2.066,0-3.519-1.603-3.519-3.972c0-2.484,1.544-4.11,3.635-4.11
		C259.033,397.751,260.416,399.389,260.416,401.711z M254.342,401.838c0,1.672,0.905,3.17,2.497,3.17
		c1.602,0,2.508-1.475,2.508-3.251c0-1.556-0.813-3.182-2.496-3.182C255.178,398.576,254.342,400.12,254.342,401.838z"/>
	<path class="disabled" d="M269.478,402.268c-0.058-1.092-0.127-2.403-0.115-3.379h-0.035c-0.268,0.918-0.592,1.893-0.986,2.973l-1.383,3.797h-0.766
		l-1.266-3.727c-0.372-1.104-0.686-2.113-0.906-3.043h-0.023c-0.023,0.976-0.081,2.287-0.15,3.461l-0.209,3.355h-0.965l0.547-7.826
		h1.289l1.335,3.785c0.325,0.964,0.592,1.823,0.79,2.636h0.034c0.197-0.79,0.476-1.648,0.825-2.636l1.393-3.785h1.289l0.488,7.826
		h-0.988L269.478,402.268z"/>
	<path class="disabled" d="M278.853,399.11h-0.023l-1.313,0.709l-0.197-0.778l1.648-0.883h0.871v7.548h-0.986V399.11z"/>
	<path class="disabled" d="M171.552,393.618c0.711-0.107,1.556-0.188,2.48-0.188c1.678,0,2.871,0.389,3.662,1.127
		c0.805,0.737,1.274,1.783,1.274,3.246c0,1.475-0.456,2.682-1.302,3.514c-0.844,0.845-2.239,1.301-3.996,1.301
		c-0.832,0-1.529-0.041-2.119-0.107V393.618z M172.718,401.612c0.296,0.054,0.725,0.066,1.182,0.066
		c2.494,0,3.849-1.395,3.849-3.836c0.014-2.133-1.194-3.486-3.661-3.486c-0.604,0-1.061,0.053-1.369,0.12V401.612z"/>
	<path class="disabled" d="M189.548,397.923c0,3.111-1.891,4.761-4.197,4.761c-2.389,0-4.064-1.851-4.064-4.586c0-2.871,1.783-4.748,4.198-4.748
		C187.953,393.35,189.548,395.241,189.548,397.923z M182.534,398.071c0,1.932,1.046,3.662,2.884,3.662
		c1.852,0,2.896-1.704,2.896-3.756c0-1.797-0.938-3.676-2.883-3.676C183.5,394.301,182.534,396.086,182.534,398.071z"/>
	<path class="disabled" d="M200.021,398.567c-0.066-1.261-0.147-2.776-0.135-3.902h-0.039c-0.309,1.059-0.685,2.186-1.141,3.434l-1.596,4.385h-0.886
		l-1.462-4.305c-0.43-1.274-0.791-2.441-1.046-3.514h-0.026c-0.027,1.126-0.095,2.642-0.175,3.996l-0.241,3.877h-1.113l0.63-9.041
		h1.489l1.542,4.373c0.376,1.113,0.685,2.105,0.912,3.045h0.04c0.229-0.912,0.551-1.904,0.953-3.045l1.609-4.373h1.488l0.563,9.041
		h-1.14L200.021,398.567z"/>
	<path class="disabled" d="M208.292,402.538v-0.725l0.926-0.898c2.227-2.119,3.232-3.246,3.246-4.561c0-0.885-0.43-1.703-1.73-1.703
		c-0.791,0-1.449,0.402-1.852,0.737l-0.375-0.831c0.604-0.51,1.462-0.886,2.468-0.886c1.878,0,2.669,1.288,2.669,2.535
		c0,1.609-1.167,2.91-3.004,4.681l-0.697,0.645v0.026h3.916v0.979H208.292z"/>
	<path class="disabled" d="M127.657,346.211c0.711-0.106,1.556-0.188,2.48-0.188c1.678,0,2.871,0.389,3.662,1.127
		c0.805,0.738,1.274,1.783,1.274,3.246c0,1.475-0.456,2.682-1.302,3.514c-0.844,0.846-2.239,1.301-3.996,1.301
		c-0.832,0-1.529-0.04-2.119-0.107V346.211z M128.823,354.206c0.296,0.055,0.725,0.067,1.182,0.067c2.494,0,3.849-1.396,3.849-3.836
		c0.014-2.133-1.194-3.487-3.661-3.487c-0.604,0-1.061,0.054-1.369,0.121V354.206z"/>
	<path class="disabled" d="M145.653,350.518c0,3.111-1.891,4.761-4.197,4.761c-2.389,0-4.064-1.851-4.064-4.587c0-2.87,1.783-4.748,4.198-4.748
		C144.058,345.944,145.653,347.834,145.653,350.518z M138.639,350.665c0,1.932,1.046,3.662,2.884,3.662
		c1.852,0,2.896-1.703,2.896-3.756c0-1.797-0.938-3.675-2.883-3.675C139.604,346.896,138.639,348.68,138.639,350.665z"/>
	<path class="disabled" d="M156.126,351.161c-0.066-1.26-0.147-2.775-0.135-3.902h-0.039c-0.309,1.06-0.685,2.186-1.141,3.434l-1.596,4.386h-0.886
		l-1.462-4.306c-0.43-1.273-0.791-2.441-1.046-3.514h-0.026c-0.027,1.127-0.095,2.643-0.175,3.997l-0.241,3.876h-1.113l0.63-9.04
		h1.489l1.542,4.372c0.376,1.113,0.685,2.105,0.912,3.045h0.04c0.229-0.912,0.551-1.904,0.953-3.045l1.609-4.372h1.488l0.563,9.04
		h-1.14L156.126,351.161z"/>
	<path class="disabled" d="M164.679,353.777c0.336,0.214,1.113,0.55,1.932,0.55c1.516,0,1.985-0.966,1.972-1.689
		c-0.013-1.221-1.113-1.744-2.253-1.744h-0.657v-0.885h0.657c0.858,0,1.945-0.443,1.945-1.477c0-0.697-0.443-1.314-1.529-1.314
		c-0.697,0-1.369,0.309-1.744,0.578l-0.309-0.859c0.456-0.335,1.342-0.67,2.28-0.67c1.717,0,2.495,1.02,2.495,2.078
		c0,0.898-0.537,1.664-1.609,2.053v0.026c1.072,0.215,1.944,1.02,1.944,2.24c0,1.396-1.087,2.615-3.179,2.615
		c-0.979,0-1.838-0.309-2.267-0.59L164.679,353.777z"/>
	<path class="disabled" d="M131.49,232.726c0.711-0.107,1.556-0.188,2.481-0.188c1.676,0,2.87,0.389,3.661,1.126c0.805,0.738,1.274,1.784,1.274,3.246
		c0,1.475-0.456,2.682-1.301,3.514c-0.846,0.845-2.24,1.301-3.997,1.301c-0.832,0-1.529-0.041-2.119-0.107V232.726z M132.657,240.72
		c0.295,0.054,0.724,0.067,1.18,0.067c2.495,0,3.85-1.395,3.85-3.836c0.014-2.133-1.193-3.487-3.661-3.487
		c-0.604,0-1.06,0.054-1.368,0.121V240.72z"/>
	<path class="disabled" d="M149.487,237.032c0,3.112-1.892,4.761-4.198,4.761c-2.388,0-4.064-1.851-4.064-4.587c0-2.87,1.784-4.748,4.198-4.748
		C147.891,232.458,149.487,234.349,149.487,237.032z M142.473,237.179c0,1.931,1.046,3.662,2.884,3.662
		c1.851,0,2.896-1.704,2.896-3.755c0-1.797-0.938-3.675-2.884-3.675C143.438,233.41,142.473,235.194,142.473,237.179z"/>
	<path class="disabled" d="M159.96,237.675c-0.067-1.261-0.147-2.776-0.134-3.903h-0.041c-0.308,1.06-0.684,2.186-1.14,3.434l-1.596,4.386h-0.886
		l-1.462-4.305c-0.429-1.274-0.791-2.441-1.046-3.514h-0.027c-0.026,1.126-0.094,2.642-0.174,3.997l-0.241,3.876h-1.113l0.63-9.04
		h1.489l1.542,4.373c0.376,1.113,0.685,2.105,0.912,3.044h0.04c0.229-0.912,0.55-1.904,0.952-3.044l1.609-4.373h1.489l0.563,9.04
		h-1.141L159.96,237.675z"/>
	<path class="disabled" d="M173.435,233.92h-3.326l-0.336,2.24c0.202-0.027,0.39-0.054,0.711-0.054c0.671,0,1.342,0.148,1.878,0.47
		c0.685,0.389,1.248,1.14,1.248,2.24c0,1.704-1.355,2.978-3.246,2.978c-0.952,0-1.757-0.268-2.173-0.537l0.295-0.898
		c0.362,0.214,1.073,0.483,1.864,0.483c1.113,0,2.065-0.724,2.065-1.891c-0.014-1.127-0.765-1.932-2.508-1.932
		c-0.496,0-0.886,0.054-1.207,0.094l0.563-4.185h4.171V233.92z"/>
	<path class="disabled" d="M244.642,180.938c0.605-0.091,1.324-0.16,2.111-0.16c1.427,0,2.443,0.331,3.116,0.959c0.685,0.628,1.084,1.519,1.084,2.763
		c0,1.255-0.388,2.282-1.106,2.99c-0.72,0.719-1.906,1.106-3.401,1.106c-0.708,0-1.302-0.034-1.804-0.091V180.938z M245.635,187.741
		c0.251,0.046,0.616,0.057,1.005,0.057c2.122,0,3.275-1.187,3.275-3.264c0.012-1.815-1.016-2.968-3.116-2.968
		c-0.514,0-0.901,0.046-1.164,0.103V187.741z"/>
	<path class="disabled" d="M259.959,184.602c0,2.647-1.609,4.052-3.572,4.052c-2.031,0-3.458-1.575-3.458-3.903c0-2.442,1.518-4.041,3.572-4.041
		C258.601,180.709,259.959,182.319,259.959,184.602z M253.99,184.727c0,1.644,0.89,3.116,2.454,3.116
		c1.574,0,2.465-1.449,2.465-3.196c0-1.529-0.799-3.127-2.454-3.127C254.812,181.52,253.99,183.039,253.99,184.727z"/>
	<path class="disabled" d="M268.874,185.15c-0.058-1.073-0.126-2.363-0.114-3.321h-0.034c-0.263,0.901-0.582,1.86-0.971,2.922l-1.357,3.731h-0.754
		l-1.244-3.663c-0.365-1.085-0.673-2.077-0.89-2.99h-0.023c-0.022,0.958-0.08,2.248-0.148,3.401l-0.205,3.298h-0.947l0.536-7.692
		h1.268l1.313,3.721c0.319,0.947,0.582,1.792,0.775,2.591h0.034c0.194-0.776,0.469-1.621,0.811-2.591l1.37-3.721h1.267l0.479,7.692
		h-0.971L268.874,185.15z"/>
	<path class="disabled" d="M280.732,181.109v0.662l-3.229,6.757h-1.039l3.219-6.563v-0.022h-3.63v-0.834H280.732z"/>
	<path class="disabled" d="M171.021,186.492c0.711-0.107,1.556-0.188,2.481-0.188c1.676,0,2.87,0.389,3.661,1.126
		c0.805,0.738,1.274,1.784,1.274,3.246c0,1.475-0.456,2.682-1.301,3.514c-0.846,0.845-2.24,1.301-3.997,1.301
		c-0.832,0-1.529-0.041-2.119-0.107V186.492z M172.188,194.486c0.295,0.054,0.724,0.067,1.18,0.067c2.495,0,3.85-1.395,3.85-3.836
		c0.014-2.133-1.193-3.487-3.661-3.487c-0.604,0-1.06,0.054-1.368,0.121V194.486z"/>
	<path class="disabled" d="M189.018,190.797c0,3.112-1.892,4.761-4.198,4.761c-2.388,0-4.064-1.851-4.064-4.587c0-2.87,1.784-4.748,4.198-4.748
		C187.421,186.224,189.018,188.115,189.018,190.797z M182.003,190.945c0,1.931,1.046,3.662,2.884,3.662
		c1.851,0,2.896-1.704,2.896-3.755c0-1.797-0.938-3.675-2.884-3.675C182.969,187.176,182.003,188.96,182.003,190.945z"/>
	<path class="disabled" d="M199.49,191.441c-0.067-1.261-0.147-2.776-0.134-3.903h-0.041c-0.309,1.06-0.684,2.186-1.14,3.434l-1.596,4.386h-0.886
		l-1.462-4.305c-0.429-1.274-0.791-2.441-1.046-3.514h-0.027c-0.026,1.126-0.094,2.642-0.174,3.997l-0.241,3.876h-1.113l0.63-9.04
		h1.489l1.542,4.373c0.376,1.113,0.685,2.105,0.912,3.044h0.04c0.229-0.912,0.55-1.904,0.952-3.044l1.609-4.373h1.489l0.563,9.04
		h-1.141L199.49,191.441z"/>
	<path class="disabled" d="M212.737,187.524c-0.242-0.013-0.551,0-0.886,0.054c-1.851,0.309-2.83,1.663-3.031,3.099h0.04
		c0.416-0.55,1.141-1.006,2.106-1.006c1.542,0,2.628,1.113,2.628,2.817c0,1.596-1.086,3.071-2.896,3.071
		c-1.864,0-3.085-1.448-3.085-3.715c0-1.717,0.617-3.071,1.476-3.93c0.724-0.711,1.689-1.153,2.789-1.288
		c0.35-0.054,0.645-0.067,0.859-0.067V187.524z M212.401,192.554c0-1.247-0.711-1.999-1.797-1.999c-0.711,0-1.368,0.443-1.69,1.073
		c-0.08,0.134-0.134,0.309-0.134,0.523c0.026,1.435,0.684,2.495,1.918,2.495C211.718,194.646,212.401,193.802,212.401,192.554z"/>
	<path class="disabled" d="M286.217,319.415l-2.393-7.395h1.471l1.01,3.357c0.285,0.932,0.526,1.799,0.724,2.699h0.022
		c0.197-0.879,0.461-1.777,0.756-2.678l1.076-3.379h1.438l-2.557,7.395H286.217z"/>
	<path class="disabled" d="M293.567,312.02v7.395h-1.35v-7.395H293.567z"/>
	<path class="disabled" d="M296.209,312.119c0.483-0.087,1.152-0.153,2.063-0.153c0.988,0,1.713,0.209,2.184,0.604
		c0.439,0.361,0.725,0.943,0.725,1.635c0,0.701-0.22,1.283-0.637,1.678c-0.537,0.538-1.383,0.791-2.336,0.791
		c-0.253,0-0.483-0.012-0.659-0.045v2.787h-1.339V312.119z M297.548,315.563c0.165,0.045,0.384,0.056,0.659,0.056
		c1.009,0,1.623-0.493,1.623-1.36c0-0.822-0.57-1.262-1.503-1.262c-0.373,0-0.636,0.033-0.779,0.066V315.563z"/>
	<path class="disabled" d="M308.617,313.5h-0.022l-1.305,0.658l-0.23-1.02l1.732-0.855h1.131v7.131h-1.306V313.5z"/>
    
    
	<circle id="vip5" onClick="reply_click(this.id)" data-id="vip5"';
        
            $result = $this->get_table_stat("vip5", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" cx="231.341" cy="256.24" r="11.065"/>
	
    <circle id="vip3" onClick="reply_click(this.id)" data-id="vip3"';
    
        $result = $this->get_table_stat("vip3", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

        echo 'data-value="'.$result->guest_status.'"';
        echo ' data-name="'.$result->name.'"';
        echo ' data-date="'.$result->booking_date.'"';
        echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" cx="231.341" cy="332.029" r="11.064"/>
    
    
	<path class="disabled" d="M225.271,334.164l-1.285-4.011h0.993l0.488,1.695c0.137,0.477,0.262,0.935,0.357,1.435h0.018
		c0.102-0.482,0.227-0.958,0.363-1.416l0.512-1.714h0.964l-1.351,4.011H225.271z"/>
	<path class="disabled" d="M230.215,330.153v4.011h-0.91v-4.011H230.215z"/>
	<path class="disabled" d="M232.193,330.206c0.279-0.047,0.673-0.083,1.227-0.083c0.559,0,0.957,0.107,1.226,0.321
		c0.256,0.202,0.429,0.536,0.429,0.929s-0.131,0.726-0.369,0.952c-0.31,0.291-0.768,0.422-1.304,0.422
		c-0.118,0-0.226-0.006-0.31-0.018v1.435h-0.898V330.206z M233.092,332.027c0.078,0.018,0.173,0.023,0.304,0.023
		c0.481,0,0.78-0.243,0.78-0.654c0-0.369-0.256-0.589-0.709-0.589c-0.184,0-0.309,0.018-0.375,0.035V332.027z"/>
	<path class="disabled" d="M236.863,333.277c0.161,0.083,0.53,0.238,0.898,0.238c0.471,0,0.709-0.227,0.709-0.519c0-0.381-0.381-0.553-0.779-0.553
		h-0.369v-0.649h0.351c0.304-0.006,0.69-0.118,0.69-0.446c0-0.231-0.19-0.404-0.571-0.404c-0.315,0-0.648,0.137-0.81,0.232
		l-0.184-0.655c0.231-0.148,0.695-0.291,1.195-0.291c0.828,0,1.285,0.435,1.285,0.964c0,0.41-0.231,0.732-0.707,0.898v0.012
		c0.463,0.084,0.838,0.435,0.838,0.94c0,0.685-0.601,1.185-1.582,1.185c-0.5,0-0.923-0.131-1.148-0.274L236.863,333.277z"/>
	<path class="disabled" d="M205.052,296.694l-2.37-7.395h1.832l0.9,3.127c0.252,0.878,0.482,1.723,0.658,2.645h0.033
		c0.186-0.889,0.416-1.767,0.669-2.611l0.943-3.16h1.777l-2.49,7.395H205.052z"/>
	<path class="disabled" d="M214.157,289.299v7.395h-1.678v-7.395H214.157z"/>
	<path class="disabled" d="M217.799,289.399c0.516-0.088,1.239-0.154,2.26-0.154c1.03,0,1.766,0.197,2.26,0.593c0.472,0.373,0.789,0.987,0.789,1.712
		c0,0.724-0.241,1.338-0.68,1.755c-0.57,0.538-1.415,0.778-2.402,0.778c-0.219,0-0.417-0.01-0.57-0.032v2.644h-1.656V289.399z
		 M219.456,292.756c0.143,0.032,0.318,0.043,0.56,0.043c0.888,0,1.437-0.449,1.437-1.207c0-0.68-0.472-1.086-1.305-1.086
		c-0.34,0-0.57,0.033-0.691,0.066V292.756z"/>
	<path class="disabled" d="M229.054,296.694v-1.7h-3.16v-1.086l2.699-4.345h2.041v4.18h0.855v1.251h-0.855v1.7H229.054z M229.054,293.743v-1.58
		c0-0.428,0.021-0.866,0.055-1.326h-0.044c-0.23,0.46-0.417,0.877-0.658,1.326l-0.954,1.559v0.021H229.054z"/>
	<path class="disabled" d="M224.705,258.934l-1.285-4.011h0.993l0.488,1.695c0.137,0.477,0.262,0.935,0.357,1.435h0.018
		c0.102-0.482,0.227-0.958,0.363-1.416l0.512-1.714h0.964l-1.351,4.011H224.705z"/>
	<path class="disabled" d="M229.649,254.923v4.011h-0.911v-4.011H229.649z"/>
	<path class="disabled" d="M231.627,254.976c0.28-0.047,0.673-0.083,1.226-0.083c0.56,0,0.959,0.107,1.227,0.321c0.256,0.202,0.429,0.536,0.429,0.929
		s-0.132,0.726-0.369,0.952c-0.31,0.291-0.768,0.422-1.304,0.422c-0.119,0-0.226-0.006-0.31-0.018v1.435h-0.898V254.976z
		 M232.525,256.797c0.078,0.018,0.173,0.023,0.304,0.023c0.482,0,0.779-0.243,0.779-0.654c0-0.369-0.256-0.589-0.708-0.589
		c-0.185,0-0.31,0.018-0.375,0.035V256.797z"/>
	<path class="disabled" d="M238.72,255.81h-1.5l-0.083,0.595c0.083-0.012,0.154-0.012,0.25-0.012c0.368,0,0.743,0.083,1.018,0.279
		c0.291,0.196,0.47,0.518,0.47,0.97c0,0.721-0.619,1.357-1.66,1.357c-0.471,0-0.863-0.107-1.077-0.221l0.16-0.678
		c0.173,0.083,0.524,0.19,0.875,0.19c0.375,0,0.773-0.179,0.773-0.59c0-0.398-0.315-0.643-1.089-0.643
		c-0.214,0-0.362,0.012-0.523,0.036l0.256-2.029h2.131V255.81z"/>
	<path class="disabled" d="M285.51,274.281l-2.392-7.395h1.47l1.01,3.357c0.285,0.932,0.526,1.799,0.724,2.699h0.022
		c0.197-0.878,0.46-1.777,0.757-2.677l1.075-3.379h1.437l-2.556,7.395H285.51z"/>
	<path class="disabled" d="M292.858,266.887v7.395h-1.349v-7.395H292.858z"/>
	<path class="disabled" d="M295.503,266.985c0.482-0.087,1.151-0.153,2.063-0.153c0.987,0,1.711,0.208,2.183,0.604
		c0.439,0.362,0.725,0.943,0.725,1.634c0,0.702-0.22,1.284-0.637,1.679c-0.537,0.538-1.382,0.79-2.337,0.79
		c-0.252,0-0.482-0.011-0.658-0.044v2.787h-1.338V266.985z M296.841,270.43c0.165,0.044,0.384,0.055,0.658,0.055
		c1.01,0,1.624-0.494,1.624-1.36c0-0.823-0.57-1.262-1.503-1.262c-0.373,0-0.637,0.033-0.779,0.066V270.43z"/>
	<path class="disabled" d="M305.791,274.281v-0.823l0.845-0.779c1.679-1.558,2.469-2.414,2.479-3.357c0-0.636-0.34-1.196-1.272-1.196
		c-0.625,0-1.163,0.318-1.525,0.592l-0.395-0.954c0.516-0.417,1.295-0.735,2.194-0.735c1.58,0,2.348,0.999,2.348,2.161
		c0,1.251-0.899,2.26-2.14,3.412l-0.625,0.538v0.022h2.929v1.119H305.791z"/>
	<line class="disabled" fill="none" x1="799.511" y1="332.934" x2="815.187" y2="332.934"/>
	
		<rect x="789.327" y="220.524" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="18.805" height="188.053"/>
	<path class="disabled" d="M802.245,339.516c0.347-0.564,0.637-1.389,0.637-2.258c0-1.287-0.681-2.039-1.664-2.039c-0.911,0-1.432,0.521-1.938,1.838
		c-0.563,1.59-1.389,2.574-2.763,2.574c-1.519,0-2.647-1.258-2.647-3.153c0-0.998,0.231-1.722,0.478-2.155l1.027,0.348
		c-0.174,0.317-0.463,0.969-0.463,1.852c0,1.33,0.796,1.836,1.461,1.836c0.911,0,1.359-0.593,1.881-1.938
		c0.636-1.649,1.432-2.488,2.863-2.488c1.505,0,2.807,1.113,2.807,3.414c0,0.939-0.274,1.967-0.622,2.488L802.245,339.516z"/>
	<path class="disabled" d="M803.46,322.501c0.231,0.463,0.463,1.389,0.463,2.575c0,2.748-1.735,4.816-4.933,4.816c-3.052,0-5.121-2.068-5.121-5.092
		c0-1.215,0.261-1.981,0.435-2.314l1.027,0.305c-0.232,0.477-0.405,1.156-0.405,1.967c0,2.285,1.461,3.805,4.021,3.805
		c2.387,0,3.92-1.375,3.92-3.747c0-0.767-0.159-1.548-0.405-2.054L803.46,322.501z"/>
	<path class="disabled" d="M794.159,318.03c-0.131-0.637-0.203-1.549-0.203-2.416c0-1.346,0.246-2.213,0.796-2.821c0.434-0.491,1.1-0.767,1.852-0.767
		c1.287,0,2.141,0.811,2.488,1.838h0.043c0.261-0.753,0.955-1.201,1.968-1.433c1.359-0.318,2.3-0.55,2.676-0.753v1.303
		c-0.274,0.158-1.114,0.376-2.329,0.65c-1.345,0.289-1.852,0.811-1.895,1.953v1.186h4.224v1.26H794.159z M798.6,316.77v-1.287
		c0-1.346-0.737-2.199-1.852-2.199c-1.259,0-1.808,0.912-1.822,2.242c0,0.608,0.058,1.042,0.115,1.244H798.6z"/>
	<path class="disabled" d="M799.207,302.302v3.79h3.516v-4.224h1.056v5.481h-9.75v-5.265h1.057v4.007h3.081v-3.79H799.207z"/>
	<path class="disabled" d="M799.207,292.29v3.791h3.516v-4.225h1.056v5.482h-9.75v-5.266h1.057v4.008h3.081v-3.791H799.207z"/>
	<path class="disabled" d="M803.778,287.327h-9.75v-1.374l4.933-3.124c1.144-0.724,2.17-1.288,3.168-1.751l-0.014-0.028
		c-1.303,0.115-2.488,0.145-4.007,0.145h-4.08v-1.187h9.75v1.273l-4.947,3.095c-1.085,0.681-2.198,1.331-3.255,1.823l0.015,0.043
		c1.229-0.072,2.401-0.101,4.021-0.101h4.166V287.327z"/>
        
	<circle id="s33" onClick="reply_click(this.id)" data-id="s33"';
        
            $result = $this->get_table_stat("s33", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="471.103" cy="393.723" r="9.99"/>
    
	<path class="disabled" d="M423.7,228.803c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.461-0.274-0.713-0.988-0.977
		c-0.954-0.34-1.404-0.866-1.404-1.503c0-0.855,0.691-1.558,1.833-1.558c0.537,0,1.009,0.153,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.308-1.086-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.637,1.01,0.899
		c0.921,0.352,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.361L423.7,228.803z"/>
	<path class="disabled" d="M428.099,228.682c0.274,0.176,0.911,0.45,1.58,0.45c1.24,0,1.624-0.79,1.613-1.383c-0.012-0.998-0.911-1.426-1.844-1.426
		h-0.537v-0.725h0.537c0.702,0,1.591-0.361,1.591-1.206c0-0.571-0.361-1.075-1.25-1.075c-0.571,0-1.119,0.252-1.427,0.472
		l-0.252-0.702c0.373-0.274,1.097-0.549,1.865-0.549c1.404,0,2.04,0.834,2.04,1.7c0,0.735-0.438,1.36-1.316,1.679v0.022
		c0.878,0.175,1.591,0.834,1.591,1.832c0,1.141-0.889,2.14-2.601,2.14c-0.801,0-1.503-0.253-1.854-0.483L428.099,228.682z"/>
	<path class="disabled" d="M433.408,227.98c0-0.899,0.537-1.535,1.415-1.908l-0.011-0.033c-0.79-0.373-1.13-0.987-1.13-1.602
		c0-1.131,0.954-1.898,2.205-1.898c1.382,0,2.073,0.867,2.073,1.756c0,0.603-0.296,1.25-1.174,1.667v0.033
		c0.889,0.351,1.438,0.977,1.438,1.843c0,1.24-1.064,2.074-2.425,2.074C434.308,229.912,433.408,229.023,433.408,227.98z
		 M434.593,224.371c0,0.713,0.537,1.098,1.36,1.316c0.614-0.208,1.086-0.646,1.086-1.294c0-0.571-0.34-1.163-1.207-1.163
		C435.031,223.23,434.593,223.756,434.593,224.371z M437.248,227.936c0-0.866-0.604-1.283-1.569-1.558
		c-0.834,0.241-1.283,0.79-1.283,1.471c-0.033,0.724,0.516,1.36,1.426,1.36C436.688,229.209,437.248,228.671,437.248,227.936z"/>
	<circle id="s32" onClick="reply_click(this.id)" data-id="s32"';
        
            $result = $this->get_table_stat("s32", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="508.317" cy="402.362" r="9.99"/>
                
	<circle id="s40" onClick="reply_click(this.id)" data-id="s40"';
        
            $result = $this->get_table_stat("s40", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="481.699" cy="212.953" r="9.991"/>
                
	<circle id="s17" onClick="reply_click(this.id)" data-id="s17"';
        
            $result = $this->get_table_stat("s17", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="396.48" cy="224.786" r="9.99"/>
            
	<path class="disabled" d="M389.29,227.807c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.46-0.274-0.713-0.988-0.976
		c-0.954-0.34-1.404-0.867-1.404-1.503c0-0.856,0.691-1.558,1.833-1.558c0.537,0,1.009,0.154,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.636,1.01,0.899
		c0.921,0.351,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L389.29,227.807z"/>
	<path class="disabled" d="M395.828,222.563h-0.021l-1.24,0.669l-0.187-0.735l1.559-0.834h0.822v7.131h-0.933V222.563z"/>
	<path class="disabled" d="M404.264,221.663v0.637l-3.104,6.495h-0.998l3.094-6.309v-0.021h-3.489v-0.801H404.264z"/>
    
	<circle id="s16" onClick="reply_click(this.id)" data-id="s16"';
        
            $result = $this->get_table_stat("s16", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="396.48" cy="251.482" r="9.99"/>
    
	<path  class="disabled"d="M389.169,254.485c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.46-0.274-0.713-0.988-0.976
		c-0.954-0.34-1.404-0.867-1.404-1.503c0-0.856,0.691-1.558,1.833-1.558c0.537,0,1.009,0.154,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.636,1.01,0.899
		c0.921,0.351,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L389.169,254.485z"/>
	<path class="disabled" d="M395.707,249.241h-0.021l-1.24,0.669l-0.187-0.735l1.559-0.834h0.822v7.131h-0.933V249.241z"/>
	<path class="disabled" d="M403.583,249.021c-0.197-0.011-0.449,0-0.724,0.044c-1.514,0.252-2.314,1.36-2.479,2.535h0.033
		c0.34-0.45,0.933-0.823,1.723-0.823c1.262,0,2.15,0.911,2.15,2.304c0,1.306-0.889,2.512-2.37,2.512
		c-1.525,0-2.523-1.185-2.523-3.039c0-1.404,0.505-2.512,1.207-3.214c0.592-0.582,1.382-0.943,2.282-1.053
		c0.285-0.044,0.526-0.055,0.701-0.055V249.021z M403.31,253.135c0-1.02-0.582-1.635-1.471-1.635c-0.581,0-1.119,0.362-1.382,0.878
		c-0.066,0.11-0.11,0.252-0.11,0.428c0.022,1.174,0.56,2.041,1.569,2.041C402.75,254.847,403.31,254.156,403.31,253.135z"/>
        
	<circle id="s15" onClick="reply_click(this.id)" data-id="s15"';
        
            $result = $this->get_table_stat("s15", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="396.48" cy="279.748" r="9.986"/>
    
	<path class="disabled" d="M389.41,282.887c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.46-0.274-0.713-0.988-0.976
		c-0.954-0.34-1.404-0.867-1.404-1.503c0-0.856,0.691-1.558,1.833-1.558c0.537,0,1.009,0.154,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.636,1.01,0.899
		c0.921,0.351,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L389.41,282.887z"/>
	<path class="disabled" d="M395.948,277.643h-0.021l-1.24,0.669l-0.187-0.735l1.559-0.834h0.822v7.131h-0.933V277.643z"/>
	<path class="disabled" d="M404.011,277.555h-2.721l-0.273,1.832c0.164-0.022,0.317-0.044,0.581-0.044c0.549,0,1.097,0.121,1.536,0.384
		c0.56,0.318,1.021,0.933,1.021,1.832c0,1.394-1.108,2.436-2.655,2.436c-0.779,0-1.438-0.219-1.777-0.439l0.241-0.735
		c0.296,0.176,0.878,0.395,1.525,0.395c0.91,0,1.689-0.592,1.689-1.547c-0.012-0.922-0.626-1.58-2.052-1.58
		c-0.406,0-0.725,0.044-0.987,0.077l0.461-3.423h3.411V277.555z"/>
        
	<circle id="s14" onClick="reply_click(this.id)" data-id="s14"';
        
            $result = $this->get_table_stat("s14", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="396.48" cy="307.22" r="9.989"/>
    
	<path class="disabled" d="M389.158,310.131c0.285,0.187,0.79,0.384,1.273,0.384c0.701,0,1.031-0.351,1.031-0.79c0-0.461-0.275-0.713-0.988-0.977
		c-0.954-0.34-1.404-0.866-1.404-1.502c0-0.856,0.691-1.559,1.832-1.559c0.538,0,1.01,0.154,1.307,0.329l-0.242,0.702
		c-0.208-0.132-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.328-0.889,0.724c0,0.438,0.318,0.636,1.01,0.899
		c0.922,0.352,1.393,0.813,1.393,1.602c0,0.934-0.724,1.592-1.985,1.592c-0.581,0-1.119-0.143-1.492-0.363L389.158,310.131z"/>
	<path class="disabled" d="M395.697,304.887h-0.022l-1.239,0.669l-0.188-0.735l1.559-0.834h0.822v7.132h-0.932V304.887z"/>
	<path class="disabled" d="M402.486,311.119v-1.942h-3.313v-0.636l3.182-4.554h1.041v4.434h0.999v0.756h-0.999v1.942H402.486z M402.486,308.42v-2.381
		c0-0.373,0.012-0.746,0.033-1.119h-0.033c-0.219,0.416-0.395,0.724-0.592,1.053l-1.744,2.425v0.022H402.486z"/>
        
	<circle id="s13" onClick="reply_click(this.id)" data-id="s13"';
        
            $result = $this->get_table_stat("s13", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="396.48" cy="334.704" r="9.99"/>
    
	<path class="disabled" d="M389.339,337.907c0.285,0.187,0.79,0.384,1.273,0.384c0.701,0,1.031-0.352,1.031-0.79c0-0.461-0.275-0.713-0.988-0.977
		c-0.954-0.34-1.404-0.866-1.404-1.503c0-0.855,0.691-1.558,1.832-1.558c0.538,0,1.01,0.153,1.307,0.329l-0.242,0.702
		c-0.208-0.132-0.592-0.308-1.086-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.636,1.01,0.899
		c0.922,0.351,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L389.339,337.907z"/>
	<path class="disabled" d="M395.878,332.663h-0.022l-1.239,0.669l-0.188-0.735l1.559-0.834h0.822v7.132h-0.932V332.663z"/>
	<path class="disabled" d="M399.913,337.786c0.275,0.176,0.911,0.45,1.58,0.45c1.24,0,1.624-0.79,1.613-1.383c-0.012-0.998-0.911-1.426-1.844-1.426
		h-0.537v-0.725h0.537c0.703,0,1.592-0.362,1.592-1.207c0-0.57-0.363-1.075-1.252-1.075c-0.57,0-1.119,0.253-1.426,0.473
		l-0.252-0.702c0.373-0.274,1.097-0.549,1.865-0.549c1.404,0,2.04,0.834,2.04,1.7c0,0.735-0.438,1.36-1.316,1.679v0.021
		c0.878,0.176,1.591,0.834,1.591,1.833c0,1.141-0.889,2.139-2.6,2.139c-0.801,0-1.504-0.252-1.854-0.482L399.913,337.786z"/>
        
	<circle id="s12" onClick="reply_click(this.id)" data-id="s12"';
        
            $result = $this->get_table_stat("s12", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="396.48" cy="360.619" r="9.989"/>
    
	<path class="disabled" d="M389.268,363.76c0.285,0.187,0.79,0.384,1.273,0.384c0.701,0,1.031-0.352,1.031-0.79c0-0.461-0.275-0.713-0.988-0.977
		c-0.954-0.34-1.404-0.866-1.404-1.503c0-0.855,0.691-1.558,1.832-1.558c0.538,0,1.01,0.153,1.307,0.329l-0.242,0.702
		c-0.208-0.132-0.592-0.308-1.086-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.636,1.01,0.899
		c0.922,0.351,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L389.268,363.76z"/>
	<path class="disabled" d="M395.807,358.516h-0.022l-1.239,0.669l-0.188-0.735l1.559-0.834h0.822v7.132h-0.932V358.516z"/>
	<path class="disabled" d="M399.611,364.748v-0.593l0.758-0.735c1.82-1.733,2.644-2.654,2.654-3.729c0-0.725-0.351-1.394-1.415-1.394
		c-0.647,0-1.185,0.329-1.514,0.604l-0.308-0.681c0.494-0.417,1.196-0.724,2.02-0.724c1.535,0,2.183,1.053,2.183,2.073
		c0,1.316-0.954,2.381-2.458,3.829l-0.57,0.526v0.022h3.204v0.801H399.611z"/>
        
	<circle id="s11" onClick="reply_click(this.id)" data-id="s11"';
        
            $result = $this->get_table_stat("s11", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="396.48" cy="386.534" r="9.99"/>
    
	<path class="disabled" d="M390.091,390.375c0.285,0.187,0.79,0.384,1.273,0.384c0.701,0,1.031-0.352,1.031-0.79c0-0.46-0.275-0.713-0.988-0.976
		c-0.954-0.341-1.404-0.867-1.404-1.504c0-0.855,0.691-1.558,1.832-1.558c0.538,0,1.01,0.153,1.307,0.329l-0.242,0.702
		c-0.208-0.132-0.592-0.308-1.086-0.308c-0.57,0-0.889,0.33-0.889,0.725c0,0.439,0.318,0.637,1.01,0.899
		c0.922,0.351,1.393,0.812,1.393,1.603c0,0.932-0.724,1.59-1.985,1.59c-0.581,0-1.119-0.143-1.492-0.361L390.091,390.375z"/>
	<path class="disabled" d="M396.63,385.13h-0.022l-1.239,0.669l-0.188-0.734l1.559-0.834h0.822v7.131h-0.932V385.13z"/>
	<path class="disabled" d="M402.53,385.13h-0.021l-1.24,0.669l-0.186-0.734l1.557-0.834h0.823v7.131h-0.933V385.13z"/>
	<path class="disabled" d="M334.92,381.735c0.285,0.188,0.79,0.385,1.273,0.385c0.701,0,1.031-0.352,1.031-0.791c0-0.46-0.275-0.713-0.988-0.976
		c-0.954-0.341-1.404-0.866-1.404-1.503c0-0.855,0.691-1.559,1.832-1.559c0.538,0,1.01,0.154,1.307,0.33l-0.242,0.701
		c-0.208-0.131-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.636,1.01,0.898
		c0.922,0.352,1.393,0.813,1.393,1.603c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L334.92,381.735z"/>
	<path class="disabled" d="M341.459,376.491h-0.022l-1.239,0.67l-0.188-0.735l1.559-0.834h0.822v7.132h-0.932V376.491z"/>
	<path class="disabled" d="M334.098,344.378c0.285,0.187,0.79,0.384,1.273,0.384c0.701,0,1.031-0.351,1.031-0.79c0-0.46-0.275-0.713-0.988-0.976
		c-0.954-0.341-1.404-0.867-1.404-1.503c0-0.856,0.691-1.559,1.832-1.559c0.538,0,1.01,0.154,1.307,0.329l-0.242,0.702
		c-0.208-0.132-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.637,1.01,0.899
		c0.922,0.352,1.393,0.813,1.393,1.603c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L334.098,344.378z"/>
	<path class="disabled" d="M338.541,345.366v-0.592l0.756-0.735c1.822-1.733,2.645-2.655,2.656-3.73c0-0.724-0.352-1.394-1.416-1.394
		c-0.646,0-1.185,0.329-1.514,0.604l-0.307-0.68c0.493-0.417,1.195-0.725,2.018-0.725c1.536,0,2.184,1.054,2.184,2.074
		c0,1.316-0.955,2.38-2.457,3.828l-0.57,0.527v0.021h3.203v0.801H338.541z"/>
	<path class="disabled" d="M334.17,309.35c0.285,0.187,0.789,0.384,1.271,0.384c0.703,0,1.031-0.351,1.031-0.79c0-0.46-0.273-0.713-0.986-0.976
		c-0.955-0.341-1.404-0.867-1.404-1.503c0-0.856,0.69-1.559,1.832-1.559c0.537,0,1.009,0.154,1.305,0.329l-0.24,0.702
		c-0.209-0.132-0.594-0.307-1.087-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.637,1.009,0.899
		c0.922,0.352,1.395,0.813,1.395,1.603c0,0.933-0.725,1.591-1.986,1.591c-0.582,0-1.119-0.143-1.492-0.362L334.17,309.35z"/>
	<path class="disabled" d="M338.842,309.23c0.275,0.175,0.911,0.449,1.58,0.449c1.24,0,1.624-0.79,1.613-1.382c-0.012-0.999-0.911-1.427-1.844-1.427
		h-0.537v-0.724h0.537c0.703,0,1.592-0.362,1.592-1.207c0-0.57-0.363-1.075-1.252-1.075c-0.57,0-1.119,0.252-1.426,0.472
		l-0.252-0.702c0.373-0.274,1.097-0.549,1.865-0.549c1.404,0,2.04,0.834,2.04,1.701c0,0.734-0.438,1.36-1.316,1.679v0.021
		c0.878,0.176,1.591,0.834,1.591,1.832c0,1.142-0.889,2.14-2.6,2.14c-0.801,0-1.504-0.253-1.854-0.482L338.842,309.23z"/>
	<path class="disabled" d="M333.988,273.186c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.46-0.274-0.713-0.988-0.976
		c-0.954-0.34-1.404-0.867-1.404-1.503c0-0.856,0.691-1.558,1.833-1.558c0.537,0,1.009,0.154,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.636,1.01,0.899
		c0.921,0.351,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L333.988,273.186z"/>
	<path class="disabled" d="M341.415,274.173v-1.942h-3.313v-0.636l3.181-4.553h1.043v4.433h0.998v0.757h-0.998v1.942H341.415z M341.415,271.474
		v-2.381c0-0.373,0.012-0.746,0.033-1.119h-0.033c-0.219,0.417-0.395,0.724-0.592,1.053l-1.745,2.425v0.022H341.415z"/>
	<path class="disabled" d="M334.24,238.338c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.46-0.274-0.713-0.988-0.976
		c-0.954-0.34-1.404-0.867-1.404-1.503c0-0.856,0.691-1.558,1.833-1.558c0.537,0,1.009,0.154,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.636,1.01,0.899
		c0.921,0.351,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L334.24,238.338z"/>
	<path class="disabled" d="M342.939,233.006h-2.721l-0.274,1.832c0.165-0.022,0.318-0.044,0.582-0.044c0.549,0,1.097,0.121,1.536,0.384
		c0.56,0.318,1.021,0.933,1.021,1.832c0,1.394-1.108,2.436-2.655,2.436c-0.779,0-1.438-0.219-1.777-0.439l0.241-0.735
		c0.296,0.176,0.878,0.395,1.525,0.395c0.91,0,1.689-0.592,1.689-1.547c-0.012-0.922-0.626-1.58-2.052-1.58
		c-0.406,0-0.725,0.044-0.987,0.077l0.461-3.423h3.411V233.006z"/>
	<path class="disabled" d="M364.361,237.969c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.46-0.274-0.713-0.988-0.976
		c-0.954-0.34-1.404-0.867-1.404-1.503c0-0.856,0.691-1.558,1.833-1.558c0.537,0,1.009,0.154,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.636,1.01,0.899
		c0.921,0.351,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L364.361,237.969z"/>
	<path class="disabled" d="M372.875,232.505c-0.198-0.011-0.45,0-0.725,0.044c-1.514,0.252-2.314,1.36-2.479,2.535h0.033
		c0.34-0.45,0.933-0.823,1.723-0.823c1.262,0,2.149,0.911,2.149,2.304c0,1.306-0.888,2.512-2.369,2.512
		c-1.525,0-2.523-1.185-2.523-3.039c0-1.404,0.505-2.512,1.207-3.214c0.592-0.582,1.382-0.943,2.281-1.053
		c0.286-0.044,0.527-0.055,0.703-0.055V232.505z M372.601,236.62c0-1.02-0.582-1.635-1.471-1.635c-0.581,0-1.119,0.362-1.382,0.878
		c-0.066,0.11-0.11,0.252-0.11,0.428c0.022,1.174,0.56,2.041,1.569,2.041C372.041,238.331,372.601,237.64,372.601,236.62z"/>
	<path class="disabled" d="M364.482,272.81c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.46-0.274-0.713-0.988-0.976
		c-0.954-0.34-1.404-0.867-1.404-1.503c0-0.856,0.691-1.558,1.833-1.558c0.537,0,1.009,0.154,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.636,1.01,0.899
		c0.921,0.351,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.362L364.482,272.81z"/>
	<path class="disabled" d="M373.554,266.666v0.637l-3.104,6.495h-0.998l3.094-6.309v-0.021h-3.489v-0.801H373.554z"/>
	<path class="disabled" d="M364.379,309.197c0.285,0.187,0.789,0.384,1.271,0.384c0.703,0,1.031-0.351,1.031-0.79c0-0.46-0.273-0.713-0.986-0.976
		c-0.955-0.341-1.404-0.867-1.404-1.503c0-0.856,0.69-1.559,1.832-1.559c0.537,0,1.009,0.154,1.305,0.329l-0.24,0.702
		c-0.209-0.132-0.594-0.307-1.087-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.637,1.009,0.899
		c0.922,0.352,1.395,0.813,1.395,1.603c0,0.933-0.725,1.591-1.986,1.591c-0.582,0-1.119-0.143-1.492-0.362L364.379,309.197z"/>
	<path class="disabled" d="M368.732,308.375c0-0.9,0.538-1.536,1.416-1.909l-0.012-0.033c-0.789-0.373-1.129-0.987-1.129-1.602
		c0-1.13,0.954-1.898,2.205-1.898c1.382,0,2.073,0.867,2.073,1.756c0,0.604-0.296,1.251-1.174,1.667v0.033
		c0.889,0.352,1.437,0.977,1.437,1.844c0,1.239-1.063,2.073-2.424,2.073C369.633,310.305,368.732,309.417,368.732,308.375z
		 M369.918,304.764c0,0.714,0.537,1.098,1.36,1.317c0.614-0.209,1.087-0.647,1.087-1.295c0-0.57-0.341-1.163-1.207-1.163
		C370.357,303.624,369.918,304.15,369.918,304.764z M372.572,308.331c0-0.867-0.603-1.284-1.568-1.559
		c-0.834,0.242-1.283,0.79-1.283,1.471c-0.033,0.724,0.516,1.36,1.426,1.36C372.014,309.603,372.572,309.065,372.572,308.331z"/>
	<path class="disabled" d="M364.364,345.179c0.285,0.187,0.789,0.384,1.271,0.384c0.703,0,1.031-0.351,1.031-0.79c0-0.46-0.273-0.713-0.986-0.976
		c-0.955-0.341-1.404-0.867-1.404-1.503c0-0.856,0.69-1.559,1.832-1.559c0.537,0,1.009,0.154,1.305,0.329l-0.24,0.702
		c-0.209-0.132-0.594-0.307-1.087-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.637,1.009,0.899
		c0.922,0.352,1.395,0.813,1.395,1.603c0,0.933-0.725,1.591-1.986,1.591c-0.582,0-1.119-0.143-1.492-0.362L364.364,345.179z"/>
	<path class="disabled" d="M369.366,345.487c0.208,0.021,0.449,0,0.778-0.033c0.56-0.077,1.087-0.308,1.492-0.691
		c0.472-0.428,0.812-1.053,0.943-1.897h-0.032c-0.396,0.482-0.966,0.768-1.68,0.768c-1.283,0-2.105-0.966-2.105-2.184
		c0-1.349,0.977-2.534,2.436-2.534s2.358,1.186,2.358,3.007c0,1.568-0.526,2.666-1.229,3.346c-0.549,0.538-1.306,0.867-2.073,0.954
		c-0.352,0.056-0.658,0.066-0.889,0.056V345.487z M369.716,341.383c0,0.889,0.538,1.514,1.372,1.514
		c0.646,0,1.151-0.317,1.404-0.746c0.055-0.087,0.087-0.197,0.087-0.351c0-1.218-0.45-2.15-1.459-2.15
		C370.297,339.65,369.716,340.375,369.716,341.383z"/>
	<path class="disabled" d="M362.793,380.779c0.285,0.187,0.789,0.384,1.272,0.384c0.702,0,1.031-0.351,1.031-0.79c0-0.46-0.274-0.713-0.987-0.976
		c-0.955-0.341-1.404-0.867-1.404-1.503c0-0.856,0.691-1.559,1.832-1.559c0.537,0,1.01,0.154,1.306,0.329l-0.241,0.702
		c-0.209-0.132-0.593-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.637,1.009,0.899
		c0.922,0.352,1.394,0.813,1.394,1.603c0,0.933-0.725,1.591-1.986,1.591c-0.581,0-1.119-0.143-1.492-0.362L362.793,380.779z"/>
	<path class="disabled" d="M367.959,375.535h-0.021l-1.24,0.669l-0.186-0.734l1.557-0.834h0.823v7.131h-0.933V375.535z"/>
	<path class="disabled" d="M375.135,378.124c0,2.425-0.9,3.764-2.48,3.764c-1.393,0-2.336-1.306-2.358-3.664c0-2.393,1.031-3.709,2.479-3.709
		C374.278,374.514,375.135,375.853,375.135,378.124z M371.262,378.234c0,1.854,0.57,2.907,1.447,2.907
		c0.988,0,1.459-1.152,1.459-2.974c0-1.755-0.449-2.907-1.447-2.907C371.875,375.26,371.262,376.292,371.262,378.234z"/>
	
		<rect class="disabled" x="530.778" y="95.156" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="23.271" height="38.182"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="530.778" y1="116.234" x2="542.708" y2="133.106"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="532.741" y1="95.156" x2="554.138" y2="122.016"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="542.165" y1="95.156" x2="554.05" y2="110.074"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="530.778" y1="103.503" x2="553.554" y2="132.918"/>
	
		<rect class="disabled" x="408.39" y="95.433" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="14.981" height="28.208"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="408.39" y1="111.007" x2="416.067" y2="123.47"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="409.652" y1="95.433" x2="423.431" y2="115.279"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="415.721" y1="95.433" x2="423.371" y2="106.456"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="408.39" y1="101.602" x2="423.052" y2="123.33"/>
	
		<rect class="disabled" x="403.417" y="467.083" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="19.169" height="28.207"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="403.417" y1="482.655" x2="413.241" y2="495.118"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="405.033" y1="467.083" x2="422.661" y2="486.926"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="412.796" y1="467.083" x2="422.587" y2="478.103"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="403.417" y1="473.249" x2="422.179" y2="494.979"/>
	
		<rect class="disabled" x="555.044" y="467.083" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" width="18.414" height="28.207"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="555.044" y1="482.655" x2="564.485" y2="495.118"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="556.597" y1="467.083" x2="573.532" y2="486.926"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="564.054" y1="467.083" x2="573.458" y2="478.103"/>
	
		<line class="disabled" fill="none" stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" x1="555.044" y1="473.249" x2="573.067" y2="494.979"/>
        
	<path id="dom4" onClick="reply_click(this.id)" data-id="dom4"';
        
            $result = $this->get_table_stat("dom4", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.3918" stroke-miterlimit="10" d="M167.19,312.954c0,0-4.216-22.888,0-36.018
            l-54.561-11.46c0,0-7.792,28.427,0,57.47L167.19,312.954z"/>
        
	<path class="disabled"  d="M117.435,289.809c0.71-0.106,1.556-0.188,2.481-0.188c1.676,0,2.87,0.389,3.661,1.127c0.805,0.738,1.274,1.783,1.274,3.246
		c0,1.475-0.456,2.682-1.301,3.514c-0.846,0.846-2.24,1.301-3.997,1.301c-0.831,0-1.529-0.04-2.119-0.107V289.809z M118.602,297.803
		c0.295,0.055,0.725,0.067,1.18,0.067c2.495,0,3.85-1.396,3.85-3.836c0.014-2.133-1.193-3.487-3.662-3.487
		c-0.604,0-1.059,0.054-1.367,0.121V297.803z"/>
	<path class="disabled"  d="M135.432,294.116c0,3.111-1.892,4.761-4.199,4.761c-2.387,0-4.063-1.851-4.063-4.587c0-2.87,1.784-4.748,4.198-4.748
		C133.835,289.542,135.432,291.432,135.432,294.116z M128.416,294.262c0,1.932,1.047,3.662,2.884,3.662
		c1.851,0,2.897-1.703,2.897-3.756c0-1.797-0.939-3.675-2.884-3.675C129.382,290.494,128.416,292.278,128.416,294.262z"/>
	<path class="disabled"  d="M145.902,294.758c-0.066-1.26-0.147-2.775-0.134-3.902h-0.04c-0.309,1.06-0.685,2.186-1.141,3.434l-1.596,4.386h-0.885
		l-1.462-4.306c-0.429-1.273-0.792-2.441-1.046-3.514h-0.027c-0.026,1.127-0.094,2.643-0.174,3.997l-0.242,3.876h-1.113l0.631-9.04
		h1.488l1.543,4.372c0.375,1.113,0.684,2.105,0.912,3.045h0.04c0.228-0.912,0.55-1.904,0.952-3.045l1.609-4.372h1.488l0.563,9.04
		h-1.14L145.902,294.758z"/>
	<path class="disabled"  d="M157.822,298.729v-2.374h-4.051v-0.778l3.89-5.566h1.274v5.42h1.221v0.925h-1.221v2.374H157.822z M157.822,295.43v-2.911
		c0-0.456,0.014-0.912,0.04-1.368h-0.04c-0.269,0.51-0.483,0.885-0.725,1.287l-2.133,2.965v0.027H157.822z"/>
	<path class="disabled"  d="M439.506,381.243c0.285,0.187,0.789,0.384,1.271,0.384c0.703,0,1.031-0.351,1.031-0.79c0-0.461-0.273-0.713-0.986-0.977
		c-0.955-0.34-1.404-0.866-1.404-1.503c0-0.855,0.69-1.558,1.832-1.558c0.537,0,1.009,0.153,1.305,0.329l-0.24,0.702
		c-0.209-0.132-0.594-0.308-1.087-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.637,1.009,0.899
		c0.922,0.352,1.395,0.812,1.395,1.602c0,0.933-0.725,1.591-1.986,1.591c-0.582,0-1.119-0.143-1.492-0.361L439.506,381.243z"/>
	<path class="disabled"  d="M443.904,381.122c0.273,0.176,0.91,0.45,1.579,0.45c1.239,0,1.624-0.79,1.612-1.383c-0.01-0.998-0.91-1.426-1.842-1.426
		h-0.538v-0.725h0.538c0.701,0,1.59-0.361,1.59-1.206c0-0.571-0.361-1.075-1.25-1.075c-0.57,0-1.119,0.252-1.427,0.472l-0.253-0.702
		c0.373-0.274,1.098-0.549,1.865-0.549c1.404,0,2.041,0.834,2.041,1.7c0,0.735-0.438,1.36-1.316,1.679v0.022
		c0.878,0.175,1.591,0.834,1.591,1.832c0,1.141-0.889,2.14-2.601,2.14c-0.801,0-1.502-0.253-1.854-0.483L443.904,381.122z"/>
	<path class="disabled"  d="M452.285,382.23v-1.941h-3.313v-0.637l3.182-4.553h1.042v4.432h0.998v0.758h-0.998v1.941H452.285z M452.285,379.531v-2.381
		c0-0.372,0.011-0.745,0.033-1.118h-0.033c-0.22,0.416-0.395,0.724-0.593,1.053l-1.744,2.425v0.021H452.285z"/>
        
	<circle id="s35" onClick="reply_click(this.id)" data-id="s35"';
        
            $result = $this->get_table_stat("s35", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="424.366" cy="392.42" r="9.991"/>
    
	<path class="disabled"  d="M417.19,395.151c0.285,0.186,0.791,0.383,1.273,0.383c0.701,0,1.031-0.35,1.031-0.789c0-0.461-0.275-0.713-0.988-0.977
		c-0.953-0.34-1.404-0.867-1.404-1.504c0-0.855,0.691-1.557,1.832-1.557c0.539,0,1.01,0.152,1.307,0.328l-0.242,0.703
		c-0.207-0.133-0.592-0.309-1.086-0.309c-0.57,0-0.889,0.33-0.889,0.725c0,0.439,0.318,0.637,1.01,0.9
		c0.922,0.352,1.393,0.811,1.393,1.602c0,0.932-0.723,1.59-1.984,1.59c-0.582,0-1.119-0.143-1.492-0.361L417.19,395.151z"/>
	<path class="disabled"  d="M421.589,395.03c0.275,0.176,0.912,0.449,1.58,0.449c1.24,0,1.625-0.789,1.613-1.383c-0.012-0.998-0.91-1.426-1.844-1.426
		h-0.537v-0.725h0.537c0.703,0,1.592-0.361,1.592-1.205c0-0.572-0.363-1.076-1.252-1.076c-0.57,0-1.119,0.252-1.426,0.473
		l-0.252-0.703c0.373-0.273,1.098-0.549,1.865-0.549c1.404,0,2.041,0.834,2.041,1.701c0,0.734-0.439,1.359-1.316,1.678v0.023
		c0.877,0.174,1.59,0.834,1.59,1.832c0,1.141-0.889,2.139-2.6,2.139c-0.801,0-1.504-0.252-1.854-0.482L421.589,395.03z"/>
	<path class="disabled"  d="M431.243,389.819h-2.721l-0.273,1.832c0.164-0.021,0.318-0.045,0.58-0.045c0.549,0,1.098,0.121,1.537,0.385
		c0.559,0.318,1.02,0.932,1.02,1.832c0,1.393-1.107,2.436-2.654,2.436c-0.779,0-1.438-0.219-1.777-0.439l0.24-0.734
		c0.297,0.176,0.879,0.395,1.525,0.395c0.91,0,1.689-0.592,1.689-1.547c-0.01-0.922-0.625-1.58-2.051-1.58
		c-0.406,0-0.725,0.045-0.988,0.078l0.461-3.424h3.412V389.819z"/>
	<path class="disabled"  d="M464.78,396.441c0.285,0.187,0.789,0.384,1.271,0.384c0.703,0,1.031-0.351,1.031-0.79c0-0.461-0.273-0.713-0.986-0.977
		c-0.955-0.34-1.404-0.866-1.404-1.503c0-0.855,0.69-1.558,1.832-1.558c0.537,0,1.009,0.153,1.305,0.329l-0.24,0.702
		c-0.209-0.132-0.594-0.308-1.087-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.637,1.009,0.899
		c0.922,0.352,1.395,0.812,1.395,1.602c0,0.933-0.725,1.591-1.986,1.591c-0.582,0-1.119-0.143-1.492-0.361L464.78,396.441z"/>
	<path class="disabled"  d="M469.179,396.32c0.273,0.176,0.91,0.45,1.579,0.45c1.239,0,1.624-0.79,1.612-1.383c-0.01-0.998-0.91-1.426-1.842-1.426
		h-0.538v-0.725h0.538c0.701,0,1.59-0.361,1.59-1.206c0-0.571-0.361-1.075-1.25-1.075c-0.57,0-1.119,0.252-1.427,0.472l-0.253-0.702
		c0.373-0.274,1.098-0.549,1.865-0.549c1.404,0,2.041,0.834,2.041,1.7c0,0.735-0.438,1.36-1.316,1.679v0.022
		c0.878,0.175,1.591,0.834,1.591,1.832c0,1.141-0.889,2.14-2.601,2.14c-0.801,0-1.502-0.253-1.854-0.483L469.179,396.32z"/>
	<path class="disabled"  d="M474.806,396.32c0.274,0.176,0.91,0.45,1.58,0.45c1.239,0,1.623-0.79,1.612-1.383c-0.011-0.998-0.911-1.426-1.843-1.426
		h-0.537v-0.725h0.537c0.702,0,1.591-0.361,1.591-1.206c0-0.571-0.362-1.075-1.251-1.075c-0.57,0-1.119,0.252-1.426,0.472
		l-0.253-0.702c0.373-0.274,1.097-0.549,1.865-0.549c1.404,0,2.04,0.834,2.04,1.7c0,0.735-0.438,1.36-1.316,1.679v0.022
		c0.879,0.175,1.592,0.834,1.592,1.832c0,1.141-0.889,2.14-2.601,2.14c-0.801,0-1.503-0.253-1.854-0.483L474.806,396.32z"/>
        
	<circle id="s39" onClick="reply_click(this.id)" data-id="s39"';
        
            $result = $this->get_table_stat("s39", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="455.78" cy="226.796" r="9.991"/>
    
	<path class="disabled"  d="M449.294,229.352c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.461-0.274-0.713-0.988-0.977
		c-0.954-0.34-1.404-0.866-1.404-1.503c0-0.855,0.691-1.558,1.833-1.558c0.537,0,1.009,0.153,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.308-1.086-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.637,1.01,0.899
		c0.921,0.352,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.361L449.294,229.352z"/>
	<path class="disabled"  d="M453.692,229.231c0.274,0.176,0.911,0.45,1.58,0.45c1.24,0,1.624-0.79,1.613-1.383c-0.012-0.998-0.911-1.426-1.844-1.426
		h-0.537v-0.725h0.537c0.702,0,1.591-0.361,1.591-1.206c0-0.57-0.361-1.075-1.25-1.075c-0.571,0-1.119,0.252-1.427,0.472
		l-0.252-0.702c0.373-0.274,1.097-0.549,1.865-0.549c1.404,0,2.04,0.834,2.04,1.7c0,0.735-0.438,1.36-1.316,1.679v0.022
		c0.878,0.175,1.591,0.834,1.591,1.832c0,1.141-0.889,2.14-2.601,2.14c-0.801,0-1.503-0.253-1.854-0.483L453.692,229.231z"/>
	<path class="disabled"  d="M459.649,229.659c0.208,0.022,0.449,0,0.778-0.032c0.56-0.077,1.086-0.308,1.492-0.691
		c0.472-0.428,0.812-1.054,0.943-1.898h-0.033c-0.395,0.483-0.965,0.769-1.678,0.769c-1.284,0-2.106-0.966-2.106-2.184
		c0-1.35,0.976-2.534,2.436-2.534c1.459,0,2.358,1.185,2.358,3.006c0,1.569-0.526,2.666-1.229,3.347
		c-0.549,0.537-1.306,0.866-2.074,0.954c-0.351,0.055-0.658,0.066-0.888,0.055V229.659z M460,225.556
		c0,0.889,0.537,1.514,1.371,1.514c0.647,0,1.152-0.318,1.404-0.746c0.055-0.088,0.088-0.197,0.088-0.351
		c0-1.218-0.449-2.15-1.459-2.15C460.581,223.823,460,224.546,460,225.556z"/>
        
	<circle id="s21" onClick="reply_click(this.id)" data-id="s21"';
        
            $result = $this->get_table_stat("s21", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="434.396" cy="431.772" r="9.99"/>

        <rect x="537.856" y="390.805" id="s30" onClick="reply_click(this.id)" data-id="s30"';
        
            $result = $this->get_table_stat("s30", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="15.514" height="20.324"/>

        <rect x="537.856" y="367.191" id="s31" onClick="reply_click(this.id)" data-id="s31"';
        
            $result = $this->get_table_stat("s31", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="15.514" height="20.324"/>
        
        <rect x="537.856" y="222.943" id="s42" onClick="reply_click(this.id)" data-id="s42"';
        
            $result = $this->get_table_stat("s42", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="15.514" height="19.857"/>
        
        <rect x="537.856" y="201.092" id="s41" onClick="reply_click(this.id)" data-id="s41"';
        
            $result = $this->get_table_stat("s41", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="15.514" height="19.857"/>
        
	<g>
		<path class="disabled"  d="M539.46,379.784c0.265,0.173,0.733,0.355,1.181,0.355c0.653,0,0.958-0.325,0.958-0.733c0-0.428-0.254-0.662-0.916-0.907
			c-0.887-0.315-1.304-0.804-1.304-1.396c0-0.794,0.641-1.446,1.701-1.446c0.499,0,0.937,0.143,1.212,0.306l-0.224,0.652
			c-0.194-0.123-0.552-0.286-1.009-0.286c-0.53,0-0.826,0.306-0.826,0.673c0,0.407,0.296,0.592,0.938,0.836
			c0.855,0.326,1.295,0.753,1.295,1.487c0,0.865-0.673,1.477-1.845,1.477c-0.541,0-1.039-0.132-1.386-0.335L539.46,379.784z"/>
		<path class="disabled"  d="M543.545,379.67c0.254,0.164,0.846,0.418,1.467,0.418c1.15,0,1.508-0.733,1.497-1.283
			c-0.009-0.928-0.846-1.324-1.711-1.324h-0.499v-0.674h0.499c0.651,0,1.477-0.335,1.477-1.119c0-0.531-0.335-0.999-1.16-0.999
			c-0.53,0-1.04,0.234-1.325,0.438l-0.235-0.652c0.347-0.255,1.02-0.51,1.732-0.51c1.305,0,1.896,0.774,1.896,1.579
			c0,0.683-0.407,1.263-1.223,1.559v0.021c0.815,0.162,1.478,0.774,1.478,1.701c0,1.06-0.825,1.987-2.415,1.987
			c-0.744,0-1.395-0.235-1.722-0.449L543.545,379.67z"/>
		<path class="disabled"  d="M550.503,374.913h-0.02l-1.152,0.622l-0.173-0.684l1.446-0.773h0.764v6.622h-0.865V374.913z"/>
	</g>
	<g>
		<path class="disabled"  d="M540.139,402.834c0.227,0.148,0.629,0.306,1.014,0.306c0.561,0,0.821-0.279,0.821-0.63c0-0.367-0.218-0.568-0.786-0.778
			c-0.761-0.271-1.119-0.69-1.119-1.198c0-0.683,0.55-1.242,1.46-1.242c0.429,0,0.805,0.122,1.041,0.263l-0.192,0.56
			c-0.166-0.105-0.473-0.245-0.866-0.245c-0.455,0-0.708,0.263-0.708,0.577c0,0.35,0.253,0.508,0.804,0.718
			c0.735,0.28,1.112,0.646,1.112,1.276c0,0.744-0.578,1.269-1.584,1.269c-0.464,0-0.893-0.114-1.189-0.288L540.139,402.834z"/>
		<path class="disabled"  d="M543.645,402.738c0.219,0.14,0.726,0.358,1.26,0.358c0.987,0,1.294-0.63,1.285-1.103
			c-0.008-0.796-0.726-1.137-1.469-1.137h-0.429v-0.577h0.429c0.56,0,1.268-0.288,1.268-0.962c0-0.455-0.288-0.857-0.996-0.857
			c-0.455,0-0.893,0.201-1.138,0.376l-0.202-0.56c0.298-0.219,0.875-0.438,1.487-0.438c1.12,0,1.627,0.665,1.627,1.355
			c0,0.587-0.35,1.085-1.049,1.339v0.018c0.699,0.14,1.268,0.665,1.268,1.461c0,0.909-0.708,1.705-2.073,1.705
			c-0.638,0-1.197-0.201-1.478-0.385L543.645,402.738z"/>
		<path class="disabled"  d="M551.727,400.717c0,1.933-0.718,3-1.978,3c-1.11,0-1.862-1.041-1.881-2.922c0-1.906,0.822-2.956,1.978-2.956
			C551.044,397.839,551.727,398.907,551.727,400.717z M548.639,400.805c0,1.478,0.455,2.317,1.153,2.317
			c0.788,0,1.164-0.918,1.164-2.37c0-1.399-0.358-2.318-1.154-2.318C549.128,398.434,548.639,399.256,548.639,400.805z"/>
	</g>
    
	<circle id="s22" onClick="reply_click(this.id)" data-id="s22"';
        
            $result = $this->get_table_stat("s22", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="496.987" cy="431.213" r="9.99"/>
    
	<path class="disabled"  d="M427.462,435.195c0.285,0.187,0.789,0.384,1.271,0.384c0.703,0,1.031-0.351,1.031-0.79c0-0.461-0.273-0.713-0.986-0.977
		c-0.955-0.34-1.404-0.866-1.404-1.503c0-0.855,0.69-1.558,1.832-1.558c0.537,0,1.009,0.153,1.305,0.329l-0.24,0.702
		c-0.209-0.132-0.594-0.308-1.087-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.637,1.009,0.899
		c0.922,0.352,1.395,0.812,1.395,1.602c0,0.933-0.725,1.591-1.986,1.591c-0.582,0-1.119-0.143-1.492-0.361L427.462,435.195z"/>
	<path class="disabled"  d="M431.63,436.182v-0.593l0.756-0.734c1.822-1.733,2.645-2.655,2.656-3.73c0-0.725-0.352-1.394-1.416-1.394
		c-0.646,0-1.185,0.329-1.514,0.604l-0.307-0.68c0.493-0.417,1.195-0.725,2.018-0.725c1.536,0,2.184,1.054,2.184,2.073
		c0,1.317-0.955,2.381-2.457,3.829l-0.57,0.526v0.022h3.203v0.801H431.63z"/>
	<path class="disabled"  d="M439.353,429.951h-0.021l-1.24,0.669l-0.187-0.735l1.558-0.833h0.822v7.131h-0.932V429.951z"/>
	<path class="disabled"  d="M489.321,433.874c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.031-0.351,1.031-0.79c0-0.461-0.274-0.713-0.987-0.977
		c-0.954-0.34-1.404-0.866-1.404-1.503c0-0.855,0.69-1.558,1.832-1.558c0.538,0,1.009,0.153,1.306,0.329l-0.241,0.702
		c-0.208-0.132-0.593-0.308-1.087-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.637,1.01,0.899
		c0.922,0.352,1.394,0.812,1.394,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.582,0-1.119-0.143-1.492-0.361L489.321,433.874z"/>
	<path class="disabled"  d="M493.489,434.861v-0.593l0.757-0.734c1.821-1.733,2.645-2.655,2.655-3.73c0-0.725-0.351-1.394-1.415-1.394
		c-0.647,0-1.186,0.329-1.514,0.604l-0.308-0.68c0.493-0.417,1.196-0.725,2.019-0.725c1.535,0,2.184,1.054,2.184,2.073
		c0,1.317-0.955,2.381-2.458,3.829l-0.57,0.526v0.022h3.204v0.801H493.489z"/>
	<path class="disabled"  d="M499.117,434.861v-0.593l0.756-0.734c1.822-1.733,2.645-2.655,2.656-3.73c0-0.725-0.352-1.394-1.416-1.394
		c-0.646,0-1.185,0.329-1.514,0.604l-0.307-0.68c0.493-0.417,1.195-0.725,2.018-0.725c1.536,0,2.184,1.054,2.184,2.073
		c0,1.317-0.955,2.381-2.457,3.829l-0.57,0.526v0.022h3.203v0.801H499.117z"/>
        
	<path id="s43" onClick="reply_click(this.id)" data-id="s43"';
        
            $result = $this->get_table_stat("s43", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M723.39,231.62
            c5.518,0,9.99-4.475,9.99-9.992c0-5.517-4.473-9.988-9.99-9.988c-5.514,0-9.988,4.472-9.988,9.988
            C713.401,227.145,717.876,231.62,723.39,231.62z"/>
        
	<path class="disabled"  d="M716.956,224.35c0.285,0.187,0.789,0.384,1.271,0.384c0.703,0,1.033-0.351,1.033-0.79c0-0.461-0.275-0.713-0.988-0.977
		c-0.955-0.34-1.404-0.866-1.404-1.503c0-0.855,0.691-1.558,1.832-1.558c0.537,0,1.01,0.153,1.305,0.329l-0.24,0.702
		c-0.209-0.132-0.592-0.308-1.086-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.637,1.01,0.899
		c0.92,0.352,1.393,0.812,1.393,1.602c0,0.933-0.725,1.591-1.986,1.591c-0.58,0-1.119-0.143-1.492-0.361L716.956,224.35z"/>
	<path class="disabled"  d="M724.108,225.337v-1.941h-3.313v-0.637l3.18-4.553h1.043v4.432h0.998v0.758h-0.998v1.941H724.108z M724.108,222.638v-2.381
		c0-0.372,0.012-0.745,0.033-1.118h-0.033c-0.219,0.416-0.395,0.724-0.592,1.053l-1.746,2.425v0.021H724.108z"/>
	<path class="disabled"  d="M726.981,224.229c0.273,0.176,0.91,0.45,1.58,0.45c1.24,0,1.623-0.79,1.613-1.383c-0.012-0.998-0.912-1.426-1.844-1.426
		h-0.537v-0.725h0.537c0.701,0,1.59-0.361,1.59-1.206c0-0.571-0.361-1.075-1.25-1.075c-0.57,0-1.119,0.252-1.426,0.472l-0.252-0.702
		c0.373-0.274,1.096-0.549,1.865-0.549c1.404,0,2.039,0.834,2.039,1.7c0,0.735-0.438,1.36-1.316,1.679v0.022
		c0.879,0.175,1.592,0.834,1.592,1.832c0,1.141-0.889,2.14-2.602,2.14c-0.801,0-1.502-0.253-1.854-0.483L726.981,224.229z"/>
        
	<path id="s23" onClick="reply_click(this.id)" data-id="s23"';
        
            $result = $this->get_table_stat("s23", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M669.704,424.194
            c5.518,0,9.994-4.474,9.994-9.99c0-5.518-4.477-9.99-9.994-9.99c-5.516,0-9.988,4.473-9.988,9.99
            C659.716,419.72,664.188,424.194,669.704,424.194z"/>
        
	<path class="disabled"  d="M663.271,416.922c0.285,0.188,0.789,0.385,1.273,0.385c0.701,0,1.031-0.352,1.031-0.791c0-0.461-0.275-0.713-0.988-0.977
		c-0.955-0.34-1.404-0.865-1.404-1.502c0-0.855,0.691-1.559,1.832-1.559c0.537,0,1.01,0.154,1.307,0.33l-0.242,0.701
		c-0.209-0.131-0.592-0.307-1.086-0.307c-0.57,0-0.889,0.328-0.889,0.725c0,0.438,0.318,0.637,1.01,0.898
		c0.922,0.352,1.393,0.813,1.393,1.602c0,0.934-0.725,1.592-1.986,1.592c-0.58,0-1.119-0.143-1.492-0.361L663.271,416.922z"/>
	<path class="disabled"  d="M667.438,417.911v-0.594l0.758-0.734c1.82-1.732,2.643-2.654,2.654-3.73c0-0.725-0.352-1.393-1.416-1.393
		c-0.646,0-1.184,0.328-1.514,0.604l-0.307-0.68c0.494-0.418,1.195-0.725,2.02-0.725c1.535,0,2.182,1.053,2.182,2.072
		c0,1.318-0.953,2.381-2.457,3.83l-0.57,0.525v0.023h3.203v0.801H667.438z"/>
	<path class="disabled"  d="M673.296,416.801c0.275,0.176,0.912,0.451,1.58,0.451c1.24,0,1.625-0.791,1.613-1.383c-0.012-0.998-0.91-1.426-1.844-1.426
		h-0.537v-0.725h0.537c0.703,0,1.592-0.361,1.592-1.207c0-0.57-0.363-1.074-1.252-1.074c-0.57,0-1.119,0.252-1.426,0.471
		l-0.252-0.701c0.373-0.275,1.098-0.549,1.865-0.549c1.404,0,2.041,0.834,2.041,1.699c0,0.736-0.439,1.361-1.316,1.68v0.021
		c0.877,0.176,1.59,0.834,1.59,1.832c0,1.141-0.889,2.141-2.6,2.141c-0.801,0-1.504-0.254-1.854-0.484L673.296,416.801z"/>
        
	<circle id="s20" onClick="reply_click(this.id)" data-id="s20"';
        
            $result = $this->get_table_stat("s20", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" cx="362.47" cy="431.991" r="9.99"/>
    
	<path class="disabled"  d="M501.84,405.016c0.285,0.187,0.789,0.384,1.271,0.384c0.703,0,1.031-0.351,1.031-0.79c0-0.461-0.273-0.713-0.986-0.977
		c-0.955-0.34-1.404-0.866-1.404-1.503c0-0.855,0.69-1.558,1.832-1.558c0.537,0,1.009,0.153,1.305,0.329l-0.24,0.702
		c-0.209-0.132-0.594-0.308-1.087-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.637,1.009,0.899
		c0.922,0.352,1.395,0.812,1.395,1.602c0,0.933-0.725,1.591-1.986,1.591c-0.582,0-1.119-0.143-1.492-0.361L501.84,405.016z"/>
	<path class="disabled"  d="M506.238,404.895c0.273,0.176,0.91,0.45,1.579,0.45c1.239,0,1.624-0.79,1.612-1.383c-0.01-0.998-0.91-1.426-1.842-1.426
		h-0.538v-0.725h0.538c0.701,0,1.59-0.361,1.59-1.206c0-0.571-0.361-1.075-1.25-1.075c-0.57,0-1.119,0.252-1.427,0.472l-0.253-0.702
		c0.373-0.274,1.098-0.549,1.865-0.549c1.404,0,2.041,0.834,2.041,1.7c0,0.735-0.438,1.36-1.316,1.679v0.022
		c0.878,0.175,1.591,0.834,1.591,1.832c0,1.141-0.889,2.14-2.601,2.14c-0.801,0-1.502-0.253-1.854-0.483L506.238,404.895z"/>
	<path class="disabled"  d="M511.635,406.003v-0.593l0.757-0.734c1.821-1.733,2.644-2.655,2.655-3.73c0-0.725-0.352-1.394-1.416-1.394
		c-0.646,0-1.184,0.329-1.514,0.604l-0.307-0.68c0.494-0.417,1.195-0.725,2.019-0.725c1.536,0,2.183,1.054,2.183,2.073
		c0,1.317-0.954,2.381-2.457,3.829l-0.57,0.526v0.022h3.203v0.801H511.635z"/>
        
	<path id="s36" onClick="reply_click(this.id)" data-id="s36"';
        
            $result = $this->get_table_stat("s36", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M423.478,331.478
            c5.518,0,9.992-4.473,9.992-9.989c0-5.518-4.475-9.99-9.992-9.99c-5.516,0-9.99,4.473-9.99,9.99
            C413.487,327.005,417.962,331.478,423.478,331.478z"/>

        <path id="s37" onClick="reply_click(this.id)" data-id="s37"';
        
            $result = $this->get_table_stat("s37", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}
        
            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7836" stroke-miterlimit="10" d="M423.478,299.799
            c5.518,0,9.992-4.472,9.992-9.989s-4.475-9.991-9.992-9.991c-5.516,0-9.99,4.474-9.99,9.991S417.962,299.799,423.478,299.799z"/>
            
            
	<path class="disabled"  d="M415.989,324.034c0.285,0.186,0.789,0.383,1.271,0.383c0.703,0,1.031-0.35,1.031-0.789c0-0.461-0.273-0.713-0.986-0.977
		c-0.955-0.34-1.404-0.867-1.404-1.504c0-0.855,0.691-1.557,1.832-1.557c0.537,0,1.01,0.152,1.305,0.328l-0.24,0.703
		c-0.209-0.133-0.594-0.309-1.086-0.309c-0.57,0-0.889,0.33-0.889,0.725c0,0.439,0.318,0.637,1.008,0.9
		c0.922,0.352,1.395,0.811,1.395,1.602c0,0.932-0.725,1.59-1.986,1.59c-0.582,0-1.119-0.143-1.492-0.361L415.989,324.034z"/>
	<path class="disabled"  d="M420.388,323.913c0.273,0.176,0.91,0.449,1.58,0.449c1.238,0,1.623-0.789,1.611-1.383c-0.01-0.998-0.91-1.426-1.842-1.426
		H421.2v-0.725h0.537c0.701,0,1.59-0.361,1.59-1.205c0-0.572-0.361-1.076-1.25-1.076c-0.57,0-1.119,0.252-1.426,0.473l-0.254-0.703
		c0.373-0.273,1.098-0.549,1.865-0.549c1.404,0,2.041,0.834,2.041,1.701c0,0.734-0.438,1.359-1.316,1.678v0.023
		c0.879,0.174,1.592,0.834,1.592,1.832c0,1.141-0.889,2.139-2.602,2.139c-0.801,0-1.502-0.252-1.854-0.482L420.388,323.913z"/>
	<path class="disabled"  d="M429.854,318.569c-0.197-0.01-0.449,0-0.725,0.045c-1.514,0.252-2.314,1.359-2.479,2.533h0.033
		c0.34-0.449,0.932-0.822,1.723-0.822c1.262,0,2.15,0.91,2.15,2.305c0,1.305-0.889,2.512-2.371,2.512
		c-1.523,0-2.523-1.186-2.523-3.039c0-1.404,0.506-2.512,1.207-3.215c0.594-0.58,1.383-0.943,2.283-1.053
		c0.285-0.043,0.525-0.055,0.701-0.055V318.569z M429.581,322.684c0-1.021-0.582-1.635-1.471-1.635
		c-0.582,0-1.119,0.361-1.383,0.877c-0.064,0.109-0.109,0.252-0.109,0.428c0.021,1.174,0.561,2.041,1.568,2.041
		C429.021,324.395,429.581,323.704,429.581,322.684z"/>
	<path class="disabled"  d="M417.053,292.426c0.285,0.186,0.79,0.384,1.272,0.384c0.701-0.001,1.032-0.351,1.031-0.79
		c0.001-0.461-0.274-0.713-0.987-0.977c-0.954-0.34-1.405-0.866-1.405-1.503c0-0.855,0.692-1.559,1.833-1.559
		c0.538,0.001,1.01,0.153,1.306,0.33l-0.241,0.702c-0.209-0.132-0.592-0.309-1.087-0.309c-0.569,0.001-0.889,0.33-0.888,0.726
		c-0.001,0.438,0.317,0.637,1.01,0.898c0.922,0.352,1.392,0.813,1.392,1.603c0.001,0.933-0.723,1.59-1.984,1.591
		c-0.582,0-1.119-0.144-1.492-0.361L417.053,292.426z"/>
	<path class="disabled"  d="M421.451,292.305c0.275,0.176,0.911,0.45,1.58,0.45c1.24,0,1.624-0.79,1.613-1.383c-0.013-0.998-0.911-1.426-1.844-1.427
		l-0.537,0.001l-0.001-0.725h0.538c0.702,0,1.592-0.362,1.591-1.206c0-0.572-0.362-1.075-1.252-1.075
		c-0.57,0-1.119,0.252-1.426,0.472l-0.251-0.702c0.373-0.274,1.097-0.549,1.865-0.549c1.403,0,2.04,0.834,2.04,1.7
		c0,0.734-0.439,1.36-1.316,1.678l-0.001,0.023c0.878,0.174,1.591,0.834,1.592,1.832c0,1.141-0.889,2.14-2.6,2.14
		c-0.802,0-1.504-0.253-1.855-0.483L421.451,292.305z"/>
	<path class="disabled"  d="M431.477,286.283v0.635l-3.104,6.495l-0.998,0.001l3.094-6.309v-0.022h-3.488l-0.001-0.8H431.477z"/>
	<path class="disabled"  d="M427.067,261.063c-0.252,0.132-0.813,0.307-1.525,0.307c-1.602,0-2.645-1.086-2.645-2.71c0-1.634,1.119-2.819,2.854-2.819
		c0.57,0,1.074,0.143,1.338,0.274l-0.219,0.746c-0.23-0.132-0.594-0.252-1.119-0.252c-1.219,0-1.877,0.899-1.877,2.008
		c0,1.229,0.791,1.985,1.844,1.985c0.549,0,0.91-0.143,1.184-0.264L427.067,261.063z"/>
	<path class="disabled"  d="M427.89,261.26v-0.593l0.756-0.734c1.822-1.733,2.645-2.655,2.654-3.73c0-0.725-0.35-1.394-1.414-1.394
		c-0.648,0-1.186,0.329-1.514,0.604l-0.309-0.68c0.494-0.417,1.197-0.725,2.02-0.725c1.535,0,2.184,1.054,2.184,2.073
		c0,1.317-0.955,2.381-2.457,3.829l-0.572,0.526v0.022h3.205v0.801H427.89z"/>
	<path class="disabled"  d="M430.104,358.55c-0.253,0.132-0.812,0.307-1.524,0.307c-1.603,0-2.645-1.086-2.645-2.71c0-1.634,1.119-2.819,2.853-2.819
		c0.57,0,1.075,0.143,1.339,0.274l-0.221,0.746c-0.229-0.132-0.592-0.252-1.118-0.252c-1.218,0-1.876,0.899-1.876,2.008
		c0,1.229,0.789,1.985,1.843,1.985c0.549,0,0.911-0.143,1.185-0.264L430.104,358.55z"/>
	<path class="disabled"  d="M433.021,352.516h-0.022l-1.239,0.669l-0.187-0.735l1.558-0.833h0.823v7.131h-0.933V352.516z"/>
	<path class="disabled"  d="M475.219,215.514c0.285,0.187,0.79,0.384,1.272,0.384c0.702,0,1.032-0.351,1.032-0.79c0-0.461-0.274-0.713-0.988-0.977
		c-0.954-0.34-1.404-0.866-1.404-1.503c0-0.855,0.691-1.558,1.833-1.558c0.537,0,1.009,0.153,1.305,0.329l-0.241,0.702
		c-0.208-0.132-0.592-0.308-1.086-0.308c-0.57,0-0.889,0.329-0.889,0.725c0,0.438,0.318,0.637,1.01,0.899
		c0.921,0.352,1.393,0.812,1.393,1.602c0,0.933-0.724,1.591-1.985,1.591c-0.581,0-1.119-0.143-1.492-0.361L475.219,215.514z"/>
	<path class="disabled"  d="M482.371,216.501v-1.941h-3.313v-0.637l3.181-4.553h1.043v4.432h0.998v0.758h-0.998v1.941H482.371z M482.371,213.802
		v-2.381c0-0.372,0.012-0.745,0.033-1.118h-0.033c-0.219,0.416-0.395,0.724-0.592,1.053l-1.745,2.425v0.021H482.371z"/>
	<path class="disabled"  d="M489.754,212.858c0,2.425-0.899,3.764-2.479,3.764c-1.394,0-2.337-1.306-2.359-3.665c0-2.392,1.031-3.708,2.479-3.708
		C488.898,209.249,489.754,210.588,489.754,212.858z M485.881,212.969c0,1.854,0.57,2.907,1.448,2.907
		c0.987,0,1.459-1.152,1.459-2.974c0-1.755-0.449-2.907-1.448-2.907C486.495,209.995,485.881,211.026,485.881,212.969z"/>
	<path class="disabled"  d="M354.683,434.551c0.285,0.187,0.789,0.384,1.272,0.384c0.702,0,1.031-0.351,1.031-0.79c0-0.46-0.274-0.713-0.987-0.976
		c-0.955-0.341-1.404-0.867-1.404-1.503c0-0.856,0.691-1.559,1.832-1.559c0.537,0,1.01,0.154,1.306,0.329l-0.241,0.702
		c-0.209-0.132-0.593-0.307-1.086-0.307c-0.57,0-0.889,0.329-0.889,0.724c0,0.439,0.318,0.637,1.009,0.899
		c0.922,0.352,1.394,0.813,1.394,1.603c0,0.933-0.725,1.591-1.986,1.591c-0.581,0-1.119-0.143-1.492-0.362L354.683,434.551z"/>
	<path class="disabled"  d="M358.851,435.539v-0.592l0.757-0.735c1.821-1.733,2.644-2.655,2.655-3.73c0-0.724-0.352-1.394-1.416-1.394
		c-0.646,0-1.184,0.329-1.514,0.604l-0.307-0.68c0.494-0.417,1.195-0.725,2.019-0.725c1.536,0,2.183,1.054,2.183,2.074
		c0,1.316-0.954,2.38-2.457,3.828l-0.57,0.527v0.021h3.203v0.801H358.851z"/>
	<path class="disabled"  d="M369.218,431.896c0,2.425-0.9,3.764-2.479,3.764c-1.394,0-2.337-1.306-2.358-3.664c0-2.393,1.031-3.709,2.479-3.709
		C368.362,428.287,369.218,429.625,369.218,431.896z M365.345,432.006c0,1.854,0.57,2.907,1.448,2.907
		c0.987,0,1.459-1.152,1.459-2.974c0-1.755-0.45-2.907-1.448-2.907C365.959,429.033,365.345,430.064,365.345,432.006z"/>
	<path class="disabled"  d="M539.37,236.011c0.255,0.167,0.708,0.344,1.14,0.344c0.629,0,0.925-0.314,0.925-0.708c0-0.413-0.246-0.639-0.886-0.875
		c-0.854-0.304-1.258-0.776-1.258-1.346c0-0.767,0.619-1.396,1.643-1.396c0.481,0,0.903,0.138,1.169,0.295l-0.217,0.629
		c-0.186-0.118-0.529-0.276-0.973-0.276c-0.511,0-0.796,0.295-0.796,0.649c0,0.393,0.285,0.57,0.904,0.806
		c0.825,0.315,1.248,0.727,1.248,1.435c0,0.835-0.648,1.425-1.779,1.425c-0.521,0-1.002-0.128-1.337-0.324L539.37,236.011z"/>
	<path class="disabled"  d="M545.778,236.896v-1.739h-2.968v-0.57l2.85-4.079h0.935v3.97h0.894v0.679h-0.894v1.739H545.778z M545.778,234.477v-2.133
		c0-0.333,0.01-0.668,0.029-1.002h-0.029c-0.196,0.373-0.354,0.648-0.53,0.943l-1.563,2.172v0.019H545.778z"/>
	<path class="disabled"  d="M548.146,236.896v-0.531l0.678-0.658c1.632-1.553,2.369-2.379,2.379-3.342c0-0.649-0.314-1.249-1.269-1.249
		c-0.58,0-1.061,0.295-1.355,0.541l-0.276-0.609c0.443-0.374,1.072-0.649,1.809-0.649c1.377,0,1.957,0.944,1.957,1.857
		c0,1.179-0.855,2.133-2.202,3.431l-0.512,0.472v0.02h2.871v0.717H548.146z"/>
	<g>
		<path class="disabled"  d="M539.667,213.957c0.257,0.168,0.712,0.346,1.146,0.346c0.633,0,0.93-0.316,0.93-0.712c0-0.415-0.247-0.642-0.89-0.879
			c-0.859-0.306-1.266-0.78-1.266-1.354c0-0.771,0.623-1.403,1.651-1.403c0.483,0,0.908,0.138,1.175,0.296l-0.217,0.633
			c-0.188-0.119-0.533-0.277-0.979-0.277c-0.514,0-0.8,0.296-0.8,0.653c0,0.395,0.286,0.573,0.909,0.81
			c0.829,0.316,1.254,0.731,1.254,1.442c0,0.84-0.651,1.433-1.788,1.433c-0.523,0-1.008-0.128-1.344-0.326L539.667,213.957z"/>
		<path class="disabled"  d="M546.109,214.846v-1.749h-2.983v-0.574l2.865-4.101h0.939v3.992h0.898v0.683h-0.898v1.749H546.109z M546.109,212.415
			v-2.145c0-0.335,0.011-0.671,0.03-1.007h-0.03c-0.196,0.375-0.354,0.652-0.532,0.948l-1.572,2.184v0.02H546.109z"/>
		<path class="disabled"  d="M550.378,209.233h-0.02l-1.117,0.603l-0.168-0.663l1.404-0.75h0.74v6.423h-0.84V209.233z"/>
	</g>
	<g>
		<path class="disabled"  d="M361.802,122.681h0.967v5.01c0,1.988-0.978,2.599-2.267,2.599c-0.355,0-0.788-0.078-1.033-0.178l0.145-0.789
			c0.2,0.078,0.489,0.145,0.812,0.145c0.866,0,1.377-0.389,1.377-1.855V122.681z"/>
		<path class="disabled"  d="M365.587,127.813l-0.777,2.355h-1l2.544-7.487h1.167l2.555,7.487h-1.033l-0.8-2.355H365.587z M368.042,127.058
			l-0.733-2.155c-0.166-0.488-0.277-0.933-0.389-1.366h-0.021c-0.111,0.444-0.233,0.9-0.378,1.355l-0.733,2.166H368.042z"/>
		<path class="disabled"  d="M376.703,129.835c-0.434,0.155-1.289,0.411-2.3,0.411c-1.133,0-2.065-0.289-2.799-0.989
			c-0.645-0.622-1.044-1.622-1.044-2.788c0.011-2.232,1.544-3.866,4.054-3.866c0.867,0,1.544,0.189,1.866,0.344l-0.232,0.789
			c-0.4-0.178-0.9-0.322-1.655-0.322c-1.822,0-3.011,1.133-3.011,3.01c0,1.9,1.145,3.021,2.889,3.021c0.633,0,1.066-0.089,1.288-0.2
			v-2.233h-1.521v-0.778h2.466V129.835z"/>
		<path class="disabled"  d="M383.873,129.835c-0.434,0.155-1.289,0.411-2.3,0.411c-1.133,0-2.065-0.289-2.799-0.989
			c-0.645-0.622-1.044-1.622-1.044-2.788c0.011-2.232,1.544-3.866,4.054-3.866c0.867,0,1.544,0.189,1.866,0.344l-0.232,0.789
			c-0.4-0.178-0.9-0.322-1.655-0.322c-1.822,0-3.011,1.133-3.011,3.01c0,1.9,1.145,3.021,2.889,3.021c0.633,0,1.066-0.089,1.288-0.2
			v-2.233h-1.521v-0.778h2.466V129.835z"/>
		<path class="disabled"  d="M389.223,126.658h-2.91v2.699h3.244v0.811h-4.211v-7.487h4.044v0.811h-3.077v2.366h2.91V126.658z"/>
		<path class="disabled"  d="M390.807,122.781c0.489-0.1,1.189-0.155,1.855-0.155c1.033,0,1.699,0.189,2.166,0.611
			c0.378,0.333,0.589,0.844,0.589,1.422c0,0.989-0.622,1.644-1.411,1.911v0.033c0.578,0.2,0.923,0.733,1.101,1.511
			c0.244,1.044,0.422,1.766,0.577,2.055h-1c-0.122-0.211-0.288-0.855-0.5-1.789c-0.222-1.033-0.621-1.422-1.499-1.455h-0.911v3.244
			h-0.967V122.781z M391.773,126.191h0.988c1.033,0,1.689-0.567,1.689-1.422c0-0.967-0.7-1.389-1.723-1.4
			c-0.466,0-0.8,0.044-0.955,0.089V126.191z"/>
	</g>
	<g>
		<path class="disabled"  d="M368.732,133.827c0.423-0.089,1.089-0.155,1.767-0.155c0.967,0,1.589,0.167,2.056,0.544
			c0.389,0.289,0.621,0.733,0.621,1.322c0,0.722-0.478,1.355-1.266,1.644v0.022c0.711,0.178,1.544,0.767,1.544,1.877
			c0,0.645-0.256,1.133-0.634,1.5c-0.521,0.478-1.366,0.7-2.588,0.7c-0.666,0-1.178-0.044-1.5-0.089V133.827z M369.699,136.893
			h0.878c1.021,0,1.622-0.533,1.622-1.255c0-0.878-0.667-1.222-1.645-1.222c-0.444,0-0.7,0.033-0.855,0.067V136.893z
			 M369.699,140.481c0.189,0.034,0.467,0.045,0.811,0.045c1,0,1.922-0.367,1.922-1.456c0-1.022-0.877-1.444-1.933-1.444h-0.8
			V140.481z"/>
		<path class="disabled"  d="M375.961,138.859l-0.777,2.355h-1l2.544-7.487h1.167l2.555,7.487h-1.033l-0.8-2.355H375.961z M378.416,138.104
			l-0.732-2.155c-0.167-0.488-0.278-0.933-0.39-1.366h-0.021c-0.111,0.444-0.233,0.9-0.378,1.355l-0.733,2.166H378.416z"/>
		<path class="disabled"  d="M381.543,133.827c0.489-0.1,1.189-0.155,1.855-0.155c1.033,0,1.699,0.189,2.166,0.611
			c0.378,0.333,0.589,0.844,0.589,1.422c0,0.989-0.622,1.644-1.411,1.911v0.033c0.578,0.2,0.923,0.733,1.101,1.511
			c0.244,1.044,0.422,1.766,0.577,2.055h-1c-0.122-0.211-0.288-0.855-0.5-1.789c-0.222-1.033-0.621-1.422-1.499-1.455h-0.911v3.244
			h-0.967V133.827z M382.51,137.238h0.988c1.033,0,1.689-0.567,1.689-1.422c0-0.967-0.7-1.389-1.723-1.4
			c-0.466,0-0.8,0.044-0.955,0.089V137.238z"/>
	</g>
	<g>
		<path class="disabled"  d="M38.868,25.847h4.387v0.882h-3.336v2.707h3.082v0.87h-3.082v3.687h-1.051V25.847z"/>
		<path class="disabled"  d="M44.402,29.968c0-0.689-0.012-1.281-0.048-1.825h0.931l0.036,1.148h0.048c0.267-0.786,0.907-1.281,1.62-1.281
			c0.12,0,0.205,0.012,0.302,0.036v1.003c-0.108-0.023-0.218-0.036-0.362-0.036c-0.75,0-1.281,0.568-1.426,1.366
			c-0.024,0.145-0.049,0.313-0.049,0.495v3.118h-1.052V29.968z"/>
		<path class="disabled"  d="M53.528,31.019c0,2.164-1.499,3.106-2.913,3.106c-1.583,0-2.804-1.16-2.804-3.01c0-1.957,1.281-3.105,2.9-3.105
			C52.392,28.01,53.528,29.231,53.528,31.019z M48.888,31.08c0,1.281,0.736,2.248,1.776,2.248c1.015,0,1.776-0.955,1.776-2.271
			c0-0.991-0.496-2.248-1.752-2.248C49.431,28.808,48.888,29.968,48.888,31.08z"/>
		<path class="disabled"  d="M54.869,29.726c0-0.604-0.012-1.1-0.048-1.583h0.942l0.061,0.967h0.024c0.29-0.556,0.967-1.1,1.934-1.1
			c0.81,0,2.066,0.483,2.066,2.489v3.493h-1.063v-3.372c0-0.942-0.351-1.729-1.354-1.729c-0.701,0-1.245,0.496-1.426,1.088
			c-0.049,0.133-0.073,0.314-0.073,0.496v3.517h-1.063V29.726z"/>
		<path class="disabled"  d="M62.809,26.463v1.68h1.522v0.81h-1.522v3.154c0,0.726,0.206,1.136,0.798,1.136c0.277,0,0.483-0.036,0.616-0.072
			l0.048,0.798c-0.205,0.085-0.531,0.145-0.942,0.145c-0.495,0-0.894-0.156-1.147-0.446c-0.303-0.314-0.411-0.834-0.411-1.523v-3.19
			h-0.906v-0.81h0.906v-1.401L62.809,26.463z"/>
		<path class="disabled"  d="M68.126,25.956c0.641-0.097,1.402-0.169,2.236-0.169c1.511,0,2.586,0.351,3.299,1.016
			c0.726,0.664,1.148,1.606,1.148,2.924c0,1.33-0.411,2.417-1.172,3.167c-0.762,0.761-2.019,1.172-3.602,1.172
			c-0.75,0-1.378-0.036-1.91-0.097V25.956z M69.178,33.159c0.266,0.048,0.652,0.061,1.063,0.061c2.248,0,3.469-1.257,3.469-3.457
			c0.012-1.921-1.076-3.142-3.3-3.142c-0.544,0-0.954,0.048-1.232,0.108V33.159z"/>
		<path class="disabled"  d="M76.78,31.261c0.023,1.438,0.942,2.03,2.006,2.03c0.762,0,1.221-0.133,1.619-0.302l0.182,0.761
			c-0.375,0.169-1.016,0.362-1.945,0.362c-1.801,0-2.877-1.184-2.877-2.948s1.039-3.154,2.743-3.154c1.91,0,2.417,1.68,2.417,2.756
			c0,0.217-0.023,0.387-0.036,0.495H76.78z M79.897,30.5c0.013-0.677-0.277-1.728-1.474-1.728c-1.076,0-1.547,0.99-1.632,1.728
			H79.897z"/>
		<path class="disabled"  d="M82.098,32.905c0.314,0.205,0.87,0.423,1.401,0.423c0.773,0,1.137-0.387,1.137-0.87c0-0.508-0.303-0.785-1.088-1.075
			c-1.052-0.375-1.547-0.955-1.547-1.656c0-0.942,0.762-1.716,2.018-1.716c0.593,0,1.112,0.169,1.438,0.362l-0.266,0.773
			c-0.229-0.145-0.652-0.338-1.196-0.338c-0.629,0-0.979,0.362-0.979,0.798c0,0.483,0.351,0.7,1.112,0.99
			c1.015,0.387,1.535,0.895,1.535,1.765c0,1.027-0.798,1.752-2.188,1.752c-0.641,0-1.233-0.156-1.644-0.398L82.098,32.905z"/>
		<path class="disabled"  d="M88.08,30.826h0.024c0.145-0.205,0.351-0.459,0.52-0.664l1.716-2.019h1.281l-2.26,2.405l2.574,3.444h-1.294l-2.018-2.804
			l-0.544,0.604v2.2h-1.052v-8.581h1.052V30.826z"/>
		<path class="disabled"  d="M102.159,30.416c-0.06-1.137-0.133-2.502-0.12-3.517h-0.036c-0.278,0.954-0.617,1.97-1.027,3.094l-1.438,3.951h-0.798
			l-1.316-3.879c-0.387-1.148-0.714-2.199-0.943-3.166h-0.023c-0.024,1.015-0.085,2.38-0.157,3.601l-0.218,3.493h-1.003l0.567-8.146
			h1.342l1.39,3.939c0.339,1.003,0.616,1.897,0.822,2.743h0.036c0.205-0.821,0.495-1.716,0.857-2.743l1.45-3.939h1.342l0.508,8.146
			h-1.027L102.159,30.416z"/>
		<path class="disabled"  d="M108.287,33.993l-0.085-0.737h-0.036c-0.326,0.459-0.954,0.87-1.788,0.87c-1.185,0-1.789-0.834-1.789-1.68
			c0-1.414,1.257-2.188,3.517-2.176v-0.121c0-0.483-0.133-1.354-1.329-1.354c-0.544,0-1.111,0.17-1.522,0.436l-0.242-0.701
			c0.483-0.314,1.185-0.52,1.922-0.52c1.788,0,2.224,1.221,2.224,2.393v2.188c0,0.508,0.024,1.003,0.097,1.402H108.287z
			 M108.13,31.007c-1.16-0.024-2.478,0.182-2.478,1.317c0,0.688,0.459,1.015,1.003,1.015c0.762,0,1.245-0.483,1.414-0.979
			c0.036-0.108,0.061-0.229,0.061-0.338V31.007z"/>
		<path class="disabled"  d="M110.873,29.726c0-0.604-0.012-1.1-0.048-1.583h0.942l0.061,0.967h0.024c0.29-0.556,0.967-1.1,1.934-1.1
			c0.81,0,2.066,0.483,2.066,2.489v3.493h-1.063v-3.372c0-0.942-0.351-1.729-1.354-1.729c-0.701,0-1.245,0.496-1.426,1.088
			c-0.049,0.133-0.073,0.314-0.073,0.496v3.517h-1.063V29.726z"/>
		<path class="disabled"  d="M120.819,33.993l-0.085-0.737h-0.036c-0.326,0.459-0.955,0.87-1.788,0.87c-1.185,0-1.789-0.834-1.789-1.68
			c0-1.414,1.257-2.188,3.517-2.176v-0.121c0-0.483-0.133-1.354-1.329-1.354c-0.544,0-1.112,0.17-1.522,0.436l-0.242-0.701
			c0.483-0.314,1.185-0.52,1.922-0.52c1.788,0,2.224,1.221,2.224,2.393v2.188c0,0.508,0.024,1.003,0.097,1.402H120.819z
			 M120.662,31.007c-1.16-0.024-2.478,0.182-2.478,1.317c0,0.688,0.459,1.015,1.003,1.015c0.762,0,1.245-0.483,1.414-0.979
			c0.036-0.108,0.061-0.229,0.061-0.338V31.007z"/>
		<path class="disabled"  d="M128.445,28.143c-0.024,0.423-0.049,0.895-0.049,1.607v3.396c0,1.342-0.266,2.164-0.834,2.671
			c-0.567,0.532-1.39,0.701-2.127,0.701c-0.7,0-1.474-0.169-1.945-0.483l0.266-0.81c0.387,0.241,0.991,0.459,1.716,0.459
			c1.088,0,1.886-0.567,1.886-2.042V32.99h-0.024c-0.326,0.543-0.954,0.979-1.861,0.979c-1.449,0-2.489-1.232-2.489-2.853
			c0-1.981,1.293-3.105,2.635-3.105c1.015,0,1.571,0.532,1.825,1.016h0.023l0.049-0.883H128.445z M127.346,30.452
			c0-0.182-0.013-0.339-0.061-0.483c-0.193-0.616-0.713-1.124-1.486-1.124c-1.016,0-1.74,0.858-1.74,2.212
			c0,1.147,0.58,2.103,1.728,2.103c0.652,0,1.245-0.411,1.475-1.088c0.061-0.182,0.085-0.387,0.085-0.568V30.452z"/>
		<path class="disabled"  d="M130.754,31.261c0.024,1.438,0.942,2.03,2.006,2.03c0.762,0,1.221-0.133,1.619-0.302l0.182,0.761
			c-0.375,0.169-1.016,0.362-1.946,0.362c-1.8,0-2.876-1.184-2.876-2.948s1.04-3.154,2.743-3.154c1.91,0,2.417,1.68,2.417,2.756
			c0,0.217-0.023,0.387-0.036,0.495H130.754z M133.872,30.5c0.012-0.677-0.278-1.728-1.475-1.728c-1.076,0-1.547,0.99-1.632,1.728
			H133.872z"/>
		<path class="disabled"  d="M136.216,29.968c0-0.689-0.012-1.281-0.048-1.825h0.931l0.036,1.148h0.048c0.267-0.786,0.906-1.281,1.62-1.281
			c0.12,0,0.205,0.012,0.302,0.036v1.003c-0.108-0.023-0.218-0.036-0.362-0.036c-0.749,0-1.281,0.568-1.427,1.366
			c-0.023,0.145-0.048,0.313-0.048,0.495v3.118h-1.052V29.968z"/>
		<path class="disabled"  d="M140.022,29.11c0-0.447,0.303-0.761,0.726-0.761s0.701,0.313,0.713,0.761c0,0.423-0.278,0.749-0.725,0.749
			C140.313,29.859,140.022,29.533,140.022,29.11z M140.022,33.376c0-0.447,0.303-0.762,0.726-0.762s0.701,0.314,0.713,0.762
			c0,0.423-0.278,0.749-0.725,0.749C140.313,34.125,140.022,33.799,140.022,33.376z"/>
		<path class="disabled"  d="M44.258,44.531c0,2.429-0.979,4.097-2.985,4.097c-2.03,0-2.925-1.825-2.937-4.048c0-2.271,0.967-4.072,2.997-4.072
			C43.436,40.507,44.258,42.38,44.258,44.531z M40.185,44.58c-0.012,1.801,0.424,2.659,1.137,2.659s1.1-0.894,1.1-2.683
			c0-1.74-0.375-2.658-1.112-2.658C40.632,41.897,40.173,42.755,40.185,44.58z"/>
		<path class="disabled"  d="M47.509,42.272h-0.024l-1.499,0.713l-0.302-1.378l2.078-0.967h1.523v7.855h-1.776V42.272z"/>
		<path class="disabled"  d="M52.197,46.694c0.326,0.169,1.075,0.483,1.825,0.483c0.954,0,1.438-0.459,1.438-1.051c0-0.773-0.773-1.124-1.583-1.124
			h-0.749v-1.317h0.713c0.616-0.012,1.401-0.241,1.401-0.906c0-0.471-0.387-0.821-1.16-0.821c-0.64,0-1.317,0.277-1.644,0.471
			l-0.374-1.329c0.471-0.302,1.414-0.592,2.429-0.592c1.68,0,2.61,0.882,2.61,1.958c0,0.833-0.472,1.486-1.438,1.824v0.024
			c0.943,0.169,1.704,0.882,1.704,1.909c0,1.39-1.22,2.405-3.214,2.405c-1.016,0-1.873-0.266-2.333-0.556L52.197,46.694z"/>
		<path class="disabled"  d="M61.02,48.495v-1.112l1.015-0.918c1.717-1.535,2.55-2.417,2.574-3.335c0-0.641-0.387-1.147-1.293-1.147
			c-0.677,0-1.269,0.338-1.68,0.652l-0.52-1.317c0.592-0.447,1.511-0.81,2.574-0.81c1.776,0,2.755,1.039,2.755,2.465
			c0,1.317-0.954,2.369-2.091,3.384L63.63,46.96v0.024h2.961v1.511H61.02z"/>
		<path class="disabled"  d="M73.358,40.64v1.16l-3.239,6.695h-1.945l3.238-6.32v-0.024h-3.602V40.64H73.358z"/>
		<path class="disabled"  d="M80.234,44.532c0,2.429-0.979,4.097-2.985,4.097c-2.03,0-2.925-1.825-2.937-4.049c0-2.271,0.967-4.072,2.997-4.072
			C79.412,40.507,80.234,42.38,80.234,44.532z M76.161,44.58c-0.012,1.801,0.424,2.659,1.137,2.659s1.1-0.895,1.1-2.684
			c0-1.74-0.375-2.658-1.112-2.658C76.608,41.897,76.149,42.755,76.161,44.58z"/>
		<path class="disabled"  d="M81.467,46.695c0.326,0.169,1.075,0.483,1.825,0.483c0.954,0,1.438-0.459,1.438-1.052c0-0.773-0.773-1.124-1.583-1.124
			h-0.749v-1.317h0.713c0.616-0.012,1.401-0.241,1.401-0.906c0-0.471-0.387-0.821-1.16-0.821c-0.64,0-1.317,0.277-1.644,0.471
			l-0.374-1.329c0.471-0.302,1.414-0.592,2.429-0.592c1.68,0,2.61,0.882,2.61,1.958c0,0.833-0.472,1.486-1.438,1.824v0.024
			c0.943,0.169,1.704,0.882,1.704,1.909c0,1.39-1.22,2.405-3.214,2.405c-1.016,0-1.873-0.266-2.333-0.556L81.467,46.695z"/>
		<path class="disabled"  d="M92.634,42.272h-0.024l-1.499,0.713l-0.302-1.378l2.078-0.967h1.523v7.855h-1.776V42.272z"/>
		<path class="disabled"  d="M99.341,42.272h-0.024l-1.499,0.713l-0.302-1.378l2.078-0.967h1.523v7.855h-1.776V42.272z"/>
		<path class="disabled"  d="M106.048,42.272h-0.024l-1.499,0.713l-0.302-1.378l2.078-0.967h1.523v7.855h-1.776V42.272z"/>
	</g>
	<g>
		<path fill="#ED1C24" d="M16.058,536.228v1.255h-3.254v-1.255H16.058z"/>
		<path fill="#ED1C24" d="M30.931,539.879c-0.348,0.174-1.129,0.36-2.148,0.36c-2.894,0-4.385-1.801-4.385-4.186
			c0-2.856,2.037-4.446,4.571-4.446c0.981,0,1.727,0.198,2.062,0.372l-0.385,1.503c-0.385-0.161-0.919-0.311-1.59-0.311
			c-1.503,0-2.67,0.906-2.67,2.77c0,1.678,0.993,2.732,2.683,2.732c0.571,0,1.204-0.123,1.577-0.272L30.931,539.879z"/>
		<path fill="#ED1C24" d="M32.078,531.297h1.889v8.818h-1.889V531.297z"/>
		<path fill="#ED1C24" d="M38.949,540.116l-0.112-0.608h-0.037c-0.397,0.484-1.019,0.745-1.739,0.745
			c-1.229,0-1.962-0.895-1.962-1.863c0-1.577,1.416-2.335,3.564-2.322v-0.088c0-0.322-0.174-0.781-1.105-0.781
			c-0.621,0-1.279,0.211-1.677,0.459l-0.348-1.217c0.422-0.236,1.254-0.535,2.359-0.535c2.025,0,2.671,1.193,2.671,2.621v2.111
			c0,0.584,0.024,1.143,0.087,1.479H38.949z M38.724,537.247c-0.993-0.013-1.764,0.224-1.764,0.957c0,0.484,0.324,0.72,0.746,0.72
			c0.472,0,0.857-0.311,0.98-0.695c0.025-0.1,0.037-0.212,0.037-0.323V537.247z"/>
		<path fill="#ED1C24" d="M44.007,532.353c0,0.521-0.398,0.944-1.02,0.944c-0.596,0-0.992-0.423-0.98-0.944
			c-0.012-0.547,0.385-0.956,0.994-0.956C43.609,531.397,43.995,531.806,44.007,532.353z M42.057,540.116v-6.074h1.888v6.074H42.057
			z"/>
		<path fill="#ED1C24" d="M45.462,535.979c0-0.757-0.025-1.402-0.051-1.938h1.59l0.088,0.82h0.037
			c0.26-0.385,0.795-0.957,1.838-0.957c0.783,0,1.404,0.398,1.664,1.031h0.025c0.223-0.311,0.496-0.559,0.782-0.732
			c0.335-0.199,0.708-0.299,1.155-0.299c1.168,0,2.049,0.82,2.049,2.634v3.577h-1.838v-3.304c0-0.882-0.285-1.392-0.895-1.392
			c-0.435,0-0.744,0.299-0.869,0.658c-0.05,0.137-0.074,0.336-0.074,0.484v3.553h-1.838v-3.403c0-0.771-0.273-1.292-0.87-1.292
			c-0.484,0-0.771,0.373-0.882,0.684c-0.063,0.148-0.074,0.322-0.074,0.472v3.54h-1.838V535.979z"/>
		<path fill="#ED1C24" d="M58.783,538.166c0.51,0.261,1.293,0.522,2.1,0.522c0.869,0,1.329-0.361,1.329-0.907
			c0-0.522-0.397-0.819-1.403-1.181c-1.392-0.484-2.299-1.254-2.299-2.471c0-1.429,1.193-2.521,3.168-2.521
			c0.943,0,1.64,0.198,2.137,0.422l-0.423,1.527c-0.335-0.161-0.931-0.396-1.751-0.396s-1.217,0.372-1.217,0.807
			c0,0.534,0.471,0.771,1.553,1.18c1.478,0.547,2.173,1.316,2.173,2.497c0,1.403-1.081,2.596-3.378,2.596
			c-0.957,0-1.9-0.248-2.373-0.509L58.783,538.166z"/>
		<path fill="#ED1C24" d="M71.456,537.01c0,2.224-1.577,3.242-3.204,3.242c-1.776,0-3.143-1.168-3.143-3.13
			c0-1.963,1.291-3.218,3.242-3.218C70.213,533.905,71.456,535.184,71.456,537.01z M67.058,537.073c0,1.043,0.436,1.826,1.242,1.826
			c0.733,0,1.205-0.733,1.205-1.826c0-0.906-0.348-1.826-1.205-1.826C67.394,535.247,67.058,536.178,67.058,537.073z"/>
		<path fill="#ED1C24" d="M72.837,540.116v-4.683h-0.795v-1.392h0.795v-0.235c0-0.733,0.225-1.54,0.771-2.037
			c0.472-0.447,1.13-0.608,1.677-0.608c0.422,0,0.746,0.049,1.006,0.124l-0.074,1.453c-0.162-0.05-0.36-0.087-0.608-0.087
			c-0.621,0-0.882,0.484-0.882,1.08v0.311h1.217v1.392h-1.205v4.683H72.837z"/>
		<path fill="#ED1C24" d="M80.317,540.116l-0.112-0.608h-0.037c-0.396,0.484-1.018,0.745-1.738,0.745
			c-1.23,0-1.963-0.895-1.963-1.863c0-1.577,1.416-2.335,3.564-2.322v-0.088c0-0.322-0.174-0.781-1.105-0.781
			c-0.621,0-1.279,0.211-1.676,0.459l-0.348-1.217c0.422-0.236,1.254-0.535,2.359-0.535c2.024,0,2.67,1.193,2.67,2.621v2.111
			c0,0.584,0.025,1.143,0.088,1.479H80.317z M80.093,537.247c-0.994-0.013-1.764,0.224-1.764,0.957c0,0.484,0.323,0.72,0.746,0.72
			c0.471,0,0.856-0.311,0.98-0.695c0.025-0.1,0.037-0.212,0.037-0.323V537.247z"/>
		<path fill="#ED1C24" d="M83.414,538.463c0.348,0.211,1.068,0.46,1.627,0.46c0.571,0,0.807-0.198,0.807-0.509
			s-0.186-0.46-0.895-0.695c-1.254-0.423-1.738-1.105-1.726-1.826c0-1.131,0.969-1.988,2.472-1.988c0.708,0,1.342,0.162,1.714,0.349
			l-0.335,1.304c-0.273-0.148-0.795-0.348-1.316-0.348c-0.46,0-0.721,0.187-0.721,0.497c0,0.286,0.236,0.435,0.98,0.695
			c1.156,0.397,1.641,0.981,1.652,1.876c0,1.13-0.895,1.962-2.633,1.962c-0.795,0-1.503-0.174-1.963-0.422L83.414,538.463z"/>
		<path fill="#ED1C24" d="M91.279,540.116c0.025-0.397,0.051-1.131,0.051-1.813v-7.005h1.887v3.465h0.025
			c0.36-0.521,0.994-0.857,1.838-0.857c1.453,0,2.521,1.205,2.51,3.068c0,2.186-1.392,3.279-2.783,3.279
			c-0.707,0-1.391-0.261-1.825-0.981h-0.024l-0.075,0.845H91.279z M93.216,537.532c0,0.125,0.014,0.236,0.037,0.336
			c0.125,0.51,0.56,0.895,1.105,0.895c0.809,0,1.305-0.621,1.305-1.715c0-0.943-0.422-1.689-1.305-1.689
			c-0.508,0-0.98,0.386-1.105,0.932c-0.023,0.112-0.037,0.225-0.037,0.349V537.532z"/>
		<path fill="#ED1C24" d="M100.064,534.042l0.906,2.981c0.1,0.36,0.225,0.808,0.299,1.13h0.037c0.087-0.322,0.187-0.782,0.273-1.13
			l0.745-2.981h2.024l-1.416,4c-0.869,2.41-1.453,3.379-2.137,3.986c-0.658,0.572-1.354,0.771-1.825,0.833l-0.397-1.603
			c0.236-0.037,0.534-0.148,0.82-0.322c0.285-0.149,0.596-0.447,0.781-0.758c0.063-0.088,0.1-0.187,0.1-0.273
			c0-0.063-0.012-0.162-0.086-0.311l-2.224-5.553H100.064z"/>
		<path fill="#ED1C24" d="M109.832,533.719h-0.025l-1.54,0.732l-0.311-1.416l2.136-0.993h1.566v8.073h-1.826V533.719z"/>
		<path fill="#ED1C24" d="M116.728,533.719h-0.025l-1.539,0.732l-0.311-1.416l2.136-0.993h1.565v8.073h-1.826V533.719z"/>
		<path fill="#ED1C24" d="M121.315,539.11c0-0.671,0.46-1.155,1.118-1.155s1.105,0.472,1.105,1.155c0,0.658-0.447,1.143-1.118,1.143
			C121.775,540.252,121.315,539.768,121.315,539.11z"/>
		<path fill="#ED1C24" d="M124.782,538.265c0.335,0.174,1.105,0.497,1.876,0.497c0.98,0,1.478-0.473,1.478-1.081
			c0-0.795-0.795-1.155-1.627-1.155h-0.771v-1.354h0.733c0.634-0.013,1.44-0.248,1.44-0.932c0-0.484-0.397-0.845-1.192-0.845
			c-0.658,0-1.354,0.286-1.688,0.484l-0.386-1.366c0.484-0.311,1.454-0.608,2.497-0.608c1.727,0,2.683,0.907,2.683,2.013
			c0,0.856-0.484,1.527-1.478,1.875v0.025c0.969,0.174,1.75,0.906,1.75,1.962c0,1.429-1.254,2.472-3.303,2.472
			c-1.044,0-1.926-0.273-2.397-0.571L124.782,538.265z"/>
		<path fill="#ED1C24" d="M137.305,536.042c0,2.496-1.006,4.211-3.067,4.211c-2.087,0-3.006-1.875-3.019-4.161
			c0-2.335,0.993-4.186,3.081-4.186C136.46,531.906,137.305,533.831,137.305,536.042z M133.12,536.091
			c-0.013,1.851,0.435,2.732,1.167,2.732c0.733,0,1.131-0.919,1.131-2.757c0-1.789-0.385-2.732-1.143-2.732
			C133.58,533.334,133.107,534.215,133.12,536.091z"/>
		<path fill="#ED1C24" d="M138.476,536.079c0-0.795-0.024-1.478-0.049-2.037h1.639l0.088,0.846h0.024
			c0.446-0.646,1.143-0.982,2.024-0.982c1.329,0,2.521,1.156,2.521,3.094c0,2.211-1.404,3.254-2.758,3.254
			c-0.732,0-1.304-0.299-1.577-0.695h-0.024v3.018h-1.889V536.079z M140.365,537.507c0,0.149,0.012,0.286,0.037,0.397
			c0.124,0.51,0.559,0.895,1.105,0.895c0.819,0,1.304-0.684,1.304-1.715c0-0.969-0.435-1.701-1.279-1.701
			c-0.534,0-1.006,0.397-1.13,0.957c-0.025,0.099-0.037,0.223-0.037,0.335V537.507z"/>
		<path fill="#ED1C24" d="M145.908,535.979c0-0.757-0.025-1.402-0.05-1.938h1.59l0.087,0.82h0.037
			c0.262-0.385,0.795-0.957,1.838-0.957c0.783,0,1.404,0.398,1.665,1.031h0.024c0.224-0.311,0.497-0.559,0.783-0.732
			c0.335-0.199,0.707-0.299,1.154-0.299c1.168,0,2.05,0.82,2.05,2.634v3.577h-1.839v-3.304c0-0.882-0.285-1.392-0.894-1.392
			c-0.435,0-0.745,0.299-0.87,0.658c-0.049,0.137-0.074,0.336-0.074,0.484v3.553h-1.838v-3.403c0-0.771-0.273-1.292-0.869-1.292
			c-0.484,0-0.771,0.373-0.883,0.684c-0.062,0.148-0.074,0.322-0.074,0.472v3.54h-1.838V535.979z"/>
		<path fill="#ED1C24" d="M16.058,551.14v1.255h-3.254v-1.255H16.058z"/>
		<path fill="#ED1C24" d="M30.931,554.792c-0.348,0.174-1.129,0.36-2.148,0.36c-2.894,0-4.385-1.801-4.385-4.186
			c0-2.856,2.037-4.446,4.571-4.446c0.981,0,1.727,0.198,2.062,0.372l-0.385,1.503c-0.385-0.161-0.919-0.311-1.59-0.311
			c-1.503,0-2.67,0.906-2.67,2.77c0,1.678,0.993,2.732,2.683,2.732c0.571,0,1.204-0.123,1.577-0.272L30.931,554.792z"/>
		<path fill="#ED1C24" d="M32.078,546.209h1.889v8.818h-1.889V546.209z"/>
		<path fill="#ED1C24" d="M38.949,555.028l-0.112-0.608h-0.037c-0.397,0.484-1.019,0.745-1.739,0.745
			c-1.229,0-1.962-0.895-1.962-1.863c0-1.577,1.416-2.335,3.564-2.322v-0.088c0-0.322-0.174-0.781-1.105-0.781
			c-0.621,0-1.279,0.211-1.677,0.459l-0.348-1.217c0.422-0.236,1.254-0.535,2.359-0.535c2.025,0,2.671,1.193,2.671,2.621v2.111
			c0,0.584,0.024,1.143,0.087,1.479H38.949z M38.724,552.159c-0.993-0.013-1.764,0.224-1.764,0.957c0,0.484,0.324,0.72,0.746,0.72
			c0.472,0,0.857-0.311,0.98-0.695c0.025-0.1,0.037-0.212,0.037-0.323V552.159z"/>
		<path fill="#ED1C24" d="M44.007,547.265c0,0.521-0.398,0.944-1.02,0.944c-0.596,0-0.992-0.423-0.98-0.944
			c-0.012-0.547,0.385-0.956,0.994-0.956C43.609,546.309,43.995,546.718,44.007,547.265z M42.057,555.028v-6.074h1.888v6.074H42.057
			z"/>
		<path fill="#ED1C24" d="M45.462,550.891c0-0.757-0.025-1.402-0.051-1.938h1.59l0.088,0.82h0.037
			c0.26-0.385,0.795-0.957,1.838-0.957c0.783,0,1.404,0.398,1.664,1.031h0.025c0.223-0.311,0.496-0.559,0.782-0.732
			c0.335-0.199,0.708-0.299,1.155-0.299c1.168,0,2.049,0.82,2.049,2.634v3.577h-1.838v-3.304c0-0.882-0.285-1.392-0.895-1.392
			c-0.435,0-0.744,0.299-0.869,0.658c-0.05,0.137-0.074,0.336-0.074,0.484v3.553h-1.838v-3.403c0-0.771-0.273-1.292-0.87-1.292
			c-0.484,0-0.771,0.373-0.882,0.684c-0.063,0.148-0.074,0.322-0.074,0.472v3.54h-1.838V550.891z"/>
		<path fill="#ED1C24" d="M58.783,553.078c0.51,0.261,1.293,0.522,2.1,0.522c0.869,0,1.329-0.361,1.329-0.907
			c0-0.522-0.397-0.819-1.403-1.181c-1.392-0.484-2.299-1.254-2.299-2.471c0-1.429,1.193-2.521,3.168-2.521
			c0.943,0,1.64,0.198,2.137,0.422l-0.423,1.527c-0.335-0.161-0.931-0.396-1.751-0.396s-1.217,0.372-1.217,0.807
			c0,0.534,0.471,0.771,1.553,1.18c1.478,0.547,2.173,1.316,2.173,2.497c0,1.403-1.081,2.596-3.378,2.596
			c-0.957,0-1.9-0.248-2.373-0.509L58.783,553.078z"/>
		<path fill="#ED1C24" d="M67.419,547.215v1.738h1.354v1.392h-1.354v2.198c0,0.732,0.174,1.068,0.744,1.068
			c0.236,0,0.423-0.025,0.56-0.05l0.013,1.429c-0.248,0.1-0.695,0.161-1.23,0.161c-0.607,0-1.117-0.211-1.416-0.521
			c-0.348-0.36-0.521-0.944-0.521-1.801v-2.484h-0.807v-1.392h0.807v-1.316L67.419,547.215z"/>
		<path fill="#ED1C24" d="M73.321,555.028l-0.112-0.608h-0.037c-0.396,0.484-1.018,0.745-1.738,0.745
			c-1.23,0-1.963-0.895-1.963-1.863c0-1.577,1.416-2.335,3.564-2.322v-0.088c0-0.322-0.174-0.781-1.105-0.781
			c-0.621,0-1.279,0.211-1.676,0.459l-0.348-1.217c0.422-0.236,1.254-0.535,2.359-0.535c2.024,0,2.67,1.193,2.67,2.621v2.111
			c0,0.584,0.025,1.143,0.088,1.479H73.321z M73.097,552.159c-0.994-0.013-1.764,0.224-1.764,0.957c0,0.484,0.323,0.72,0.746,0.72
			c0.471,0,0.856-0.311,0.98-0.695c0.025-0.1,0.037-0.212,0.037-0.323V552.159z"/>
		<path fill="#ED1C24" d="M76.429,550.891c0-0.757-0.024-1.402-0.049-1.938h1.639l0.088,0.832h0.037
			c0.248-0.385,0.869-0.969,1.875-0.969c1.242,0,2.174,0.82,2.174,2.609v3.602h-1.889v-3.366c0-0.782-0.272-1.316-0.955-1.316
			c-0.522,0-0.833,0.36-0.957,0.708c-0.05,0.111-0.074,0.298-0.074,0.473v3.502h-1.889V550.891z"/>
		<path fill="#ED1C24" d="M89.599,546.209v7.005c0,0.683,0.025,1.403,0.05,1.813h-1.677l-0.087-0.895h-0.024
			c-0.386,0.684-1.119,1.031-1.9,1.031c-1.441,0-2.597-1.229-2.597-3.117c-0.013-2.05,1.267-3.23,2.72-3.23
			c0.746,0,1.33,0.262,1.604,0.684h0.024v-3.291H89.599z M87.711,551.526c0-0.1-0.013-0.236-0.024-0.336
			c-0.112-0.51-0.522-0.932-1.105-0.932c-0.857,0-1.305,0.77-1.305,1.727c0,1.031,0.51,1.677,1.291,1.677
			c0.547,0,0.982-0.372,1.094-0.907c0.037-0.137,0.05-0.273,0.05-0.434V551.526z"/>
		<path fill="#ED1C24" d="M93.068,547.265c0,0.521-0.397,0.944-1.018,0.944c-0.598,0-0.994-0.423-0.982-0.944
			c-0.012-0.547,0.385-0.956,0.994-0.956C92.67,546.309,93.056,546.718,93.068,547.265z M91.119,555.028v-6.074h1.887v6.074H91.119z
			"/>
		<path fill="#ED1C24" d="M94.523,550.891c0-0.757-0.025-1.402-0.05-1.938h1.64l0.087,0.832h0.037
			c0.249-0.385,0.87-0.969,1.876-0.969c1.242,0,2.174,0.82,2.174,2.609v3.602h-1.889v-3.366c0-0.782-0.273-1.316-0.957-1.316
			c-0.521,0-0.832,0.36-0.955,0.708c-0.051,0.111-0.075,0.298-0.075,0.473v3.502h-1.888V550.891z"/>
		<path fill="#ED1C24" d="M107.605,548.954c-0.024,0.386-0.049,0.895-0.049,1.802v3.391c0,1.167-0.236,2.124-0.92,2.732
			c-0.67,0.571-1.577,0.745-2.471,0.745c-0.795,0-1.641-0.161-2.187-0.472l0.372-1.429c0.385,0.224,1.057,0.46,1.764,0.46
			c0.895,0,1.578-0.484,1.578-1.603v-0.397h-0.025c-0.359,0.509-0.943,0.795-1.639,0.795c-1.504,0-2.572-1.218-2.572-2.968
			c0-1.951,1.268-3.193,2.758-3.193c0.832,0,1.354,0.361,1.664,0.857h0.025l0.063-0.721H107.605z M105.667,551.426
			c0-0.125-0.012-0.249-0.037-0.348c-0.137-0.498-0.496-0.832-1.018-0.832c-0.684,0-1.242,0.62-1.242,1.726
			c0,0.907,0.447,1.614,1.242,1.614c0.484,0,0.869-0.322,0.993-0.77c0.05-0.137,0.062-0.336,0.062-0.496V551.426z"/>
		<path fill="#ED1C24" d="M112.777,548.247h-2.248v-1.59h6.434v1.59h-2.285v6.781h-1.9V548.247z"/>
		<path fill="#ED1C24" d="M120.542,555.028l-0.111-0.608h-0.037c-0.398,0.484-1.02,0.745-1.739,0.745
			c-1.229,0-1.962-0.895-1.962-1.863c0-1.577,1.416-2.335,3.564-2.322v-0.088c0-0.322-0.174-0.781-1.105-0.781
			c-0.621,0-1.279,0.211-1.678,0.459l-0.348-1.217c0.423-0.236,1.255-0.535,2.36-0.535c2.024,0,2.671,1.193,2.671,2.621v2.111
			c0,0.584,0.024,1.143,0.086,1.479H120.542z M120.319,552.159c-0.993-0.013-1.764,0.224-1.764,0.957c0,0.484,0.323,0.72,0.745,0.72
			c0.473,0,0.857-0.311,0.981-0.695c0.024-0.1,0.037-0.212,0.037-0.323V552.159z"/>
		<path fill="#ED1C24" d="M123.601,555.028c0.025-0.397,0.051-1.131,0.051-1.813v-7.005h1.887v3.465h0.025
			c0.36-0.521,0.994-0.857,1.838-0.857c1.453,0,2.521,1.205,2.51,3.068c0,2.186-1.392,3.279-2.783,3.279
			c-0.707,0-1.391-0.261-1.825-0.981h-0.024l-0.075,0.845H123.601z M125.539,552.444c0,0.125,0.014,0.236,0.037,0.336
			c0.125,0.51,0.56,0.895,1.105,0.895c0.809,0,1.305-0.621,1.305-1.715c0-0.943-0.422-1.689-1.305-1.689
			c-0.508,0-0.98,0.386-1.105,0.932c-0.023,0.112-0.037,0.225-0.037,0.349V552.444z"/>
		<path fill="#ED1C24" d="M131.083,546.209h1.888v8.818h-1.888V546.209z"/>
		<path fill="#ED1C24" d="M135.953,552.593c0.063,0.782,0.832,1.155,1.715,1.155c0.646,0,1.167-0.087,1.676-0.248l0.249,1.279
			c-0.621,0.248-1.378,0.372-2.198,0.372c-2.063,0-3.242-1.192-3.242-3.093c0-1.54,0.957-3.242,3.068-3.242
			c1.963,0,2.707,1.528,2.707,3.031c0,0.322-0.037,0.608-0.062,0.745H135.953z M138.176,551.301c0-0.459-0.198-1.229-1.067-1.229
			c-0.795,0-1.119,0.721-1.168,1.229H138.176z"/>
		<path fill="#ED1C24" d="M141.048,553.375c0.348,0.211,1.068,0.46,1.628,0.46c0.571,0,0.808-0.198,0.808-0.509
			s-0.188-0.46-0.895-0.695c-1.255-0.423-1.739-1.105-1.727-1.826c0-1.131,0.969-1.988,2.472-1.988c0.708,0,1.341,0.162,1.714,0.349
			l-0.336,1.304c-0.272-0.148-0.795-0.348-1.316-0.348c-0.459,0-0.72,0.187-0.72,0.497c0,0.286,0.235,0.435,0.981,0.695
			c1.154,0.397,1.639,0.981,1.651,1.876c0,1.13-0.894,1.962-2.633,1.962c-0.795,0-1.503-0.174-1.963-0.422L141.048,553.375z"/>
		<path fill="#ED1C24" d="M151.138,548.631h-0.025l-1.539,0.732l-0.311-1.416l2.136-0.993h1.565v8.073h-1.826V548.631z"/>
		<path fill="#ED1C24" d="M158.035,548.631h-0.024l-1.54,0.732l-0.311-1.416l2.137-0.993h1.564v8.073h-1.826V548.631z"/>
		<path fill="#ED1C24" d="M162.759,550.991c0-0.795-0.025-1.478-0.051-2.037h1.641l0.086,0.846h0.025
			c0.447-0.646,1.143-0.982,2.024-0.982c1.329,0,2.521,1.156,2.521,3.094c0,2.211-1.403,3.254-2.757,3.254
			c-0.733,0-1.305-0.299-1.578-0.695h-0.025v3.018h-1.887V550.991z M164.646,552.419c0,0.149,0.014,0.286,0.037,0.397
			c0.125,0.51,0.56,0.895,1.105,0.895c0.82,0,1.305-0.684,1.305-1.715c0-0.969-0.435-1.701-1.279-1.701
			c-0.533,0-1.006,0.397-1.131,0.957c-0.023,0.099-0.037,0.223-0.037,0.335V552.419z"/>
		<path fill="#ED1C24" d="M170.19,550.891c0-0.757-0.024-1.402-0.05-1.938h1.59l0.087,0.82h0.037
			c0.261-0.385,0.795-0.957,1.839-0.957c0.782,0,1.402,0.398,1.664,1.031h0.025c0.223-0.311,0.496-0.559,0.781-0.732
			c0.336-0.199,0.709-0.299,1.156-0.299c1.167,0,2.049,0.82,2.049,2.634v3.577h-1.838v-3.304c0-0.882-0.286-1.392-0.895-1.392
			c-0.436,0-0.746,0.299-0.869,0.658c-0.051,0.137-0.074,0.336-0.074,0.484v3.553h-1.839v-3.403c0-0.771-0.273-1.292-0.87-1.292
			c-0.484,0-0.77,0.373-0.881,0.684c-0.063,0.148-0.075,0.322-0.075,0.472v3.54h-1.838V550.891z"/>
	</g>
	
		<rect x="335.855" y="167.687" id="bt1" onClick="reply_click(this.id)" data-id="bt1"';
        
            $result = $this->get_table_stat("bt1", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>

        <rect x="358.73" y="167.495" id="bt2" onClick="reply_click(this.id)" data-id="bt2"';
        
            $result = $this->get_table_stat("bt2", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>

        <rect x="381.81" y="167.495" id="bt3" onClick="reply_click(this.id)" data-id="bt3"';
        
            $result = $this->get_table_stat("bt3", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>

        <rect x="405.132" y="167.495" id="bt4" onClick="reply_click(this.id)" data-id="bt4"';
        
            $result = $this->get_table_stat("bt4", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>

        <rect x="428.257" y="167.495" id="bt5" onClick="reply_click(this.id)" data-id="bt5"';
        
            $result = $this->get_table_stat("bt5", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>

        <rect x="451.257" y="167.495" id="bt6" onClick="reply_click(this.id)" data-id="bt6"';
        
            $result = $this->get_table_stat("bt6", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>

        <rect x="474.257" y="167.495" id="bt7" onClick="reply_click(this.id)" data-id="bt7"';
        
            $result = $this->get_table_stat("bt7", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>

        <rect x="497.431" y="167.495" id="bt8" onClick="reply_click(this.id)" data-id="bt8"';
        
            $result = $this->get_table_stat("bt8", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>

        <rect x="520.217" y="167.495" id="bt9" onClick="reply_click(this.id)" data-id="bt9"';
        
            $result = $this->get_table_stat("bt9", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>

        <rect x="543.023" y="167.495" id="bt10" onClick="reply_click(this.id)" data-id="bt10"';
        
            $result = $this->get_table_stat("bt10", $date); if($result->guest_status == 1){echo 'fill="#32CD32"';} elseif($result->guest_status == 2) {echo 'fill="#CF000F"';} else {echo 'fill="#fff"';}

            echo 'data-value="'.$result->guest_status.'"';
            echo ' data-name="'.$result->name.'"';
            echo ' data-date="'.$result->booking_date.'"';
            echo 'stroke="#000000" stroke-width="0.7131" stroke-miterlimit="10" width="20.746" height="17"/>
            
	<g>
		<path class="disabled"  d="M59.819,90.805l0.876-0.087l-0.056,0.061l-0.223,0.037l0.167,0.123l0.112-0.017l0.112,0.034l0.15-0.113l-0.114-0.146
			l1.436-0.231l0.076,0.042l0.055-0.06l0.634-0.103v0.205l0.264-0.042l-0.132-0.081l0.056-0.111l4.885-0.776l0.147,0.217
			l0.077-0.052v-0.205l1.286-0.202l-0.333,0.104v0.076l0.203-0.109l-0.076,0.115l0.076,0.034l0.13-0.118l0.205-0.035l0.056-0.11
			l3.32-0.531l0.073,0.04l0.075-0.012v-0.05l0.262-0.042v0.432l-0.112,0.071l0.112,0.071v1.118l-0.15,0.111v0.193l0.15-0.062v0.317
			l-0.15,0.024l-0.838,0.196l0.222-0.15l0.264-0.045v-0.468l0.318-0.05v-0.038l-0.169-0.076l-0.333,0.132v-0.167l-0.079,0.012
			l-0.129,0.187l-0.354,0.17v0.14l0.296-0.188l0.338-0.055v0.193l-0.226,0.188l-0.055-0.042l-0.279-0.032l-0.094,0.178l0.168,0.012
			v0.051l-0.185,0.03l-0.153-0.106l-0.165,0.028l-0.186,0.158l-0.411,0.062l0.315-0.136l0.111-0.375l0.17-0.103l0.373-0.302
			l-0.168-0.355l-0.281,0.236l-0.259-0.036v0.204l0.093,0.103l0.13-0.1l0.112-0.019v0.04l-0.317,0.165l-0.073-0.05l-0.057,0.148
			l-0.132,0.096l-0.094-0.098l-0.055,0.084l-0.205,0.184l-0.28,0.046l-0.279,0.134l-0.391,0.06v0.054l-0.298,0.146v0.067
			l-0.539,0.007v-0.14l-0.151,0.024l-0.112,0.296l-0.634,0.102v-0.227l0.206-0.173v-0.153l-0.168,0.154l-0.093-0.062l-0.15,0.023
			l-0.074,0.062l-0.132,0.022l-0.147,0.161l-0.077,0.064v0.152l0.077-0.008l0.147-0.13l0.132,0.085v0.074l-3.972,0.633l-0.094-0.1
			l-0.149,0.112l-0.336-0.175l-0.258,0.167l-0.076-0.038l-0.129,0.021v0.176l-0.208,0.034v-0.317l-0.057,0.01l-0.072-0.09
			l-0.224,0.036l-0.058-0.093l-0.074-0.027l0.279-0.096l-0.185-0.084l-0.148,0.15L62.13,92.09l-0.184,0.029v0.051l0.26-0.004
			l0.15,0.169l0.411,0.226v0.077l-0.486,0.078v-0.128l-0.093-0.047l-0.168,0.218l-0.41,0.063l-0.167-0.048l-0.056,0.083
			l-0.467,0.077l-0.076-0.041l-0.205,0.035v-0.126l-0.298,0.225l-2.125,0.338l-0.13-0.296l0.13-0.022v-0.152l-0.262,0.141v0.373
			l-0.84,0.13l-0.112-0.032l-0.147,0.024v-1.167l0.185,0.122l0.15-0.024l-0.188-0.173l-0.147-0.24 M69.887,91.556l-0.056,0.009
			l0.056-0.111l0.168-0.026L69.887,91.556z M71.285,91.229l-0.092,0.016l0.092-0.14v-0.14l0.132-0.124l0.149-0.025l0.076,0.156
			l-0.076,0.139l-0.076-0.18L71.285,91.229z M70.934,91.288l-0.282,0.044l0.149-0.148l0.076-0.114l0.058-0.01V91.288z
			 M70.391,91.374l-0.076,0.012v-0.023L70.391,91.374z M68.602,91.646l0.262-0.157l-0.079-0.037l-0.184,0.03V91.646z M60.286,92.958
			l0.297-0.253v-0.088l-0.242,0.178l-0.299,0.2L60.286,92.958z M58.346,92.691L58.496,93v0.243l0.259-0.042l-0.109-0.135
			l-0.189-0.392L58.346,92.691z M63.941,92.323v-0.049l-0.076,0.01v0.051L63.941,92.323z M69.626,91.075v0.102l0.076,0.077
			l0.073-0.046v-0.242l-0.223,0.031L69.626,91.075z M68.955,91.374l0.074-0.012v-0.038l-0.166,0.025L68.955,91.374z M70.521,90.985
			l-0.13-0.159v-0.1l-0.243,0.319L70.521,90.985z M57.621,92.987l0.258-0.222l0.076,0.169l0.132-0.2l-0.055-0.041v-0.088
			l-0.077-0.028l-0.13,0.163l-0.28,0.158V93L57.621,92.987z M72.331,90.596v-0.04l-0.076,0.013v0.038L72.331,90.596z M63.791,91.916
			v-0.039l-0.057,0.087L63.791,91.916z M69.087,90.703l0.091-0.015l-0.148,0.238l0.391,0.057l0.076-0.114l0.279-0.108v-0.217
			l-0.558,0.088v-0.088l0.203-0.11v-0.126l-0.127,0.022l-0.264,0.245v0.241L69.087,90.703z M70.521,90.501l0.206,0.043l-0.15,0.201
			l0.15-0.021l0.241-0.204l-0.112-0.188l0.186-0.229l-0.109,0.015l-0.207,0.134l-0.206,0.098V90.501z M68.676,90.872v0.175
			l0.109-0.018v-0.177l-0.109-0.081l-0.074,0.01v0.052L68.676,90.872z M61.833,92.136l0.113-0.153v-0.119l0.26,0.037l0.111-0.17
			l-0.297,0.048L61.722,91.7l0.073,0.24l-0.092,0.219L61.833,92.136z M71.304,90.555l0.186-0.133l-0.131-0.283l0.131-0.109v-0.05
			l-0.261,0.042l0.056,0.093v0.34l-0.132,0.022L71.304,90.555z M70.315,90.688l0.262-0.081l-0.262-0.098l-0.185-0.263v0.396
			l-0.074,0.085v-0.039H70.315z M67.239,91.177l0.058-0.05l-0.132-0.068l-0.109,0.148L67.239,91.177z M66.663,91.229v-0.09
			l-0.056,0.01v0.128L66.663,91.229z M60.88,92.188l0.168-0.027l0.206-0.111v-0.098l0.055-0.11l-0.13,0.02V91.62l0.094-0.167
			l-0.298-0.309L60.9,91.027l-0.187,0.158l0.207,0.17l-0.281,0.097v0.075l0.056,0.04v0.129l-0.056,0.062v0.05l0.056-0.01
			l0.148-0.152v-0.05l0.131-0.211l0.15,0.205l-0.15,0.114L60.9,91.93l-0.427-0.02L60.88,92.188z M62.671,91.876l0.167-0.129
			l-0.129-0.03l-0.076-0.09l-0.129,0.187L62.671,91.876z M72.591,90.288v-0.04l-0.075,0.013L72.591,90.288z M60.156,92.176v-0.242
			l-0.079,0.011v0.05l-0.07,0.104v0.191L60.156,92.176z M68.341,90.925v-0.05l-0.077,0.012v0.05L68.341,90.925z M60.509,92.17
			v-0.051l-0.092,0.066L60.509,92.17z M58.291,92.523v-0.05l-0.075,0.062L58.291,92.523z M57.396,92.463v0.126l0.224-0.111
			l0.071-0.154l0.262-0.041v-0.227l-0.15,0.023l-0.184,0.082L57.357,92.2v0.179L57.396,92.463z M58.979,92.314v-0.054l-0.129,0.02
			v0.055L58.979,92.314z M72.516,90.108l0.147-0.076l-0.073-0.137l-0.243,0.127L72.516,90.108z M59.67,92.1v-0.14l0.203-0.084V91.65
			l-0.333,0.394L59.67,92.1z M58.271,92.323l0.093-0.014l0.092-0.106l0.264-0.038l0.073-0.064l-0.147-0.078l-0.189,0.094
			l-0.092-0.048l0.356-0.288l-0.15-0.153l-0.241-0.123l-0.187,0.142l-0.056,0.202l0.056,0.077l-0.056,0.11v-0.05L58.271,92.323z
			 M67.296,90.749l0.203-0.084v-0.079l-0.335,0.055v0.18L67.296,90.749z M60.509,91.778l-0.092-0.036l-0.13,0.019v0.054
			L60.509,91.778z M71.901,89.888l-0.073,0.012v0.027L71.901,89.888z M70.391,90.152v-0.024l-0.076-0.039v0.05L70.391,90.152z
			 M62.484,91.41v-0.074l-0.074,0.011v0.074L62.484,91.41z M58.979,91.97v-0.028l-0.073,0.012v0.028L58.979,91.97z M59.575,91.862
			l0.095-0.079v-0.05l0.148-0.126v-0.051l-0.224,0.087l-0.055-0.03l0.055-0.099v-0.052l0.279-0.144v-0.14l-0.129,0.021l-0.074,0.114
			l-0.076,0.01l-0.055-0.142l-0.056,0.008v0.623L59.575,91.862z M72.516,89.792l0.075-0.064v-0.049l0.13-0.073v-0.05l-0.13-0.017
			l-0.149,0.213v-0.05L72.516,89.792z M72.255,89.83l0.076-0.112v-0.139l-0.076,0.01l-0.077,0.206L72.255,89.83z M70.186,90.163
			v-0.244l-0.13,0.021v0.24L70.186,90.163z M73.001,89.611l0.261-0.268l-0.188,0.025l-0.146,0.255L73.001,89.611z M68.452,90.336
			l0.095-0.332l-0.206,0.349L68.452,90.336z M57.19,92.129l0.129-0.022l-0.129-0.359l-0.15-0.065v0.138L57.19,92.129z
			 M69.123,90.152l0.094-0.081l0.076,0.078l0.073-0.012v-0.126l-0.148-0.078l-0.188,0.169L69.123,90.152z M59.054,91.78l0.11-0.016
			l-0.11-0.214l-0.091,0.18L59.054,91.78z M57.713,91.954l0.241-0.1v-0.076L57.748,91.9l-0.127,0.018L57.713,91.954z M60.509,91.421
			V91.18l-0.168,0.027v0.277L60.509,91.421z M67.52,89.888l0.261-0.119l-0.073,0.164l-0.132,0.122l0.055,0.03l0.077,0.192
			l0.053-0.01v-0.205l0.17-0.116v-0.098l0.073-0.13l-0.166-0.087l-0.262,0.045l-0.15,0.124L67.52,89.888z M58.832,91.676
			l0.074-0.204l-0.056,0.01l-0.13,0.121L58.832,91.676z M71.285,89.605l-0.056,0.009v0.051L71.285,89.605z M70.651,89.759v-0.195
			l-0.074,0.051v0.154L70.651,89.759z M69.702,89.908l0.166-0.168l0.094,0.074l0.094-0.014v-0.205l-0.429,0.145v0.179L69.702,89.908
			z M72.721,89.375l0.055-0.01v-0.05l-0.112-0.068l-0.073,0.008v0.039L72.721,89.375z M72.255,89.449v-0.1l-0.077-0.027
			l-0.129,0.085L72.255,89.449z M65.6,90.318l-0.094,0.015v0.14L65.6,90.318z M63.308,90.733v-0.047l-0.076,0.06v0.09L63.308,90.733
			z M61.179,91.162v-0.05l-0.073-0.029v0.041L61.179,91.162z M60.248,91.233l0.168-0.141l-0.076-0.04l-0.264,0.042v0.05
			L60.248,91.233z M69.496,89.75v-0.052L69.42,89.66v0.103L69.496,89.75z M58.793,90.895l-0.073,0.06v0.128l0.073,0.09v0.13
			l-0.073,0.059l-0.074-0.038v-0.127l-0.15,0.024l-0.04,0.13l0.189,0.125l0.147-0.024l0.057-0.06l0.204-0.034v-0.329l-0.241-0.033
			l0.317-0.154 M65.19,90.411l0.205-0.111l-0.113-0.197l-0.185,0.153v0.092L65.19,90.411z M72.178,89.167v-0.035l-0.073,0.013v0.086
			L72.178,89.167z M57.878,91.496l0.076-0.1l-0.076-0.029l-0.074,0.143L57.878,91.496z M70.168,89.515l0.073-0.164l-0.055,0.008
			l-0.056,0.061l-0.168,0.066L70.168,89.515z M58.142,91.365l0.109,0.036l-0.109-0.276l-0.056,0.111L58.142,91.365z M73.467,88.964
			v-0.077l-0.035,0.005v0.079L73.467,88.964z M72.442,89.131v-0.183l-0.074,0.012v0.102L72.442,89.131z M70.521,89.431v-0.176
			l-0.13,0.02v0.18L70.521,89.431z M59.448,90.816l0.092,0.05l0.093,0.2l0.112,0.046l0.074-0.013l-0.074-0.128v-0.139 M61.31,90.671
			l-0.13,0.02v0.154L61.31,90.671z M59.39,91.127v-0.1l-0.074-0.037v0.05L59.39,91.127z M70.934,89.241l0.053-0.009l-0.053-0.093
			l-0.058,0.061L70.934,89.241z M57.621,91.172l0.071,0.177l0.187-0.182v-0.075l-0.074,0.047l-0.056,0.01 M57.002,91.355V91.27
			l-0.073,0.012v0.085L57.002,91.355z M58.364,91.052v-0.041l-0.073,0.012L58.364,91.052z"/>
		<path class="disabled"  d="M88.092,86.304l0.743-0.066l-0.046,0.058l-0.191,0.03l0.142,0.131l0.095-0.014l0.097,0.033l0.128-0.108l-0.097-0.151
			l1.217-0.193l0.063,0.042l0.043-0.06l0.54-0.084v0.204l0.22-0.036l-0.107-0.084l0.045-0.112l4.138-0.657l0.129,0.22l0.064-0.045
			v-0.205l1.088-0.174l-0.286,0.097v0.078l0.175-0.104l-0.063,0.109l0.063,0.042l0.11-0.121l0.174-0.026l0.048-0.112l2.814-0.448
			L99.5,84.59l0.063-0.011V84.53l0.224-0.035v0.434l-0.098,0.067l0.098,0.074v1.123L99.659,86.3v0.195l0.127-0.063v0.318
			l-0.127,0.021l-0.712,0.178l0.191-0.145l0.22-0.036v-0.473l0.269-0.042v-0.041l-0.142-0.076l-0.285,0.119v-0.164l-0.063,0.01
			l-0.112,0.186l-0.3,0.161v0.14l0.252-0.182l0.286-0.044v0.191l-0.19,0.183l-0.048-0.042l-0.237-0.04l-0.079,0.179l0.142,0.016
			V86.9l-0.159,0.024l-0.126-0.104l-0.14,0.021l-0.161,0.152l-0.345,0.054l0.27-0.132l0.092-0.371l0.145-0.101l0.314-0.292
			l-0.142-0.358l-0.237,0.226l-0.222-0.042v0.209l0.08,0.102l0.111-0.096l0.095-0.016v0.037l-0.269,0.161l-0.063-0.055l-0.046,0.146
			l-0.111,0.097l-0.082-0.103l-0.045,0.085l-0.175,0.18L97.4,86.762l-0.238,0.127l-0.334,0.054v0.05l-0.251,0.14v0.063l-0.459-0.004
			v-0.136l-0.125,0.016l-0.094,0.299l-0.54,0.082v-0.227l0.175-0.168v-0.153l-0.142,0.15l-0.077-0.063l-0.13,0.017l-0.063,0.063
			l-0.106,0.016l-0.129,0.162l-0.062,0.059v0.153l0.062-0.01l0.129-0.123l0.106,0.086v0.077l-3.364,0.537l-0.076-0.104l-0.129,0.109
			l-0.285-0.185l-0.223,0.163l-0.062-0.042l-0.111,0.018v0.178L90.7,88.197v-0.321l-0.047,0.008l-0.062-0.092l-0.19,0.03
			l-0.049-0.092l-0.064-0.026l0.24-0.09l-0.157-0.092l-0.126,0.148l-0.192-0.021l-0.154,0.023v0.055l0.217,0.004l0.129,0.17
			l0.348,0.241v0.073l-0.411,0.067v-0.129l-0.079-0.051l-0.145,0.211l-0.346,0.059l-0.142-0.055l-0.047,0.083l-0.398,0.064
			l-0.06-0.042l-0.174,0.028v-0.127l-0.252,0.22l-1.8,0.286l-0.111-0.302l0.111-0.019v-0.152l-0.222,0.137v0.371l-0.712,0.11
			l-0.094-0.036l-0.127,0.021V87.79l0.158,0.125l0.125-0.021l-0.156-0.177l-0.127-0.248 M96.625,87.304l-0.048,0.01l0.048-0.112
			l0.143-0.021L96.625,87.304z M97.811,87.015l-0.081,0.012l0.081-0.138v-0.14l0.109-0.121l0.128-0.021l0.062,0.154L98.048,86.9
			l-0.063-0.182L97.811,87.015z M97.51,87.064L97.273,87.1l0.127-0.149l0.062-0.11l0.048-0.008V87.064z M97.053,87.137l-0.066,0.01
			v-0.027L97.053,87.137z M95.534,87.365l0.22-0.15l-0.063-0.041l-0.157,0.023V87.365z M88.49,88.472l0.25-0.244v-0.087
			l-0.203,0.169l-0.254,0.194L88.49,88.472z M86.846,88.16l0.126,0.312v0.24l0.22-0.034l-0.094-0.137l-0.157-0.394L86.846,88.16z
			 M91.586,87.927v-0.052l-0.064,0.012v0.052L91.586,87.927z M96.403,86.817v0.103L96.467,87l0.063-0.049v-0.242l-0.189,0.03
			L96.403,86.817z M95.833,87.097l0.066-0.008V87.05l-0.145,0.022L95.833,87.097z M97.162,86.749l-0.109-0.163v-0.102l-0.208,0.314
			L97.162,86.749z M86.23,88.434l0.222-0.212l0.063,0.168l0.111-0.198l-0.049-0.041v-0.09l-0.062-0.026l-0.111,0.156l-0.24,0.154
			v0.102L86.23,88.434z M98.693,86.404v-0.04l-0.062,0.01v0.038L98.693,86.404z M91.458,87.513v-0.036l-0.046,0.084L91.458,87.513z
			 M95.944,86.43l0.081-0.013l-0.126,0.237l0.331,0.064l0.063-0.111l0.237-0.102v-0.219l-0.473,0.074v-0.086l0.172-0.106v-0.127
			l-0.112,0.018l-0.219,0.24v0.241L95.944,86.43z M97.162,86.263l0.174,0.046l-0.126,0.203l0.126-0.023l0.205-0.196l-0.095-0.19
			l0.16-0.231l-0.095,0.015l-0.174,0.132l-0.174,0.091V86.263z M95.597,86.588v0.177l0.094-0.014v-0.177l-0.094-0.085l-0.063,0.008
			v0.05L95.597,86.588z M89.801,87.687l0.095-0.153v-0.112l0.217,0.042l0.098-0.17l-0.255,0.04l-0.252-0.086l0.066,0.243
			l-0.082,0.22L89.801,87.687z M97.825,86.337l0.16-0.13l-0.112-0.285l0.112-0.108v-0.051L97.764,85.8l0.047,0.093v0.343
			l-0.112,0.018L97.825,86.337z M96.987,86.444l0.223-0.073l-0.223-0.104L96.828,86v0.393l-0.06,0.09v-0.044L96.987,86.444z
			 M94.382,86.859l0.046-0.045l-0.109-0.071l-0.096,0.142L94.382,86.859z M93.891,86.897v-0.086l-0.048,0.006v0.128L93.891,86.897z
			 M88.994,87.717l0.143-0.024l0.175-0.104v-0.102l0.044-0.111l-0.108,0.017v-0.24l0.076-0.166l-0.252-0.315l-0.062-0.12
			l-0.16,0.156l0.172,0.174l-0.234,0.09v0.074l0.046,0.044v0.125l-0.046,0.06v0.05l0.046-0.007l0.128-0.146v-0.053l0.109-0.206
			l0.126,0.21l-0.126,0.108l-0.062,0.224l-0.364-0.029L88.994,87.717z M90.511,87.447l0.142-0.122l-0.109-0.032l-0.063-0.094
			l-0.11,0.184L90.511,87.447z M98.916,86.098V86.06l-0.064,0.012L98.916,86.098z M88.378,87.687v-0.243l-0.064,0.009v0.051
			l-0.062,0.099v0.192L88.378,87.687z M95.315,86.634v-0.051l-0.064,0.011v0.049L95.315,86.634z M88.678,87.69v-0.051l-0.08,0.064
			L88.678,87.69z M86.798,87.99v-0.05l-0.062,0.058L86.798,87.99z M86.04,87.906v0.13l0.19-0.109l0.063-0.15l0.222-0.036v-0.23
			l-0.127,0.02l-0.157,0.077l-0.223,0.034v0.18L86.04,87.906z M87.382,87.796v-0.053l-0.112,0.014v0.056L87.382,87.796z
			 M98.852,85.917l0.126-0.069l-0.062-0.144l-0.206,0.122L98.852,85.917z M87.966,87.598v-0.139l0.174-0.076v-0.23l-0.282,0.387
			L87.966,87.598z M86.782,87.79l0.079-0.017l0.08-0.102l0.222-0.036l0.063-0.058l-0.127-0.082l-0.157,0.09l-0.08-0.052l0.302-0.276
			l-0.128-0.161l-0.206-0.13l-0.157,0.137l-0.046,0.201l0.046,0.081l-0.046,0.109v-0.049L86.782,87.79z M94.428,86.43l0.174-0.078
			v-0.076l-0.283,0.043V86.5L94.428,86.43z M88.678,87.295l-0.08-0.038l-0.108,0.018v0.05L88.678,87.295z M98.332,85.681
			l-0.066,0.011v0.025L98.332,85.681z M97.053,85.912v-0.026l-0.066-0.039v0.046L97.053,85.912z M90.351,86.977V86.9l-0.064,0.013
			v0.074L90.351,86.977z M87.382,87.447v-0.024l-0.064,0.01v0.026L87.382,87.447z M87.887,87.36l0.079-0.079v-0.052l0.126-0.123
			v-0.047l-0.188,0.078l-0.046-0.03l0.046-0.096v-0.049l0.235-0.141v-0.142l-0.112,0.018l-0.062,0.114l-0.062,0.01l-0.046-0.148
			l-0.049,0.01v0.625L87.887,87.36z M98.852,85.599l0.064-0.06v-0.052l0.109-0.068v-0.052l-0.109-0.02l-0.127,0.212v-0.051
			L98.852,85.599z M98.631,85.635l0.062-0.11v-0.142l-0.062,0.01l-0.064,0.2L98.631,85.635z M96.879,85.912v-0.239l-0.111,0.015
			v0.244L96.879,85.912z M99.264,85.433l0.222-0.266l-0.16,0.028l-0.125,0.248L99.264,85.433z M95.41,86.043l0.08-0.328
			l-0.174,0.345L95.41,86.043z M85.864,87.565l0.112-0.02l-0.112-0.365l-0.125-0.068v0.14L85.864,87.565z M95.977,85.877l0.08-0.076
			l0.061,0.078l0.064-0.007v-0.127l-0.125-0.083l-0.158,0.167L95.977,85.877z M87.444,87.264l0.097-0.017l-0.097-0.214l-0.08,0.178
			L87.444,87.264z M86.307,87.405l0.208-0.098v-0.074l-0.174,0.116l-0.111,0.018L86.307,87.405z M88.678,86.939v-0.243l-0.142,0.022
			V87L88.678,86.939z M94.62,85.571l0.219-0.11l-0.062,0.162l-0.112,0.121l0.047,0.032l0.065,0.191l0.047-0.005v-0.205l0.14-0.114
			v-0.102l0.063-0.125l-0.142-0.09l-0.221,0.034l-0.126,0.121L94.62,85.571z M87.255,87.153l0.063-0.202l-0.047,0.006l-0.108,0.121
			L87.255,87.153z M97.811,85.383l-0.047,0.006v0.054L97.811,85.383z M97.273,85.521v-0.193l-0.063,0.048v0.153L97.273,85.521z
			 M96.467,85.647l0.142-0.162l0.081,0.077l0.079-0.01v-0.208l-0.365,0.135v0.179L96.467,85.647z M99.025,85.188l0.048-0.006v-0.051
			l-0.096-0.075l-0.062,0.011v0.038L99.025,85.188z M98.631,85.251v-0.102l-0.064-0.026l-0.109,0.081L98.631,85.251z M92.989,85.958
			l-0.078,0.012v0.141L92.989,85.958z M91.046,86.319v-0.05l-0.062,0.058v0.09L91.046,86.319z M89.249,86.694v-0.051l-0.066-0.026
			v0.038L89.249,86.694z M88.457,86.744l0.142-0.136l-0.062-0.043l-0.223,0.036v0.052L88.457,86.744z M96.293,85.485v-0.052
			l-0.063-0.04v0.1L96.293,85.485z M87.226,86.368l-0.063,0.06v0.128l0.063,0.092v0.126l-0.063,0.06l-0.064-0.04v-0.128
			l-0.126,0.022l-0.031,0.131l0.157,0.128l0.127-0.022l0.045-0.06l0.174-0.026v-0.328l-0.205-0.047l0.269-0.144 M92.645,86.042
			l0.174-0.109l-0.097-0.2l-0.157,0.153v0.089L92.645,86.042z M98.567,84.97v-0.039l-0.062,0.009v0.089L98.567,84.97z
			 M86.452,86.949l0.063-0.1l-0.063-0.026l-0.064,0.134L86.452,86.949z M96.863,85.267l0.062-0.162l-0.046,0.006l-0.051,0.056
			l-0.139,0.064L96.863,85.267z M86.672,86.827l0.095,0.034l-0.095-0.277l-0.046,0.107L86.672,86.827z M99.659,84.792v-0.074
			l-0.032,0.005v0.074L99.659,84.792z M98.789,84.935v-0.18l-0.063,0.011v0.103L98.789,84.935z M97.162,85.195v-0.181l-0.109,0.018
			v0.177L97.162,85.195z M87.778,86.304l0.08,0.052l0.079,0.202l0.091,0.053l0.064-0.012l-0.064-0.128v-0.143 M89.356,86.207
			l-0.108,0.018v0.152L89.356,86.207z M87.729,86.621v-0.103l-0.063-0.042v0.05L87.729,86.621z M97.51,85.009l0.045-0.006
			l-0.045-0.097l-0.048,0.061L97.51,85.009z M86.23,86.617l0.063,0.178l0.159-0.174v-0.08l-0.064,0.047l-0.046,0.01 M85.708,86.787
			v-0.09l-0.067,0.012v0.09L85.708,86.787z M86.861,86.514v-0.038l-0.063,0.009L86.861,86.514z"/>
		<path class="disabled"  d="M116.146,81.845l0.743-0.064l-0.047,0.056l-0.191,0.033l0.143,0.129l0.095-0.016l0.097,0.036l0.125-0.109l-0.095-0.15
			l1.215-0.192l0.063,0.04l-0.063,2.214v-0.128l-0.079-0.052l-0.142,0.217l-0.348,0.053l-0.143-0.053l-0.047,0.081l-0.396,0.065
			l-0.062-0.039l-0.174,0.026v-0.128l-0.252,0.219l-1.802,0.287l-0.111-0.303l0.111-0.014v-0.153l-0.22,0.138v0.368l-0.712,0.114
			l-0.092-0.041l-0.127,0.022v-1.169l0.157,0.126l0.125-0.018l-0.154-0.181l-0.127-0.248l0.063-0.761L116.146,81.845z
			 M118.294,83.211l-0.189-0.019l-0.159,0.025v0.05l0.222,0.004l0.126,0.17 M116.543,84.016l0.251-0.245v-0.09l-0.205,0.172
			l-0.252,0.193L116.543,84.016z M114.897,83.702l0.126,0.312v0.24l0.223-0.034l-0.095-0.138l-0.157-0.395L114.897,83.702z
			 M114.281,83.978l0.22-0.213l0.066,0.169l0.109-0.196l-0.048-0.045v-0.087l-0.062-0.03l-0.112,0.158l-0.237,0.154v0.103
			L114.281,83.978z M117.853,83.232l0.094-0.156v-0.113l0.222,0.041l0.097-0.172l-0.254,0.045l-0.255-0.088l0.064,0.247
			l-0.077,0.214L117.853,83.232z M117.046,83.258l0.143-0.023l0.174-0.103V83.03l0.046-0.109l-0.109,0.018v-0.242l0.08-0.168
			l-0.255-0.313l-0.062-0.117l-0.158,0.152l0.172,0.177l-0.235,0.085v0.081l0.047,0.04v0.13l-0.047,0.06v0.049l0.047-0.009
			l0.126-0.145v-0.051l0.109-0.208l0.127,0.208l-0.127,0.108L117.063,83l-0.364-0.032L117.046,83.258z M116.429,83.229v-0.242
			l-0.062,0.012v0.05l-0.063,0.1v0.189L116.429,83.229z M116.732,83.232v-0.052l-0.082,0.064L116.732,83.232z M114.851,83.531
			v-0.053l-0.063,0.06L114.851,83.531z M114.094,83.446v0.128l0.188-0.106l0.066-0.15l0.22-0.036v-0.228l-0.126,0.021l-0.16,0.074
			l-0.223,0.032v0.18L114.094,83.446z M115.437,83.337v-0.052l-0.112,0.018v0.052L115.437,83.337z M116.02,83.142V83l0.172-0.079
			v-0.228l-0.283,0.388L116.02,83.142z M114.835,83.331l0.08-0.012l0.079-0.103l0.22-0.035l0.066-0.06l-0.129-0.084l-0.157,0.091
			l-0.079-0.051l0.299-0.277l-0.126-0.161l-0.205-0.132l-0.157,0.142l-0.049,0.196l0.049,0.083l-0.049,0.109v-0.05L114.835,83.331z
			 M116.732,82.836l-0.082-0.038l-0.108,0.018v0.049L116.732,82.836z M115.437,82.992v-0.028l-0.064,0.012V83L115.437,82.992z
			 M115.94,82.9l0.08-0.079v-0.048l0.126-0.124V82.6l-0.188,0.077l-0.049-0.027l0.049-0.098v-0.05l0.234-0.138v-0.14l-0.109,0.014
			l-0.063,0.114l-0.062,0.01l-0.049-0.144l-0.048,0.006v0.625L115.94,82.9z M113.917,83.107l0.112-0.016l-0.112-0.369l-0.125-0.068
			v0.14L113.917,83.107z M115.499,82.804l0.095-0.016l-0.095-0.211l-0.08,0.175L115.499,82.804z M114.36,82.947l0.208-0.097v-0.077
			l-0.172,0.117l-0.114,0.017L114.36,82.947z M116.732,82.479v-0.242l-0.143,0.023v0.283L116.732,82.479z M115.309,82.694
			l0.063-0.203l-0.047,0.01l-0.111,0.117L115.309,82.694z M117.3,82.237v-0.05l-0.063-0.03v0.038L117.3,82.237z M116.508,82.286
			l0.143-0.136l-0.062-0.044l-0.222,0.038v0.051L116.508,82.286z M115.28,81.91l-0.066,0.062v0.126l0.066,0.092v0.13l-0.066,0.056
			l-0.063-0.038v-0.126l-0.128,0.018l-0.029,0.134l0.157,0.127l0.129-0.019l0.045-0.06l0.174-0.028v-0.331l-0.206-0.045l0.268-0.145
			 M114.501,82.492l0.066-0.098l-0.066-0.03l-0.06,0.138L114.501,82.492z M114.726,82.368l0.094,0.033l-0.094-0.276l-0.049,0.11
			L114.726,82.368z M115.832,81.845l0.077,0.052l0.08,0.206l0.094,0.049l0.063-0.012l-0.063-0.128V81.87 M117.41,81.747
			l-0.109,0.018v0.155L117.41,81.747z M115.782,82.16v-0.103l-0.062-0.041v0.05L115.782,82.16z M114.281,82.157l0.066,0.18
			l0.154-0.177v-0.079l-0.06,0.05l-0.046,0.008 M113.763,82.328v-0.086l-0.064,0.008v0.091L113.763,82.328z M114.915,82.055v-0.038
			l-0.064,0.013L114.915,82.055z"/>
		<path class="disabled"  d="M59.578,73.3l0.068-0.194l0.381-0.064v0.052l0.085-0.014l0.014-0.102l0.202,0.05l-0.13,0.105l0.064,0.038l0.234-0.072
			l0.051-0.071l-0.168-0.042l0.886-0.193l1.953-0.314l0.119,0.082l0.133-0.124l2.003-0.32l0.268,0.005l0.482-0.077l0.986,0.026
			l0.133,0.046l0.167,0.022l0.069,0.005l0.433,0.048l0.902,0.323l0.384,0.24l0.886,0.743l0.182,0.288l0.118,0.166l0.083,0.238
			l-0.133,0.17v0.151l0.166,0.122l0.153-0.14l0.066,0.206l0.032,0.129l0.017,0.2l0.118,0.147v0.353l-0.135,0.054v0.284l0.067-0.01
			l0.081-0.063v0.083l-0.081,0.146l-0.05,0.158l-0.249,0.161l0.066,0.038l0.133-0.021l0.15,0.058l0.167-0.127l-0.083,0.7v0.569
			l-0.135,0.089v0.064l0.067,0.04l-0.118,0.32v0.151l-0.049,0.226l-0.066,0.21l-0.018,0.068l-0.318,0.805L69.7,80.536l-0.135,0.086
			l-0.052,0.125l-0.249,0.193v-0.118l0.083-0.081V80.51l-0.101,0.064l-0.233,0.036v0.103l0.152,0.06l-0.051,0.058l-0.167,0.026
			l-0.115-0.1l-0.07,0.077l0.07,0.209l-0.136,0.154l-0.066,0.26l-0.084-0.054l-0.1,0.018v0.084l0.048,0.095l-0.401,0.246
			l-0.082,0.065l-0.252,0.172l-0.181,0.029l0.066-0.191l-0.167-0.311l-0.068-0.256V81.1l-0.115-0.098l-0.084,0.132l0.067,0.104
			l-0.067,0.264l-0.132,0.071v0.065l0.101,0.102l0.115-0.205l0.1,0.053v0.116l-0.132,0.056l-0.052,0.076l-0.069,0.042v0.115
			l-0.214,0.037v0.118l0.283,0.085l0.184-0.31l0.016,0.028v0.2l-0.268,0.179l-1.235,0.415l-2.954,0.474l-0.052,0.074l-0.066,1.182
			l-0.084,0.063l0.084,0.035v1.021l-0.25,0.156l0.116-0.018l0.133,0.096v0.25l-0.217,0.033l-0.032,0.107l0.25,0.113v0.583
			l-0.133,0.072l0.133,0.096v1.305l-2.471,0.442l-0.718,0.066L59.578,73.3z M59.846,81.01l0.118-0.138v-0.05l-0.066,0.011
			l-0.118,0.134L59.846,81.01z M59.897,83.707l0.031-0.005l0.136-0.205l-0.167,0.028V83.707z M60.064,87.057l0.063-0.094v-0.135
			l-0.1-0.052l-0.1,0.252L60.064,87.057z M60.548,86.744v-0.098l-0.067,0.008v0.102L60.548,86.744z M60.548,88.05l0.064-0.046
			v-0.032l-0.115,0.018v0.032L60.548,88.05z M60.548,84.189l0.064-0.06v-0.036l-0.064,0.012V84.189z M60.548,86.144l0.084-0.081
			l-0.084,0.064V86.144z M60.613,73.332l0.02-0.069l-0.02,0.003V73.332z M60.679,87.743l0.118-0.02v-0.116l-0.118,0.02l-0.066,0.059
			L60.679,87.743z M60.73,87.185l0.066-0.012l0.167-0.159l-0.083-0.041l-0.15,0.076V87.185z M60.747,73.178l0.119-0.019v-0.07
			l-0.07-0.001l-0.049,0.023V73.178z M60.747,86.043l0.25-0.037l-0.065-0.039l-0.135,0.02L60.747,86.043z M61.116,81.875L61.3,81.71
			l-0.202-0.15v0.182l-0.066,0.145L61.116,81.875z M61.116,84.65l0.2-0.184v-0.082l-0.119-0.048l-0.014,0.002v0.099l-0.067,0.079
			V84.65z M61.183,87.095l0.014-0.003v-0.047l-0.014-0.067V87.095z M61.316,88.11l0.132-0.139l0.202-0.1l-0.067,0.096l0.084,0.103
			l0.083-0.08l0.184-0.03v-0.113l-0.133-0.03l-0.051-0.074l-0.083-0.123v-0.1l0.133-0.006l0.133-0.02v-0.133l0.185-0.264
			l-0.369,0.058v0.032l0.167,0.158l-0.283,0.096v-0.032l-0.05-0.125L61.5,87.295v0.134l0.066,0.058L61.5,87.716v0.116l-0.067,0.04
			l-0.067,0.114l-0.1,0.016l-0.069-0.058l-0.014,0.004v0.103L61.316,88.11z M61.197,74.491l0.119-0.103v-0.033l-0.119,0.087V74.491z
			 M61.197,86.743l0.069-0.113l-0.069,0.027V86.743z M61.266,73.428l0.05-0.006l0.117-0.053l-0.067-0.057l-0.1,0.018V73.428z
			 M61.266,73.712l0.05-0.007V73.67L61.266,73.712z M61.5,83.985v-0.116l-0.234-0.046v0.099l0.1-0.014L61.5,83.985z M61.316,86.623
			l0.049-0.006v-0.034l-0.049,0.005V86.623z M61.316,87.592l0.049-0.025v-0.083l-0.049,0.01V87.592z M61.448,81.971l0.052-0.057
			l-0.052-0.06l-0.083,0.081L61.448,81.971z M61.366,85.343l0.083-0.01v-0.018l-0.015,0.002L61.366,85.343z M61.448,81.236
			L61.5,81.23v-0.117l-0.052,0.005l-0.015,0.072L61.448,81.236z M61.433,82.31l0.133-0.022l0.101-0.148l0.166-0.029v-0.166
			l0.053-0.192l-0.136,0.02l-0.067,0.262l-0.117,0.068l-0.133,0.138V82.31z M61.448,84.662l0.118-0.018v-0.066l-0.118,0.017V84.662z
			 M61.5,84.976l0.133-0.022l0.049-0.075l0.203-0.034l0.048-0.326L61.8,84.54v0.167l-0.167,0.06L61.5,84.939V84.976z M61.583,87.167
			l0.05-0.061l-0.05-0.074L61.5,87.044v0.02L61.583,87.167z M61.583,73.242l0.084-0.013l0.133-0.172l-0.133-0.11L61.583,73.242z
			 M61.833,81.609l0.133-0.238l-0.08-0.087l-0.252,0.174v0.136L61.833,81.609z M61.868,84.312l0.083-0.097v-0.15l-0.064-0.042
			l-0.136,0.122l-0.083,0.032v0.082L61.868,84.312z M61.683,83.791l0.203-0.031v-0.083l-0.203,0.031V83.791z M61.95,73.638
			l0.133-0.023l0.135-0.086l0.147-0.094v-0.085l0.053-0.242l-0.053,0.008l-0.082,0.114v0.168l-0.2,0.065l-0.133,0.138V73.638z
			 M62,73.312l0.049-0.042L62,73.209l-0.05,0.009v0.068L62,73.312z M61.95,83.815l0.168-0.026v-0.071l-0.168,0.027V83.815z
			 M61.95,88.392l0.133-0.088l0.135-0.036l0.032-0.104l-0.032-0.082v-0.164l-0.067-0.122l-0.115,0.017l0.083,0.203L62.05,88.11
			v0.184l-0.1,0.016V88.392z M62.151,82.312l0.133-0.024l0.066-0.076l-0.099-0.102l-0.201,0.034v0.117L62.151,82.312z
			 M62.119,83.471v-0.083l-0.035,0.039L62.119,83.471z M62.151,85.455v-0.134l-0.067,0.008v0.134L62.151,85.455z M62.365,85v-0.202
			l-0.247,0.044v0.116L62.365,85z M62.334,72.921l0.066-0.012v-0.117l-0.1-0.049l-0.118,0.139L62.334,72.921z M62.218,81.13
			l0.032-0.006V81.11l-0.032,0.002V81.13z M62.35,79.17l0.185-0.127l0.083,0.002l0.034-0.025v-0.297l-0.066,0.06v0.135L62.4,79.012
			l-0.117,0.134L62.35,79.17z M62.284,78.848l0.051-0.01v-0.013l-0.051,0.005V78.848z M62.449,86.106l0.052-0.041l-0.052-0.092
			l-0.115-0.03v0.183L62.449,86.106z M62.334,87.645l0.031-0.003l-0.031-0.027V87.645z M62.365,82.543l0.035-0.005v-0.034
			l-0.035,0.005V82.543z M62.449,83.217v-0.27l-0.084,0.016v0.168L62.449,83.217z M62.4,84.645l0.049-0.006L62.4,84.61V84.645z
			 M62.535,81.831l0.051-0.09l-0.051-0.06l-0.085,0.081L62.535,81.831z M62.535,85.393v-0.252l-0.085,0.03v0.15L62.535,85.393z
			 M62.786,73.634l0.049-0.038v-0.103l-0.166-0.024l-0.067,0.129L62.786,73.634z M62.618,85.445l0.034-0.006v-0.014L62.618,85.445z
			 M62.751,85.323l0.035-0.055l-0.035-0.043l-0.1,0.013v0.053L62.751,85.323z M62.751,74.06l0.084-0.015l0.167-0.195l-0.049-0.008
			l-0.118,0.02l-0.166,0.143L62.751,74.06z M62.702,74.251l0.3-0.051v-0.1l-0.3,0.048V74.251z M62.786,87.259v-0.1l-0.035,0.002
			v0.068L62.786,87.259z M62.901,80.354l2.708-0.434l0.583-0.177l0.651-0.44l0.035-0.02l0.118-0.12l0.349-0.375l0.251-0.708
			l0.066-0.246l0.052-0.125V76.69l-0.067-0.509v-0.066l-0.066-0.023v-0.051l-0.301-0.47l0.066-0.078l-0.082,0.029l-0.42-0.264
			l-0.132-0.115l-0.854-0.147l-0.248,0.042l-0.168-0.024l0.066-0.044v-0.032l-0.066,0.01l-0.066,0.043l-0.066-0.021l-0.184,0.096
			l-2.224,0.354V80.354z M63.002,81.808l0.018-0.003l-0.018-0.05V81.808z M63.02,74.415l0.066-0.008v-0.019l-0.066,0.013V74.415z
			 M63.219,74.285l0.049-0.01l0.052-0.059l-0.052-0.041l-0.049,0.006V74.285z M63.32,82.358l0.018-0.002v-0.034L63.32,82.358z
			 M63.538,82.208l0.047-0.058l-0.047-0.063l-0.051,0.063L63.538,82.208z M63.637,81.473l0.084-0.03v-0.052l-0.084,0.012V81.473z
			 M63.736,74.536l0.118-0.019v-0.116l-0.118,0.018l-0.015,0.055L63.736,74.536z M63.736,74.802l0.051-0.006v-0.034l-0.051,0.006
			V74.802z M64.321,72.737l0.035-0.072v-0.07l-0.167-0.038l-0.15,0.125l0.164,0.006L64.321,72.737z M64.105,74.343l0.098-0.134
			v-0.083l-0.051-0.075l-0.047,0.172l-0.034,0.125L64.105,74.343z M64.271,73.446l0.086-0.012l0.083-0.063l-0.083-0.022
			l-0.086,0.012V73.446z M64.404,74.746l0.101-0.016l0.15-0.176l-0.031-0.044l-0.185,0.146L64.404,74.746z M64.439,74.355
			l0.048-0.008v-0.051l-0.048-0.006V74.355z M64.624,81.313v-0.064l-0.119-0.065l-0.066,0.011v0.066L64.624,81.313z M64.439,81.46
			l0.066-0.01v-0.018l-0.066,0.01V81.46z M64.624,73.271l0.066-0.013l0.115-0.116v-0.102l-0.066-0.039l-0.084,0.014v0.116
			L64.624,73.271z M64.805,74.031l0.103-0.187l-0.103,0.018l-0.15,0.093L64.805,74.031z M64.855,81.278l0.084-0.016v-0.135
			l-0.201-0.102v0.134L64.855,81.278z M64.774,74.553l0.082-0.017V74.29l-0.082,0.013V74.553z M64.99,73.332l0.035-0.006
			l0.032-0.056l-0.032-0.027l-0.035,0.005V73.332z M65.125,80.666l0.049-0.076l0.083-0.013v-0.135l-0.05-0.109l-0.181,0.033
			l0.115,0.164l-0.115,0.083L65.125,80.666z M65.057,73.619l0.117-0.101v-0.032l-0.049,0.008l-0.067,0.079V73.619z M65.125,74.813
			l0.049-0.008V74.79l-0.049,0.01V74.813z M65.374,72.967l0.132-0.22l-0.15,0.022l-0.182,0.063v0.117L65.374,72.967z M65.241,80.898
			l0.067-0.01l0.048-0.078l-0.048-0.056l-0.067,0.008V80.898z M65.308,73.478l0.048-0.005l0.018-0.168l0.066-0.126l-0.132,0.02
			V73.478z M65.54,74.512l0.085-0.212v-0.066l-0.269,0.144v0.066L65.54,74.512z M65.506,80.47v-0.116l-0.066-0.156l-0.084,0.012
			v0.168L65.506,80.47z M65.506,74.852l0.052-0.125l0.051-0.059v-0.049l-0.183,0.132L65.506,74.852z M65.506,80.838v-0.184
			l-0.066,0.01v0.186L65.506,80.838z M65.743,81.353l0.063-0.11l-0.063-0.04l-0.05,0.057L65.743,81.353z M65.876,82.1l0.066-0.013
			l0.1-0.147l-0.267-0.025l-0.083,0.099l0.114,0.044L65.876,82.1z M66.191,73.586l0.151-0.021v-0.018l-0.084,0.013L66.191,73.586z
			 M66.259,73.997l0.05-0.061l-0.05-0.042V73.997z M66.96,81.423v-0.18l0.119-0.022v-0.067l-0.303-0.27l-0.066,0.078l0.031,0.012
			v0.069l-0.149,0.074l-0.033,0.123l-0.181-0.022l-0.035,0.056l0.115,0.098l0.101-0.016l0.217-0.269l0.066,0.056l-0.066,0.112
			L66.96,81.423z M66.426,74.906l0.032-0.006v-0.05l-0.032,0.005V74.906z M66.592,73.14l0.118-0.02v-0.117l-0.118-0.114
			l-0.099,0.014v0.187L66.592,73.14z M66.678,73.628l0.032-0.024v-0.048l-0.032,0.005l-0.052,0.059L66.678,73.628z M66.678,74.179
			l0.032-0.056l-0.032-0.042V74.179z M66.741,82.03l0.053-0.078v-0.017l-0.116,0.018L66.741,82.03z M67.042,80.792l0.1-0.015
			l0.069-0.145l0.052-0.007v-0.304l-0.184,0.13v0.152l-0.084,0.062l-0.067,0.063L67.042,80.792z M67.162,75.006l0.117-0.018v-0.269
			l-0.016,0.002l-0.052,0.125l-0.168,0.059L67.162,75.006z M67.211,72.973l0.133-0.02v-0.118l-0.183-0.188l-0.02,0.004v0.25
			L67.211,72.973z M67.142,74.355l0.069-0.013l0.184-0.161l-0.05-0.042l-0.202,0.032V74.355z M67.395,72.609l0.066-0.078
			l-0.05-0.059l-0.066,0.011l-0.066,0.112L67.395,72.609z M67.278,73.33l0.066-0.06v-0.018l-0.066,0.011V73.33z M67.278,74.602
			l0.132-0.02v-0.052l-0.132,0.02V74.602z M67.46,81.043l0.119-0.017l0.133-0.157l-0.183-0.072l-0.12,0.137L67.46,81.043z
			 M67.58,74.605l0.098-0.219l-0.032-0.045V74.26l0.435-0.305v-0.05l-0.067,0.007l-0.032-0.144l-0.184,0.167l-0.151-0.163
			L67.46,73.82v0.235l0.217-0.038l-0.147,0.262v0.148l-0.052,0.109L67.58,74.605z M67.58,75.706l0.066-0.076l-0.066-0.073
			l-0.049,0.007L67.58,75.706z M67.58,74.887l0.066-0.044v-0.066l-0.066,0.011V74.887z M67.58,81.208l0.066-0.011V81.13
			l-0.066,0.063V81.208z M67.779,75.691l0.301-0.048v-0.085l-0.202-0.031l-0.166,0.091L67.779,75.691z M67.797,75.522l0.283-0.196
			l-0.182-0.106l-0.138,0.206L67.797,75.522z M67.898,77.06l0.083-0.163l-0.102-0.118l-0.1,0.015v0.185L67.898,77.06z
			 M67.898,74.451l0.115-0.218l-0.134,0.004l-0.049,0.026L67.898,74.451z M67.98,80.51l0.051-0.058l0.148-0.024l-0.1-0.236
			l-0.1,0.014l-0.083,0.066l0.115,0.114l-0.134,0.072L67.98,80.51z M68.08,75.059l0.064-0.03V74.88l-0.064-0.072l-0.049,0.005v0.236
			L68.08,75.059z M68.094,80.756l0.102-0.015l0.103-0.084l0.048-0.074l0.084-0.064l-0.132-0.097l-0.085,0.181l-0.119,0.022
			l-0.032,0.087L68.094,80.756z M68.08,75.945l0.014-0.002l0.119-0.171l0.133-0.068l0.084-0.066l-0.084-0.036l-0.15,0.126
			l-0.116,0.018V75.945z M68.196,77.881v-0.116l-0.102,0.018v0.116L68.196,77.881z M68.094,78.267l0.119-0.018v-0.121l-0.119,0.021
			V78.267z M68.213,75.356l0.133-0.073l0.049,0.042l0.151-0.029l0.084-0.127l-0.051-0.076l-0.436,0.172L68.213,75.356z
			 M68.196,76.778l0.103-0.017l0.031-0.054l-0.031-0.027l-0.103,0.015V76.778z M68.196,77.196l0.133-0.022l0.017-0.036l-0.017-0.047
			l-0.133,0.021V77.196z M68.299,80.339l0.097-0.014v-0.166l-0.199-0.087v0.204L68.299,80.339z M68.299,79.12l0.031-0.006
			l0.017-0.049l-0.048,0.007V79.12z M68.447,76.621l0.1-0.018v-0.082l-0.1,0.016V76.621z M68.596,77.015l0.084-0.08l-0.084-0.087
			l-0.149,0.023v0.119L68.596,77.015z M68.495,79.038l0.121-0.136V78.77l-0.168,0.026L68.495,79.038z M68.749,79.953l0.166-0.182
			l0.034,0.114l0.116-0.021v-0.15l-0.084-0.17v-0.169l-0.048-0.126l-0.438,0.004l-0.048,0.06l0.1,0.066l0.216,0.252l0.07,0.021
			v0.102l-0.121,0.016l-0.097,0.136L68.749,79.953z M68.763,80.5v-0.066l-0.147-0.191l-0.168,0.191l0.202,0.019L68.763,80.5z
			 M68.581,78.624l0.051-0.242l-0.168-0.041v0.184L68.581,78.624z M68.763,74.761l0.186-0.262l0.116-0.069l-0.116-0.015
			l-0.115,0.055l-0.217,0.153l-0.035,0.052L68.763,74.761z M68.697,81.147v-0.185l-0.082,0.012l-0.035,0.075L68.697,81.147z
			 M68.649,78.693v-0.045l-0.034-0.012v0.014L68.649,78.693z M68.697,75.074h0.015l0.151-0.142l-0.167,0.025V75.074z M68.896,76.465
			l0.052-0.106l0.116-0.021l0.067-0.078l-0.118-0.216l0.051-0.091V75.85l-0.15,0.026l-0.051,0.344l-0.167,0.174L68.896,76.465z
			 M68.712,74.17l0.05-0.01l-0.05-0.042V74.17z M68.712,75.29l0.121-0.036v-0.048l-0.121-0.034V75.29z M68.712,78.939l0.05-0.011
			l0.186-0.212l-0.052-0.079l-0.184,0.114V78.939z M68.763,77.442l0.07-0.012l0.031-0.09l-0.031-0.028l-0.07,0.01V77.442z
			 M68.864,79.365v0.132l-0.101,0.018V79.38L68.864,79.365z M68.915,80.627v-0.134l-0.082,0.016v0.064L68.915,80.627z M68.98,80.968
			l0.185,0.102l-0.051,0.028l-0.134,0.02V80.968z M69.014,75.493l0.051-0.023V75.35l-0.051,0.008V75.493z M69.247,76.059
			l0.136-0.141l-0.084-0.12l-0.133,0.02v0.134L69.247,76.059z M69.265,77.728l0.133-0.156l-0.05-0.341l-0.182,0.228v0.134
			l0.081-0.014L69.265,77.728z M69.265,74.365l0.034-0.006v-0.034l-0.034,0.005V74.365z M69.533,76.731v-0.166l-0.135,0.02v0.168
			L69.533,76.731z M69.499,78.355l0.034-0.001v-0.051l-0.135,0.021L69.499,78.355z M69.43,74.926l0.069-0.012V74.88l-0.069,0.012
			V74.926z M69.631,76.065l0.101-0.018v-0.182l-0.101,0.13V76.065z M69.799,78.83l0.019-0.022l-0.085-0.033l-0.048,0.007
			L69.799,78.83z M69.732,79.076l0.067-0.012v-0.053l-0.115,0.02L69.732,79.076z M69.799,75.718l0.067-0.011v-0.115l-0.067,0.008
			V75.718z M69.9,77.408l0.132-0.021v-0.05l-0.116,0.004L69.9,77.358V77.408z M69.916,77.873l0.116-0.018v-0.167l-0.049-0.043
			l-0.067,0.063V77.873z M69.916,78.995l0.067-0.045l-0.067,0.012V78.995z M69.983,79.218v-0.032l-0.067,0.009L69.983,79.218z
			 M70.067,75.993l0.101-0.133l-0.052-0.074l-0.049,0.007l-0.084,0.146L70.067,75.993z M70.067,76.727v-0.082l-0.035,0.006v0.032
			L70.067,76.727z M70.067,77.214l0.049-0.077l-0.049,0.011V77.214z M70.067,78.667l0.069-0.008v-0.017l-0.02,0.001L70.067,78.667z
			 M70.136,74.946l0.164-0.026v-0.136l-0.164,0.028V74.946z M70.252,78.539l0.115-0.018l0.086-0.08l-0.086-0.088L70.2,78.381
			L70.252,78.539z M70.3,76.605l0.217-0.201v-0.063l-0.15-0.029l-0.133,0.138v0.082L70.3,76.605z M70.234,76.785l0.251-0.037
			l0.064-0.097l-0.115-0.035l-0.2,0.035V76.785z M70.434,78.292l0.051-0.008v-0.102l-0.051-0.024v-0.269L70.3,77.862l-0.066,0.011
			v0.203L70.434,78.292z M70.453,79.008l0.216-0.151L70.6,78.784l-0.348,0.006v0.135L70.453,79.008z M70.549,76.167l0.136-0.09
			l0.149-0.173L70.6,75.906l-0.184-0.036l0.069,0.104v0.135L70.549,76.167z M70.549,78.492l0.269-0.163v-0.181l-0.199,0.034
			l-0.102,0.147v0.134L70.549,78.492z M70.549,77.034l0.05-0.006l0.135-0.157l0.133-0.069v-0.118l-0.115,0.018l-0.067,0.096
			l-0.136,0.072V77.034z M70.6,74.233l0.02,0.098v0.035l-0.02-0.03V74.233z M70.685,78.57l0.049-0.024v-0.084l-0.115,0.018
			l0.066,0.074V78.57z M70.734,77.842l0.084-0.032l-0.066-0.02l-0.067,0.01v0.032L70.734,77.842z M70.818,75.254l0.032-0.142
			l-0.032,0.008V75.254z M70.918,77.178l0.067-0.011v-0.035L70.918,77.178z"/>
		<path class="disabled"  d="M76.646,70.334v6.393l-0.133,0.087l-0.048,0.056l-0.301,0.119v0.134l-0.168,0.093l0.101,0.084l0.118,0.048l-0.084,0.165
			l0.15,0.144l0.067-0.009l-0.067-0.126l0.133-0.204l0.069-0.38l0.164-0.027v4.001l-0.082,0.164l0.082,0.088v1.103l-0.133,0.021
			v-0.201l-0.166,0.028v0.453l-0.184-0.041v0.071l0.301,0.119l0.048,0.177l0.069-0.064v-0.303l0.064-0.077l0.067,0.294l4.644-0.743
			l0.135,0.096l0.066-0.012l-0.066-0.106l1.537-0.244l0.182,0.036l-0.066,0.128v0.135l-0.185,0.097l-0.064,0.058l0.383-0.109v-0.269
			l0.167-0.024v2.458l-0.167,0.026l-0.187-0.136v-0.318l-0.132,0.021v0.351l-0.216-0.097l-0.084,0.279l-0.369,0.06l0.052-0.076
			l-0.236-0.014V84.04l-0.283,0.048l-0.084,0.262l0.235,0.049l-0.1,0.1l-0.136,0.02l-0.098-0.068l-0.15,0.108l-1.101,0.176v-0.066
			l0.048-0.043l0.066-0.143l0.135-0.154v-0.087l-0.551,0.236v-0.116l0.133-0.17l-0.085-0.202l-0.048-0.062v-0.185l-0.185-0.086
			l0.268-0.042l0.133,0.212l0.087-0.017l0.048-0.122l-0.048-0.043v-0.201l-0.186,0.027v-0.181l0.133-0.024V83.15l-0.133,0.02
			l-0.368,0.429l-0.052-0.061l0.118-0.201v-0.248l-0.251,0.14l-0.181,0.362l-0.187,0.03l-0.083,0.248l-0.416-0.037l-0.185,0.03
			l0.268,0.195l0.351-0.056l0.136-0.09l-0.07,0.146l-0.083,0.114l0.3,0.268l0.083-0.199l0.067-0.076l-0.2-0.052l0.067-0.096
			l0.185-0.028l0.133-0.088l0.133,0.044l-0.217,0.102l0.116,0.318l-0.166,0.176l0.082,0.187l0.235,0.064l-1.653,0.264l-0.184-0.138
			l-0.234,0.036v-0.133l0.234-0.288v-0.185l0.115-0.135l0.069-0.144l0.115-0.022v-0.099l-0.063-0.056l-0.052,0.075l-0.069,0.011
			v-0.068l0.069-0.079v-0.118l-0.069,0.063l-0.248,0.174l-0.184,0.194l-0.168,0.029l-0.151-0.392l-0.148,0.207l0.167,0.156
			l-0.066,0.01l-0.167-0.056l-0.302,0.183v0.134l0.233-0.039l0.168,0.141l0.266-0.092l0.101-0.132l0.15-0.024l-0.318,0.351
			l-0.232,0.04v0.133l0.232,0.013l0.101,0.118l-0.101,0.083l-0.065,0.079l-0.133,0.02l-0.034-0.063l-0.368,0.125l0.051,0.028
			l0.182-0.031l0.069,0.057l-2.34,0.374v-0.069l0.252-0.04l0.115-0.121l-0.467,0.076l-0.099,0.183l-1.153,0.186V70.82L76.646,70.334
			z M73.708,81.13l0.066-0.008l0.032-0.058l-0.032,0.005L73.708,81.13z M73.872,80.302v-0.187l-0.083,0.198L73.872,80.302z
			 M73.907,84.579l0.101-0.118l-0.136-0.027l-0.066,0.061L73.907,84.579z M74.125,81.699l0.067-0.078l-0.119,0.022L74.125,81.699z
			 M74.073,83.232l0.052-0.076l-0.052-0.06V83.232z M74.192,84.5l0.251-0.038v-0.066l-0.318,0.049L74.192,84.5z M74.192,83.581
			l0.07-0.012v-0.051L74.192,83.581z M74.443,76.897v-0.184l-0.051-0.061l-0.184,0.282L74.443,76.897z M74.262,78.716l0.13-0.022
			l-0.067-0.056l-0.063,0.012V78.716z M74.493,76.221l0.066-0.012l0.067-0.078L74.493,76.221z M74.694,82.312l0.1-0.015v-0.17
			l-0.1,0.134V82.312z M74.859,85.249l0.133-0.024l-0.064-0.039l-0.068,0.013V85.249z M74.992,76.49l0.051-0.007v-0.05L74.992,76.49
			z M75.11,84.656l0.134-0.02l0.115-0.088l-0.064-0.158l-0.051,0.008v0.12L75.11,84.656z M75.295,81.979l0.064-0.008v-0.134
			l-0.149-0.11L75.295,81.979z M75.245,78.426l0.051-0.009v-0.135l-0.051,0.073V78.426z M76.045,82.511v-0.4l-0.317-0.014
			l-0.151-0.042l-0.15,0.091l0.168,0.02l0.182,0.19v0.069L76.045,82.511z M75.545,76.72v-0.05l-0.067,0.012L75.545,76.72z
			 M75.478,77.282l0.067-0.06v-0.066l-0.067,0.076V77.282z M75.663,77.822v-0.45l-0.118,0.152v0.318L75.663,77.822z M75.729,81.479
			l-0.133-0.083l-0.05,0.01v0.101L75.729,81.479z M75.729,81.227l-0.133-0.079v0.1L75.729,81.227z M75.729,81.979l0.116-0.02
			l0.118-0.084l-0.118-0.215l-0.067,0.009v0.167l-0.049,0.074V81.979z M75.777,76.634l0.067-0.013V76.49l-0.067,0.075V76.634z
			 M75.896,81.451l0.066-0.012v-0.032l-0.066,0.011V81.451z M76.045,73.61l0.118-0.068v-0.05L76.045,73.61z M76.213,76.864
			l0.066-0.01v-0.121l-0.066,0.064V76.864z M76.279,81.958l0.067-0.011v-0.067l-0.067,0.011V81.958z M76.413,75.847l0.052-0.011
			l0.082-0.198l-0.133,0.022V75.847z M76.512,80.866v-0.118l0.069-0.125l-0.168,0.026v0.118L76.512,80.866z M76.464,78.298
			l0.048-0.075v-0.068l-0.048,0.077V78.298z M76.646,84.344l0.121-0.02v-0.053l-0.121,0.022V84.344z M76.813,84.616l0.066-0.058
			v-0.052l-0.066,0.012V84.616z M77.333,84.67l-0.202-0.152V84.7L77.333,84.67z M77.732,85.159l0.067,0.053l-0.101,0.019
			l-0.133-0.045L77.732,85.159z M77.732,83.753l0.135-0.09l-0.168,0.026L77.732,83.753z M77.999,84.498l0.052,0.057l-0.101,0.083
			l-0.15,0.024v-0.133L77.999,84.498z M78.05,84.251l0.133-0.02l-0.133,0.14l-0.052-0.043L78.05,84.251z M78.116,85.029v0.068
			l-0.118,0.02v-0.068L78.116,85.029z M78.184,82.624l0.066-0.01l0.118-0.068l-0.069,0.01L78.184,82.624z M78.482,82.897
			l0.069-0.065l-0.132,0.022L78.482,82.897z M78.419,85.048l0.196-0.216l0.17,0.056l0.285-0.044l0.099-0.219l0.1-0.131l0.085,0.235
			l0.331,0.098l-0.101-0.134v-0.069l-0.113-0.047v-0.066l-0.302-0.135l-0.084-0.156l-0.133,0.156l-0.167-0.126l-0.201,0.032
			l-0.118,0.256l0.084,0.069l0.049-0.143l0.185-0.028v0.066l-0.118,0.139L78.6,84.65l-0.181,0.299V85.048z M78.868,83.183v-0.098
			l-0.148-0.11l-0.237,0.036v0.121L78.868,83.183z M78.719,83.459l0.148-0.141l-0.083-0.051L78.6,83.294v0.068L78.719,83.459z
			 M78.985,82.999l0.051-0.192v-0.2l-0.118,0.018l0.098-0.183l-0.349,0.057v0.252l0.118,0.043L78.985,82.999z M79.218,83.581
			l0.136-0.224l0.117-0.135l-0.117-0.098v-0.303l-0.119,0.021l-0.066,0.247l-0.184,0.094v0.052l0.184-0.031v0.137L79.218,83.581z
			 M79.354,82.438l0.048-0.007l-0.048-0.042l-0.07,0.008L79.354,82.438z M79.584,84.49l0.119-0.014v-0.184l-0.119,0.153V84.49z
			 M79.703,82.816l0.082-0.013v-0.116l-0.133,0.02L79.703,82.816z M80.087,82.94l0.25-0.274l-0.202,0.03l-0.048,0.126L80.02,82.9
			L80.087,82.94z M80.988,84.051l0.369-0.393l0.252-0.158l0.098-0.234l-0.185,0.148l-0.349-0.13l0.083-0.096l0.133-0.02
			l-0.133-0.297l-0.066,0.195l-0.301,0.048l-0.064,0.144l-0.069,0.013v-0.187l-0.116,0.018l-0.083-0.152l-0.153,0.157l0.236,0.182
			v0.25l0.116,0.101l0.248-0.294v-0.116l0.302,0.269v0.052l-0.184-0.021l-0.118,0.02l-0.432,0.47v-0.167l-0.168,0.026l0.135,0.194
			l0.251-0.153L80.988,84.051z M80.755,84.609l0.133-0.022v-0.103l-0.133,0.026V84.609z M81.003,84.266l0.052-0.006v-0.05
			l-0.052,0.005V84.266z M81.055,84.56v-0.031l-0.052,0.005L81.055,84.56z M81.609,84.186l0.266-0.308l-0.136,0.021l-0.13,0.155
			l-0.052,0.005v-0.131l0.118-0.087v-0.051l-0.25,0.042v0.317L81.609,84.186z M81.557,82.822l0.052-0.005v-0.053l-0.052-0.06
			l-0.066,0.078L81.557,82.822z M81.739,83.176l0.069-0.007V83.1l-0.133,0.021L81.739,83.176z M81.875,82.957l0.049-0.06
			l-0.049,0.01V82.957z M81.924,83.501l0.182-0.128l-0.132,0.02l-0.1,0.066L81.924,83.501z M82.29,84.129v-0.07l-0.063,0.013
			L82.29,84.129z M82.475,84.299l0.184-0.347l-0.133-0.11l-0.118,0.018v0.066l0.067,0.058V84.299z M82.659,83.683l0.133-0.018
			v-0.303l-0.198-0.02l-0.068,0.062l0.133,0.11V83.683z M83.144,82.888l-0.053-0.178l-0.063-0.054v-0.301l-0.119,0.018v0.549
			L83.144,82.888z M83.277,82.732v-0.118l-0.067,0.08L83.277,82.732z"/>
		<path class="disabled"  d="M85.61,84.654v-0.119l0.185-0.412l0.066-0.23l0.266-0.56l0.067-0.194l2.305-5.632l0.135-0.086v-0.252l0.6-1.472
			l0.116-0.271l0.82-1.992l0.166-0.108v-0.32l0.333-0.757l0.184-0.114v-0.45l0.653-1.396l0.067-0.078v-0.184l0.314-0.723
			l0.251-0.358v-0.065l-0.2,0.149l0.554-1.248l0.097-0.015L92.709,68v0.4l0.135-0.02l0.349,0.549l0.101,0.418l0.133,0.113
			l1.787,3.603l-0.166,0.363l0.25-0.174l4.541,9.202l-2.337,0.373l-0.183,0.095l-0.805,0.061l-0.181-0.575l0.133-0.27l-0.052-0.063
			l-0.266,0.044l-0.135-0.364l-0.148-0.36l0.133-0.021l0.083-0.198l0.252-0.042l0.332-0.321l0.268-0.046l0.133-0.153v-0.068
			l-0.199,0.035l-0.519,0.332l-0.2,0.034l-0.135-0.096v-0.102l0.303,0.105l-0.168-0.225V80.51l-0.067,0.01l-0.449,0.507L95.23,81.09
			l-0.182-0.154v0.187l-1.303,0.206l-0.069-0.04l-0.25,0.04l-0.133-0.112l-0.186,0.096l-0.332,0.121l-0.084,0.113l-0.103-0.218
			l-0.066,0.012l-0.133,0.254l-0.234-0.18l-0.199,0.151l-0.133,0.022l-0.068,0.057l-2.221,0.357l-0.3,0.516v-0.116l-0.066,0.01
			l-0.069,0.06l0.118,0.233L88.5,84.329l-1.586,0.25l-0.485,0.011l-0.819,0.198l-0.067-0.054L85.61,84.654z M87.164,82.682v-0.233
			l-0.25,0.038v0.152L87.164,82.682z M87.88,80.087l0.168-0.214l-0.168-0.038V80.087z M88.116,80.302l0.1-0.2L88,80.133v0.069
			L88.116,80.302z M88.116,79.799V79.73l-0.05,0.009L88.116,79.799z M88.065,84.014l0.05-0.01v-0.066l-0.05,0.005V84.014z
			 M88.116,83.351l0.133-0.021v-0.136l-0.066-0.056l-0.067,0.079V83.351z M88.316,82.933v-0.201l-0.133,0.02v0.201L88.316,82.933z
			 M88.249,80.347l0.317-0.052v-0.386l0.335-0.052v-0.184l-0.199,0.113v-0.083l0.098-0.116l-0.098-0.234l-0.252,0.24v0.437
			L88.249,80.347z M88.45,79.277l0.05-0.145v-0.164l0.401-0.201v-0.086l-0.199,0.034L88.6,78.547l0.301-0.048l0.135,0.097
			l0.098-0.019l0.101-0.2l0.185-0.246v-0.069l-0.119,0.022L89.1,78.333v-0.218l-0.064,0.012l-0.269,0.324l-0.132-0.111l-0.135,0.02
			l-0.151,0.259l0.184,0.072L88.45,78.89V79.277z M88.566,78.085v-0.07l-0.116-0.112v0.2L88.566,78.085z M89.686,81.205l0.049-0.056
			v-0.135l-0.251-0.027v-0.064l0.3-0.2l-0.216-0.202l0.502-0.262l0.118-0.372l0.213-0.135l0.07-0.146l-0.2,0.033l-0.15,0.092
			l-0.317,0.046l-0.068-0.052l-0.049,0.14l-0.136,0.09l0.07,0.038l0.351-0.056l-0.101,0.219v0.05l-0.134,0.021l-0.315-0.136
			l-0.069,0.145l-0.182,0.081l-0.151-0.111l0.333-0.17v-0.049l-0.182-0.107l-0.285,0.047l0.084,0.17l-0.067,0.08l-0.266,0.041v0.252
			l0.067,0.04l0.183-0.096l0.084,0.052l0.452-0.07v0.335l-0.219,0.032l0.1,0.186l0.05,0.194l0.199,0.036L89.686,81.205z
			 M88.849,82.511v-0.118l-0.147,0.026v0.119L88.849,82.511z M88.849,77.455v-0.07l-0.083,0.014L88.849,77.455z M88.968,79.443
			L89.1,79.17l0.201-0.098l-0.167-0.206l0.217,0.066l0.384-0.063v0.149l0.268-0.126l0.084-0.096l0.184,0.053v-0.067l-0.368-0.309
			l0.217-0.12v-0.117l-0.118-0.048l-0.067-0.057l-0.132,0.021l0.1,0.152l-0.217,0.253l-0.066,0.146l-0.136-0.114l-0.064,0.012v0.132
			l-0.352,0.056l-0.1,0.202l-0.202,0.097l0.083,0.056l0.052,0.241L88.968,79.443z M89.036,79.769l0.133-0.02l0.066-0.079l0.5-0.082
			l0.47-0.306V79.18l-0.27,0.042l-0.333,0.238l-0.151-0.128l-0.15,0.21l-0.265,0.04V79.769z M89.1,77.513l0.418-0.282l-0.283-0.093
			v0.119l-0.135,0.09V77.513z M89.169,82.127l0.182-0.03l0.133-0.207l-0.133,0.024L89.169,82.127z M89.235,79.266l0.066-0.01v-0.05
			l-0.066,0.01V79.266z M89.301,75.823l0.05-0.009v-0.135l-0.05,0.074V75.823z M89.351,76.265l0.069-0.009l0.266-0.298l-0.202,0.035
			L89.351,76.265z M89.55,81.581v-0.22l-0.115-0.098l-0.084,0.261L89.55,81.581z M89.484,76.897l0.066-0.01v-0.066l-0.13,0.02
			L89.484,76.897z M89.484,76.63l0.066-0.014v-0.063l-0.066,0.008V76.63z M89.55,77.725l0.07-0.012l-0.07-0.056V77.725z
			 M89.686,81.475l0.118-0.018v-0.134l-0.118,0.018V81.475z M89.87,75.025l0.066-0.012l0.067-0.077l-0.133,0.022V75.025z
			 M89.87,75.278l0.066-0.012v-0.067l-0.066,0.013V75.278z M90.003,75.774l0.067-0.01l-0.067-0.057l-0.133,0.021L90.003,75.774z
			 M89.87,76.935l0.201-0.131l-0.067-0.056l-0.133,0.087V76.935z M89.971,81.915l0.617-0.248v-0.154l-0.187,0.029l-0.13,0.157
			l-0.201,0.1L89.971,81.915z M90.003,81.359l0.268-0.046v-0.2l0.2-0.151V80.83l-0.134,0.02l-0.183-0.069l-0.151,0.191l0.067,0.055
			l0.084,0.24L90.003,81.359z M90.121,78.019l0.216-0.102v-0.135l-0.302,0.148L90.121,78.019z M90.271,77.608l0.2-0.03l-0.134-0.164
			v-0.066l-0.066-0.056l-0.201,0.166v0.119l0.135-0.072L90.271,77.608z M90.654,80.803l0.318-0.253l-0.118-0.117l-0.133,0.02v0.201
			l-0.067,0.011l-0.082-0.252l-0.452,0.072v0.064l0.281,0.09L90.654,80.803z M90.337,78.321v-0.121l-0.066,0.012v0.069
			L90.337,78.321z M90.337,80.247l0.064-0.011l0.087-0.25l-0.151,0.025V80.247z M90.337,81.438l0.185-0.03v-0.204l-0.084,0.016
			L90.337,81.438z M90.401,77.136l0.121-0.019l-0.121-0.047V77.136z M90.972,79.592l0.133-0.156v-0.117l-0.067-0.055l0.135-0.106
			l0.583-0.092l-0.066,0.092l-0.051,0.126l0.15-0.108l0.168,0.056l0.115-0.118l-0.184-0.071l2.122-0.338l0.468-0.141l-0.733-1.83
			v-0.201l-0.119-0.098l-0.452-1.067v-0.302l-0.131-0.18l-0.184-0.286l0.117-0.138l-0.199-0.154l-0.219-0.683l-0.6,1.704
			l-0.133,0.022l-0.068,0.076l0.152,0.062l-0.82,2.31l-0.184,0.03v0.065l0.067,0.075v0.132l-0.251-0.176v0.334l0.15,0.045
			l-0.184,0.566l-0.216,0.335l0.051,0.06l0.066-0.015l0.133,0.064l0.251,0.044V79.592z M90.588,80.159l0.066-0.013l0.067-0.078
			l-0.067,0.013L90.588,80.159z M90.654,77.094l0.2-0.03l-0.067-0.172v-0.068l-0.133,0.021V77.094z M90.654,77.867l0.067-0.06
			v-0.066l-0.067,0.074V77.867z M90.721,72.877l0.066-0.013l0.118-0.15l-0.184,0.028V72.877z M90.787,77.592l0.118-0.086v-0.064
			L90.787,77.592z M90.905,76.804l0.133-0.157l-0.133,0.022V76.804z M90.972,81.136l0.066-0.012l-0.066-0.056V81.136z
			 M91.105,72.278l0.135-0.021v-0.25l-0.067,0.012l-0.067,0.144l-0.067,0.063L91.105,72.278z M91.42,71.841l0.154-0.142l0.064-0.142
			l0.117-0.152l-0.117,0.019l-0.285,0.314L91.42,71.841z M91.673,75.793l-0.098-0.271l-0.067,0.148l-0.153,0.074L91.673,75.793z
			 M91.42,73.286l0.087-0.014l0.067-0.146l-0.154,0.024V73.286z M91.639,80.895l0.117-0.019v-0.05l-0.066-0.059l0.134-0.085
			l-0.185-0.24l0.051-0.076l0.268-0.045v-0.13l-0.383,0.061L91.42,80.41v0.232L91.639,80.895z M91.639,75.312l0.117-0.068v-0.068
			l-0.249,0.042L91.639,75.312z M91.639,74.993l0.051-0.005v-0.068l-0.051,0.008V74.993z M91.69,73.042l0.066-0.013v-0.063
			L91.69,73.042z M91.756,72.108l0.068-0.011v-0.049L91.756,72.108z M91.756,79.719l0.133-0.086l-0.133-0.097V79.719z
			 M92.023,80.832l0.049-0.058l-0.115,0.019L92.023,80.832z M92.475,80.577l0.101-0.252l-0.168,0.126l-0.201-0.166l-0.217,0.033
			l0.103,0.218L92.475,80.577z M92.14,70.874l0.067-0.011l-0.067-0.038l-0.067,0.009L92.14,70.874z M92.14,79.588l0.135-0.02v-0.118
			l-0.135,0.022V79.588z M92.207,81.256l0.201-0.034l-0.067-0.056l-0.133,0.02V81.256z M92.408,71.299l0.067-0.012v-0.064
			L92.408,71.299z M92.475,80.242l0.184-0.03v-0.135l-0.184,0.03V80.242z M92.709,69.708l-0.05-0.124l-0.069,0.012v0.135
			L92.709,69.708z M92.659,79.389v-0.066l-0.069-0.056v0.068L92.659,79.389z M92.659,80.864l0.05-0.005V80.79L92.659,80.864z
			 M92.709,71.454l0.135-0.022l-0.067-0.056l-0.067,0.012V71.454z M92.776,71.692v-0.066l-0.067,0.012L92.776,71.692z
			 M93.009,70.917l0.099-0.13l0.186-0.151v-0.132l0.199-0.168l-0.134-0.162l-0.064,0.01l-0.084,0.299l-0.301,0.337L93.009,70.917z
			 M93.043,69.854l0.131-0.021l0.067-0.078l-0.067-0.054L93.043,69.854z M93.108,71.387l0.186-0.029v-0.066l-0.12,0.018
			L93.108,71.387z M93.174,71.947l0.067-0.009l-0.067-0.056l-0.066,0.008L93.174,71.947z M93.242,74.855l0.052-0.008v-0.051
			L93.242,74.855z M93.358,70.04v-0.05l-0.064,0.013L93.358,70.04z M93.493,74.697v-0.185l-0.066,0.011l-0.133,0.139L93.493,74.697z
			 M93.444,71.636l0.167-0.195l-0.303-0.033L93.444,71.636z M93.358,69.872l0.068-0.012v-0.064L93.358,69.872z M93.358,75.038
			l0.134-0.024v-0.048l-0.134,0.022V75.038z M93.427,70.615l0.25-0.039v-0.066l-0.184,0.026L93.427,70.615z M93.559,75.843
			l0.067-0.012v-0.117l-0.199,0.033L93.559,75.843z M93.676,75.37l0.202-0.03l0.115-0.12l-0.248-0.444v0.2l0.066,0.122v0.135
			L93.676,75.37z M93.745,76.283l0.066-0.013v-0.066l-0.066,0.01V76.283z M93.811,79.072l0.067-0.077v-0.067l-0.067,0.011
			l-0.066,0.076L93.811,79.072z M93.878,70.947l0.066-0.012l-0.066-0.056V70.947z M94.345,75.918l0.118-0.017l-0.118-0.051V75.918z
			 M94.731,73.14l0.064-0.012l-0.064-0.053V73.14z M94.731,76.325l0.064-0.01v-0.067l-0.064,0.012V76.325z M94.844,74.799
			l0.069-0.011v-0.053l-0.069,0.012V74.799z M95.048,73.942l0.133-0.02v-0.066l-0.133,0.021V73.942z M95.297,77.007v-0.137
			l-0.25,0.043l0.067,0.055L95.297,77.007z M95.048,77.232l0.067-0.012v-0.066l-0.067,0.013V77.232z M95.181,76.573l0.25-0.042
			v-0.132l-0.066,0.01l-0.184-0.072V76.573z M95.297,75.38l0.067-0.011l-0.067-0.058V75.38z M95.365,80.754l0.066-0.012
			l-0.066-0.058V80.754z M95.513,74.756l0.069-0.009v-0.068L95.513,74.756z M95.899,81.054l-0.066,0.009l0.066-0.079V81.054z
			 M95.966,80.403l0.115-0.151l0.135-0.022v-0.117l-0.366,0.192L95.966,80.403z M95.966,80.087l0.25-0.178l-0.067-0.052
			l-0.135,0.086l-0.115,0.02v0.066L95.966,80.087z M96.399,81.811l0.067-0.178l-0.052,0.006l-0.098,0.102l0.098-0.367l-0.081,0.01
			l-0.217,0.337L96.399,81.811z M96.384,78.946l0.083-0.098l-0.083-0.086l-0.102,0.117L96.384,78.946z M96.282,79.365l0.251-0.042
			v-0.066l-0.118,0.021L96.282,79.365z M96.415,80.717l0.187-0.029v-0.132l-0.187,0.028V80.717z M96.467,77.861l0.134-0.157
			l-0.134,0.021V77.861z M96.533,80.313l0.133-0.021v-0.07l-0.064,0.013L96.533,80.313z M96.666,78.212l0.268-0.042v-0.136
			l-0.369,0.01L96.666,78.212z M96.601,79.648l0.064-0.01V79.57l-0.064,0.012V79.648z M96.733,81.389l0.083-0.012v-0.071
			l-0.083,0.017V81.389z M97.067,80.379v-0.152l-0.199,0.032l-0.052,0.074L97.067,80.379z M96.934,77.598l0.067-0.008v-0.068
			l-0.067,0.012V77.598z M97.001,79.451l0.251-0.106l0.084-0.249l-0.269-0.157v0.184l0.168,0.04L97.001,79.451z M97.252,82.146
			l0.067-0.012l-0.067-0.058V82.146z M97.449,81.794l-0.064-0.125l-0.066,0.011v0.137L97.449,81.794z M97.687,82.412l0.064-0.078
			l-0.064,0.01V82.412z M99.237,82.363l0.068-0.008l0.067-0.078l-0.136,0.02V82.363z"/>
		<path class="disabled"  d="M105.475,81.523l-0.17,0.06l-0.032-0.03l0.067-0.078l-0.101-0.066v-0.251l0.051-0.078v-0.234l-0.017-0.03V80.73
			l0.017-0.018l0.05,0.023l0.084-0.146l0.051-0.006l0.047,0.023l0.086-0.011v-0.053l-0.086-0.104l-0.115,0.019l-0.032,0.087
			l-0.035,0.008l-0.035-0.03v-0.066l0.103-0.035l-0.032-0.127l-0.053,0.01l-0.049,0.074l-0.034-0.046l0.034-0.106v-0.572
			l-0.034-0.079v-0.218l0.034-0.071l-0.034-0.13l0.034-0.104l0.067-0.18v-0.099l-0.101-0.103l0.034-0.393l-0.034-0.096l0.034-0.022
			l0.067-0.026l0.118-0.12l0.032-0.006l0.032,0.064l0.052-0.01l0.081-0.062v-0.034l-0.067-0.075l0.185-0.18v-0.05l-0.049-0.042
			l-0.101,0.067l-0.101,0.031l-0.047,0.092l-0.067,0.081l-0.049,0.008l0.049-0.209l0.032-0.141l0.1-0.15l0.116-0.068l0.234,0.012
			l0.084-0.048v-0.098l-0.166-0.01v-0.214l-0.05,0.006l-0.103,0.063l-0.067-0.007l-0.014-0.027l-0.066,0.012v0.085l0.047,0.024
			v0.016l-0.047,0.006l-0.084-0.002l-0.049,0.007v0.052l0.014,0.03v0.066l-0.014,0.037l-0.053-0.006v0.214l-0.083,0.016v-0.167
			l0.051-0.074l-0.051-0.044V76.86l0.168-0.026l0.017-0.055v-0.135l-0.084,0.013l-0.035,0.038l-0.066,0.012l-0.08-0.287
			l-0.101-0.187v-0.169l0.014-0.103l-0.014-0.029l-0.17,0.01l-0.081-0.156v-0.098l0.098-0.018v-0.052l-0.115-0.114l-0.018-0.13
			l-0.049-0.061l-0.118,0.106l-0.052,0.006l-0.081-0.086l-0.032-0.162l-0.119-0.117v-0.066l0.017-0.054l-0.084-0.09l-0.066-0.037
			l-0.3-0.458l-0.05-0.127v-0.082l0.018-0.004l0.063,0.073l0.034-0.037v-0.103l-0.083-0.02l-0.083-0.037l-0.133-0.03l-0.083-0.154
			v-0.068l0.117-0.016l0.047,0.022l0.035,0.03l0.085,0.053l0.014-0.02v-0.052l-0.032-0.058v-0.083l0.081-0.016l0.052,0.042
			l0.067-0.142l0.052-0.076l0.066,0.057l0.13-0.023l-0.066-0.089v-0.098l-0.166,0.007l-0.067-0.058h-0.1l-0.032-0.076l-0.085,0.062
			l-0.066,0.026L103.67,73.3v0.068l0.034,0.046v0.116l-0.067,0.078l-0.066,0.011l-0.154-0.045l-0.098-0.134v-0.135l-0.132-0.114
			l-0.035-0.078l-0.117-0.148l-0.05-0.143l-0.064-0.073l-0.018-0.03l-0.201-0.339l-0.05-0.092l-0.067-0.072l-0.183-0.34
			l-0.033-0.145l-0.084-0.021l-0.15-0.229l-0.017-0.046l-0.135-0.212l-0.116-0.252l-0.083-0.085l-0.034-0.079l-0.1-0.12l-0.084-0.22
			l-0.135-0.13l-0.032-0.162l-0.081-0.053l-0.889-1.471l-0.015-0.112l-0.067-0.042l-0.45-0.749l-0.052-0.109l-0.05-0.061
			l-0.031-0.06l-0.018-0.08l-0.064-0.126l0.064-0.074v-0.17l0.049-0.161v-0.116l-0.049-0.042l-0.081,0.062l-0.066,0.096l0.031,0.079
			l0.018,0.149l0.017,0.03v0.117l-0.103-0.084l-0.282-0.491l3.522-0.565l0.084,0.153l0.1,0.134l0.617,1.08l0.052,0.122l0.081,0.07
			l0.369,0.629v0.084l-0.066,0.198l0.017,0.029l0.066-0.012l0.1-0.1l0.084,0.106l0.435,0.783l0.069,0.16l0.081,0.086l-0.068,0.178
			l0.068,0.058l0.15-0.008l0.05,0.11v0.083l-0.031,0.006l-0.052-0.01l-0.035,0.021v0.065l0.05,0.045l0.138-0.024l0.08,0.104
			l1.187,2.363l0.098,0.234l0.033,0.064l0.303,0.673l0.032-0.021l0.034-0.006l-0.052,0.108l0.037,0.03l0.116-0.021l0.117-0.086
			v-0.066l-0.133-0.062v-0.068l0.066-0.179l-0.032-0.096l0.182-0.464l0.018-0.02l0.067-0.181l0.149-0.358l0.066-0.078l0.053-0.243
			l1.101-2.511l0.135-0.154v-0.136l0.865-1.853l0.051-0.11l1.07-2.204l0.704-0.112l0.016,0.032l0.032-0.006l0.035-0.037l2.44-0.393
			v0.049l-5.196,10.593l-0.032,0.072l-0.369,0.75l-0.133,0.051l-0.1,0.103v0.066l0.149,0.01l0.084,0.07v0.888l-0.1,0.169l0.05,0.027
			v0.065l-0.035,0.038l-0.098-0.033l-0.017-0.114l-0.05-0.042l-0.019,0.022v0.098l-0.033,0.073v0.099l0.102-0.015l0.049-0.042
			l0.017,0.016v0.232l-0.083,0.114l0.05,0.026l0.082-0.011l0.017-0.071l0.05,0.026V78l-0.05,0.003l-0.083-0.036l-0.151,0.075
			l0.052,0.111l-0.034,0.073l-0.118,0.102v0.05l0.067,0.04l0.118-0.052l0.083-0.081l0.049-0.176l0.035-0.074l0.049,0.043v0.219
			l-0.049,0.073l0.032,0.096v0.237l0.017,0.045v0.2l-0.166,0.03l-0.034-0.045v-0.037l0.1-0.066l0.05-0.14l-0.05-0.026l-0.083,0.045
			l-0.067,0.13l-0.167,0.028l-0.034,0.086l0.049,0.111l0.067,0.038l0.084,0.072l0.1-0.013l0.083-0.049l0.067,0.025v0.097
			l-0.049,0.042l-0.101,0.016l-0.032,0.039v0.05l0.165-0.026v0.12l-0.067,0.076l-0.082,0.012l-0.084-0.104l-0.084,0.016
			l-0.049,0.074v0.232l-0.052,0.063v0.102l0.018,0.112l-0.034,0.188l0.034,0.032l0.133-0.056l0.05-0.092l-0.101-0.152v-0.15
			l0.201-0.135l0.049-0.041l0.052-0.006l0.032,0.026l-0.032,0.089l0.032,0.079v0.118l-0.017,0.052v0.102l0.017,0.03v0.252
			l-0.084,0.064l-0.115,0.137l-0.102,0.05l0.018,0.03l0.034-0.006l0.017,0.2l0.083-0.014l0.05-0.042l0.016-0.154v-0.134l0.035-0.039
			l0.049,0.043v0.404l-0.017,0.086v0.098l-0.182-0.086l-0.05,0.01l-0.034,0.122l-0.069,0.043l-1.05,0.167l-0.066-0.074l-0.217,0.037
			l-0.034,0.055l-0.284,0.045l-0.051-0.01l-0.116,0.018l-0.118,0.072l-0.485,0.078L105.475,81.523z M100.097,67.412l0.05-0.007
			v-0.067l-0.05,0.009l-0.032,0.055L100.097,67.412z M100.38,67.587l0.049-0.01l0.051-0.074l-0.051-0.042l-0.049,0.042V67.587z
			 M100.948,68.736l0.05-0.005l0.034-0.041l-0.05-0.042l-0.034,0.001V68.736z M101.096,68.512l0.153-0.023v-0.085l-0.153,0.021
			l-0.046,0.077L101.096,68.512z M101.249,69.51l0.049-0.008l0.084-0.063l0.081-0.016l0.103,0.019v-0.05l-0.034-0.027l-0.133,0.021
			l-0.05,0.042l-0.135,0.02L101.249,69.51z M101.349,68.186l0.05-0.01v-0.084l-0.068-0.056l-0.064,0.062v0.083L101.349,68.186z
			 M101.583,66.839l0.067-0.008v-0.039l-0.067-0.02l-0.017-0.047l-0.069-0.042l-0.034,0.005v0.103l0.034,0.025L101.583,66.839z
			 M101.566,68.418v-0.05l-0.034-0.028l-0.069,0.01v0.083L101.566,68.418z M101.497,70.058l0.035-0.006l0.051-0.074V69.96
			l-0.032,0.006l-0.054,0.042V70.058z M101.783,68.955l0.051-0.01l0.017-0.016l-0.017-0.033l-0.051,0.006l-0.018,0.04
			L101.783,68.955z M101.935,70.224l0.048-0.01v-0.052l-0.048,0.01V70.224z M102.167,69.932l0.034-0.038l-0.034-0.061l-0.084,0.013
			v0.066L102.167,69.932z M102.235,70.71l-0.019,0.002L102.235,70.71z M102.301,70.615l0.052-0.039l0.049-0.094l-0.049-0.041
			l-0.084,0.063v0.1L102.301,70.615z M102.353,70.204l0.016-0.018l-0.016,0.004V70.204z M102.434,68.11l0.084-0.013v-0.084
			l-0.067-0.024l-0.034,0.059v0.031L102.434,68.11z M102.434,68.398l0.084-0.017V68.35l-0.084,0.015V68.398z M102.518,69.222
			l0.066-0.095l-0.1-0.037l-0.05,0.063v0.051L102.518,69.222z M102.451,69.685l0.067-0.009v-0.052l-0.067,0.011V69.685z
			 M102.619,68.249l0.066-0.01v-0.051l-0.066,0.012l-0.017,0.037L102.619,68.249z M102.619,69.423l0.098-0.015v-0.05l-0.066,0.009
			l-0.032,0.041V69.423z M102.685,70.923v-0.066l-0.066,0.011v0.068L102.685,70.923z M102.818,70.734l0.053-0.024v-0.068
			l-0.07,0.012l-0.017,0.052L102.818,70.734z M102.818,69.476h0.017l0.036-0.024l-0.053,0.008V69.476z M102.92,69.259l0.014-0.02
			l-0.014-0.03l-0.035,0.006v0.032L102.92,69.259z M103.17,69.622v-0.05l-0.103-0.067v0.032l0.019,0.064L103.17,69.622z
			 M103.086,72.321l0.034-0.006v-0.186l-0.052,0.01v0.15L103.086,72.321z M103.204,71.494v-0.099L103.17,71.4l-0.05,0.041v0.07
			L103.204,71.494z M103.386,69.804l0.017-0.002l0.084-0.082v-0.148l0.167-0.213l0.034-0.089v-0.066l-0.086,0.08l-0.099,0.067
			l-0.049,0.107l-0.05,0.059l-0.017,0.069l-0.032,0.057l-0.15,0.023v0.137l0.15-0.025L103.386,69.804z M103.27,68.264l0.018-0.022
			v-0.016l-0.036,0.006v0.016L103.27,68.264z M103.334,67.562l0.052-0.022v-0.084l-0.052-0.023l-0.064,0.059v0.064L103.334,67.562z
			 M103.302,70.856l0.017-0.001V70.84l-0.031,0.005L103.302,70.856z M103.487,68.528v-0.084l-0.084,0.016v0.084L103.487,68.528z
			 M103.487,68.38l0.084-0.016v-0.066l-0.035-0.029l-0.049,0.026V68.38z M103.602,73.159l0.086-0.011l0.032-0.026l-0.049-0.04
			l-0.034,0.006l-0.05,0.06L103.602,73.159z M103.87,69.121V69.04l-0.049-0.011l-0.085,0.114L103.87,69.121z M103.837,71.528
			l0.05-0.008l0.1-0.066l-0.15,0.022V71.528z M103.903,71.315l0.067-0.042l0.084-0.066v-0.052l-0.067,0.012l-0.05,0.058
			l-0.082,0.067L103.903,71.315z M103.918,71.934v-0.032l-0.063,0.008v0.034L103.918,71.934z M104.02,70.725v-0.082l-0.067,0.012
			l-0.034,0.089L104.02,70.725z M103.971,73.017l0.049-0.039v-0.053l-0.049,0.008V73.017z M104.038,73.208l0.083-0.064V73.08
			l-0.066,0.008l-0.052,0.06L104.038,73.208z M104.136,70.892l0.035-0.037l-0.05-0.13l-0.031,0.006L104.136,70.892z M104.321,73.883
			v-0.066l-0.101,0.017V73.9L104.321,73.883z M104.338,74.2l0.118-0.169l0.082-0.045v-0.087l-0.013-0.014l-0.254,0.226l-0.05,0.106
			L104.338,74.2z M104.321,74.723l0.049-0.008l0.037-0.04v-0.082l0.049-0.076l0.233-0.037l0.035,0.047l0.049-0.01l0.082-0.114
			l-0.063-0.122l-0.084,0.013l-0.085,0.012l-0.233,0.038l-0.032,0.24l-0.085,0.098L104.321,74.723z M104.338,71.55l0.05-0.01v-0.053
			l-0.05,0.01l-0.034,0.022L104.338,71.55z M104.524,73.836l0.13-0.056v-0.051l-0.067-0.09v-0.151l0.034-0.054l0.103-0.018v0.203
			l0.049,0.025l0.15-0.025l0.084-0.081l0.083-0.063l0.05-0.144l0.1-0.08v-0.086l-0.049-0.076v-0.134l-0.132,0.022l-0.069,0.195
			l-0.116,0.018l-0.053-0.026v-0.183l-0.048,0.005l-0.049,0.028l-0.035,0.072l0.084,0.104v0.134l-0.118-0.032l-0.101,0.015
			l-0.047,0.06l-0.051,0.16l-0.085,0.062l-0.014,0.104l0.032,0.078L104.524,73.836z M104.524,70.226v-0.084l-0.084,0.012v0.088
			L104.524,70.226z M104.488,75.082l0.049-0.008l0.084-0.045v-0.069l-0.034-0.026l-0.05,0.006l-0.097,0.103L104.488,75.082z
			 M104.506,74.843h0.018v-0.05l-0.018,0.018V74.843z M104.621,74.104l0.103-0.05l0.182-0.064l0.101-0.08v-0.103l-0.035-0.027
			l-0.118,0.103l-0.13,0.022l-0.136,0.072v0.116L104.621,74.104z M104.791,75.049l0.049-0.005l0.115-0.087l0.084-0.011l0.084-0.099
			l0.15-0.16l0.032,0.079l-0.098,0.133l0.032,0.046l0.168-0.026l0.067-0.062l-0.051-0.091l-0.017-0.081l-0.032-0.08v-0.15
			l0.032-0.125v-0.083l-0.168,0.027l-0.116,0.05l-0.034-0.097l-0.067,0.015v0.1l0.037-0.006l0.031,0.097l0.082,0.018v0.154
			l-0.112,0.15l-0.136,0.021l-0.017-0.146l-0.085,0.012l-0.03,0.056v0.034l0.049,0.06v0.032l-0.116,0.05v0.137L104.791,75.049z
			 M104.922,75.316v-0.083l-0.083,0.012v0.083L104.922,75.316z M104.889,73.39l0.017-0.086l0.084-0.012v0.063l-0.052,0.126
			l-0.049,0.01l-0.035-0.028L104.889,73.39z M104.972,74.251l0.05-0.128v-0.084l-0.067,0.012l-0.066,0.16L104.972,74.251z
			 M105.007,72.097l0.015-0.002v-0.07l-0.032-0.026l-0.084,0.013L105.007,72.097z M104.99,72.77l0.017-0.002v-0.015h-0.017V72.77z
			 M105.007,72.599l0.015-0.003v-0.019l-0.015,0.004V72.599z M105.106,70.519l0.064-0.044l-0.048-0.094l-0.034,0.006l-0.05,0.076
			l0.02,0.03L105.106,70.519z M105.16,75.394l0.063-0.093l0.05-0.041l0.017-0.022l-0.051-0.042l-0.15,0.024v0.15L105.16,75.394z
			 M105.223,75.938l0.1-0.032l0.053-0.042v-0.051l-0.017-0.031l-0.235,0.071v0.049L105.223,75.938z M105.223,71.776v-0.103
			l-0.063,0.012v0.101L105.223,71.776z M105.19,74.166l0.032-0.056v-0.018l-0.032,0.002V74.166z M105.39,74.048l0.133-0.056
			l0.066-0.109l-0.049-0.128l-0.064-0.02l-0.1,0.115l-0.035,0.02l-0.067,0.096v0.085L105.39,74.048z M105.39,72.471l0.035-0.022
			l-0.035-0.096l-0.049,0.006v0.12L105.39,72.471z M105.408,73.426v-0.101l-0.067,0.011v0.099L105.408,73.426z M105.49,75.558
			l0.118-0.082v-0.038l-0.086-0.086l-0.047-0.14l-0.117,0.084l0.049,0.142v0.136L105.49,75.558z M105.375,72.841l0.083-0.012v-0.082
			l-0.068-0.006L105.375,72.841z M105.624,75.876l0.135-0.108l-0.049-0.092l-0.068,0.012l-0.118,0.1l-0.098,0.021v0.032
			L105.624,75.876z M105.475,81.286l0.034-0.038l-0.051-0.094l-0.034,0.073L105.475,81.286z M105.475,79.641l0.081-0.012
			l0.133-0.207v-0.083l-0.081-0.072l-0.133,0.143l-0.035,0.207L105.475,79.641z M105.509,79.216l0.047-0.006v-0.084l-0.066,0.009
			l-0.032,0.023v0.034L105.509,79.216z M105.458,80.986l0.051-0.008v-0.083l-0.051,0.009V80.986z M106.193,78.857l0.066-0.13
			l0.083-0.066l0.119,0.066l0.082,0.072l0.084-0.065v-0.15l-0.166-0.038l-0.068,0.042l-0.017,0.055l-0.05,0.007l-0.15-0.091
			l-0.13,0.001l-0.07-0.006l-0.166,0.028l-0.066,0.061l-0.069,0.011l-0.099-0.036l-0.084,0.064v0.086l0.066,0.039l0.067-0.012
			l0.066-0.027l0.32-0.052l0.116,0.098L106.193,78.857z M105.656,80.033l0.034-0.04v-0.034l-0.101-0.016v-0.052l0.035-0.056
			l0.085-0.047l0.049-0.04l-0.049-0.06l-0.121,0.018l-0.066,0.095l-0.032,0.039v0.084l0.066,0.023l0.052,0.093L105.656,80.033z
			 M106.375,74.932l0.051-0.058v-0.167l0.098-0.051l0.018-0.086l0.118-0.038l0.034-0.038l-0.067-0.123l-0.116,0.018l-0.084,0.067
			l-0.101,0.048l-0.066,0.16l-0.184-0.07l-0.302,0.014l-0.1-0.052l-0.05-0.04l-0.067,0.012l-0.034,0.035l0.052,0.112v0.134
			l0.034,0.044l0.065-0.008l0.035-0.055l0.149-0.027l0.084-0.028l0.151-0.059l0.132,0.028l0.116,0.234L106.375,74.932z
			 M106.275,81.311l0.1-0.051v-0.1l-0.083,0.012l-0.067-0.09l-0.132,0.003l-0.049-0.058l-0.103-0.036l-0.034-0.058l-0.118-0.137
			v-0.149l0.118-0.052l-0.084-0.086l0.049-0.108v-0.035l-0.083,0.013l-0.135-0.078l-0.067,0.01l-0.049,0.06l0.035,0.044h0.099
			l0.035,0.026v0.185l-0.153,0.159v0.066l0.118-0.019l0.035,0.03v0.084l-0.085,0.096v0.033l0.066,0.04l0.201-0.012l0.268,0.159
			L106.275,81.311z M105.809,76.433l0.082-0.132v-0.067l-0.181-0.04l-0.02,0.005v0.051l-0.034,0.071l-0.081,0.048v0.051l0.115-0.003
			L105.809,76.433z M105.624,73.426l0.066-0.064l0.069-0.043v-0.066l-0.084-0.022l-0.085,0.048v0.119L105.624,73.426z
			 M105.588,77.172l0.101-0.017l0.069,0.022l0.015,0.048l-0.064,0.044l-0.085,0.014l-0.035-0.043V77.172z M105.656,72.229
			l0.053-0.06v-0.085l-0.035,0.004l-0.05,0.041v0.069L105.656,72.229z M105.709,73.646l0.034-0.006l0.016-0.053l-0.049-0.042
			l-0.035,0.021v0.052L105.709,73.646z M105.743,75.284l0.048-0.006v-0.116l-0.101,0.014v0.066L105.743,75.284z M105.709,81.485
			l0.149-0.024l0.032-0.058l-0.017-0.08l-0.115,0.02l-0.069,0.078L105.709,81.485z M105.743,74.427l0.097-0.014l0.019-0.152
			l0.05-0.107l-0.05-0.046l-0.149,0.059v0.235L105.743,74.427z M105.709,76.599l0.064-0.012v-0.046l-0.064,0.008V76.599z
			 M105.839,78.355l0.051-0.056v-0.082l-0.032-0.03l-0.049-0.125l-0.066,0.011l-0.034,0.039v0.048l0.1,0.053v0.101L105.839,78.355z
			 M105.773,79.108l0.035-0.024v-0.167l-0.05,0.009L105.709,79v0.117L105.773,79.108z M106.044,73.105l0.097-0.016l0.084-0.08
			l0.116,0.014l0.084-0.014v-0.084l-0.285,0.03l-0.097-0.018l-0.086,0.079l-0.185-0.052l-0.049,0.057l0.049,0.092l0.168-0.026
			L106.044,73.105z M105.824,80.276l0.034-0.123l0.032-0.076v-0.032l-0.032-0.012l-0.049,0.042v0.102l-0.018,0.069L105.824,80.276z
			 M105.942,79.653l0.032-0.006v-0.102l-0.084,0.097L105.942,79.653z M105.958,75.734l0.067-0.008l0.019-0.054l-0.035-0.046
			l-0.051,0.01l-0.05,0.058v0.034L105.958,75.734z M106.225,77.861l0.05-0.011l0.084-0.062l0.083-0.048v-0.084l-0.05-0.025
			l-0.067,0.043l-0.215,0.036l-0.065-0.006l-0.136,0.021v0.018l0.083,0.005l0.067,0.055l0.135-0.005L106.225,77.861z
			 M106.009,75.292l0.315-0.05l0.05-0.06l-0.134-0.027l-0.115-0.05l-0.151,0.027v0.097l0.07,0.006l-0.035,0.038V75.292z
			 M105.974,77.06l0.035-0.006v-0.069l-0.035,0.006V77.06z M106.026,71.965l-0.035-0.093v0.066L106.026,71.965z M106.175,79.294
			l0.066-0.078v-0.185l-0.066,0.011l-0.034,0.04l-0.016,0.118l-0.032,0.024l-0.018-0.148l-0.031-0.028l-0.035,0.005v0.132
			l0.049,0.059l0.052,0.078L106.175,79.294z M106.009,79.506l0.035-0.006l0.049-0.058l-0.035-0.045l-0.049,0.024V79.506z
			 M106.11,78.181l0.031-0.04l-0.048-0.042l-0.049,0.01v0.05L106.11,78.181z M106.225,77.123l0.034-0.006v-0.118l-0.084-0.068
			l-0.1,0.013v0.102L106.225,77.123z M106.36,80.574l0.032-0.054l-0.117-0.148l-0.134,0.021l-0.066,0.078v0.102l0.184-0.015
			L106.36,80.574z M106.241,76.313l0.084-0.015l0.05-0.07l-0.1-0.121l0.135-0.156l-0.035-0.03l-0.116,0.068l-0.133-0.027v0.048
			l0.049,0.029l-0.082,0.145l0.048,0.061L106.241,76.313z M106.175,76.711l0.118-0.021v-0.05l-0.034-0.061l0.034-0.089l-0.1-0.038
			l-0.1,0.018v0.085l0.048,0.109L106.175,76.711z M106.259,72.835l0.066-0.076v-0.052l-0.066-0.04l-0.101,0.068v0.082
			L106.259,72.835z M106.275,77.567l0.135-0.175l0.064-0.211l-0.1,0.018v0.083l-0.083,0.115l-0.118,0.035l0.018,0.045l0.032,0.1
			L106.275,77.567z M106.259,78.443l0.034-0.023l0.032-0.091l-0.032-0.06l-0.1,0.016v0.103L106.259,78.443z M106.341,80.98
			l0.019-0.052l-0.035-0.029l-0.066,0.093L106.341,80.98z M106.36,80.826l0.115-0.018l0.035-0.041l-0.035-0.075V80.64l-0.1,0.015
			l-0.083,0.113l-0.017,0.041L106.36,80.826z M106.341,73.746l0.034-0.006v-0.051l-0.034,0.006V73.746z M106.341,78.008L106.41,78
			v-0.035l-0.069,0.009V78.008z M106.442,75.577l0.05-0.079l0.031-0.136l-0.149,0.141v0.05L106.442,75.577z M106.442,79l0.1-0.05
			v-0.131l-0.032,0.001l-0.135,0.125v0.05L106.442,79z M106.442,79.52l0.082-0.014l0.018-0.12l0.066-0.077v-0.032l-0.166,0.026
			l-0.067,0.06v0.121L106.442,79.52z M106.426,75.143l0.116-0.021l0.084-0.045v-0.101l-0.084-0.054l-0.032,0.005l-0.049,0.093
			L106.426,75.143z M106.608,80.216l0.035-0.055l0.017-0.169l0.05-0.06l0.118-0.053l0.116-0.021v-0.185l0.199-0.147v-0.07
			l-0.117,0.004l-0.116-0.098l-0.083,0.013v0.049l0.098,0.102l-0.133,0.156l-0.1,0.05l-0.034,0.106l-0.034,0.039l-0.102-0.019
			l-0.082,0.015v0.086l0.067,0.057v0.217L106.608,80.216z M106.475,81.378l0.067-0.01l0.084-0.064l0.049-0.024l0.068-0.077
			l0.201-0.135v-0.116l-0.084-0.054l-0.049-0.01l-0.101,0.034v0.068l-0.05,0.075l-0.034-0.062l-0.102-0.068l-0.063,0.012v0.167
			l0.097,0.084v0.083l-0.083,0.048V81.378z M106.693,77.953l0.148-0.191l-0.049-0.163l-0.118,0.004l-0.016-0.048l0.034-0.056
			l0.217-0.22l0.083-0.027l-0.083-0.121l0.05-0.095l-0.05-0.039l-0.1,0.015l-0.035,0.09l0.035,0.114l-0.151,0.172l-0.118,0.19
			l0.101,0.084l-0.035,0.07l-0.098,0.016v0.102l0.066,0.074L106.693,77.953z M106.643,78.279l0.118-0.052l0.05-0.092l0.049-0.073
			l0.133-0.023l0.033,0.079l0.049,0.042l0.1-0.016l0.05-0.058v-0.182l-0.015,0.002l-0.035,0.038h-0.215l-0.035-0.025l-0.066,0.007
			l-0.167,0.163l-0.184,0.044l0.032,0.064l0.015,0.145L106.643,78.279z M106.524,80.414l0.033-0.054v-0.021l-0.033,0.058V80.414z
			 M106.693,76.325l0.199-0.098v-0.07l-0.132-0.026l-0.051-0.06l-0.017,0.002l-0.034,0.072l-0.118,0.103l0.101,0.05L106.693,76.325z
			 M106.576,74.817l0.05-0.01v-0.067l-0.05-0.011l-0.019,0.022L106.576,74.817z M106.557,75.322l0.069-0.012l0.049-0.056
			l-0.067-0.058l-0.051,0.058V75.322z M106.626,80.701l0.084-0.013l0.051-0.028l0.233-0.068l0.05-0.06l0.182-0.044l-0.066-0.174
			l-0.133-0.012l-0.033-0.146l-0.12-0.099l-0.032-0.096l-0.081,0.011v0.167l-0.085,0.05l0.068,0.122l-0.05,0.125l-0.034,0.141
			l-0.052,0.106L106.626,80.701z M106.643,79.049l0.05-0.007l0.017-0.018l-0.017-0.013l-0.05,0.006V79.049z M106.675,78.476
			l0.035-0.006v-0.064l-0.035,0.003V78.476z M106.675,79.314l0.052-0.005l0.017-0.037l-0.068,0.01V79.314z M106.71,76.875
			l0.051-0.058l-0.017-0.046l-0.034,0.007l-0.017,0.067L106.71,76.875z M106.842,74.251l0.152-0.122v-0.152l0.15-0.058V73.85
			l-0.117,0.02l-0.066,0.042l-0.017,0.022l-0.052,0.074l-0.032,0.122l-0.117,0.055l0.017,0.048L106.842,74.251z M106.761,74.619
			l0.032-0.006l-0.032-0.011l-0.017,0.004v0.017L106.761,74.619z M106.761,75.977l0.132-0.053l0.118-0.07l0.116-0.02v-0.116
			l-0.035-0.064l-0.082-0.037l-0.199,0.135l-0.067,0.209L106.761,75.977z M106.926,75.162v-0.1l-0.034-0.03l0.018-0.036l0.05-0.006
			v-0.103l-0.05-0.041l-0.15,0.022v0.103l0.1,0.132v0.068L106.926,75.162z M106.842,76.567l0.032-0.172l-0.032,0.006l-0.066,0.112
			L106.842,76.567z M106.811,75.601l0.1-0.067v-0.068l-0.1,0.018V75.601z M106.811,80.354l0.017-0.04l0.014,0.034v0.05l-0.014,0.019
			l-0.017-0.013V80.354z M107.076,74.685l0.05-0.01l0.118-0.134v-0.068l-0.033-0.046l-0.067-0.02l-0.067,0.042l-0.1-0.016
			l-0.116,0.136l0.15,0.092L107.076,74.685z M106.994,80.826l0.098-0.016v-0.116l-0.048-0.042l-0.05,0.006l-0.067,0.109
			L106.994,80.826z M107.044,78.886l0.048-0.007l0.018-0.118l0.084-0.1l0.017-0.087l0.033-0.071v-0.236l-0.101,0.015l-0.067,0.079
			l-0.049,0.161l-0.066,0.078v0.116l0.033,0.162L107.044,78.886z M107.16,77.761l0.066-0.044l0.184-0.063l0.084-0.05v-0.232
			l-0.097-0.036l-0.035-0.026l0.035-0.09l0.03-0.108l0.05-0.09l0.067-0.212l-0.05-0.008l-0.034,0.006l-0.034,0.07l-0.049-0.042
			l-0.015-0.064l-0.067-0.09l-0.119-0.03l-0.049-0.011l-0.083,0.013l-0.05,0.145l0.133-0.006l0.049,0.043v0.051l-0.149,0.175v0.17
			v0.015v0.032l0.065,0.074l0.052,0.161l0.083,0.018l-0.05,0.126l-0.084,0.015v0.032L107.16,77.761z M107.027,76.337v-0.035
			l-0.017-0.012v0.034L107.027,76.337z M107.027,74.341l0.049-0.042l0.05-0.077l-0.035-0.027l-0.065,0.043v0.052V74.341z
			 M107.144,79.829l0.05-0.008l0.032-0.059v-0.084l-0.05,0.011l-0.066,0.077L107.144,79.829z M107.194,81.266l0.032-0.023v-0.067
			l-0.116,0.017v0.05L107.194,81.266z M107.144,75.514l0.032-0.006V75.49l-0.032,0.006V75.514z M107.477,75.962l0.103-0.097
			l0.031-0.008l0.052-0.058l-0.052-0.076l-0.1,0.019l-0.034,0.056l-0.301,0.046v0.052l0.035,0.029l0.167,0.021L107.477,75.962z
			 M107.176,80.022l0.035,0v-0.053l-0.017,0.003L107.176,80.022z M107.277,76.381l0.035-0.007v-0.231l-0.085-0.022l-0.032,0.056v0.1
			L107.277,76.381z M107.544,74.141l0.118-0.068v-0.086l-0.101-0.001l-0.084-0.069l-0.067,0.009l-0.066,0.046l-0.067,0.044v0.066
			l0.067,0.056l0.066-0.044l0.067-0.01L107.544,74.141z M107.344,73.047l0.066-0.062v-0.116l-0.047-0.042l-0.067,0.008v0.153
			L107.344,73.047z M107.344,79.006l0.053-0.074l0.164-0.06v-0.066l-0.05-0.029l-0.148,0.058l-0.051,0.092v0.034L107.344,79.006z
			 M107.377,80.864v-0.098l-0.066,0.008v0.102L107.377,80.864z M107.327,72.697l0.035-0.006l-0.019-0.013l-0.017,0V72.697z
			 M107.362,74.455l0.232-0.125v-0.045l-0.101-0.088l-0.049,0.009l-0.035,0.075l-0.066,0.108L107.362,74.455z M107.397,76.7
			l0.03-0.006l0.1-0.116v-0.053l-0.032-0.028l-0.117,0.018l-0.015,0.038L107.397,76.7z M107.377,75.426l0.083-0.013v-0.051
			l-0.051-0.01l-0.032,0.024V75.426z M107.377,79.622l0.049-0.007l0.084-0.065v-0.065l-0.066,0.01L107.377,79.622z M107.511,79.3
			l0.05-0.01v-0.034l-0.084-0.086l-0.017-0.114l-0.063,0.011l0.013,0.066v0.134L107.511,79.3z M107.41,73.709l0.101-0.017
			l0.034-0.04l-0.067-0.024l-0.067,0.043V73.709z M107.544,75.164l0.085-0.097l0.064-0.043v-0.084l-0.084-0.072l-0.031-0.078
			l-0.069,0.012v0.167l-0.101,0.08l0.067,0.09L107.544,75.164z M107.41,78.341l0.117-0.018v-0.068l-0.016-0.013l-0.101,0.048V78.341
			z M107.46,81.172l0.066-0.012l0.104-0.134l-0.05,0.01l-0.153,0.106L107.46,81.172z M107.477,76.265l0.034-0.006v-0.015
			l-0.034,0.006V76.265z M107.794,78.631l0.05-0.189l0.168-0.046l-0.05-0.057v-0.204l-0.016,0.002l-0.035,0.04l-0.1,0.115
			l-0.182,0.083l-0.035,0.104l-0.118,0.036v0.116l0.185,0.156L107.794,78.631z M107.511,80.022l0.05-0.006l-0.035-0.014
			l-0.032,0.005L107.511,80.022z M107.61,79.066l0.084-0.098v-0.066l-0.015-0.048l-0.084,0.063l-0.05,0.092L107.61,79.066z
			 M107.694,75.408l0.1-0.064v-0.07l-0.1,0.018l-0.1,0.047v0.084L107.694,75.408z M107.947,72.852l-0.053-0.042l-0.1-0.018
			l-0.031,0.001l-0.101,0.019l-0.052,0.042l0.069,0.056l0.067-0.077l0.066-0.011l0.1,0.082L107.947,72.852z M107.61,74.733
			l0.069-0.01l0.067-0.097v-0.05l-0.052-0.023l-0.032,0.002l-0.052,0.112V74.733z M107.61,76.313l0.052-0.01v-0.032l-0.032,0.006
			L107.61,76.313z M107.679,77.794l0.049-0.076l-0.034-0.008l-0.032,0.002l-0.052,0.042v0.053L107.679,77.794z M107.679,78.063
			l0.032-0.001v-0.053l-0.017-0.066l-0.084,0.016v0.067L107.679,78.063z M107.694,79.789l0.084-0.146l-0.084,0.013l-0.064,0.045
			v0.101L107.694,79.789z M107.679,73.446l0.067-0.01l0.017-0.02l-0.052-0.024l-0.032,0.005l-0.017,0.038L107.679,73.446z
			 M107.711,80.223l0.052-0.006v-0.235l-0.017-0.049l-0.084,0.114l0.032,0.114L107.711,80.223z M107.794,79.49l0.05-0.007
			l0.067-0.112l-0.083-0.071l-0.118,0.053l-0.032,0.056L107.794,79.49z M107.863,73.971l0.049-0.091l0.101-0.065v-0.053l-0.066-0.04
			l-0.067,0.063l-0.185,0.03v0.15L107.863,73.971z M107.812,75.643l0.067-0.013v-0.05l-0.035-0.046l-0.15,0.024v0.053l0.052-0.01
			L107.812,75.643z M107.779,77.528l0.133-0.022v-0.064l-0.118-0.083l-0.048,0.004l-0.035,0.108L107.779,77.528z M107.711,80.846
			l0.067-0.012v-0.031l-0.067,0.007V80.846z M107.746,81.16l0.048-0.007v-0.067l-0.048,0.004V81.16z M107.894,73.111l0.018-0.003
			v-0.032h-0.018V73.111z M107.947,73.586h0.016l0.017-0.021l-0.017-0.03l-0.016,0.002V73.586z M108.077,72.324l0.084-0.012v-0.102
			l-0.115-0.03v0.116L108.077,72.324z M108.077,78.704v-0.048h-0.015v0.018L108.077,78.704z M108.18,73.718l0.05-0.006l0.049-0.078
			v-0.047l-0.1,0.015l-0.052,0.075L108.18,73.718z M108.161,75.586l0.035-0.006l0.034-0.072l-0.069,0.013l-0.033,0.02
			L108.161,75.586z M108.161,80.372l0.035-0.005l0.051-0.059l0.049-0.042v-0.049l-0.066,0.043l-0.069,0.098V80.372z M108.33,75.358
			l0.067-0.046l0.133-0.02v-0.069l-0.084,0.015l-0.132-0.03l-0.067,0.078v0.084L108.33,75.358z M108.345,76.647v-0.082l-0.082,0.013
			v0.086L108.345,76.647z M108.296,74.188l0.034-0.006v-0.017l-0.034-0.011V74.188z M108.345,74.618l0.017-0.005v-0.031
			l-0.017,0.001V74.618z M108.412,70.456l0.034-0.005v-0.048l-0.034-0.013l-0.032,0.04L108.412,70.456z M108.478,74.343l0.052-0.008
			v-0.068l-0.101,0.018l-0.032,0.038L108.478,74.343z M108.412,75.042l0.034-0.005l-0.017-0.014h-0.017V75.042z M108.429,71.313
			l0.084-0.017v-0.05l-0.084,0.014V71.313z M108.464,72.701l0.1-0.102v-0.034l-0.1,0.068V72.701z M108.548,73.542l0.081-0.012
			v-0.067l-0.081-0.021l-0.07,0.011v0.07L108.548,73.542z M108.564,69.73l0.017-0.004l0.049-0.041v-0.02l-0.065,0.028V69.73z
			 M108.597,72.393l0.066-0.06l-0.049-0.042l-0.05,0.056L108.597,72.393z M108.645,74.536l0.035-0.006v-0.032l-0.066-0.077
			l-0.034,0.006v0.067L108.645,74.536z M108.663,73.325l0.084-0.049l-0.052-0.043l-0.032,0.006l-0.034,0.039L108.663,73.325z
			 M108.695,74.275l0.017-0.037l-0.032-0.043l-0.017,0.034L108.695,74.275z M108.815,71.014l0.031-0.002v-0.034l-0.115-0.233
			l-0.05,0.076v0.133L108.815,71.014z M108.763,71.696l0.035-0.006v-0.018l-0.035,0.005V71.696z M108.846,72.875v-0.034
			l-0.031,0.004v0.032L108.846,72.875z M108.897,69.592l0.085-0.015l0.032-0.058l-0.017-0.013l-0.069,0.013l-0.032,0.04V69.592z
			 M108.965,70.874l0.05-0.006v-0.07l-0.05,0.009V70.874z M109.046,70.573l0.035-0.021v-0.034l-0.035,0.003l-0.017,0.039
			L109.046,70.573z M109.214,72.447l0.017-0.055l-0.017-0.016l-0.05,0.026L109.214,72.447z M109.38,73.36l0.068-0.078v-0.07
			l-0.032-0.009l-0.119,0.019v0.067L109.38,73.36z M109.48,70.268l0.101-0.065l0.017-0.037l-0.183-0.188l-0.05,0.008l0.032,0.265
			L109.48,70.268z M109.599,69.947l0.081-0.114v-0.031l-0.064,0.012l-0.081,0.078L109.599,69.947z M109.817,68.925v-0.037
			l-0.035,0.007v0.034L109.817,68.925z M109.966,68.26l0.067-0.008l0.05-0.094l-0.034-0.03l-0.084,0.067V68.26z M110.065,70.697
			l0.034-0.006l0.017-0.018l-0.05,0.008V70.697z M110.852,66.893l0.066-0.061v-0.101l-0.051-0.061l-0.049,0.16L110.852,66.893z
			 M110.852,65.954l0.015-0.055l-0.015,0.002V65.954z M110.935,65.853l0.017-0.001v-0.016h-0.017V65.853z M111,65.441l0.02-0.021
			L111,65.39l-0.049,0.01v0.052L111,65.441z M111.118,66.042l0.051-0.007v-0.049l-0.051-0.025l-0.084-0.054l-0.064,0.009v0.087
			L111.118,66.042z M111.269,65.229l0.116-0.052l0.067-0.076l-0.201,0.032l-0.032,0.038v0.05L111.269,65.229z M111.32,65.894
			l0.015-0.019v-0.052l-0.015,0.003l-0.02,0.05L111.32,65.894z M111.604,64.891l0.05-0.008v-0.034l-0.05-0.061l-0.069,0.012v0.032
			L111.604,64.891z M112.054,67.238V67.05l-0.084,0.017v0.181L112.054,67.238z M111.969,67.819v0.019v0.031V67.819z M112.103,67.817
			l0.084-0.015l0.084-0.081l-0.019-0.063v-0.064l-0.049-0.027l-0.049,0.01l-0.034,0.036l0.034,0.114l-0.052,0.074V67.817z"/>
		<path class="disabled"  d="M90.617,79.973l0.017-0.024l0.421-0.781l0.02-0.036l0.087-0.164l0.011-0.029l0.432-0.787l0.013-0.025l0.011-0.016
			l0.016-0.036l0.214-0.394l0.017-0.043l0.148-0.26l-0.084-0.102l-0.02-0.068l-0.044-0.042l-0.017-0.037l-0.062-0.078l-0.014-0.038
			l-0.193-0.276l-0.04-0.062l-0.24-0.355l-0.011-0.022l-0.049-0.068l-0.013-0.03l-0.064-0.078l-0.011-0.03l-0.119-0.173
			l-0.017-0.034l-0.06-0.076l-0.028-0.064l-0.032-0.037l-0.028-0.05l-0.045-0.06l-0.032-0.052l-0.053-0.077V75.43l0.037-0.03
			l-0.032-0.013l-0.022,0.033l-0.017-0.012v-0.05l1.098-0.175l0.032,0.029l0.256,0.398l0.027,0.056l0.167,0.242l0.094,0.171
			l0.031,0.03l0.024,0.068l0.038,0.05l0.017,0.04l0.13,0.276l0.041,0.021l0.082-0.274l0.034-0.068l0.025-0.086l0.147-0.333
			l0.017-0.021l0.079-0.163l0.042-0.004v-0.059l0.094-0.199l0.017-0.019l0.196-0.394l0.133-0.04l0.938-0.15v0.068l-0.035,0.031
			l-0.017,0.037l-0.009,0.012l-0.094,0.178l-0.016,0.024l-0.017,0.034l-0.198,0.344l-0.041,0.098l-0.093,0.152l-0.015,0.03
			l-0.042,0.085l-0.012,0.034l-0.022,0.017l-0.017,0.036l-0.055,0.113l-0.011,0.033l-0.015,0.021l-0.055,0.096l-0.055,0.068
			l-0.104,0.235l-0.258,0.463l-0.011,0.024l-0.094,0.166v0.078l0.038,0.048l0.042,0.066l0.939,1.419l0.017,0.027l0.213,0.315
			l0.02,0.029l0.267,0.412v0.092l-1.071,0.173l-0.024-0.046l-0.28-0.406l-0.013-0.036l-0.147-0.231l-0.016-0.013l-0.017-0.018
			l-0.199-0.3l-0.016-0.037L92.844,78.6l-0.296-0.569l-0.031-0.005l-0.208,0.54l-0.105,0.21l-0.06,0.128l-0.046,0.046l-0.047,0.009
			l-0.088,0.061v0.047l0.071,0.028L91.9,79.338l-0.042,0.09l-0.094,0.17l-0.019,0.036l-0.091,0.161l-0.066,0.164l-0.126,0.207
			L90.5,80.317v-0.111L90.617,79.973z M90.513,80.254l0.079-0.027v-0.018l-0.043-0.015l-0.035,0.045V80.254z M90.858,79.841
			l0.018-0.002v-0.009l-0.035,0.003L90.858,79.841z M90.952,79.827h0.013v-0.041l-0.06,0.009L90.952,79.827z M90.937,75.57
			l0.028-0.006l-0.013-0.042l-0.039,0.024L90.937,75.57z M91.042,79.405v-0.036l-0.028,0.002v0.04L91.042,79.405z M91.055,75.45
			l0.02-0.012l-0.02-0.008l-0.013,0.002v0.011L91.055,75.45z M91.091,79.66v-0.045l-0.032,0.032L91.091,79.66z M91.105,79.356
			l0.056-0.037l-0.056,0.009V79.356z M91.119,79.719l0.042-0.006v-0.019l-0.042,0.006V79.719z M91.145,75.574l0.017-0.003v-0.013
			l-0.017,0V75.574z M91.304,79.605l0.08-0.079l-0.042-0.042l-0.06,0.01l-0.087,0.081L91.304,79.605z M91.25,79.256l0.017-0.002
			v-0.019l-0.017,0.002V79.256z M91.266,79.165l0.016-0.025v-0.011l-0.016,0.004V79.165z M91.282,75.933l0.017-0.002v-0.016
			l-0.017,0.004V75.933z M91.282,79.709l0.017-0.002l-0.017-0.016V79.709z M91.342,79.762l0.017-0.012v-0.026l-0.027,0.002v0.03
			L91.342,79.762z M91.374,75.537l0.03-0.003v-0.018l-0.03-0.006V75.537z M91.425,79.477l0.05-0.048l0.042,0.032l0.052-0.056
			l-0.072-0.016l-0.056,0.009l-0.045,0.057L91.425,79.477z M91.425,79.553l0.017-0.02l-0.038,0.006L91.425,79.553z M91.528,76.033
			l-0.025-0.059l-0.084,0.013L91.528,76.033z M91.441,75.836v-0.05l-0.017,0.03L91.441,75.836z M91.441,79.303v-0.015h-0.01
			L91.441,79.303z M91.515,79.715V79.67l-0.052,0.008v0.046L91.515,79.715z M91.515,79.939l0.035-0.002l0.024-0.028l-0.029-0.051
			l-0.064,0.008v0.053L91.515,79.939z M91.549,78.801l0.02-0.02v-0.027l-0.035,0.032L91.549,78.801z M91.604,78.249l0.013-0.003
			l0.011-0.019l-0.024,0.004V78.249z M91.604,78.854l0.013-0.005l0.011-0.023l-0.024,0.006V78.854z M91.644,76.119v-0.028
			l-0.027,0.003L91.644,76.119z M91.644,79.288l0.011-0.019v-0.027h-0.011l-0.016,0.024L91.644,79.288z M91.671,79.078l0.022-0.047
			l-0.022,0.005l-0.017,0.036L91.671,79.078z M91.824,75.962v-0.066l-0.098,0.005l-0.039-0.017l-0.016,0.024l0.066,0.044
			L91.824,75.962z M91.671,79.338l0.055-0.01v-0.032l-0.055,0.01V79.338z M91.726,75.305v-0.042l-0.039,0.004v0.01L91.726,75.305z
			 M91.809,78.761l0.026-0.006l-0.031-0.056l-0.067,0.01v0.019l0.059,0.018L91.809,78.761z M91.746,78.848l0.019-0.003v-0.019
			l-0.019,0.004V78.848z M91.764,76.373l0.018-0.019v-0.017l-0.018,0.021V76.373z M91.764,79.565l0.018-0.029l-0.018,0.017V79.565z
			 M91.796,78.896l0.028-0.006v-0.026l-0.028,0.002V78.896z M91.858,76.132l0.027-0.005v-0.021l-0.027,0.002V76.132z M91.9,75.493
			l0.02-0.002v-0.054l-0.044,0.006v0.015L91.9,75.493z M91.962,78.857l0.028-0.028l-0.07-0.042v0.033L91.962,78.857z M91.962,76.271
			l0.017-0.003v-0.033l-0.017,0.019V76.271z M92.144,77.457l0.041-0.006V77.43l-0.041,0.006V77.457z M92.155,77.202l0.029-0.035
			l-0.013-0.022l-0.017,0.012V77.202z M92.235,76.245v-0.051l-0.051,0.006l-0.02,0.034L92.235,76.245z M92.22,77.208l0.016-0.003
			v-0.015l-0.016,0.002V77.208z M92.291,76.256l0.019-0.003v-0.019l-0.019,0.006V76.256z M92.291,76.513l0.019-0.003l-0.019-0.006
			V76.513z M92.412,76.301l0.028-0.004v-0.021l-0.013-0.01L92.4,76.283L92.412,76.301z M92.898,78.525l0.028-0.003v-0.018
			l-0.028,0.005V78.525z M93.016,77.779l0.014-0.003v-0.015l-0.014,0.003V77.779z M93.09,78.553l0.018-0.001l0.017-0.018
			l-0.017-0.015l-0.018,0.02V78.553z M93.201,75.718l0.043-0.006v-0.046l-0.022,0.006l-0.021,0.03V75.718z M93.301,76.75
			l0.014-0.001v-0.021l-0.014-0.012l-0.011,0.019L93.301,76.75z M93.41,75.983l0.028-0.006l-0.017-0.009l-0.011,0.002V75.983z
			 M93.573,78.841l0.017-0.003v-0.013l-0.017-0.017V78.841z M93.625,78.492l0.027-0.004v-0.025l-0.027,0.004l-0.022,0.021
			L93.625,78.492z M93.706,79.049l0.055-0.007l0.039-0.061l-0.055-0.007l-0.077,0.011v0.016L93.706,79.049z M93.92,78.751
			l0.016-0.002v-0.011H93.92V78.751z M94.044,75.188l0.031-0.005v-0.011l-0.031,0.004V75.188z M94.237,79.583l0.022-0.002v-0.034
			l-0.022,0.004l-0.017,0.018L94.237,79.583z"/>
		<path class="disabled"  d="M90.617,78.361l0.017-0.022l0.421-0.785l0.02-0.036l0.087-0.16l0.011-0.031l0.432-0.784l0.013-0.03l0.011-0.011
			l0.016-0.037l0.214-0.398l0.017-0.04l0.148-0.262l-0.084-0.101l-0.02-0.071l-0.044-0.041l-0.017-0.036l-0.062-0.078l-0.014-0.035
			l-0.193-0.277l-0.04-0.061l-0.24-0.356l-0.011-0.022l-0.049-0.068l-0.013-0.032l-0.064-0.079l-0.011-0.029l-0.119-0.175
			l-0.017-0.03l-0.06-0.078l-0.028-0.062l-0.032-0.041l-0.028-0.05l-0.045-0.058l-0.032-0.051l-0.053-0.08V73.82l0.037-0.029
			l-0.032-0.016l-0.022,0.036l-0.017-0.014v-0.048l1.098-0.176l0.032,0.026l0.256,0.398l0.027,0.058l0.167,0.242l0.094,0.173
			l0.031,0.027l0.024,0.069l0.038,0.047l0.017,0.042l0.13,0.276l0.041,0.021l0.082-0.271l0.034-0.07l0.025-0.088l0.147-0.333
			l0.017-0.018l0.079-0.162l0.042-0.008v-0.06l0.094-0.194l0.017-0.02l0.196-0.396l0.133-0.039l0.938-0.15v0.066l-0.035,0.033
			l-0.017,0.036l-0.009,0.014l-0.094,0.18l-0.016,0.026l-0.017,0.03l-0.198,0.341l-0.041,0.101l-0.093,0.155l-0.015,0.029
			l-0.042,0.083l-0.012,0.035l-0.022,0.013l-0.017,0.037l-0.055,0.113l-0.011,0.037l-0.015,0.018l-0.055,0.098l-0.055,0.068
			l-0.104,0.23l-0.258,0.469l-0.011,0.02l-0.094,0.17v0.078l0.038,0.048l0.042,0.065l0.939,1.418l0.017,0.025l0.213,0.317
			l0.02,0.026l0.267,0.413v0.093l-1.071,0.175l-0.024-0.051l-0.28-0.406l-0.013-0.037l-0.147-0.231l-0.016-0.011l-0.017-0.02
			l-0.199-0.3l-0.016-0.033l-0.094-0.128l-0.296-0.573l-0.031-0.002l-0.208,0.539l-0.105,0.208l-0.06,0.131l-0.046,0.048
			l-0.047,0.008l-0.088,0.062v0.045l0.071,0.027L91.9,77.728l-0.042,0.089l-0.094,0.17l-0.019,0.034l-0.091,0.166l-0.066,0.158
			l-0.126,0.207L90.5,78.705v-0.109L90.617,78.361z M90.513,78.644l0.079-0.03V78.6l-0.043-0.019l-0.035,0.044V78.644z
			 M90.858,78.231l0.018-0.004v-0.01l-0.035,0.006L90.858,78.231z M90.952,78.217l0.013-0.005v-0.04l-0.06,0.011L90.952,78.217z
			 M90.937,73.958l0.028-0.003l-0.013-0.043l-0.039,0.022L90.937,73.958z M91.042,77.794v-0.041l-0.028,0.007v0.04L91.042,77.794z
			 M91.055,73.842l0.02-0.016l-0.02-0.007h-0.013v0.013L91.055,73.842z M91.091,78.051v-0.05l-0.032,0.031L91.091,78.051z
			 M91.105,77.747l0.056-0.037l-0.056,0.006V77.747z M91.119,78.105l0.042-0.006v-0.014l-0.042,0.006V78.105z M91.145,73.965
			l0.017-0.004v-0.018l-0.017,0.003V73.965z M91.304,77.995l0.08-0.082l-0.042-0.041l-0.06,0.008l-0.087,0.08L91.304,77.995z
			 M91.25,77.645l0.017-0.003v-0.015L91.25,77.63V77.645z M91.266,77.554l0.016-0.024v-0.012l-0.016,0.003V77.554z M91.282,74.323
			l0.017-0.004v-0.016l-0.017,0.002V74.323z M91.282,78.098l0.017-0.005l-0.017-0.011V78.098z M91.342,78.153l0.017-0.012v-0.03
			l-0.027,0.006v0.026L91.342,78.153z M91.374,73.928l0.03-0.006v-0.016l-0.03-0.008V73.928z M91.425,77.867l0.05-0.05l0.042,0.034
			l0.052-0.06l-0.072-0.014l-0.056,0.008l-0.045,0.058L91.425,77.867z M91.425,77.94l0.017-0.018l-0.038,0.006L91.425,77.94z
			 M91.528,74.418l-0.025-0.058l-0.084,0.016L91.528,74.418z M91.441,74.222v-0.05l-0.017,0.033L91.441,74.222z M91.441,77.692
			v-0.018l-0.01,0.003L91.441,77.692z M91.515,78.105v-0.043l-0.052,0.005v0.044L91.515,78.105z M91.515,78.329l0.035-0.005
			l0.024-0.025l-0.029-0.049l-0.064,0.008v0.048L91.515,78.329z M91.549,77.189l0.02-0.017v-0.028l-0.035,0.029L91.549,77.189z
			 M91.604,76.634l0.013,0l0.011-0.019l-0.024,0.002V76.634z M91.604,77.241h0.013l0.011-0.024l-0.024,0.003V77.241z M91.644,74.505
			v-0.026l-0.027,0.001L91.644,74.505z M91.644,77.675l0.011-0.018V77.63l-0.011,0.001l-0.016,0.025L91.644,77.675z M91.671,77.469
			l0.022-0.048l-0.022,0.004l-0.017,0.034L91.671,77.469z M91.824,74.349v-0.064l-0.098,0.005l-0.039-0.017l-0.016,0.026
			l0.066,0.042L91.824,74.349z M91.671,77.725l0.055-0.008v-0.035l-0.055,0.011V77.725z M91.726,73.694v-0.045l-0.039,0.007v0.01
			L91.726,73.694z M91.809,77.148l0.026-0.004l-0.031-0.056L91.737,77.1v0.016l0.059,0.015L91.809,77.148z M91.746,77.234
			l0.019-0.002v-0.016l-0.019,0.003V77.234z M91.764,74.761l0.018-0.021v-0.014l-0.018,0.019V74.761z M91.764,77.953l0.018-0.03
			l-0.018,0.02V77.953z M91.796,77.282l0.028-0.005V77.25l-0.028,0.006V77.282z M91.858,74.521l0.027-0.004v-0.023l-0.027,0.005
			V74.521z M91.9,73.88l0.02-0.003v-0.053l-0.044,0.006v0.019L91.9,73.88z M91.962,77.246l0.028-0.026l-0.07-0.046v0.035
			L91.962,77.246z M91.962,74.657l0.017-0.001v-0.033l-0.017,0.021V74.657z M92.144,75.847l0.041-0.011v-0.02l-0.041,0.008V75.847z
			 M92.155,75.593l0.029-0.041l-0.013-0.02l-0.017,0.014V75.593z M92.235,74.631v-0.05l-0.051,0.007l-0.02,0.03L92.235,74.631z
			 M92.22,75.598l0.016-0.005v-0.017L92.22,75.58V75.598z M92.291,74.644l0.019-0.005v-0.013l-0.019,0.001V74.644z M92.291,74.904
			l0.019-0.004l-0.019-0.008V74.904z M92.412,74.691l0.028-0.006v-0.022l-0.013-0.008L92.4,74.668L92.412,74.691z M92.898,76.914
			l0.028-0.006v-0.015l-0.028,0.004V76.914z M93.016,76.169l0.014-0.002v-0.018l-0.014,0.001V76.169z M93.09,76.943l0.018-0.003
			l0.017-0.02l-0.017-0.012l-0.018,0.018V76.943z M93.201,74.106l0.043-0.006v-0.043l-0.022,0.003l-0.021,0.029V74.106z
			 M93.301,75.137l0.014-0.004V75.12l-0.014-0.016l-0.011,0.018L93.301,75.137z M93.41,74.371l0.028-0.004l-0.017-0.008H93.41
			V74.371z M93.573,77.23l0.017-0.004V77.21l-0.017-0.014V77.23z M93.625,76.877l0.027-0.002v-0.021l-0.027,0.003l-0.022,0.02
			H93.625z M93.706,77.438l0.055-0.007l0.039-0.063l-0.055-0.009l-0.077,0.014v0.016L93.706,77.438z M93.92,77.142l0.016-0.004
			v-0.01L93.92,77.13V77.142z M94.044,73.574l0.031-0.002v-0.012l-0.031,0.005V73.574z M94.237,77.971l0.022-0.003v-0.032
			l-0.022,0.002l-0.017,0.018L94.237,77.971z"/>
		<path class="disabled"  d="M90.617,77.019l0.017-0.023l0.421-0.781l0.02-0.037l0.087-0.163l0.011-0.031l0.432-0.784l0.013-0.029l0.011-0.013
			l0.016-0.036l0.214-0.398l0.017-0.038l0.148-0.265l-0.084-0.102l-0.02-0.068l-0.044-0.042l-0.017-0.037l-0.062-0.078l-0.014-0.035
			l-0.193-0.28l-0.04-0.058l-0.24-0.356l-0.011-0.021l-0.049-0.068l-0.013-0.03l-0.064-0.078l-0.011-0.035l-0.119-0.172
			l-0.017-0.029l-0.06-0.079l-0.028-0.062l-0.032-0.039l-0.028-0.052l-0.045-0.056l-0.032-0.053l-0.053-0.077v-0.038l0.037-0.03
			l-0.032-0.015l-0.022,0.035l-0.017-0.015v-0.047l1.098-0.177l0.032,0.026l0.256,0.403l0.027,0.051l0.167,0.245l0.094,0.172
			l0.031,0.03l0.024,0.066l0.038,0.048l0.017,0.042l0.13,0.275l0.041,0.024l0.082-0.272l0.034-0.072l0.025-0.087l0.147-0.332
			l0.017-0.018l0.079-0.162l0.042-0.009v-0.06l0.094-0.196l0.017-0.02l0.196-0.394l0.133-0.038l0.938-0.15v0.066l-0.035,0.031
			l-0.017,0.036l-0.009,0.017l-0.094,0.178l-0.016,0.023l-0.017,0.03l-0.198,0.345l-0.041,0.102l-0.093,0.152l-0.015,0.031
			l-0.042,0.083l-0.012,0.037l-0.022,0.012l-0.017,0.036l-0.055,0.114l-0.011,0.035l-0.015,0.02l-0.055,0.098l-0.055,0.069
			l-0.104,0.23L93.29,74.01l-0.011,0.026l-0.094,0.166v0.078l0.038,0.049l0.042,0.066l0.939,1.418l0.017,0.022l0.213,0.318
			l0.02,0.023l0.267,0.417v0.094l-1.071,0.173l-0.024-0.048l-0.28-0.408l-0.013-0.035l-0.147-0.227l-0.016-0.016l-0.017-0.021
			l-0.199-0.296l-0.016-0.036l-0.094-0.13l-0.296-0.571l-0.031-0.002L92.31,75.61l-0.105,0.208l-0.06,0.132l-0.046,0.044
			l-0.047,0.01l-0.088,0.062v0.046l0.071,0.026L91.9,76.385l-0.042,0.09l-0.094,0.17l-0.019,0.035l-0.091,0.161l-0.066,0.161
			l-0.126,0.206L90.5,77.362v-0.11L90.617,77.019z M90.513,77.3l0.079-0.03v-0.014l-0.043-0.016l-0.035,0.041V77.3z M90.858,76.888
			l0.018-0.002v-0.015l-0.035,0.007L90.858,76.888z M90.952,76.871l0.013,0v-0.036l-0.06,0.007L90.952,76.871z M90.937,72.615
			l0.028-0.003l-0.013-0.043l-0.039,0.023L90.937,72.615z M91.042,76.451v-0.039l-0.028,0.005v0.04L91.042,76.451z M91.055,72.497
			l0.02-0.014l-0.02-0.006h-0.013v0.011L91.055,72.497z M91.091,76.708v-0.05l-0.032,0.032L91.091,76.708z M91.105,76.401
			l0.056-0.034l-0.056,0.007V76.401z M91.119,76.761l0.042-0.005V76.74l-0.042,0.008V76.761z M91.145,72.621l0.017-0.004v-0.014
			l-0.017,0.003V72.621z M91.304,76.651l0.08-0.078l-0.042-0.042l-0.06,0.01l-0.087,0.076L91.304,76.651z M91.25,76.301h0.017
			v-0.018l-0.017,0.002V76.301z M91.266,76.211l0.016-0.024v-0.013l-0.016,0.003V76.211z M91.282,72.979l0.017-0.001v-0.017h-0.017
			V72.979z M91.282,76.753l0.017-0.003l-0.017-0.012V76.753z M91.342,76.81l0.017-0.012v-0.03l-0.027,0.006v0.028L91.342,76.81z
			 M91.374,72.583l0.03-0.006v-0.014l-0.03-0.006V72.583z M91.425,76.521l0.05-0.046l0.042,0.032l0.052-0.056l-0.072-0.018
			l-0.056,0.008l-0.045,0.056L91.425,76.521z M91.425,76.597l0.017-0.018l-0.038,0.005L91.425,76.597z M91.528,73.075l-0.025-0.053
			l-0.084,0.011L91.528,73.075z M91.441,72.882v-0.049l-0.017,0.03L91.441,72.882z M91.441,76.349v-0.018l-0.01,0.002L91.441,76.349
			z M91.515,76.761v-0.046l-0.052,0.011v0.042L91.515,76.761z M91.515,76.985l0.035-0.005l0.024-0.024l-0.029-0.05l-0.064,0.008
			v0.052L91.515,76.985z M91.549,75.847l0.02-0.019v-0.025l-0.035,0.027L91.549,75.847z M91.604,75.292h0.013l0.011-0.018
			l-0.024,0.004V75.292z M91.604,75.901l0.013-0.005l0.011-0.023l-0.024,0.004V75.901z M91.644,73.162v-0.028l-0.027,0.006
			L91.644,73.162z M91.644,76.333l0.011-0.018v-0.03l-0.011,0.004l-0.016,0.023L91.644,76.333z M91.671,76.124l0.022-0.047
			l-0.022,0.002l-0.017,0.036L91.671,76.124z M91.824,73.005v-0.064l-0.098,0.006l-0.039-0.016l-0.016,0.024l0.066,0.042
			L91.824,73.005z M91.671,76.385l0.055-0.01v-0.032l-0.055,0.006V76.385z M91.726,72.351v-0.043l-0.039,0.004v0.012L91.726,72.351z
			 M91.809,75.804l0.026-0.001l-0.031-0.059l-0.067,0.013v0.018l0.059,0.013L91.809,75.804z M91.746,75.891l0.019-0.002v-0.016
			l-0.019,0.004V75.891z M91.764,73.419l0.018-0.021v-0.014l-0.018,0.018V73.419z M91.764,76.609l0.018-0.03l-0.018,0.02V76.609z
			 M91.796,75.938l0.028-0.001v-0.031l-0.028,0.006V75.938z M91.858,73.178l0.027-0.004v-0.024l-0.027,0.006V73.178z M91.9,72.538
			h0.02v-0.059l-0.044,0.01v0.014L91.9,72.538z M91.962,75.903l0.028-0.027l-0.07-0.046v0.034L91.962,75.903z M91.962,73.314
			l0.017-0.003v-0.034L91.962,73.3V73.314z M92.144,74.503l0.041-0.006v-0.024l-0.041,0.008V74.503z M92.155,74.248l0.029-0.039
			l-0.013-0.019l-0.017,0.012V74.248z M92.235,73.289v-0.049l-0.051,0.006l-0.02,0.032L92.235,73.289z M92.22,74.255l0.016-0.004
			v-0.018l-0.016,0.004V74.255z M92.291,73.3h0.019v-0.018l-0.019,0.003V73.3z M92.291,73.561l0.019-0.005l-0.019-0.008V73.561z
			 M92.412,73.346l0.028-0.001v-0.025l-0.013-0.008L92.4,73.326L92.412,73.346z M92.898,75.57l0.028-0.006v-0.013l-0.028,0.001
			V75.57z M93.016,74.826l0.014-0.002v-0.019l-0.014,0.002V74.826z M93.09,75.601l0.018-0.002l0.017-0.021l-0.017-0.013
			l-0.018,0.018V75.601z M93.201,72.763l0.043-0.003v-0.046l-0.022,0.002l-0.021,0.035V72.763z M93.301,73.792l0.014-0.002v-0.016
			l-0.014-0.014l-0.011,0.018L93.301,73.792z M93.41,73.028l0.028-0.004l-0.017-0.008l-0.011,0.001V73.028z M93.573,75.884
			l0.017-0.001v-0.017l-0.017-0.016V75.884z M93.625,75.534l0.027-0.001V75.51l-0.027,0.004l-0.022,0.02H93.625z M93.706,76.095
			l0.055-0.01l0.039-0.058l-0.055-0.006l-0.077,0.012v0.014L93.706,76.095z M93.92,75.798l0.016-0.001v-0.014l-0.016,0.003V75.798z
			 M94.044,72.23l0.031-0.002v-0.012l-0.031,0.002V72.23z M94.237,76.627l0.022-0.004v-0.032l-0.022,0.003l-0.017,0.021
			L94.237,76.627z"/>
		<path class="disabled"  d="M90.617,80.912l0.017-0.024l0.421-0.781l0.02-0.035l0.087-0.163l0.011-0.03l0.432-0.785l0.013-0.028l0.011-0.017
			l0.016-0.035l0.214-0.395l0.017-0.042l0.148-0.259l-0.084-0.102l-0.02-0.07l-0.044-0.042l-0.017-0.036l-0.062-0.077l-0.014-0.04
			l-0.193-0.274l-0.04-0.062l-0.24-0.359l-0.011-0.017l-0.049-0.073l-0.013-0.03l-0.064-0.078l-0.011-0.028l-0.119-0.174
			l-0.017-0.034l-0.06-0.076l-0.028-0.061l-0.032-0.041l-0.028-0.05l-0.045-0.06l-0.032-0.047l-0.053-0.081v-0.04l0.037-0.027
			l-0.032-0.018l-0.022,0.036l-0.017-0.012v-0.052l1.098-0.176l0.032,0.03l0.256,0.398l0.027,0.056l0.167,0.243l0.094,0.174
			l0.031,0.026l0.024,0.07l0.038,0.049l0.017,0.042l0.13,0.273l0.041,0.023l0.082-0.272l0.034-0.072l0.025-0.085l0.147-0.335
			l0.017-0.018l0.079-0.161l0.042-0.006v-0.06l0.094-0.198l0.017-0.019l0.196-0.395l0.133-0.038l0.938-0.15v0.066l-0.035,0.035
			l-0.017,0.034l-0.009,0.012l-0.094,0.18l-0.016,0.027l-0.017,0.029l-0.198,0.344l-0.041,0.102l-0.093,0.15l-0.015,0.032
			l-0.042,0.084l-0.012,0.032l-0.022,0.016l-0.017,0.036l-0.055,0.114l-0.011,0.036l-0.015,0.016l-0.055,0.096l-0.055,0.072
			l-0.104,0.232l-0.258,0.463l-0.011,0.024l-0.094,0.17v0.078l0.038,0.048l0.042,0.065l0.939,1.416l0.017,0.026l0.213,0.319
			l0.02,0.024l0.267,0.417v0.092l-1.071,0.172l-0.024-0.046l-0.28-0.409l-0.013-0.037l-0.147-0.23l-0.016-0.013l-0.017-0.021
			l-0.199-0.299l-0.016-0.032l-0.094-0.131l-0.296-0.569l-0.031-0.005l-0.208,0.542l-0.105,0.208l-0.06,0.13l-0.046,0.043
			l-0.047,0.008l-0.088,0.064v0.043l0.071,0.028L91.9,80.281l-0.042,0.09l-0.094,0.166l-0.019,0.037l-0.091,0.162l-0.066,0.163
			l-0.126,0.206L90.5,81.26v-0.111L90.617,80.912z M90.513,81.193l0.079-0.027v-0.018l-0.043-0.014l-0.035,0.043V81.193z
			 M90.858,80.78h0.018v-0.013l-0.035,0.007L90.858,80.78z M90.952,80.766h0.013v-0.038l-0.06,0.007L90.952,80.766z M90.937,76.51
			l0.028-0.006l-0.013-0.04l-0.039,0.024L90.937,76.51z M91.042,80.347v-0.04l-0.028,0.004v0.038L91.042,80.347z M91.055,76.393
			l0.02-0.014l-0.02-0.01l-0.013,0.003v0.012L91.055,76.393z M91.091,80.603v-0.049l-0.032,0.033L91.091,80.603z M91.105,80.295
			l0.056-0.037l-0.056,0.011V80.295z M91.119,80.658l0.042-0.006v-0.018l-0.042,0.008V80.658z M91.145,76.515l0.017-0.002v-0.018
			l-0.017,0.002V76.515z M91.304,80.543l0.08-0.078l-0.042-0.043l-0.06,0.01l-0.087,0.08L91.304,80.543z M91.25,80.197l0.017-0.003
			v-0.017L91.25,80.18V80.197z M91.266,80.103l0.016-0.021v-0.01h-0.016V80.103z M91.282,76.871l0.017,0v-0.016l-0.017,0.003V76.871
			z M91.282,80.648l0.017-0.002l-0.017-0.014V80.648z M91.342,80.706l0.017-0.014v-0.028l-0.027,0.001v0.032L91.342,80.706z
			 M91.374,76.477l0.03-0.001v-0.018l-0.03-0.006V76.477z M91.425,80.416l0.05-0.044l0.042,0.03l0.052-0.058l-0.072-0.017
			l-0.056,0.011l-0.045,0.055L91.425,80.416z M91.425,80.494l0.017-0.018l-0.038,0.006L91.425,80.494z M91.528,76.972l-0.025-0.058
			l-0.084,0.017L91.528,76.972z M91.441,76.778v-0.053l-0.017,0.03L91.441,76.778z M91.441,80.246v-0.019h-0.01L91.441,80.246z
			 M91.515,80.654V80.61l-0.052,0.01v0.044L91.515,80.654z M91.515,80.883l0.035-0.007l0.024-0.026l-0.029-0.052l-0.064,0.013v0.048
			L91.515,80.883z M91.549,79.743l0.02-0.022v-0.026l-0.035,0.032L91.549,79.743z M91.604,79.188l0.013-0.002l0.011-0.018
			l-0.024,0.002V79.188z M91.604,79.792h0.013l0.011-0.026l-0.024,0.005V79.792z M91.644,77.057v-0.025l-0.027,0.002L91.644,77.057z
			 M91.644,80.227l0.011-0.018v-0.026h-0.011l-0.016,0.026L91.644,80.227z M91.671,80.022l0.022-0.049l-0.022,0.003l-0.017,0.036
			L91.671,80.022z M91.824,76.904v-0.069l-0.098,0.005l-0.039-0.016l-0.016,0.024l0.066,0.045L91.824,76.904z M91.671,80.279
			l0.055-0.01v-0.034l-0.055,0.01V80.279z M91.726,76.248v-0.047l-0.039,0.008v0.012L91.726,76.248z M91.809,79.701l0.026-0.006
			l-0.031-0.054l-0.067,0.013v0.013l0.059,0.019L91.809,79.701z M91.746,79.786l0.019-0.003v-0.017l-0.019,0.005V79.786z
			 M91.764,77.313l0.018-0.019v-0.018l-0.018,0.021V77.313z M91.764,80.505l0.018-0.03l-0.018,0.018V80.505z M91.796,79.835
			l0.028-0.006v-0.027l-0.028,0.003V79.835z M91.858,77.071l0.027-0.005v-0.021l-0.027,0.006V77.071z M91.9,76.433l0.02-0.003
			v-0.055l-0.044,0.007v0.018L91.9,76.433z M91.962,79.795l0.028-0.027l-0.07-0.042v0.035L91.962,79.795z M91.962,77.21l0.017-0.002
			v-0.035l-0.017,0.019V77.21z M92.144,78.399l0.041-0.01v-0.022l-0.041,0.008V78.399z M92.155,78.141l0.029-0.036l-0.013-0.02
			l-0.017,0.014V78.141z M92.235,77.184v-0.053l-0.051,0.011l-0.02,0.03L92.235,77.184z M92.22,78.147h0.016v-0.019l-0.016,0.003
			V78.147z M92.291,77.196l0.019-0.004v-0.014l-0.019,0.003V77.196z M92.291,77.455h0.019l-0.019-0.01V77.455z M92.412,77.244
			l0.028-0.006v-0.021l-0.013-0.008L92.4,77.222L92.412,77.244z M92.898,79.464l0.028-0.004v-0.018l-0.028,0.005V79.464z
			 M93.016,78.719h0.014v-0.021l-0.014,0.005V78.719z M93.09,79.495h0.018l0.017-0.021l-0.017-0.017l-0.018,0.022V79.495z
			 M93.201,76.66l0.043-0.008v-0.042l-0.022,0.002l-0.021,0.029V76.66z M93.301,77.689l0.014-0.001v-0.019l-0.014-0.012
			l-0.011,0.018L93.301,77.689z M93.41,76.923l0.028-0.003l-0.017-0.009H93.41V76.923z M93.573,79.781l0.017-0.004v-0.014
			l-0.017-0.013V79.781z M93.625,79.43l0.027-0.002v-0.02l-0.027,0.002l-0.022,0.02H93.625z M93.706,79.992l0.055-0.01l0.039-0.061
			l-0.055-0.008l-0.077,0.012v0.018L93.706,79.992z M93.92,79.694l0.016-0.004v-0.012l-0.016,0.004V79.694z M94.044,76.127
			l0.031-0.003v-0.011l-0.031,0.002V76.127z M94.237,80.524l0.022-0.004v-0.032l-0.022,0.005l-0.017,0.018L94.237,80.524z"/>
		<path class="disabled"  d="M91.983,80.804l0.018-0.027l0.415-0.782l0.024-0.034l0.087-0.163l0.01-0.03l0.433-0.783l0.013-0.03l0.007-0.011
			l0.02-0.039l0.213-0.397l0.02-0.042l0.146-0.259l-0.083-0.103l-0.021-0.07l-0.042-0.04l-0.02-0.037l-0.06-0.08l-0.014-0.037
			l-0.195-0.275l-0.038-0.061l-0.24-0.358l-0.01-0.019l-0.05-0.073l-0.013-0.029l-0.066-0.078l-0.01-0.032l-0.121-0.174
			l-0.016-0.029l-0.063-0.08l-0.026-0.057l-0.034-0.04l-0.025-0.05l-0.045-0.061l-0.032-0.047l-0.055-0.082v-0.038l0.037-0.026
			l-0.032-0.019l-0.021,0.036l-0.017-0.017v-0.047l1.098-0.177l0.034,0.03l0.257,0.399l0.026,0.056l0.164,0.242l0.093,0.174
			l0.035,0.027l0.02,0.069l0.039,0.047l0.017,0.043l0.129,0.274l0.041,0.02l0.083-0.269l0.033-0.072l0.028-0.086l0.147-0.332
			l0.017-0.022l0.076-0.161l0.046-0.005v-0.061l0.089-0.198l0.017-0.018l0.199-0.395l0.132-0.04l0.937-0.148v0.064l-0.034,0.034
			l-0.016,0.037l-0.011,0.012l-0.094,0.18l-0.016,0.026l-0.015,0.03l-0.196,0.344l-0.041,0.099l-0.094,0.153l-0.016,0.032
			l-0.046,0.084l-0.009,0.033l-0.022,0.013l-0.014,0.038l-0.058,0.113l-0.011,0.036l-0.016,0.018l-0.056,0.096l-0.055,0.07
			l-0.103,0.233l-0.259,0.464l-0.013,0.022l-0.093,0.172v0.074l0.038,0.053l0.041,0.066l0.944,1.417l0.014,0.023l0.215,0.317
			l0.017,0.027l0.271,0.413v0.093l-1.078,0.174l-0.02-0.049l-0.28-0.406l-0.013-0.036l-0.147-0.23l-0.014-0.016l-0.016-0.018
			l-0.199-0.299l-0.017-0.036l-0.093-0.128l-0.297-0.569l-0.035-0.005l-0.205,0.542l-0.104,0.209l-0.062,0.127l-0.043,0.044
			l-0.049,0.01l-0.088,0.065v0.043l0.07,0.026l-0.129,0.25l-0.046,0.087l-0.091,0.169l-0.017,0.036l-0.095,0.164l-0.066,0.159
			l-0.125,0.206l-0.964,0.156v-0.11L91.983,80.804z M91.879,81.086l0.076-0.029v-0.018l-0.042-0.016l-0.034,0.045V81.086z
			 M92.225,80.672l0.017-0.002v-0.012l-0.034,0.006L92.225,80.672z M92.318,80.658l0.01-0.003v-0.039l-0.06,0.01L92.318,80.658z
			 M92.301,76.399l0.026-0.006l-0.01-0.04l-0.038,0.021L92.301,76.399z M92.406,80.236v-0.039l-0.028,0.002v0.04L92.406,80.236z
			 M92.416,76.279l0.024-0.012l-0.024-0.008l-0.01,0.004v0.007L92.416,76.279z M92.454,80.492v-0.05l-0.033,0.033L92.454,80.492z
			 M92.474,80.185l0.053-0.036l-0.053,0.01V80.185z M92.482,80.545l0.045-0.003v-0.018l-0.045,0.008V80.545z M92.508,76.401h0.019
			v-0.016l-0.019,0.002V76.401z M92.67,80.436l0.083-0.08l-0.043-0.043l-0.062,0.008l-0.087,0.082L92.67,80.436z M92.615,80.087
			l0.015-0.003v-0.015h-0.015V80.087z M92.63,79.995l0.017-0.022v-0.011l-0.017,0.001V79.995z M92.647,76.761l0.018-0.001v-0.017
			l-0.018,0.005V76.761z M92.647,80.537l0.018-0.001l-0.018-0.012V80.537z M92.709,80.596l0.014-0.016v-0.026l-0.027,0.002v0.03
			L92.709,80.596z M92.74,76.367l0.028-0.004v-0.016l-0.028-0.006V76.367z M92.789,80.305l0.052-0.046l0.042,0.03l0.051-0.056
			l-0.073-0.016l-0.055,0.01l-0.043,0.059L92.789,80.305z M92.789,80.384l0.017-0.018l-0.038,0.005L92.789,80.384z M92.896,76.86
			l-0.029-0.056l-0.082,0.013L92.896,76.86z M92.806,76.666v-0.051l-0.017,0.03L92.806,76.666z M92.806,80.133v-0.018l-0.01,0.004
			L92.806,80.133z M92.875,80.543v-0.04l-0.046,0.006v0.044L92.875,80.543z M92.875,80.772l0.041-0.006l0.021-0.028l-0.025-0.05
			l-0.067,0.013v0.047L92.875,80.772z M92.915,79.633l0.019-0.022v-0.028l-0.035,0.035L92.915,79.633z M92.97,79.078l0.013-0.002
			l0.007-0.021l-0.02,0.004V79.078z M92.97,79.683l0.013-0.004l0.007-0.023l-0.02,0.005V79.683z M93.009,76.946V76.92l-0.027,0.003
			L93.009,76.946z M93.009,80.115l0.01-0.019v-0.025h-0.01l-0.02,0.025L93.009,80.115z M93.037,79.909l0.021-0.046l-0.021,0.001
			l-0.018,0.037L93.037,79.909z M93.191,76.792v-0.066l-0.101,0.001l-0.038-0.013l-0.016,0.023l0.066,0.046L93.191,76.792z
			 M93.037,80.167l0.053-0.008v-0.034l-0.053,0.008V80.167z M93.09,76.137v-0.046l-0.038,0.005v0.01L93.09,76.137z M93.174,79.588
			l0.027-0.006l-0.034-0.052l-0.064,0.012v0.014l0.059,0.019L93.174,79.588z M93.114,79.676l0.017-0.003v-0.018l-0.017,0.005V79.676
			z M93.131,77.202l0.017-0.018v-0.018l-0.017,0.02V77.202z M93.131,80.396l0.017-0.029l-0.017,0.018V80.396z M93.162,79.725
			l0.029-0.005V79.69l-0.029,0.004V79.725z M93.222,76.962l0.028-0.006v-0.021l-0.028,0.005V76.962z M93.269,76.321l0.015-0.001
			v-0.055l-0.042,0.005v0.015L93.269,76.321z M93.327,79.686l0.028-0.027l-0.072-0.042v0.031L93.327,79.686z M93.327,77.1
			l0.017-0.002v-0.034l-0.017,0.018V77.1z M93.508,78.285l0.043-0.006v-0.021l-0.043,0.005V78.285z M93.52,78.03l0.032-0.035
			l-0.016-0.021l-0.017,0.015V78.03z M93.601,77.071v-0.05l-0.049,0.01l-0.022,0.028L93.601,77.071z M93.583,78.035h0.018v-0.016
			l-0.018,0.002V78.035z M93.655,77.084l0.019-0.002v-0.015l-0.019,0.004V77.084z M93.655,77.342l0.019-0.002l-0.019-0.006V77.342z
			 M93.776,77.131l0.027-0.003v-0.021l-0.008-0.013l-0.03,0.018L93.776,77.131z M94.264,79.356l0.028-0.007v-0.017l-0.028,0.006
			V79.356z M94.38,78.608h0.017V78.59l-0.017,0.003V78.608z M94.459,79.382h0.014l0.017-0.02l-0.017-0.016l-0.014,0.022V79.382z
			 M94.565,76.549l0.045-0.008v-0.046l-0.024,0.007l-0.021,0.029V76.549z M94.665,77.579l0.015-0.002v-0.018l-0.015-0.011
			l-0.011,0.017L94.665,77.579z M94.774,76.812l0.028-0.004l-0.018-0.006h-0.01V76.812z M94.94,79.67h0.015v-0.017l-0.015-0.015
			V79.67z M94.989,79.322l0.027-0.003v-0.022L94.989,79.3l-0.021,0.02L94.989,79.322z M95.07,79.879l0.056-0.008l0.038-0.06
			l-0.055-0.009l-0.079,0.015v0.016L95.07,79.879z M95.286,79.583l0.015-0.002v-0.012l-0.015,0.002V79.583z M95.411,76.017
			l0.027-0.002v-0.011l-0.027,0.001V76.017z M95.602,80.414l0.022-0.004v-0.032l-0.022,0.002l-0.017,0.018L95.602,80.414z"/>
		<path class="disabled"  d="M89.066,81.268l0.017-0.024l0.417-0.78l0.022-0.036l0.087-0.165l0.01-0.03l0.431-0.785l0.013-0.026l0.013-0.013
			l0.015-0.034l0.214-0.4l0.017-0.041l0.148-0.261l-0.083-0.103l-0.022-0.068l-0.043-0.045l-0.017-0.032l-0.059-0.081l-0.019-0.036
			l-0.19-0.277L90,77.974l-0.244-0.36l-0.01-0.017l-0.048-0.073l-0.013-0.029l-0.066-0.079l-0.01-0.031l-0.122-0.17l-0.017-0.034
			l-0.061-0.077l-0.026-0.063l-0.034-0.038l-0.027-0.05l-0.044-0.061l-0.031-0.052l-0.056-0.077v-0.039l0.037-0.026l-0.031-0.019
			l-0.021,0.034l-0.02-0.01v-0.052l1.101-0.177l0.031,0.03l0.256,0.399l0.03,0.056l0.164,0.243l0.092,0.174l0.032,0.026l0.024,0.07
			l0.038,0.048l0.017,0.042l0.132,0.275l0.038,0.022l0.083-0.275l0.032-0.069l0.027-0.085l0.15-0.334l0.015-0.02l0.079-0.158
			l0.043-0.009v-0.06l0.091-0.198l0.02-0.019l0.196-0.393l0.13-0.041l0.937-0.148v0.066l-0.032,0.032l-0.017,0.036l-0.01,0.012
			l-0.094,0.18l-0.015,0.025l-0.017,0.03l-0.198,0.345l-0.038,0.102l-0.094,0.15l-0.017,0.032l-0.043,0.085l-0.011,0.032
			l-0.02,0.015l-0.019,0.036l-0.056,0.115l-0.01,0.034l-0.017,0.018l-0.053,0.096l-0.058,0.069l-0.104,0.233l-0.26,0.465
			l-0.008,0.023l-0.094,0.17v0.076l0.039,0.05l0.038,0.067l0.943,1.415l0.017,0.025l0.213,0.318l0.016,0.022l0.269,0.417v0.095
			l-1.074,0.17l-0.021-0.046l-0.28-0.407l-0.01-0.036l-0.15-0.23l-0.016-0.015L91.6,80.36l-0.196-0.301l-0.02-0.037l-0.091-0.127
			l-0.297-0.568l-0.031-0.007l-0.209,0.539l-0.104,0.21l-0.061,0.13l-0.046,0.046L90.5,80.254l-0.088,0.063v0.044l0.071,0.028
			l-0.133,0.245l-0.043,0.09l-0.092,0.17l-0.018,0.036l-0.093,0.16l-0.064,0.16l-0.126,0.21l-0.966,0.153v-0.111L89.066,81.268z
			 M88.963,81.549l0.077-0.026v-0.019l-0.046-0.014l-0.031,0.044V81.549z M89.308,81.136l0.017-0.001v-0.01l-0.034,0.004
			L89.308,81.136z M89.401,81.123h0.01v-0.04l-0.06,0.008L89.401,81.123z M89.385,76.866l0.026-0.005l-0.01-0.043l-0.039,0.024
			L89.385,76.866z M89.488,80.701v-0.037l-0.026,0.001v0.04L89.488,80.701z M89.501,76.75l0.022-0.016l-0.022-0.008l-0.013,0.001
			v0.013L89.501,76.75z M89.539,80.958V80.91l-0.031,0.03L89.539,80.958z M89.556,80.652l0.055-0.036l-0.055,0.01V80.652z
			 M89.565,81.014l0.045-0.01V80.99l-0.045,0.006V81.014z M89.592,76.871l0.018,0v-0.019l-0.018,0.003V76.871z M89.752,80.899
			l0.083-0.077L89.79,80.78l-0.059,0.009l-0.09,0.08L89.752,80.899z M89.699,80.554l0.014-0.004v-0.018l-0.014,0.004V80.554z
			 M89.713,80.459l0.018-0.023v-0.008h-0.018V80.459z M89.731,77.23l0.016-0.004V77.21l-0.016,0.004V77.23z M89.731,81.004
			l0.016-0.001l-0.016-0.016V81.004z M89.79,81.063l0.014-0.015V81.02l-0.025,0.003v0.027L89.79,81.063z M89.824,76.834l0.028-0.004
			v-0.018l-0.028-0.004V76.834z M89.874,80.772l0.048-0.048l0.043,0.032l0.05-0.056l-0.07-0.017l-0.056,0.008l-0.045,0.056
			L89.874,80.772z M89.874,80.85l0.016-0.02l-0.038,0.008L89.874,80.85z M89.977,77.328L89.95,77.27l-0.083,0.012L89.977,77.328z
			 M89.89,77.131v-0.05l-0.016,0.03L89.89,77.131z M89.89,80.597v-0.013h-0.013L89.89,80.597z M89.959,81.01v-0.042l-0.047,0.006
			v0.046L89.959,81.01z M89.959,81.236L90,81.23l0.021-0.025l-0.028-0.051l-0.063,0.01v0.05L89.959,81.236z M90,80.095l0.016-0.019
			v-0.025l-0.034,0.032L90,80.095z M90.051,79.542h0.013l0.013-0.019l-0.025,0.002V79.542z M90.051,80.149l0.013-0.003l0.013-0.025
			l-0.025,0.003V80.149z M90.091,77.415v-0.03l-0.028,0.005L90.091,77.415z M90.091,80.584l0.011-0.018v-0.029h-0.011l-0.015,0.024
			L90.091,80.584z M90.121,80.377l0.021-0.051l-0.021,0.005l-0.018,0.035L90.121,80.377z M90.272,77.258v-0.066l-0.098,0.004
			l-0.037-0.015l-0.017,0.024l0.064,0.046L90.272,77.258z M90.121,80.634l0.054-0.008v-0.034l-0.054,0.011V80.634z M90.174,76.604
			V76.56l-0.037,0.005v0.013L90.174,76.604z M90.258,80.057l0.026-0.006l-0.035-0.056l-0.065,0.011v0.016l0.062,0.019L90.258,80.057
			z M90.195,80.143l0.018-0.003v-0.018l-0.018,0.003V80.143z M90.213,77.668l0.015-0.018v-0.019l-0.015,0.022V77.668z
			 M90.213,80.862l0.015-0.03l-0.015,0.018V80.862z M90.247,80.191l0.025-0.006v-0.026l-0.025,0.002V80.191z M90.306,77.43
			l0.028-0.006v-0.022l-0.028,0.002V77.43z M90.349,76.79l0.017-0.004v-0.054l-0.043,0.006v0.019L90.349,76.79z M90.411,80.153
			l0.026-0.028l-0.071-0.042v0.029L90.411,80.153z M90.411,77.567l0.014-0.003V77.53l-0.014,0.018V77.567z M90.592,78.751
			l0.042-0.006v-0.02l-0.042,0.006V78.751z M90.603,78.498l0.031-0.04l-0.017-0.016l-0.014,0.013V78.498z M90.685,77.541v-0.053
			l-0.051,0.01l-0.02,0.03L90.685,77.541z M90.669,78.503l0.016-0.004v-0.014l-0.016,0.002V78.503z M90.739,77.552l0.017-0.004
			v-0.015h-0.017V77.552z M90.739,77.809h0.017l-0.017-0.008V77.809z M90.858,77.598l0.029-0.006v-0.021l-0.011-0.008l-0.025,0.015
			L90.858,77.598z M91.349,79.821l0.025-0.004v-0.018l-0.025,0.006V79.821z M91.462,79.076l0.017-0.004v-0.016l-0.017,0.004V79.076z
			 M91.541,79.852l0.016-0.005l0.017-0.018l-0.017-0.014l-0.016,0.021V79.852z M91.652,77.015l0.042-0.008v-0.042l-0.022,0.003
			l-0.02,0.03V77.015z M91.746,78.045l0.019-0.003v-0.017l-0.019-0.013l-0.011,0.018L91.746,78.045z M91.858,77.278l0.027-0.001
			l-0.016-0.01h-0.011V77.278z M92.023,80.137l0.014-0.003v-0.014l-0.014-0.016V80.137z M92.072,79.786l0.025-0.003v-0.021
			l-0.025,0.005l-0.022,0.017L92.072,79.786z M92.155,80.347l0.053-0.01l0.038-0.058l-0.055-0.01l-0.077,0.012v0.018L92.155,80.347z
			 M92.367,80.047l0.017-0.002v-0.01l-0.017,0.003V80.047z M92.495,76.483l0.026-0.002V76.47l-0.026,0V76.483z M92.687,80.878
			l0.022-0.002v-0.032l-0.022,0.002l-0.017,0.018L92.687,80.878z"/>
		<path class="disabled"  d="M88.911,81.905l0.609-0.043l-0.041,0.061l-0.154,0.023l0.118,0.137l0.077-0.012l0.08,0.04l0.101-0.108l-0.079-0.157
			l1-0.158l0.052,0.042l0.038-0.056l0.44-0.072v0.21l0.182-0.03l-0.091-0.09l0.039-0.11l3.393-0.542l0.104,0.229l0.052-0.047v-0.207
			l0.893-0.144l-0.233,0.09v0.079l0.142-0.098l-0.05,0.11l0.05,0.044l0.091-0.121l0.142-0.021l0.039-0.109l2.304-0.368l0.053,0.041
			l0.053-0.005v-0.054l0.181-0.029v0.44l-0.079,0.066l0.079,0.078v1.146l-0.105,0.107v0.196l0.105-0.058v0.327L98.39,82.75
			l-0.582,0.156l0.155-0.143l0.181-0.026v-0.484l0.22-0.034v-0.039l-0.118-0.088l-0.231,0.118v-0.17l-0.052,0.009l-0.091,0.182
			l-0.247,0.156v0.145l0.206-0.177l0.234-0.036v0.191l-0.153,0.183l-0.041-0.046L97.679,82.6l-0.064,0.18l0.115,0.02v0.054
			l-0.129,0.018l-0.104-0.109l-0.118,0.018l-0.127,0.147l-0.286,0.046l0.222-0.125l0.078-0.377l0.114-0.096l0.259-0.289l-0.116-0.37
			l-0.193,0.225l-0.184-0.048V82.1l0.069,0.108l0.087-0.092l0.079-0.012v0.04l-0.217,0.15l-0.056-0.056l-0.035,0.15l-0.091,0.09
			l-0.065-0.104l-0.039,0.084l-0.143,0.179l-0.195,0.03l-0.195,0.122l-0.271,0.042v0.054l-0.208,0.135v0.065l-0.375-0.018v-0.145
			l-0.103,0.019l-0.078,0.3l-0.442,0.069v-0.233l0.14-0.165v-0.16l-0.113,0.15l-0.064-0.07l-0.105,0.019l-0.05,0.061l-0.091,0.015
			l-0.104,0.158l-0.052,0.061v0.156l0.052-0.006l0.104-0.124l0.091,0.091v0.082l-2.759,0.436l-0.063-0.103l-0.107,0.107
			l-0.231-0.198l-0.181,0.159l-0.052-0.046l-0.091,0.015v0.184l-0.144,0.022v-0.326l-0.035,0.006l-0.055-0.097l-0.154,0.029
			l-0.039-0.099l-0.052-0.032l0.194-0.083l-0.129-0.096l-0.102,0.145l-0.157-0.027l-0.127,0.021v0.054l0.181,0.007l0.104,0.178
			l0.283,0.252v0.081l-0.335,0.051v-0.127l-0.067-0.055l-0.114,0.212l-0.286,0.043l-0.115-0.058L90,84.087l-0.325,0.05l-0.053-0.044
			l-0.143,0.021v-0.129l-0.206,0.217l-1.475,0.236l-0.091-0.312l0.091-0.014v-0.157l-0.179,0.133v0.377l-0.585,0.094l-0.077-0.04
			l-0.103,0.018v-1.193l0.126,0.129l0.105-0.013l-0.129-0.188l-0.103-0.254 M95.904,83.195l-0.039,0.008l0.039-0.112l0.118-0.019
			L95.904,83.195z M96.876,82.938l-0.064,0.009l0.064-0.141v-0.14l0.09-0.12l0.105-0.019l0.052,0.164l-0.052,0.139l-0.05-0.188
			L96.876,82.938z M96.631,82.977l-0.195,0.032l0.103-0.148l0.052-0.11l0.041-0.006V82.977z M96.252,83.036l-0.05,0.011v-0.028
			L96.252,83.036z M95.008,83.222l0.184-0.146l-0.05-0.042l-0.133,0.016V83.222z M89.235,84.129l0.208-0.24v-0.092l-0.17,0.17
			l-0.206,0.188L89.235,84.129z M87.889,83.759l0.104,0.322v0.247l0.181-0.029l-0.077-0.144l-0.13-0.41L87.889,83.759z
			 M91.774,83.676v-0.055l-0.052,0.008v0.052L91.774,83.676z M95.724,82.694v0.1l0.052,0.084l0.05-0.048v-0.244l-0.155,0.021
			L95.724,82.694z M95.255,82.963l0.055-0.011v-0.038l-0.118,0.018L95.255,82.963z M96.343,82.645l-0.091-0.167v-0.104l-0.166,0.315
			L96.343,82.645z M87.384,84.021l0.181-0.21l0.053,0.174l0.088-0.196l-0.038-0.046V83.65l-0.05-0.029l-0.093,0.158l-0.196,0.146
			v0.104L87.384,84.021z M97.601,82.34V82.3l-0.053,0.01v0.04L97.601,82.34z M91.67,83.247v-0.038l-0.039,0.082L91.67,83.247z
			 M95.348,82.281l0.063-0.008L95.31,82.51l0.272,0.077l0.05-0.112l0.193-0.099v-0.223l-0.388,0.064v-0.09l0.145-0.102v-0.132
			l-0.091,0.017l-0.181,0.236v0.248L95.348,82.281z M96.343,82.152l0.143,0.056l-0.103,0.198l0.103-0.018l0.168-0.194l-0.077-0.199
			l0.129-0.227l-0.076,0.013l-0.145,0.124l-0.143,0.09V82.152z M95.063,82.431v0.183l0.079-0.013v-0.182l-0.079-0.088l-0.055,0.006
			v0.053L95.063,82.431z M90.31,83.373l0.079-0.155V83.1l0.181,0.05l0.079-0.168l-0.208,0.034l-0.208-0.099l0.052,0.251
			l-0.066,0.219L90.31,83.373z M96.887,82.248l0.133-0.126l-0.094-0.297l0.094-0.108v-0.05l-0.184,0.03l0.039,0.096v0.352
			l-0.091,0.012L96.887,82.248z M96.202,82.332l0.182-0.071l-0.182-0.111l-0.129-0.28v0.402l-0.051,0.086V82.32L96.202,82.332z
			 M94.066,82.672l0.038-0.045l-0.091-0.077l-0.077,0.145L94.066,82.672z M93.664,82.696v-0.09l-0.038,0.002v0.133L93.664,82.696z
			 M89.65,83.374l0.115-0.017l0.142-0.103V83.15l0.042-0.11l-0.092,0.015V82.81l0.066-0.168l-0.209-0.33l-0.051-0.123l-0.13,0.151
			l0.143,0.187l-0.196,0.081v0.08l0.041,0.044v0.13l-0.041,0.059v0.054l0.041-0.01l0.102-0.143v-0.054l0.091-0.21l0.106,0.219
			l-0.106,0.108l-0.051,0.228l-0.295-0.041L89.65,83.374z M90.892,83.15l0.119-0.122l-0.093-0.041l-0.053-0.091l-0.09,0.182
			L90.892,83.15z M97.782,82.037v-0.039l-0.052,0.009L97.782,82.037z M89.145,83.324v-0.246l-0.053,0.01v0.05l-0.051,0.1v0.194
			L89.145,83.324z M94.831,82.471v-0.053l-0.052,0.008v0.052L94.831,82.471z M89.39,83.337v-0.052l-0.066,0.063L89.39,83.337z
			 M87.85,83.584v-0.053l-0.052,0.06L87.85,83.584z M87.227,83.472v0.133l0.157-0.104l0.051-0.15l0.184-0.03v-0.232l-0.104,0.018
			l-0.13,0.069l-0.182,0.027v0.184L87.227,83.472z M88.329,83.401v-0.05l-0.091,0.016v0.05L88.329,83.401z M97.73,81.851
			l0.102-0.068l-0.05-0.148l-0.167,0.119L97.73,81.851z M88.809,83.222v-0.144l0.142-0.07v-0.238l-0.233,0.388L88.809,83.222z
			 M87.837,83.377l0.067-0.01l0.062-0.1l0.181-0.028l0.052-0.063l-0.103-0.085l-0.13,0.083l-0.062-0.054l0.242-0.272l-0.104-0.165
			l-0.167-0.144l-0.132,0.137l-0.038,0.201l0.038,0.085l-0.038,0.109v-0.051L87.837,83.377z M94.104,82.235l0.143-0.075v-0.079
			l-0.234,0.038V82.3L94.104,82.235z M89.39,82.934l-0.066-0.04l-0.089,0.014v0.05L89.39,82.934z M97.301,81.594l-0.049,0.008v0.025
			L97.301,81.594z M96.252,81.789v-0.028l-0.05-0.044v0.054L96.252,81.789z M90.763,82.666v-0.08l-0.052,0.007v0.078L90.763,82.666z
			 M88.329,83.05v-0.026l-0.052,0.01v0.026L88.329,83.05z M88.745,82.974l0.063-0.074v-0.056l0.102-0.118v-0.051l-0.154,0.075
			l-0.039-0.034l0.039-0.097v-0.05l0.194-0.139v-0.14l-0.091,0.013l-0.05,0.114l-0.052,0.008l-0.039-0.148l-0.039,0.003v0.639
			L88.745,82.974z M97.73,81.524l0.052-0.057v-0.053l0.091-0.065v-0.054l-0.091-0.022l-0.103,0.212v-0.056L97.73,81.524z
			 M97.548,81.554l0.053-0.111v-0.144l-0.053,0.007l-0.051,0.205L97.548,81.554z M96.11,81.787v-0.251l-0.088,0.017v0.246
			L96.11,81.787z M98.066,81.371l0.181-0.264l-0.129,0.021l-0.102,0.249L98.066,81.371z M94.908,81.874l0.063-0.337l-0.14,0.349
			L94.908,81.874z M87.085,83.121l0.091-0.014l-0.091-0.375l-0.105-0.076V82.8L87.085,83.121z M95.373,81.721l0.064-0.077
			l0.053,0.083l0.052-0.005v-0.132l-0.105-0.086l-0.127,0.165L95.373,81.721z M88.382,82.862l0.076-0.011l-0.076-0.22l-0.066,0.176
			L88.382,82.862z M87.45,82.97l0.168-0.089v-0.078l-0.143,0.114l-0.091,0.015L87.45,82.97z M89.39,82.57v-0.245l-0.118,0.018v0.287
			L89.39,82.57z M94.26,81.364l0.182-0.104l-0.053,0.161l-0.09,0.121l0.04,0.033l0.05,0.199l0.04-0.005v-0.209l0.116-0.108v-0.104
			l0.053-0.125l-0.118-0.098l-0.181,0.03l-0.102,0.12L94.26,81.364z M88.224,82.744l0.053-0.204l-0.039,0.006l-0.091,0.12
			L88.224,82.744z M96.876,81.272l-0.039,0.008v0.05L96.876,81.272z M96.436,81.395v-0.196l-0.052,0.05v0.155L96.436,81.395z
			 M95.775,81.502l0.116-0.162l0.064,0.08l0.066-0.012v-0.21l-0.298,0.13v0.178L95.775,81.502z M97.873,81.113l0.041-0.006v-0.05
			l-0.082-0.083l-0.05,0.011v0.039L97.873,81.113z M97.548,81.167v-0.104l-0.051-0.031l-0.091,0.078L97.548,81.167z M92.926,81.709
			l-0.066,0.007v0.145L92.926,81.709z M91.333,82.014v-0.053l-0.052,0.063v0.092L91.333,82.014z M89.856,82.34v-0.053l-0.052-0.028
			v0.038L89.856,82.34z M89.209,82.368l0.115-0.137l-0.052-0.044l-0.181,0.03v0.05L89.209,82.368z M95.632,81.329v-0.05l-0.05-0.046
			v0.104L95.632,81.329z M88.199,81.945l-0.052,0.06v0.128l0.052,0.096v0.128l-0.052,0.062l-0.05-0.044v-0.132l-0.104,0.017
			l-0.027,0.135l0.13,0.137l0.103-0.021l0.039-0.054l0.145-0.026v-0.338l-0.172-0.05l0.223-0.139 M92.642,81.781l0.142-0.102
			l-0.076-0.21l-0.132,0.152v0.089L92.642,81.781z M97.497,80.875v-0.042l-0.052,0.01v0.091L97.497,80.875z M87.565,82.511
			l0.053-0.1l-0.053-0.03l-0.051,0.136L87.565,82.511z M96.098,81.124l0.052-0.164l-0.04,0.006l-0.038,0.057l-0.117,0.06
			L96.098,81.124z M87.744,82.39l0.08,0.041l-0.08-0.286l-0.038,0.11L87.744,82.39z M98.39,80.733v-0.079l-0.025,0.003v0.078
			L98.39,80.733z M97.679,80.846v-0.182l-0.053,0.008v0.102L97.679,80.846z M96.343,81.058v-0.183l-0.091,0.014v0.185L96.343,81.058
			z M88.651,81.897l0.066,0.055l0.064,0.208l0.077,0.054l0.052-0.008l-0.052-0.136v-0.141 M89.948,81.845l-0.092,0.017v0.156
			L89.948,81.845z M88.615,82.214v-0.104l-0.053-0.042v0.052L88.615,82.214z M96.631,80.883l0.036-0.007l-0.036-0.098l-0.041,0.061
			L96.631,80.883z M87.384,82.164l0.051,0.188l0.13-0.176v-0.078l-0.051,0.046l-0.039,0.006 M86.957,82.322v-0.09l-0.052,0.01v0.09
			L86.957,82.322z M87.904,82.082v-0.038L87.85,82.05L87.904,82.082z"/>
		<path class="disabled"  d="M116.058,81.927l0.051-0.664l0.052,0.032v0.167l0.148-0.15V81.23l0.054-0.089l-0.09-0.098l-0.164,0.11v-1.078l0.052-0.064
			l-0.052-0.032v-0.473l0.2-0.033v-0.196l-0.099,0.112l-0.101-0.024v-3.657l0.241-0.15l-0.041-0.05l-0.2,0.032v-0.963l0.052,0.243
			l0.076-0.012l-0.076-0.14l0.1,0.039l0.049-0.063l-0.099-0.082v-0.155l-0.101-0.024v-2.486l0.052-0.065v-0.055l-0.052,0.01V71.59
			l0.432-0.068l0.051,0.073l0.088-0.098l1.117-0.177l0.09,0.098l0.189-0.03l-0.036-0.106l0.314-0.051v0.114l0.066,0.615
			l-0.115-0.147v-0.197l-0.47,0.076v-0.236l-0.038,0.006l-0.103,0.142l0.076,0.236l-0.164,0.029v0.055l0.164,0.072l0.116,0.247
			l0.139-0.022l-0.139-0.203v-0.248l0.189-0.035l0.152,0.145l-0.052,0.05l-0.074,0.222l0.166,0.046l0.038-0.136l0.049-0.006v0.137
			l-0.126,0.135v0.125l0.126,0.119v0.306l-0.087-0.22l-0.354-0.028l-0.077-0.114l-0.243-0.243l-0.38,0.187l0.19,0.18l-0.077,0.208
			l0.205-0.032l0.113-0.09l-0.077-0.083v-0.084l0.04-0.006l0.113,0.219l-0.062,0.065l0.139,0.022l0.077,0.084l-0.115,0.087
			l0.076,0.029l0.154,0.132v0.208l0.087,0.194v0.292l0.051-0.008l0.101,0.21l0.066-0.013l-0.079,0.417l-0.139,0.024v0.11
			l0.278,0.038v0.477l-0.227,0.036l-0.138-0.132l-0.154,0.023l0.129,0.109l-0.077,0.082v0.11l0.05,0.046v0.1l0.139,0.09l0.051,0.046
			l0.153-0.024V75.57l-0.104-0.095l0.104-0.114l0.074-0.012v2.971l-0.112,0.089l0.09,0.098l-0.23,0.287l0.126,0.174l-0.052,0.066
			v0.096l0.178-0.028v0.152l-0.314,0.053v0.041l-0.103,0.072v0.167l-0.102,0.06l-0.038,0.061l-0.053-0.2l-0.111,0.156l0.126,0.092
			l-0.054,0.176v0.139l0.054-0.006l0.038-0.201l0.192-0.145l0.291-0.352l0.074-0.012v0.363l-0.126,0.02l-0.063,0.078l0.189,0.098
			v0.308l-0.074,0.138l0.074,0.029v0.349l-0.049,0.065v0.151l-0.129,0.02l0.178,0.197v1.591l-0.314,0.149v-0.1l-0.153,0.024
			l0.102,0.18l0.365-0.06v0.628l-0.049,0.093v0.112l-1.167,0.185l0.153-0.163v-0.114l-0.202,0.175l-0.269,0.152 M118.406,74.015
			v0.042l-0.102-0.026v-0.126L118.406,74.015z M118.304,72.983v0.07l-0.129-0.05l-0.136,0.025l-0.103-0.084v-0.111l0.164-0.08
			l0.126,0.034l-0.188,0.084L118.304,72.983z M118.304,73.248v0.21l-0.129-0.092l-0.1-0.04v-0.04L118.304,73.248z M118.304,73.652
			v0.057l-0.025,0.002L118.304,73.652z M118.293,74.996l-0.118-0.176l-0.049,0.063v0.138L118.293,74.996z M118.279,81.223
			l-0.204-0.19l-0.087,0.016l0.138,0.156l0.153,0.202V81.223z M117.705,82.768l0.334-0.167l0.24-0.039V82.37l-0.153,0.108
			l-0.421,0.206V82.768z M118.227,78.498l-0.052,0.006v0.056l0.052-0.008V78.498z M117.886,74.293l0.102-0.014l0.087-0.073
			l-0.036-0.046l-0.243,0.036v0.166L117.886,74.293z M118.075,74.766v-0.057l-0.036,0.005v0.127L118.075,74.766z M117.937,73.614
			l-0.178,0.125l-0.101,0.016l0.279,0.136V73.614z M117.886,83.282l-0.181-0.168l0.181-0.084l-0.181-0.067l-0.047,0.047
			l-0.091,0.014l-0.036,0.064l0.14,0.074l0.113,0.192l0.103-0.014V83.282z M117.834,72.277l-0.038,0.005v0.056l0.038-0.005V72.277z
			 M117.796,78.676l-0.038,0.006l0.076,0.03L117.796,78.676z M117.428,74.772V74.7l0.216,0.077l0.115-0.31l-0.101-0.04l-0.066-0.2
			l-0.214,0.036v0.418l-0.087,0.012l-0.078-0.14l-0.124,0.022v0.098l0.202,0.162l0.24-0.04L117.428,74.772z M117.453,73.692
			l0.077-0.164l0.175,0.082v-0.112l-0.163-0.154l-0.203,0.113l-0.202-0.103v0.08l0.1,0.138l0.064,0.144L117.453,73.692z
			 M117.53,75.062l0.175-0.03v-0.085l-0.175,0.03l-0.103,0.099v0.057l0.05-0.007L117.53,75.062z M117.705,80.156l-0.139-0.061
			l-0.113,0.018l0.077-0.206l-0.153-0.06v0.222l-0.126,0.245l0.252-0.096l0.202,0.037V80.156z M117.632,73.08l-0.102-0.124
			l-0.306,0.144l-0.087-0.082l-0.049,0.006v0.198l0.1-0.06l0.342-0.054v0.1L117.632,73.08z M117.606,73.82l-0.04-0.188l-0.139,0.218
			l-0.291,0.187l0.393-0.065l0.076,0.043l-0.04,0.005L117.606,73.82z M117.606,76.124l-0.04-0.035l-0.088,0.11l0.128,0.066V76.124z
			 M117.566,76.562l-0.088,0.016v0.039l0.128-0.018L117.566,76.562z M117.606,80.884V80.76l-0.076-0.141l-0.103,0.014l-0.103-0.026
			v0.098l-0.237,0.039l-0.156-0.043l-0.353,0.277l-0.129,0.079l0.129,0.116l0.202-0.183l0.051,0.201l0.076-0.013l0.052-0.05
			l0.129-0.021l0.049,0.036l0.051-0.008V81.09l-0.127-0.093l-0.051,0.01l-0.19-0.067l0.229-0.148l0.089,0.095l0.215,0.024
			l-0.09,0.336L117.606,80.884z M117.582,79.546l-0.104-0.106l-0.05,0.105l-0.103,0.072l0.167,0.072L117.582,79.546z
			 M117.566,72.122l-0.036,0.007v0.058L117.566,72.122z M117.478,81.451l-0.241,0.04v0.052l0.053-0.008l0.087,0.042l0.189-0.03
			L117.478,81.451z M117.53,75.312l-0.052,0.01v0.054l0.052-0.008V75.312z M117.53,81.176l-0.052,0.008l0.052,0.064V81.176z
			 M117.53,82.836l-0.052,0.008l0.052,0.05V82.836z M117.325,83.538l0.128-0.02l-0.076-0.156l-0.141-0.032v-0.198l-0.227,0.038
			v0.112l0.051,0.133v0.193l0.176-0.027L117.325,83.538z M117.428,82.337l-0.05,0.008v0.096l0.05-0.005V82.337z M117.377,72.211
			l-0.052-0.104l-0.153,0.08l0.09,0.166L117.377,72.211z M117.325,81.837l-0.137,0.02l-0.051-0.142l-0.229,0.034l0.343,0.196
			L117.325,81.837z M117.325,82.884v-0.068l-0.088-0.059v-0.195l-0.049-0.047l-0.1,0.125l0.06,0.132l-0.06,0.077l-0.231-0.227
			l-0.178,0.14l-0.166,0.207l0.115,0.121l0.191,0.016l0.088-0.059l0.102,0.024l-0.05,0.01L117.325,82.884z M117.188,76.149
			l-0.051-0.145l-0.077,0.012v0.25l0.176-0.027L117.188,76.149z M117.137,81.239l-0.049,0.077v0.098l0.049-0.008V81.239z
			 M117.061,72.721v0.058l0.028-0.006L117.061,72.721z M117.088,73.849l-0.028,0.004l-0.051,0.063l0.051-0.009L117.088,73.849z
			 M117.088,79.766l-0.079,0.01v0.059l0.079-0.013V79.766z M117.088,82.39l-0.028,0.005v0.055l0.028-0.002V82.39z M117.072,81.947
			l-0.062-0.062l-0.05,0.008l-0.103-0.094l-0.049,0.009l0.049,0.158l-0.038,0.048l-0.087-0.026l-0.053,0.007l-0.1-0.193
			l-0.142,0.023v0.101l0.102,0.036v0.056l-0.15,0.064v0.045l0.62-0.097L117.072,81.947z M117.061,72.261l-0.051-0.048l-0.05,0.01
			l-0.052-0.09l-0.051,0.008l-0.038,0.103l0.19,0.084l-0.05,0.006L117.061,72.261z M117.061,72.455l-0.101-0.038l-0.14,0.024v0.054
			l0.19,0.026L117.061,72.455z M117.061,74.005l-0.241,0.04v0.096l0.241-0.041V74.005z M116.959,71.914l-0.227-0.158v0.142
			l0.227,0.073V71.914z M116.959,75.317l-0.32-0.017l0.32,0.103V75.317z M116.959,83.753v-0.1l-0.38,0.158l-0.091,0.127l0.14-0.02
			L116.959,83.753z M116.882,74.832l-0.063-0.06l0.088-0.072v-0.054l-0.126,0.018l-0.102,0.13l0.14,0.116L116.882,74.832z
			 M116.908,82.363V82.28l-0.229,0.12l0.165,0.044L116.908,82.363z M116.87,83.374l-0.062-0.17l-0.076,0.012l0.087,0.139v0.098
			L116.87,83.374z M116.781,81.295l-0.241,0.039v0.126l0.279-0.046L116.781,81.295z M116.362,76.115l-0.075-0.184l0.15,0.031
			l0.102,0.082l0.04-0.049l0.202-0.088v-0.04l-0.202,0.03l-0.091-0.11l-0.098,0.018l-0.118-0.04l-0.112,0.144v0.195l0.1,0.096
			L116.362,76.115z M116.767,82.556l-0.188-0.029v0.043l0.1,0.08L116.767,82.556z M116.679,73.242v0.043l0.053-0.008L116.679,73.242
			z M116.732,73.709l-0.192,0.03l0.04,0.051l0.153-0.025V73.709z M116.732,74.42l-0.142-0.104l0.088-0.079v-0.071l-0.202,0.031
			l0.076,0.309l0.18-0.026V74.42z M116.679,72.169v-0.042l-0.051,0.007l-0.088,0.097v0.058l0.04-0.006L116.679,72.169z
			 M116.679,72.518l-0.1,0.015l-0.04,0.063l0.063,0.087L116.679,72.518z M116.488,77.53v0.068l0.14-0.02L116.488,77.53z
			 M116.54,79.238l-0.052,0.01l0.052,0.048l0.088-0.014L116.54,79.238z M116.628,80.816l-0.049,0.01l-0.04,0.062l0.04-0.01
			L116.628,80.816z M116.553,81.524l-0.115-0.107l-0.048,0.068v0.194l0.048-0.006L116.553,81.524z M116.54,74.605l-0.052,0.007
			l-0.05,0.066l0.102-0.018V74.605z M115.981,82.708l0.05,0.049l0.129-0.023l0.1-0.069l0.13-0.022l0.048,0.049l-0.048,0.061
			l-0.13,0.022v0.114l0.13,0.006l0.15-0.166v-0.109l-0.052-0.032V82.43l-0.328,0.054l-0.077,0.193l-0.102-0.22 M116.514,77.833
			l-0.076-0.14l-0.216,0.118l0.128,0.121l0.088-0.013L116.514,77.833z M116.39,72.621l-0.041,0.006v0.055l0.088-0.015L116.39,72.621
			z M116.438,83.318l-0.088-0.042l-0.041,0.063l0.129,0.034V83.318z M116.413,74.123l-0.153-0.03v0.043l0.049,0.033l0.041,0.119
			L116.413,74.123z M116.35,83.137l0.052-0.09l-0.293,0.127l0.101,0.028L116.35,83.137z M116.39,71.658l-0.082,0.01v0.03
			l0.082-0.012V71.658z M116.39,72.427l-0.181,0.025v0.057l0.099-0.014L116.39,72.427z M116.39,73.862l-0.181,0.03v0.095
			l0.181-0.026V73.862z M116.006,82.214l0.064-0.081l0.217-0.102l0.062-0.096v-0.054l-0.14,0.077l-0.139,0.021 M116.16,80.796v0.094
			l0.148-0.024L116.16,80.796z M116.309,82.208l-0.099,0.016l-0.049,0.064l0.049-0.008L116.309,82.208z M116.26,73.574v-0.042
			l-0.1,0.06l0.049,0.035L116.26,73.574z M116.07,83.573l0.189-0.088l-0.151-0.112l-0.077,0.008l0.039,0.052v0.04 M116.16,84.018
			l-0.09,0.016v0.054l0.09-0.012V84.018z M116.07,83.015l-0.039,0.004v0.057L116.07,83.015z"/>
		<path class="disabled"  d="M118.343,61.369l-0.05,0.665l-0.049-0.034v-0.166l-0.154,0.148v0.083l-0.05,0.094l0.087,0.099l0.167-0.111v1.073
			l-0.049,0.062l0.049,0.037v0.475l-0.204,0.032v0.194l0.1-0.113l0.104,0.026v3.656l-0.243,0.151l0.039,0.05l0.204-0.032v0.962
			l-0.049-0.242l-0.079,0.011l0.079,0.141l-0.103-0.038l-0.052,0.062l0.1,0.082v0.154l0.104,0.025v2.486l-0.049,0.064v0.056
			l0.049-0.01v0.194l-0.435,0.071l-0.05-0.077l-0.088,0.101l-1.116,0.18l-0.089-0.098l-0.191,0.028l0.04,0.106l-0.318,0.051v-0.111
			l-0.063-0.617l0.115,0.148v0.196l0.468-0.076v0.237l0.039-0.006l0.103-0.14l-0.077-0.238l0.163-0.029v-0.056l-0.163-0.07
			l-0.115-0.249l-0.136,0.022l0.136,0.202v0.25l-0.191,0.032l-0.151-0.144l0.05-0.05l0.077-0.222l-0.165-0.04l-0.038,0.129
			l-0.052,0.006v-0.136l0.127-0.133v-0.13l-0.127-0.116V70.42l0.09,0.224l0.357,0.028l0.073,0.114l0.244,0.238l0.38-0.186
			l-0.192-0.179l0.077-0.21l-0.203,0.032l-0.114,0.09l0.076,0.083v0.085l-0.041,0.005l-0.112-0.219l0.065-0.066l-0.142-0.021
			l-0.076-0.084l0.112-0.089l-0.076-0.026l-0.151-0.132V69.9l-0.09-0.194v-0.294l-0.05,0.011l-0.101-0.207l-0.063,0.008l0.077-0.415
			l0.137-0.026v-0.11l-0.279-0.038v-0.477l0.229-0.036l0.14,0.132l0.151-0.025l-0.126-0.104l0.076-0.084v-0.11l-0.052-0.05v-0.095
			l-0.139-0.089l-0.05-0.049l-0.153,0.023v0.059l0.102,0.092l-0.102,0.117l-0.076,0.012v-2.975l0.116-0.086l-0.09-0.098l0.229-0.288
			l-0.127-0.172l0.05-0.067V64.17l-0.178,0.026v-0.152l0.318-0.05v-0.047l0.099-0.071v-0.166l0.103-0.059l0.039-0.062l0.052,0.2
			l0.112-0.156l-0.127-0.092l0.053-0.176v-0.139l-0.053,0.01l-0.037,0.2l-0.19,0.144l-0.293,0.353l-0.076,0.013v-0.363l0.127-0.02
			l0.064-0.082l-0.192-0.096v-0.307l0.076-0.136l-0.076-0.03v-0.35l0.052-0.063v-0.151l0.126-0.022l-0.178-0.195V60.54l0.318-0.15
			v0.097l0.151-0.024l-0.101-0.178l-0.369,0.058v-0.627l0.052-0.092v-0.111l1.167-0.189l-0.151,0.163v0.112l0.205-0.172l0.267-0.154
			 M115.992,69.283v-0.042l0.104,0.028v0.124L115.992,69.283z M116.096,70.317v-0.072l0.126,0.05l0.141-0.023l0.099,0.083v0.112
			l-0.163,0.081l-0.127-0.036l0.191-0.085L116.096,70.317z M116.096,70.049V69.84l0.126,0.092l0.101,0.041v0.042L116.096,70.049z
			 M116.096,69.646V69.59l0.024-0.004L116.096,69.646z M116.108,68.305l0.113,0.174l0.051-0.063v-0.138L116.108,68.305z
			 M116.12,62.077l0.203,0.191l0.09-0.015l-0.14-0.162l-0.153-0.196V62.077z M116.693,60.534l-0.331,0.164l-0.243,0.04v0.194
			l0.153-0.108l0.42-0.206V60.534z M116.171,64.804l0.05-0.01v-0.054l-0.05,0.01V64.804z M116.514,69.005l-0.101,0.019l-0.09,0.067
			l0.04,0.053l0.241-0.04v-0.167L116.514,69.005z M116.323,68.535v0.053l0.04-0.006v-0.124L116.323,68.535z M116.461,69.685
			l0.178-0.125l0.105-0.02l-0.283-0.135V69.685z M116.514,60.015l0.179,0.168l-0.179,0.086l0.179,0.066l0.052-0.048l0.087-0.014
			l0.038-0.062l-0.137-0.077l-0.118-0.191l-0.101,0.02V60.015z M116.564,71.021l0.039-0.003v-0.058l-0.039,0.005V71.021z
			 M116.603,64.62l0.037-0.002l-0.076-0.03L116.603,64.62z M116.971,68.526v0.072l-0.215-0.078l-0.116,0.312l0.105,0.038l0.063,0.2
			l0.211-0.036v-0.418l0.091-0.013l0.077,0.142l0.127-0.02v-0.101l-0.205-0.16l-0.241,0.038L116.971,68.526z M116.947,69.606
			l-0.077,0.166l-0.177-0.08v0.11l0.164,0.154l0.204-0.117l0.202,0.104v-0.08l-0.101-0.138l-0.063-0.142L116.947,69.606z
			 M116.87,68.237l-0.177,0.029v0.084l0.177-0.03l0.101-0.101v-0.055l-0.051,0.01L116.87,68.237z M116.693,63.142l0.139,0.061
			l0.115-0.018l-0.077,0.209l0.15,0.061V63.23l0.129-0.246l-0.251,0.098l-0.205-0.038V63.142z M116.767,70.22l0.103,0.127
			l0.303-0.15l0.09,0.086l0.053-0.008v-0.196l-0.104,0.059l-0.342,0.054v-0.098L116.767,70.22z M116.791,69.478l0.041,0.188
			l0.139-0.219l0.292-0.183l-0.393,0.062l-0.079-0.042l0.041-0.006L116.791,69.478z M116.791,67.175l0.041,0.034l0.088-0.109
			l-0.129-0.063V67.175z M116.832,66.736l0.088-0.015v-0.043l-0.129,0.021L116.832,66.736z M116.791,62.412v0.13l0.079,0.14
			l0.101-0.018l0.102,0.028v-0.101l0.243-0.039l0.151,0.044l0.355-0.278l0.126-0.079l-0.126-0.12l-0.201,0.187l-0.05-0.2
			l-0.079,0.011l-0.053,0.052l-0.124,0.02l-0.053-0.032l-0.05,0.006v0.04l0.127,0.094l0.052-0.01l0.191,0.07l-0.23,0.146
			l-0.09-0.097l-0.214-0.02l0.089-0.338L116.791,62.412z M116.819,63.75l0.101,0.112l0.051-0.108l0.102-0.072l-0.165-0.072
			L116.819,63.75z M116.832,71.175l0.038-0.008v-0.054L116.832,71.175z M116.92,61.851l0.241-0.04v-0.056l-0.05,0.007l-0.091-0.042
			l-0.188,0.034L116.92,61.851z M116.87,67.983l0.05-0.007v-0.054l-0.05,0.01V67.983z M116.87,62.122l0.05-0.006l-0.05-0.062V62.122
			z M116.87,60.461l0.05-0.01l-0.05-0.045V60.461z M117.073,59.759l-0.126,0.02l0.073,0.155l0.142,0.035v0.195l0.23-0.039v-0.11
			l-0.052-0.131v-0.196l-0.178,0.029L117.073,59.759z M116.971,60.961l0.049-0.006v-0.097l-0.049,0.007V60.961z M117.02,71.087
			l0.053,0.107l0.152-0.081l-0.087-0.17L117.02,71.087z M117.073,61.46l0.139-0.022l0.05,0.144l0.23-0.036l-0.344-0.194
			L117.073,61.46z M117.073,60.414v0.072l0.088,0.055v0.198l0.051,0.044l0.104-0.126l-0.064-0.128l0.064-0.083l0.227,0.229
			l0.177-0.14l0.167-0.207l-0.116-0.122l-0.188-0.011l-0.09,0.055l-0.101-0.024l0.048-0.01L117.073,60.414z M117.212,67.148
			l0.05,0.145l0.077-0.012v-0.25l-0.178,0.03L117.212,67.148z M117.262,62.059l0.053-0.077v-0.097l-0.053,0.006V62.059z
			 M117.339,70.577v-0.058l-0.024,0.005L117.339,70.577z M117.315,69.452l0.024-0.006l0.052-0.064l-0.052,0.006L117.315,69.452z
			 M117.315,63.531l0.076-0.012v-0.056l-0.076,0.013V63.531z M117.315,60.905l0.024-0.005v-0.053l-0.024,0.004V60.905z
			 M117.327,61.351l0.064,0.06l0.048-0.008l0.104,0.095l0.049-0.006l-0.049-0.159l0.04-0.05l0.088,0.028l0.049-0.008l0.103,0.192
			l0.142-0.022v-0.097l-0.105-0.04v-0.056l0.154-0.067v-0.041l-0.621,0.101L117.327,61.351z M117.339,71.037l0.052,0.048l0.048-0.01
			l0.053,0.09l0.05-0.01l0.04-0.1l-0.191-0.081l0.048-0.011L117.339,71.037z M117.339,70.843l0.1,0.039l0.143-0.021v-0.058
			l-0.191-0.026L117.339,70.843z M117.339,69.291l0.243-0.038v-0.097l-0.243,0.037V69.291z M117.439,71.384l0.231,0.159v-0.142
			l-0.231-0.073V71.384z M117.439,67.978l0.32,0.018l-0.32-0.103V67.978z M117.439,59.546v0.098l0.383-0.163l0.09-0.125
			l-0.142,0.024L117.439,59.546z M117.519,68.466l0.063,0.061l-0.09,0.072v0.052l0.129-0.02l0.098-0.125l-0.137-0.118
			L117.519,68.466z M117.492,60.935v0.083l0.227-0.124l-0.164-0.04L117.492,60.935z M117.53,59.923l0.062,0.17l0.079-0.012
			l-0.088-0.137v-0.099L117.53,59.923z M117.621,62.003l0.237-0.041v-0.124l-0.276,0.044L117.621,62.003z M118.039,67.183
			l0.076,0.186l-0.151-0.034l-0.105-0.08l-0.036,0.047l-0.201,0.086v0.043l0.201-0.03l0.09,0.111l0.101-0.02l0.114,0.039
			l0.118-0.144v-0.194l-0.103-0.097L118.039,67.183z M117.632,60.744l0.189,0.026v-0.042l-0.103-0.081L117.632,60.744z
			 M117.719,70.056v-0.041l-0.049,0.005L117.719,70.056z M117.67,69.59l0.188-0.03l-0.036-0.053l-0.151,0.025V69.59z M117.67,68.877
			l0.137,0.1l-0.088,0.087v0.071l0.205-0.035l-0.076-0.308l-0.178,0.028V68.877z M117.719,71.129v0.042l0.051-0.01l0.088-0.094
			v-0.056l-0.036,0.006L117.719,71.129z M117.719,70.781l0.103-0.016l0.036-0.064l-0.062-0.085L117.719,70.781z M117.912,65.768
			v-0.073l-0.142,0.024L117.912,65.768z M117.858,64.057l0.054-0.007l-0.054-0.049l-0.088,0.016L117.858,64.057z M117.77,62.48
			l0.052-0.006l0.036-0.065l-0.036,0.007L117.77,62.48z M117.848,61.769l0.115,0.108l0.049-0.063v-0.197l-0.049,0.01L117.848,61.769
			z M117.858,68.69l0.054-0.006l0.052-0.066l-0.105,0.019V68.69z M118.419,60.587l-0.05-0.046l-0.125,0.019l-0.103,0.072
			l-0.129,0.021l-0.049-0.047l0.049-0.064l0.129-0.021v-0.11l-0.129-0.005l-0.154,0.16v0.114l0.054,0.034v0.152l0.332-0.055
			l0.07-0.191l0.105,0.218 M117.886,65.465l0.077,0.141l0.211-0.121l-0.125-0.12l-0.087,0.016L117.886,65.465z M118.012,70.679
			l0.038-0.006v-0.058l-0.087,0.016L118.012,70.679z M117.963,59.98l0.087,0.041l0.039-0.062l-0.126-0.036V59.98z M117.988,69.173
			l0.153,0.032v-0.043l-0.052-0.031l-0.039-0.121L117.988,69.173z M118.05,60.16l-0.049,0.092l0.292-0.133l-0.104-0.021
			L118.05,60.16z M118.012,71.641l0.077-0.011v-0.029l-0.077,0.012V71.641z M118.012,70.874l0.177-0.029V70.79l-0.1,0.017
			L118.012,70.874z M118.012,69.436l0.177-0.03v-0.096l-0.177,0.027V69.436z M118.394,61.082l-0.063,0.08l-0.216,0.105l-0.064,0.092
			v0.059l0.139-0.079l0.142-0.024 M118.244,62.502v-0.099l-0.154,0.026L118.244,62.502z M118.089,61.09l0.1-0.018l0.055-0.064
			l-0.055,0.01L118.089,61.09z M118.141,69.724v0.042l0.103-0.06l-0.055-0.034L118.141,69.724z M118.331,59.723l-0.189,0.088
			l0.152,0.114l0.076-0.012l-0.038-0.05v-0.042 M118.244,59.277l0.087-0.013v-0.056l-0.087,0.014V59.277z M118.331,60.281
			l0.038-0.006V60.22L118.331,60.281z"/>
		<path class="disabled"  d="M54.689,91.696l0.05-0.657l0.048,0.032v0.167l0.153-0.147v-0.086l0.053-0.093l-0.09-0.097l-0.164,0.109v-1.066
			l0.048-0.065l-0.048-0.032v-0.471l0.201-0.032v-0.197l-0.098,0.115l-0.103-0.026v-3.633l0.24-0.152l-0.039-0.05l-0.201,0.032
			v-0.957l0.048,0.244l0.079-0.014l-0.079-0.14l0.101,0.04l0.052-0.064l-0.098-0.081v-0.151l-0.103-0.028v-2.469l0.048-0.062v-0.054
			l-0.048,0.005v-0.195l0.429-0.069l0.05,0.074l0.091-0.098l1.116-0.177l0.091,0.096l0.189-0.029l-0.04-0.104l0.317-0.052v0.112
			l0.064,0.613l-0.113-0.146v-0.194l-0.473,0.074v-0.237l-0.036,0.007l-0.101,0.14l0.076,0.24l-0.163,0.026v0.054l0.163,0.072
			l0.116,0.245l0.135-0.022l-0.135-0.203v-0.246l0.189-0.032l0.153,0.143l-0.052,0.05l-0.077,0.22l0.165,0.044l0.04-0.133
			l0.049-0.01v0.143l-0.125,0.129v0.125l0.125,0.118v0.307l-0.088-0.223l-0.357-0.026l-0.076-0.113l-0.241-0.237l-0.378,0.185
			l0.191,0.178l-0.077,0.206l0.203-0.034l0.114-0.086l-0.076-0.081v-0.087l0.041-0.008l0.112,0.223l-0.063,0.063l0.139,0.021
			l0.076,0.082l-0.114,0.09l0.074,0.027l0.154,0.129v0.21l0.09,0.194v0.288l0.05-0.008l0.103,0.206l0.062-0.008l-0.077,0.413
			l-0.137,0.022v0.112l0.277,0.038v0.471l-0.227,0.036l-0.14-0.128l-0.154,0.023l0.13,0.104l-0.076,0.083v0.109l0.048,0.048v0.096
			l0.142,0.091l0.05,0.045l0.153-0.024v-0.056l-0.102-0.091l0.102-0.114l0.074-0.012v2.952l-0.112,0.091l0.087,0.094l-0.229,0.286
			l0.129,0.177l-0.052,0.062v0.1l0.176-0.029v0.151l-0.317,0.05v0.042l-0.102,0.073v0.167l-0.103,0.056l-0.036,0.061l-0.052-0.198
			l-0.113,0.155l0.127,0.09l-0.052,0.177v0.138l0.052-0.01l0.038-0.2l0.19-0.141l0.293-0.352l0.074-0.01v0.358l-0.125,0.019
			L56.795,89.6l0.189,0.096V90l-0.074,0.138l0.074,0.031v0.347l-0.049,0.061v0.155l-0.127,0.018l0.176,0.194v1.583l-0.317,0.146
			v-0.097l-0.15,0.024l0.1,0.175l0.367-0.057v0.625l-0.049,0.092v0.11l-1.169,0.187l0.153-0.162v-0.11l-0.203,0.168l-0.267,0.153
			 M57.037,83.833v0.043l-0.102-0.028v-0.126L57.037,83.833z M56.935,82.806v0.07l-0.127-0.05l-0.141,0.024l-0.102-0.08v-0.114
			l0.166-0.08l0.129,0.036l-0.192,0.083L56.935,82.806z M56.935,83.071v0.208l-0.127-0.09l-0.101-0.041v-0.041L56.935,83.071z
			 M56.935,83.472v0.056l-0.025,0.005L56.935,83.472z M56.921,84.805l-0.113-0.173l-0.051,0.063v0.138L56.921,84.805z M56.91,90.997
			l-0.203-0.19l-0.09,0.014l0.14,0.158l0.153,0.198V90.997z M56.336,92.533l0.331-0.167l0.243-0.037v-0.196l-0.153,0.106
			l-0.42,0.206V92.533z M56.859,88.287l-0.052,0.007v0.054l0.052-0.006V88.287z M56.517,84.11l0.1-0.017l0.09-0.072l-0.04-0.047
			l-0.241,0.04v0.166L56.517,84.11z M56.707,84.578v-0.056l-0.04,0.007v0.125L56.707,84.578z M56.565,83.435l-0.177,0.126
			l-0.101,0.013l0.278,0.135V83.435z M56.517,93.043l-0.181-0.164l0.181-0.084l-0.181-0.068l-0.049,0.046l-0.09,0.017l-0.038,0.059
			l0.14,0.077l0.115,0.19l0.102-0.017V93.043z M56.462,82.105l-0.036,0.004v0.056l0.036-0.005V82.105z M56.426,88.467l-0.038,0.005
			l0.074,0.029L56.426,88.467z M56.059,84.585v-0.069l0.215,0.074l0.115-0.308l-0.101-0.041l-0.066-0.195l-0.211,0.032v0.417
			l-0.091,0.015l-0.076-0.142l-0.127,0.022v0.094l0.203,0.166l0.241-0.04L56.059,84.585z M56.085,83.512l0.074-0.167l0.177,0.084
			v-0.11l-0.163-0.154l-0.204,0.114l-0.205-0.104v0.084l0.101,0.134l0.064,0.145L56.085,83.512z M56.16,84.875l0.177-0.03v-0.08
			l-0.177,0.026l-0.101,0.098v0.058l0.049-0.011L56.16,84.875z M56.336,89.938l-0.139-0.062l-0.112,0.02l0.074-0.206l-0.15-0.061
			v0.22l-0.128,0.245l0.254-0.096l0.201,0.033V89.938z M56.261,82.902L56.16,82.78l-0.303,0.142l-0.091-0.08l-0.05,0.008v0.191
			l0.102-0.056l0.342-0.054v0.096L56.261,82.902z M56.238,83.641l-0.041-0.188l-0.139,0.217l-0.293,0.184l0.394-0.063l0.079,0.042
			l-0.041,0.009L56.238,83.641z M56.238,85.932l-0.041-0.038l-0.089,0.112l0.13,0.064V85.932z M56.197,86.364l-0.089,0.016v0.042
			l0.13-0.022L56.197,86.364z M56.238,90.659v-0.122l-0.079-0.142l-0.101,0.016l-0.102-0.024v0.096l-0.241,0.039l-0.153-0.044
			l-0.355,0.279l-0.126,0.077l0.126,0.116l0.202-0.184l0.049,0.201l0.079-0.012l0.053-0.05l0.125-0.021l0.05,0.033l0.052-0.009
			v-0.041l-0.127-0.091l-0.049,0.006l-0.192-0.066l0.23-0.146l0.087,0.096l0.217,0.023l-0.091,0.333L56.238,90.659z M56.21,89.333
			l-0.102-0.11l-0.049,0.108l-0.102,0.07l0.165,0.069L56.21,89.333z M56.197,81.953l-0.038,0.006v0.058L56.197,81.953z
			 M56.108,91.222l-0.241,0.038v0.058l0.052-0.008l0.091,0.04l0.188-0.032L56.108,91.222z M56.16,85.124l-0.052,0.007v0.056
			l0.052-0.01V85.124z M56.16,90.949l-0.052,0.011l0.052,0.062V90.949z M56.16,92.601l-0.052,0.009l0.052,0.047V92.601z
			 M55.957,93.301l0.129-0.021l-0.076-0.156l-0.143-0.032v-0.194l-0.226,0.037v0.114l0.049,0.128v0.194l0.177-0.026L55.957,93.301z
			 M56.059,92.104l-0.049,0.009v0.096l0.049-0.008V92.104z M56.01,82.041l-0.053-0.106l-0.152,0.082l0.087,0.164L56.01,82.041z
			 M55.957,91.607l-0.139,0.02l-0.052-0.144l-0.229,0.038l0.345,0.194L55.957,91.607z M55.957,92.649v-0.072l-0.09-0.054v-0.194
			l-0.049-0.049l-0.102,0.127l0.063,0.132l-0.063,0.078l-0.229-0.228l-0.177,0.141l-0.167,0.205l0.115,0.121l0.19,0.012l0.088-0.056
			l0.104,0.026l-0.051,0.006L55.957,92.649z M55.817,85.956l-0.052-0.144l-0.076,0.011v0.249l0.177-0.029L55.817,85.956z
			 M55.766,91.011l-0.05,0.081v0.093l0.05-0.005V91.011z M55.69,82.55v0.052l0.025-0.001L55.69,82.55z M55.715,83.669l-0.025,0.002
			l-0.049,0.066l0.049-0.01L55.715,83.669z M55.715,89.552l-0.074,0.012v0.055l0.074-0.013V89.552z M55.715,92.158l-0.025,0.003
			v0.058l0.025-0.004V92.158z M55.703,91.718l-0.062-0.061l-0.051,0.006l-0.104-0.092l-0.048,0.006l0.048,0.159l-0.038,0.047
			l-0.09-0.026l-0.049,0.008l-0.103-0.191l-0.142,0.022v0.094l0.103,0.04v0.056l-0.151,0.068v0.04l0.624-0.098L55.703,91.718z
			 M55.69,82.091l-0.049-0.047l-0.051,0.01l-0.053-0.092l-0.05,0.01l-0.038,0.102l0.192,0.08l-0.051,0.011L55.69,82.091z
			 M55.69,82.286l-0.1-0.042l-0.142,0.023v0.055l0.192,0.028L55.69,82.286z M55.69,83.823l-0.241,0.04v0.096l0.241-0.04V83.823z
			 M55.59,81.747l-0.231-0.158v0.138l0.231,0.075V81.747z M55.59,85.131l-0.317-0.02l0.317,0.104V85.131z M55.59,93.511v-0.098
			l-0.383,0.157l-0.09,0.126l0.141-0.021L55.59,93.511z M55.51,84.645l-0.062-0.06l0.088-0.069v-0.055l-0.127,0.016l-0.1,0.127
			l0.139,0.119L55.51,84.645z M55.537,92.13v-0.082l-0.227,0.118l0.166,0.046L55.537,92.13z M55.498,93.137l-0.059-0.171
			l-0.08,0.012l0.09,0.139v0.098L55.498,93.137z M55.41,91.069l-0.241,0.038v0.126l0.28-0.044L55.41,91.069z M54.993,85.922
			l-0.079-0.182l0.151,0.029l0.103,0.081l0.039-0.048l0.202-0.086v-0.042l-0.202,0.032l-0.09-0.109l-0.101,0.016l-0.114-0.04
			l-0.116,0.146v0.195l0.101,0.094L54.993,85.922z M55.397,92.319l-0.189-0.022v0.039l0.103,0.084L55.397,92.319z M55.31,83.066
			v0.042l0.049-0.008L55.31,83.066z M55.359,83.531l-0.19,0.03l0.039,0.05l0.151-0.024V83.531z M55.359,84.238l-0.14-0.102
			l0.091-0.084v-0.068l-0.204,0.032l0.075,0.309l0.178-0.03V84.238z M55.31,81.999v-0.041l-0.052,0.008l-0.09,0.096v0.058
			l0.039-0.008L55.31,81.999z M55.31,82.345l-0.103,0.016l-0.039,0.063l0.064,0.085L55.31,82.345z M55.118,87.327v0.071l0.141-0.021
			L55.118,87.327z M55.168,89.029l-0.051,0.008l0.051,0.043l0.09-0.013L55.168,89.029z M55.258,90.596l-0.051,0.005l-0.039,0.064
			l0.039-0.006L55.258,90.596z M55.181,91.299l-0.115-0.104l-0.049,0.061v0.195l0.049-0.009L55.181,91.299z M55.168,84.419
			l-0.051,0.011l-0.052,0.06l0.103-0.014V84.419z M54.61,92.473l0.052,0.047l0.125-0.021l0.101-0.068l0.129-0.021l0.049,0.046
			l-0.049,0.063l-0.129,0.019v0.112l0.129,0.006l0.151-0.16v-0.111l-0.051-0.037v-0.153l-0.331,0.054l-0.074,0.193l-0.103-0.22
			 M55.143,87.629l-0.077-0.14l-0.211,0.119l0.125,0.118l0.087-0.015L55.143,87.629z M55.017,82.448l-0.038,0.005v0.056l0.087-0.013
			L55.017,82.448z M55.066,93.08l-0.087-0.042l-0.039,0.062l0.126,0.038V93.08z M55.042,83.938l-0.154-0.027v0.041l0.052,0.033
			l0.039,0.121L55.042,83.938z M54.979,92.9l0.051-0.089l-0.291,0.128l0.103,0.024L54.979,92.9z M55.017,81.491l-0.077,0.012v0.029
			l0.077-0.012V81.491z M55.017,82.254l-0.175,0.027v0.056l0.098-0.016L55.017,82.254z M55.017,83.683l-0.175,0.027v0.1l0.175-0.031
			V83.683z M54.637,91.984l0.062-0.08l0.216-0.102l0.064-0.096v-0.053l-0.137,0.077l-0.143,0.022 M54.787,90.573v0.098l0.153-0.026
			L54.787,90.573z M54.94,91.976l-0.098,0.016l-0.055,0.064l0.055-0.008L54.94,91.976z M54.888,83.399v-0.042l-0.101,0.058
			l0.055,0.031L54.888,83.399z M54.699,93.334l0.189-0.086l-0.149-0.113l-0.077,0.011l0.037,0.047v0.043 M54.787,93.777
			l-0.088,0.016v0.054l0.088-0.013V93.777z M54.699,92.776l-0.037,0.006v0.059L54.699,92.776z"/>
		<path class="disabled"  d="M56.972,71.264l-0.051,0.658l-0.049-0.031v-0.165l-0.151,0.146v0.084l-0.054,0.092l0.09,0.096l0.164-0.108v1.069
			l-0.049,0.063l0.049,0.034v0.468l-0.2,0.035v0.194l0.099-0.112l0.101,0.024v3.638l-0.241,0.149l0.041,0.047l0.2-0.034v0.959
			l-0.049-0.241l-0.077,0.012l0.077,0.141l-0.101-0.039l-0.05,0.062l0.099,0.083v0.151l0.101,0.025v2.472l-0.049,0.063v0.054
			l0.049-0.007v0.195l-0.43,0.068l-0.052-0.074l-0.088,0.096l-1.117,0.18l-0.09-0.096l-0.189,0.028l0.039,0.107l-0.317,0.05v-0.11
			l-0.066-0.613l0.116,0.146v0.194l0.468-0.074v0.236l0.038-0.006l0.103-0.144l-0.077-0.236l0.165-0.027V81.21l-0.165-0.069
			l-0.115-0.246l-0.137,0.023l0.137,0.198v0.252l-0.189,0.028l-0.152-0.14l0.052-0.052l0.074-0.22l-0.166-0.042l-0.037,0.132
			l-0.05,0.005v-0.137l0.126-0.132v-0.126l-0.126-0.116v-0.304l0.087,0.222l0.354,0.026l0.077,0.11l0.244,0.24l0.378-0.187
			l-0.19-0.176l0.077-0.207l-0.206,0.032l-0.112,0.088l0.077,0.083v0.083l-0.04,0.006l-0.113-0.22l0.063-0.062l-0.14-0.02
			l-0.077-0.086l0.118-0.09l-0.079-0.026l-0.153-0.131v-0.207l-0.088-0.195V79.26l-0.051,0.01l-0.101-0.205l-0.063,0.012
			l0.076-0.417l0.139-0.023v-0.111l-0.278-0.037v-0.473l0.227-0.034l0.139,0.128l0.153-0.024l-0.129-0.104l0.077-0.082v-0.11
			l-0.05-0.048v-0.096l-0.139-0.09l-0.051-0.048L54.75,77.53v0.056l0.104,0.095l-0.104,0.113l-0.074,0.014v-2.957l0.112-0.085
			l-0.09-0.099l0.23-0.285l-0.126-0.174l0.052-0.067v-0.094l-0.178,0.028v-0.151l0.317-0.05V73.83l0.1-0.074v-0.164l0.102-0.056
			l0.038-0.063l0.05,0.198l0.114-0.154l-0.124-0.09l0.051-0.178v-0.137l-0.051,0.009l-0.041,0.199l-0.191,0.14l-0.292,0.355
			l-0.074,0.012v-0.36l0.126-0.02l0.063-0.081l-0.189-0.094v-0.304l0.074-0.138l-0.074-0.03v-0.347l0.05-0.063v-0.153l0.128-0.02
			l-0.178-0.195v-1.579l0.317-0.15v0.098l0.15-0.024l-0.101-0.18l-0.366,0.062v-0.626l0.05-0.09v-0.109l1.166-0.189l-0.152,0.16
			v0.112l0.204-0.172l0.266-0.151 M54.626,79.132v-0.038l0.101,0.022v0.126L54.626,79.132z M54.727,80.159v-0.071l0.128,0.048
			l0.139-0.024l0.1,0.081v0.113l-0.164,0.082l-0.126-0.036l0.191-0.088L54.727,80.159z M54.727,79.895v-0.209l0.128,0.089l0.1,0.042
			v0.04L54.727,79.895z M54.727,79.49v-0.053l0.024-0.006L54.727,79.49z M54.739,78.159l0.115,0.174l0.049-0.064v-0.137
			L54.739,78.159z M54.75,71.97l0.204,0.188l0.088-0.014l-0.139-0.158l-0.153-0.198V71.97z M55.324,70.436l-0.331,0.161
			l-0.243,0.039v0.194l0.153-0.108l0.421-0.206V70.436z M54.802,74.679l0.052-0.011v-0.051l-0.052,0.008V74.679z M55.143,78.857
			l-0.101,0.015l-0.088,0.072l0.039,0.048l0.24-0.04v-0.168L55.143,78.857z M54.954,78.388v0.055l0.039-0.005v-0.124L54.954,78.388z
			 M55.093,79.53l0.181-0.125l0.1-0.016l-0.28-0.139V79.53z M55.143,69.922l0.181,0.166l-0.181,0.085l0.181,0.069l0.049-0.052
			l0.09-0.016l0.035-0.058l-0.139-0.077l-0.113-0.192l-0.103,0.018V69.922z M55.195,80.858l0.038-0.006v-0.055l-0.038,0.007V80.858z
			 M55.233,74.499l0.041-0.005l-0.079-0.03L55.233,74.499z M55.602,78.381v0.068l-0.216-0.074l-0.112,0.307l0.1,0.041l0.066,0.196
			l0.213-0.034v-0.417l0.088-0.012l0.077,0.141l0.126-0.021v-0.099l-0.204-0.161l-0.242,0.039L55.602,78.381z M55.576,79.451
			l-0.078,0.167l-0.174-0.081v0.111l0.163,0.152l0.203-0.116l0.202,0.106v-0.082l-0.1-0.136l-0.064-0.142L55.576,79.451z
			 M55.498,78.091l-0.174,0.029v0.08l0.174-0.028l0.104-0.097v-0.056l-0.05,0.008L55.498,78.091z M55.324,73.028l0.139,0.062
			l0.113-0.021l-0.078,0.209l0.154,0.058v-0.222l0.126-0.243l-0.252,0.096l-0.202-0.036V73.028z M55.397,80.063l0.101,0.122
			l0.307-0.146l0.087,0.083l0.052-0.009v-0.193l-0.101,0.06l-0.345,0.054v-0.096L55.397,80.063z M55.423,79.322l0.04,0.19
			l0.139-0.216l0.291-0.188l-0.394,0.066l-0.075-0.046l0.04-0.005L55.423,79.322z M55.423,77.034l0.04,0.036l0.088-0.11
			l-0.128-0.063V77.034z M55.463,76.597l0.088-0.013v-0.041l-0.128,0.021L55.463,76.597z M55.423,72.303v0.126l0.075,0.14
			l0.104-0.015l0.103,0.022v-0.098l0.24-0.036l0.151,0.046l0.356-0.279l0.128-0.077l-0.128-0.121l-0.203,0.187l-0.049-0.2
			l-0.077,0.013l-0.052,0.049l-0.126,0.021l-0.052-0.034l-0.049,0.01v0.039l0.127,0.091l0.049-0.008l0.19,0.064l-0.227,0.15
			l-0.091-0.094l-0.213-0.024l0.087-0.333L55.423,72.303z M55.449,73.632l0.103,0.107l0.05-0.106l0.103-0.072l-0.167-0.068
			L55.449,73.632z M55.463,81.01l0.035-0.006v-0.056L55.463,81.01z M55.551,71.744l0.241-0.04v-0.056l-0.052,0.01l-0.088-0.044
			l-0.189,0.034L55.551,71.744z M55.498,77.842l0.053-0.01v-0.056l-0.053,0.008V77.842z M55.498,72.016l0.053-0.009l-0.053-0.063
			V72.016z M55.498,70.364l0.053-0.009l-0.053-0.048V70.364z M55.704,69.664l-0.128,0.021l0.076,0.155l0.14,0.032v0.194l0.227-0.039
			v-0.11L55.97,69.79v-0.195l-0.178,0.029L55.704,69.664z M55.602,70.861l0.051-0.01v-0.096l-0.051,0.01V70.861z M55.652,80.924
			l0.052,0.102l0.153-0.079l-0.091-0.167L55.652,80.924z M55.704,71.358l0.139-0.021l0.049,0.143l0.229-0.04l-0.343-0.194
			L55.704,71.358z M55.704,70.317v0.067l0.088,0.058v0.194l0.05,0.048l0.101-0.13l-0.062-0.127l0.062-0.079l0.23,0.225l0.176-0.137
			l0.167-0.21l-0.116-0.12l-0.191-0.008l-0.088,0.056l-0.102-0.026l0.05-0.01L55.704,70.317z M55.843,77.007l0.049,0.146
			l0.078-0.012v-0.249l-0.178,0.027L55.843,77.007z M55.892,71.951l0.052-0.074v-0.1l-0.052,0.01V71.951z M55.97,80.416V80.36
			l-0.026,0.006L55.97,80.416z M55.944,79.296l0.026-0.002l0.049-0.067l-0.049,0.009L55.944,79.296z M55.944,73.414l0.076-0.013
			v-0.057l-0.076,0.011V73.414z M55.944,70.807L55.97,70.8v-0.053l-0.026,0.002V70.807z M55.959,71.247l0.061,0.059l0.05-0.009
			l0.104,0.097l0.047-0.009l-0.047-0.159l0.036-0.047l0.09,0.027l0.05-0.005l0.101,0.19l0.142-0.025V71.27l-0.102-0.039v-0.057
			l0.148-0.065v-0.042l-0.62,0.098L55.959,71.247z M55.97,80.872l0.049,0.05l0.05-0.01l0.052,0.09l0.052-0.01l0.036-0.103
			l-0.19-0.08l0.05-0.007L55.97,80.872z M55.97,80.678l0.1,0.039l0.14-0.02V80.64l-0.19-0.024L55.97,80.678z M55.97,79.139
			l0.24-0.037v-0.1l-0.24,0.041V79.139z M56.07,81.216l0.23,0.161v-0.141l-0.23-0.072V81.216z M56.07,77.833l0.318,0.018
			l-0.318-0.102V77.833z M56.07,69.454v0.096l0.381-0.158l0.09-0.127l-0.14,0.02L56.07,69.454z M56.147,78.321l0.063,0.056
			l-0.088,0.072v0.054l0.126-0.018l0.102-0.13l-0.14-0.116L56.147,78.321z M56.122,70.831v0.084l0.229-0.12l-0.164-0.042
			L56.122,70.831z M56.16,69.828l0.062,0.169l0.079-0.011l-0.09-0.14V69.75L56.16,69.828z M56.248,71.893l0.243-0.035v-0.126
			l-0.281,0.045L56.248,71.893z M56.667,77.042l0.076,0.185l-0.15-0.03l-0.102-0.084l-0.04,0.048l-0.203,0.09v0.042l0.203-0.035
			l0.09,0.111l0.098-0.017l0.118,0.039l0.115-0.145v-0.194l-0.101-0.096L56.667,77.042z M56.261,70.643l0.19,0.027v-0.043
			l-0.101-0.08L56.261,70.643z M56.35,79.897v-0.04l-0.05,0.008L56.35,79.897z M56.3,79.435l0.191-0.03l-0.04-0.052L56.3,79.376
			V79.435z M56.3,78.726l0.139,0.1l-0.088,0.086v0.069l0.204-0.032l-0.074-0.308l-0.18,0.03V78.726z M56.35,80.966v0.038
			l0.051-0.006l0.09-0.098v-0.054l-0.04,0.007L56.35,80.966z M56.35,80.62l0.101-0.017l0.04-0.061l-0.064-0.089L56.35,80.62z
			 M56.541,75.633v-0.069l-0.14,0.024L56.541,75.633z M56.491,73.936l0.05-0.008l-0.05-0.048l-0.09,0.014L56.491,73.936z
			 M56.401,72.369l0.05-0.01l0.04-0.058l-0.04,0.002L56.401,72.369z M56.479,71.664l0.113,0.106l0.046-0.066v-0.193l-0.046,0.009
			L56.479,71.664z M56.491,78.543l0.05-0.01l0.052-0.064l-0.102,0.019V78.543z M57.048,70.486L57,70.442l-0.127,0.021l-0.101,0.072
			l-0.132,0.019l-0.046-0.046l0.046-0.065l0.132-0.02v-0.112l-0.132-0.006l-0.148,0.164v0.11l0.05,0.032v0.154l0.331-0.054
			l0.074-0.192l0.102,0.219 M56.517,75.334l0.076,0.142l0.215-0.119l-0.128-0.119l-0.087,0.011L56.517,75.334z M56.639,80.517
			l0.041-0.005v-0.059l-0.087,0.017L56.639,80.517z M56.593,69.882l0.087,0.042l0.041-0.063l-0.128-0.035V69.882z M56.617,79.02
			l0.154,0.034v-0.042l-0.05-0.037l-0.041-0.116L56.617,79.02z M56.68,70.06l-0.052,0.094l0.293-0.129l-0.101-0.027L56.68,70.06z
			 M56.639,81.475l0.082-0.014v-0.027l-0.082,0.011V81.475z M56.639,80.712l0.181-0.03v-0.057l-0.099,0.017L56.639,80.712z
			 M56.639,79.283l0.181-0.033v-0.094l-0.181,0.03V79.283z M57.023,70.977l-0.064,0.08l-0.216,0.104l-0.063,0.094v0.055l0.14-0.074
			l0.139-0.024 M56.872,72.389v-0.098l-0.151,0.028L56.872,72.389z M56.721,70.988l0.099-0.019l0.052-0.064l-0.052,0.01
			L56.721,70.988z M56.771,79.565v0.044l0.101-0.059l-0.052-0.032L56.771,79.565z M56.959,69.627l-0.188,0.086l0.15,0.114L57,69.816
			l-0.041-0.05v-0.041 M56.872,69.185l0.087-0.016v-0.053l-0.087,0.016V69.185z M56.959,70.184L57,70.178v-0.056L56.959,70.184z"/>
		<path class="disabled"  d="M58.784,68.752l0.809-0.076l-0.052,0.056l-0.206,0.033l0.156,0.13l0.102-0.019l0.103,0.036l0.14-0.109l-0.105-0.153
			l1.326-0.214l0.07,0.042l0.049-0.06l0.584-0.096v0.204l0.244-0.037l-0.119-0.083l0.05-0.111l4.514-0.729l0.136,0.221l0.07-0.049
			v-0.205l1.186-0.191l-0.31,0.101v0.075l0.194-0.105l-0.072,0.111l0.072,0.043l0.116-0.124l0.19-0.03l0.051-0.109l3.068-0.494
			l0.066,0.04l0.071-0.009v-0.054l0.24-0.036v0.432l-0.103,0.064l0.103,0.077v1.117l-0.137,0.113v0.19l0.137-0.062v0.319
			l-0.137,0.022l-0.775,0.188l0.209-0.148l0.24-0.04v-0.469l0.293-0.046v-0.04l-0.156-0.078l-0.309,0.127V68.35l-0.068,0.012
			l-0.122,0.184l-0.327,0.167v0.14l0.274-0.183l0.309-0.051v0.191l-0.206,0.188l-0.05-0.042l-0.257-0.036l-0.088,0.178l0.154,0.012
			v0.052l-0.171,0.027l-0.139-0.104l-0.156,0.024l-0.171,0.155l-0.379,0.062l0.292-0.138l0.104-0.371l0.154-0.101l0.348-0.297
			l-0.158-0.356l-0.258,0.23l-0.238-0.034v0.202l0.085,0.098l0.121-0.094l0.101-0.016v0.041l-0.292,0.16l-0.069-0.052l-0.052,0.148
			l-0.122,0.095l-0.084-0.102l-0.052,0.084l-0.189,0.185l-0.258,0.042l-0.258,0.128l-0.362,0.061v0.05l-0.276,0.144V69.5l-0.5,0.001
			v-0.136l-0.137,0.021l-0.103,0.296l-0.584,0.091v-0.226l0.189-0.17v-0.154l-0.156,0.154l-0.085-0.064l-0.138,0.02l-0.068,0.064
			l-0.122,0.021l-0.136,0.162l-0.071,0.063v0.15l0.071-0.009l0.136-0.126l0.122,0.082v0.076l-3.669,0.593l-0.087-0.102l-0.137,0.109
			l-0.312-0.174l-0.24,0.162l-0.069-0.038l-0.121,0.018v0.18l-0.189,0.03v-0.318l-0.052,0.009l-0.069-0.092l-0.209,0.034
			l-0.05-0.092l-0.07-0.028l0.259-0.088l-0.171-0.088l-0.137,0.146l-0.208-0.018l-0.173,0.029v0.053h0.241l0.139,0.167l0.378,0.23
			v0.079l-0.449,0.072v-0.129l-0.087-0.051l-0.153,0.218l-0.383,0.063l-0.153-0.053l-0.05,0.085l-0.432,0.067l-0.068-0.037
			l-0.189,0.029v-0.125l-0.275,0.222l-1.963,0.317l-0.122-0.299l0.122-0.018v-0.154l-0.244,0.141v0.37l-0.772,0.125l-0.102-0.036
			l-0.139,0.023v-1.167l0.171,0.122l0.139-0.02l-0.171-0.176l-0.139-0.246 M68.083,69.603l-0.051,0.009l0.051-0.111l0.156-0.024
			L68.083,69.603z M69.375,69.296l-0.087,0.011l0.087-0.14v-0.141l0.121-0.12l0.138-0.024l0.068,0.157l-0.068,0.136l-0.069-0.178
			L69.375,69.296z M69.047,69.347l-0.256,0.041l0.137-0.148l0.069-0.112l0.05-0.008V69.347z M68.547,69.427l-0.066,0.012v-0.027
			L68.547,69.427z M66.897,69.682l0.241-0.156l-0.071-0.037l-0.169,0.027V69.682z M59.216,70.909l0.275-0.249v-0.089l-0.225,0.176
			l-0.275,0.194L59.216,70.909z M57.423,70.623l0.139,0.309v0.243l0.24-0.04L57.699,71l-0.171-0.396L57.423,70.623z M62.591,70.313
			v-0.05l-0.07,0.008v0.051L62.591,70.313z M67.842,69.121v0.103l0.071,0.078l0.067-0.048v-0.243l-0.208,0.034L67.842,69.121z
			 M67.225,69.412l0.067-0.012v-0.035l-0.154,0.022L67.225,69.412z M68.67,69.04l-0.124-0.16v-0.099l-0.22,0.315L68.67,69.04z
			 M56.753,70.911l0.24-0.218l0.067,0.168l0.122-0.198l-0.05-0.042V70.53l-0.072-0.026l-0.119,0.159l-0.258,0.157v0.101
			L56.753,70.911z M70.34,68.667v-0.036l-0.07,0.009v0.04L70.34,68.667z M62.449,69.9v-0.037L62.4,69.947L62.449,69.9z
			 M67.344,68.745l0.085-0.014l-0.138,0.238l0.362,0.058l0.072-0.114l0.255-0.104v-0.216l-0.515,0.084v-0.09l0.188-0.108V68.35
			l-0.122,0.02l-0.24,0.243v0.243L67.344,68.745z M68.67,68.556l0.191,0.047l-0.141,0.2l0.141-0.022l0.22-0.204l-0.101-0.185
			l0.172-0.23l-0.105,0.015l-0.186,0.132l-0.191,0.096V68.556z M66.965,68.907v0.178l0.101-0.018V68.89l-0.101-0.085l-0.068,0.011
			v0.05L66.965,68.907z M60.644,70.104l0.104-0.157v-0.114l0.241,0.037l0.104-0.168l-0.275,0.046l-0.276-0.083l0.067,0.243
			l-0.085,0.217L60.644,70.104z M69.393,68.617l0.172-0.127l-0.121-0.287l0.121-0.107v-0.049l-0.241,0.039l0.052,0.092v0.339
			l-0.121,0.023L69.393,68.617z M68.481,68.739l0.24-0.079l-0.24-0.098l-0.172-0.267v0.395l-0.07,0.086v-0.038H68.481z
			 M65.639,69.199l0.049-0.046l-0.118-0.07l-0.104,0.144L65.639,69.199z M65.105,69.245v-0.088l-0.051,0.006v0.128L65.105,69.245z
			 M59.767,70.146l0.154-0.025l0.188-0.107v-0.103l0.05-0.11l-0.119,0.02v-0.243l0.087-0.167l-0.277-0.311l-0.067-0.114
			l-0.174,0.156l0.19,0.17l-0.258,0.092v0.079l0.052,0.042v0.125l-0.052,0.06v0.051l0.052-0.008l0.138-0.151v-0.05l0.119-0.209
			l0.14,0.206l-0.14,0.111l-0.067,0.227l-0.396-0.024L59.767,70.146z M61.419,69.852l0.156-0.126l-0.121-0.032l-0.067-0.09
			l-0.122,0.187L61.419,69.852z M70.583,68.362v-0.04l-0.072,0.013L70.583,68.362z M59.093,70.128v-0.242l-0.067,0.012v0.05
			l-0.068,0.099v0.192L59.093,70.128z M66.656,68.957v-0.05l-0.07,0.012v0.05L66.656,68.957z M59.421,70.124v-0.052l-0.085,0.065
			L59.421,70.124z M57.371,70.454v-0.05l-0.067,0.063L57.371,70.454z M56.546,70.384v0.128l0.207-0.109l0.068-0.152l0.238-0.041
			v-0.226l-0.137,0.024l-0.169,0.078l-0.243,0.038V70.3L56.546,70.384z M58.009,70.251v-0.053l-0.118,0.021v0.051L58.009,70.251z
			 M70.511,68.181l0.139-0.076l-0.067-0.139l-0.226,0.126L70.511,68.181z M58.647,70.046v-0.139l0.188-0.081v-0.229l-0.307,0.393
			L58.647,70.046z M57.355,70.253l0.085-0.011l0.087-0.105l0.24-0.039l0.068-0.061l-0.137-0.081l-0.171,0.093l-0.087-0.052
			l0.327-0.28l-0.138-0.155l-0.224-0.129l-0.171,0.145l-0.053,0.196l0.053,0.081l-0.053,0.112v-0.05L57.355,70.253z M65.688,68.769
			l0.191-0.08v-0.077L65.57,68.66v0.18L65.688,68.769z M59.421,69.73l-0.085-0.037l-0.119,0.021v0.052L59.421,69.73z M69.945,67.956
			l-0.07,0.01v0.027L69.945,67.956z M68.547,68.207v-0.025l-0.066-0.041v0.055L68.547,68.207z M61.247,69.386v-0.077l-0.07,0.011
			v0.077L61.247,69.386z M58.009,69.91v-0.028l-0.067,0.012v0.024L58.009,69.91z M58.562,69.808l0.085-0.078v-0.05l0.137-0.124
			v-0.051l-0.206,0.084l-0.05-0.03l0.05-0.1v-0.051l0.257-0.144v-0.138l-0.121,0.02l-0.067,0.113l-0.069,0.01l-0.05-0.144
			l-0.052,0.01v0.621L58.562,69.808z M70.511,67.866l0.072-0.063v-0.051l0.119-0.07v-0.05l-0.119-0.021l-0.138,0.212v-0.047
			L70.511,67.866z M70.27,67.904l0.07-0.114v-0.14l-0.07,0.012l-0.068,0.205L70.27,67.904z M68.36,68.212V67.97l-0.122,0.02v0.243
			L68.36,68.212z M70.958,67.691l0.243-0.27l-0.171,0.03l-0.138,0.251L70.958,67.691z M66.759,68.37l0.084-0.333l-0.188,0.35
			L66.759,68.37z M56.356,70.046l0.118-0.018l-0.118-0.362l-0.139-0.064v0.135L56.356,70.046z M67.379,68.19l0.087-0.074
			l0.066,0.079l0.069-0.014v-0.127l-0.135-0.078l-0.174,0.169L67.379,68.19z M58.079,69.717l0.103-0.016l-0.103-0.212l-0.087,0.18
			L58.079,69.717z M56.837,69.882l0.223-0.098v-0.078l-0.188,0.12l-0.119,0.017L56.837,69.882z M59.421,69.377v-0.242l-0.154,0.021
			v0.283L59.421,69.377z M65.897,67.91l0.241-0.114l-0.07,0.162l-0.121,0.122l0.053,0.031l0.067,0.191l0.052-0.01v-0.203
			l0.156-0.113v-0.103l0.07-0.126l-0.154-0.086L65.948,67.7l-0.136,0.124L65.897,67.91z M57.872,69.612l0.07-0.204l-0.051,0.009
			l-0.123,0.123L57.872,69.612z M69.375,67.667l-0.052,0.008v0.052L69.375,67.667z M68.791,67.812v-0.189l-0.07,0.046v0.154
			L68.791,67.812z M67.913,67.956l0.153-0.167l0.087,0.076l0.086-0.016v-0.204l-0.397,0.142v0.176L67.913,67.956z M70.702,67.452
			l0.05-0.009v-0.05l-0.103-0.071l-0.067,0.01v0.04L70.702,67.452z M70.27,67.521v-0.1l-0.068-0.029l-0.122,0.083L70.27,67.521z
			 M64.121,68.322l-0.083,0.016v0.14L64.121,68.322z M62.005,68.718v-0.052l-0.069,0.06v0.09L62.005,68.718z M60.041,69.121v-0.05
			l-0.066-0.026v0.038L60.041,69.121z M59.18,69.185l0.156-0.14l-0.069-0.04l-0.241,0.04v0.051L59.18,69.185z M67.726,67.793v-0.052
			l-0.072-0.039v0.103L67.726,67.793z M57.836,68.833l-0.068,0.058v0.131l0.068,0.088v0.13l-0.068,0.058l-0.069-0.038v-0.127
			l-0.138,0.024l-0.033,0.129l0.171,0.127l0.137-0.024l0.055-0.056l0.188-0.034v-0.329l-0.227-0.038l0.294-0.15 M63.745,68.41
			l0.188-0.108l-0.102-0.198l-0.172,0.156v0.086L63.745,68.41z M70.202,67.243v-0.04l-0.066,0.013v0.087L70.202,67.243z
			 M56.993,69.423l0.067-0.098l-0.067-0.028l-0.07,0.138L56.993,69.423z M68.341,67.566l0.072-0.161l-0.052,0.006l-0.052,0.057
			l-0.156,0.064L68.341,67.566z M57.235,69.296l0.103,0.036l-0.103-0.274l-0.053,0.105L57.235,69.296z M71.391,67.048v-0.076
			l-0.034,0.007v0.076L71.391,67.048z M70.445,67.203v-0.178l-0.07,0.013v0.1L70.445,67.203z M68.67,67.488v-0.176l-0.124,0.017
			v0.18L68.67,67.488z M58.441,68.759l0.087,0.051l0.083,0.201l0.104,0.046l0.07-0.01l-0.07-0.128v-0.143 M60.16,68.635
			l-0.119,0.016v0.155L60.16,68.635z M58.388,69.071v-0.102l-0.069-0.038v0.05L58.388,69.071z M69.047,67.299l0.052-0.008
			l-0.052-0.094l-0.05,0.06L69.047,67.299z M56.753,69.096l0.068,0.179l0.171-0.179v-0.079l-0.07,0.05l-0.05,0.01 M56.185,69.275
			v-0.088l-0.07,0.008v0.089L56.185,69.275z M57.441,68.983v-0.039l-0.07,0.012L57.441,68.983z"/>
		<path class="disabled"  d="M83.698,67.024l-0.81,0.077l0.049-0.056l0.208-0.034l-0.154-0.128l-0.102,0.016l-0.105-0.031l-0.137,0.109l0.104,0.147
			l-1.329,0.214l-0.064-0.039l-0.052,0.06l-0.586,0.093v-0.204l-0.243,0.043l0.121,0.08l-0.052,0.11l-4.512,0.727l-0.137-0.22
			l-0.069,0.05v0.204l-1.189,0.191l0.31-0.101v-0.074l-0.188,0.106l0.066-0.113l-0.066-0.04l-0.122,0.12l-0.187,0.03l-0.055,0.11
			l-3.065,0.493l-0.07-0.036l-0.067,0.009v0.048l-0.241,0.042v-0.432l0.104-0.071l-0.104-0.072v-1.12l0.136-0.11v-0.193
			l-0.136,0.065v-0.319l0.136-0.023l0.775-0.189l-0.206,0.146l-0.24,0.042v0.47l-0.294,0.043v0.041l0.156,0.079l0.31-0.126v0.164
			l0.069-0.014l0.121-0.185l0.328-0.164v-0.141l-0.276,0.182l-0.31,0.051v-0.191l0.209-0.187l0.049,0.042l0.259,0.036l0.087-0.18
			l-0.154-0.013v-0.05l0.169-0.03l0.139,0.104l0.153-0.024l0.175-0.152l0.375-0.062l-0.291,0.134l-0.104,0.374l-0.156,0.103
			l-0.343,0.294l0.154,0.358l0.261-0.232l0.24,0.036v-0.203l-0.087-0.1l-0.118,0.096l-0.106,0.013v-0.037l0.293-0.164l0.072,0.056
			l0.052-0.149l0.119-0.095l0.085,0.102l0.052-0.085l0.189-0.186l0.258-0.038l0.261-0.132l0.36-0.06v-0.05l0.277-0.148v-0.063
			l0.497-0.003v0.138l0.139-0.021l0.103-0.296l0.586-0.096v0.23l-0.192,0.17v0.152l0.16-0.152l0.084,0.063l0.14-0.022l0.066-0.06
			l0.121-0.023l0.139-0.16l0.067-0.063V65.98l-0.067,0.011l-0.139,0.123l-0.121-0.08v-0.075l3.669-0.595l0.084,0.1l0.139-0.11
			l0.312,0.18l0.24-0.17l0.068,0.044l0.121-0.022v-0.178l0.189-0.032v0.32l0.053-0.008l0.067,0.09l0.209-0.032l0.05,0.093
			l0.07,0.025l-0.259,0.094l0.169,0.086l0.142-0.15l0.206,0.018l0.171-0.028v-0.05h-0.24l-0.137-0.168l-0.381-0.232v-0.076
			l0.446-0.071v0.127l0.09,0.05l0.156-0.217l0.378-0.062l0.153,0.05l0.053-0.083l0.431-0.069l0.068,0.039l0.188-0.029v0.124
			l0.278-0.22l1.963-0.318l0.119,0.3l-0.119,0.018v0.152l0.241-0.14v-0.369l0.775-0.125l0.101,0.036l0.142-0.025v1.174l-0.174-0.127
			l-0.137,0.023l0.169,0.176l0.142,0.244 M74.395,66.171l0.055-0.01l-0.055,0.111l-0.154,0.026L74.395,66.171z M73.104,66.478
			l0.085-0.012l-0.085,0.142v0.141l-0.124,0.12l-0.133,0.024l-0.071-0.156l0.071-0.138l0.064,0.18L73.104,66.478z M73.432,66.428
			l0.258-0.043l-0.139,0.151l-0.067,0.111l-0.052,0.009V66.428z M73.931,66.348L74,66.335v0.024L73.931,66.348z M75.581,66.094
			l-0.238,0.152l0.069,0.04l0.169-0.028V66.094z M83.266,64.866l-0.276,0.246v0.091l0.225-0.179l0.274-0.198L83.266,64.866z
			 M85.055,65.151l-0.138-0.313v-0.242l-0.24,0.04l0.103,0.137l0.174,0.391L85.055,65.151z M79.89,65.461v0.051l0.069-0.011v-0.05
			L79.89,65.461z M74.636,66.652V66.55l-0.067-0.078l-0.07,0.05v0.243l0.206-0.034L74.636,66.652z M75.257,66.361l-0.07,0.011v0.039
			l0.155-0.025L75.257,66.361z M73.812,66.736l0.119,0.156v0.103l0.223-0.317L73.812,66.736z M85.727,64.864l-0.24,0.219
			l-0.068-0.172l-0.122,0.202l0.053,0.041v0.09l0.069,0.028l0.12-0.164l0.257-0.155v-0.103L85.727,64.864z M72.139,67.107v0.035
			l0.07-0.008v-0.037L72.139,67.107z M80.029,65.874v0.037l0.05-0.086L80.029,65.874z M75.137,67.031l-0.087,0.014l0.138-0.241
			l-0.363-0.056l-0.066,0.114l-0.259,0.105v0.215l0.514-0.082v0.087l-0.189,0.109v0.128l0.122-0.021l0.241-0.243v-0.244
			L75.137,67.031z M73.812,67.219l-0.191-0.043l0.137-0.203l-0.137,0.023l-0.224,0.202l0.102,0.186l-0.169,0.23l0.102-0.013
			l0.189-0.132l0.191-0.097V67.219z M75.517,66.868v-0.18l-0.105,0.019v0.176l0.105,0.085l0.064-0.01v-0.052L75.517,66.868z
			 M81.836,65.669l-0.104,0.158v0.114l-0.24-0.04l-0.105,0.172l0.278-0.046l0.273,0.084l-0.07-0.242l0.087-0.219L81.836,65.669z
			 M73.087,67.156l-0.175,0.132l0.124,0.284l-0.124,0.11v0.05l0.244-0.038L73.104,67.6v-0.342l0.122-0.02L73.087,67.156z M74,67.037
			l-0.241,0.076l0.241,0.1l0.173,0.263v-0.39l0.068-0.088v0.036L74,67.037z M76.843,66.575l-0.053,0.05l0.121,0.067l0.104-0.144
			L76.843,66.575z M77.376,66.53v0.085l0.05-0.008v-0.126L77.376,66.53z M82.713,65.629l-0.155,0.024l-0.189,0.108v0.103l-0.05,0.11
			l0.119-0.02v0.241l-0.085,0.166l0.276,0.313l0.069,0.116l0.171-0.154L82.68,66.46l0.256-0.092v-0.075l-0.049-0.046v-0.125
			l0.049-0.06v-0.052l-0.049,0.01l-0.139,0.15v0.05l-0.121,0.21l-0.137-0.206l0.137-0.112l0.069-0.226l0.394,0.022L82.713,65.629z
			 M81.062,65.922l-0.156,0.125l0.119,0.033l0.069,0.091l0.119-0.187L81.062,65.922z M71.898,67.412v0.04l0.072-0.013L71.898,67.412
			z M83.388,65.647v0.243l0.067-0.013v-0.05l0.067-0.1v-0.19L83.388,65.647z M75.825,66.816v0.052l0.069-0.011v-0.053L75.825,66.816
			z M83.059,65.651v0.05l0.085-0.066L83.059,65.651z M85.108,65.319v0.051l0.069-0.062L85.108,65.319z M85.936,65.39v-0.129
			l-0.209,0.11l-0.068,0.15l-0.24,0.042v0.227l0.136-0.02l0.172-0.081l0.241-0.039v-0.178L85.936,65.39z M84.472,65.521v0.054
			l0.119-0.02v-0.051L84.472,65.521z M71.97,67.593l-0.141,0.071l0.069,0.144l0.226-0.126L71.97,67.593z M83.833,65.728v0.143
			l-0.188,0.08v0.228l0.309-0.393L83.833,65.728z M85.124,65.521l-0.084,0.014l-0.085,0.101l-0.243,0.042l-0.071,0.06l0.14,0.08
			l0.174-0.092l0.085,0.052l-0.328,0.281l0.135,0.155l0.227,0.131l0.171-0.143l0.052-0.2l-0.052-0.082l0.052-0.11v0.051
			L85.124,65.521z M76.79,67.005l-0.191,0.083v0.077l0.312-0.052v-0.177L76.79,67.005z M83.059,66.046l0.085,0.036l0.122-0.018
			V66.01L83.059,66.046z M72.537,67.817l0.069-0.01v-0.027L72.537,67.817z M73.931,67.567v0.026L74,67.635v-0.053L73.931,67.567z
			 M81.233,66.39v0.076l0.07-0.012V66.38L81.233,66.39z M84.472,65.87v0.024l0.067-0.013v-0.024L84.472,65.87z M83.919,65.967
			l-0.087,0.08V66.1l-0.135,0.121v0.051l0.205-0.082l0.051,0.03l-0.051,0.095v0.05l-0.258,0.145v0.14l0.121-0.019l0.067-0.113
			l0.07-0.012l0.051,0.144l0.053-0.006v-0.626L83.919,65.967z M71.97,67.91l-0.072,0.062v0.053l-0.121,0.068v0.054l0.121,0.016
			l0.139-0.212V68L71.97,67.91z M72.209,67.869l-0.07,0.114v0.143l0.07-0.011l0.068-0.205L72.209,67.869z M74.12,67.562v0.244
			l0.121-0.022v-0.238L74.12,67.562z M71.52,68.084l-0.241,0.267l0.172-0.029l0.137-0.25L71.52,68.084z M75.722,67.405l-0.087,0.334
			l0.19-0.351L75.722,67.405z M86.125,65.728l-0.121,0.02l0.121,0.365l0.137,0.066v-0.142L86.125,65.728z M75.102,67.583
			l-0.088,0.079l-0.067-0.079l-0.069,0.011v0.128l0.136,0.078l0.174-0.167L75.102,67.583z M84.402,66.058l-0.103,0.016l0.103,0.212
			l0.087-0.178L84.402,66.058z M85.641,65.895l-0.223,0.101v0.078l0.188-0.12l0.121-0.022L85.641,65.895z M83.059,66.402v0.243
			l0.156-0.029v-0.277L83.059,66.402z M76.583,67.866l-0.243,0.116l0.07-0.164l0.121-0.124l-0.049-0.029l-0.072-0.191l-0.052,0.008
			v0.204l-0.154,0.114v0.1l-0.068,0.126l0.155,0.09l0.24-0.038l0.139-0.122L76.583,67.866z M84.608,66.162l-0.069,0.204l0.052-0.011
			l0.121-0.119L84.608,66.162z M73.104,68.105l0.052-0.008v-0.049L73.104,68.105z M73.69,67.963v0.193l0.068-0.053v-0.152
			L73.69,67.963z M74.569,67.819l-0.156,0.164l-0.085-0.073l-0.087,0.015v0.203l0.396-0.14v-0.176L74.569,67.819z M71.777,68.322
			l-0.049,0.01v0.048l0.101,0.074l0.069-0.013v-0.038L71.777,68.322z M72.209,68.254v0.097l0.068,0.03l0.121-0.083L72.209,68.254z
			 M78.357,67.452l0.085-0.013v-0.142L78.357,67.452z M80.475,67.061v0.05l0.068-0.063v-0.09L80.475,67.061z M82.438,66.652v0.052
			l0.07,0.027v-0.037L82.438,66.652z M83.3,66.591l-0.156,0.14l0.07,0.039l0.241-0.039v-0.048L83.3,66.591z M74.758,67.981v0.05
			l0.066,0.04V67.97L74.758,67.981z M84.64,66.947l0.071-0.06v-0.128l-0.071-0.09V66.54l0.071-0.062l0.069,0.041v0.126l0.137-0.02
			l0.037-0.132l-0.174-0.127l-0.14,0.02l-0.049,0.06l-0.189,0.032v0.332l0.224,0.04l-0.294,0.148 M78.737,67.365l-0.192,0.108
			l0.105,0.196l0.169-0.154v-0.087L78.737,67.365z M72.278,68.535v0.035l0.069-0.012v-0.086L72.278,68.535z M85.487,66.354
			l-0.068,0.097l0.068,0.026l0.067-0.136L85.487,66.354z M74.137,68.208l-0.07,0.166l0.053-0.009l0.052-0.06l0.155-0.063
			L74.137,68.208z M85.244,66.482l-0.102-0.037l0.102,0.276l0.052-0.107L85.244,66.482z M71.087,68.726v0.077l0.035-0.006V68.72
			L71.087,68.726z M72.037,68.575v0.176l0.069-0.012v-0.102L72.037,68.575z M73.812,68.289v0.177l0.119-0.021V68.27L73.812,68.289z
			 M84.04,67.021l-0.087-0.05l-0.085-0.204l-0.103-0.048l-0.067,0.012l0.067,0.129V67 M82.318,67.143l0.119-0.019v-0.152
			L82.318,67.143z M84.09,66.707v0.102l0.07,0.04v-0.051L84.09,66.707z M73.432,68.477l-0.05,0.007l0.05,0.093l0.052-0.061
			L73.432,68.477z M85.727,66.683l-0.068-0.179l-0.171,0.179v0.078l0.067-0.048l0.052-0.008 M86.294,66.504v0.087l0.072-0.01v-0.088
			L86.294,66.504z M85.04,66.792v0.04l0.069-0.011L85.04,66.792z"/>
		<path class="disabled"  d="M88.595,63.942l0.809-0.081l-0.05,0.061l-0.208,0.031l0.154,0.128l0.104-0.018l0.104,0.038l0.136-0.114l-0.101-0.148
			l1.327-0.217l0.07,0.04l0.051-0.056l0.584-0.096v0.204l0.241-0.039l-0.121-0.082l0.05-0.109l4.512-0.73l0.139,0.22l0.07-0.05
			v-0.202l1.188-0.193l-0.31,0.101v0.076l0.189-0.108l-0.07,0.114l0.07,0.038l0.121-0.12l0.189-0.027l0.051-0.111l3.068-0.499
			l0.067,0.042l0.067-0.013v-0.049l0.241-0.038v0.433l-0.098,0.068l0.098,0.072v1.123l-0.136,0.11v0.192l0.136-0.06v0.316
			l-0.136,0.025l-0.774,0.188l0.207-0.148l0.242-0.036v-0.475l0.292-0.046v-0.04l-0.154-0.076l-0.31,0.129v-0.168l-0.07,0.012
			l-0.121,0.184l-0.33,0.17v0.138l0.277-0.184l0.309-0.05v0.19l-0.208,0.188l-0.049-0.044l-0.26-0.032l-0.085,0.178l0.154,0.012
			v0.052l-0.171,0.026l-0.138-0.106l-0.155,0.028l-0.171,0.154l-0.378,0.062l0.29-0.138l0.105-0.375l0.154-0.098l0.343-0.3
			l-0.153-0.359l-0.259,0.235l-0.24-0.036v0.201l0.084,0.103l0.121-0.096l0.104-0.018v0.04l-0.292,0.161l-0.07-0.051l-0.052,0.147
			l-0.119,0.096l-0.088-0.102l-0.049,0.087l-0.189,0.182l-0.258,0.043l-0.261,0.13l-0.362,0.058v0.053l-0.275,0.142v0.067
			l-0.499,0.004v-0.14l-0.14,0.02l-0.101,0.301l-0.586,0.092v-0.228l0.189-0.17v-0.156l-0.156,0.156l-0.084-0.064l-0.138,0.021
			l-0.071,0.061l-0.118,0.02l-0.139,0.166l-0.068,0.059v0.154l0.068-0.01l0.139-0.126l0.118,0.083v0.076l-3.668,0.593l-0.085-0.102
			l-0.139,0.11l-0.31-0.176l-0.24,0.164l-0.07-0.038l-0.118,0.018v0.18l-0.192,0.028v-0.316l-0.052,0.005l-0.067-0.089l-0.208,0.033
			l-0.051-0.092l-0.068-0.027l0.259-0.092l-0.175-0.088l-0.135,0.15l-0.209-0.019l-0.169,0.025v0.053h0.238l0.14,0.17l0.377,0.229
			v0.079l-0.447,0.072v-0.128l-0.087-0.052l-0.156,0.218l-0.377,0.06l-0.157-0.052l-0.05,0.083l-0.432,0.07l-0.067-0.04
			l-0.189,0.032v-0.126l-0.278,0.22l-1.96,0.318l-0.125-0.301l0.125-0.021v-0.153l-0.241,0.144v0.369l-0.778,0.126l-0.102-0.036
			l-0.138,0.024v-1.173l0.171,0.125l0.139-0.022l-0.172-0.174l-0.138-0.246 M97.894,64.798l-0.051,0.008l0.051-0.11l0.155-0.024
			L97.894,64.798z M99.188,64.487L99.101,64.5l0.087-0.137V64.22l0.121-0.123l0.136-0.021l0.07,0.154l-0.07,0.14l-0.069-0.18
			L99.188,64.487z M98.858,64.54l-0.256,0.043l0.139-0.151l0.067-0.112l0.05-0.01V64.54z M98.359,64.62l-0.069,0.013v-0.027
			L98.359,64.62z M96.707,64.876l0.24-0.156l-0.067-0.038l-0.172,0.025V64.876z M89.026,66.1l0.275-0.247v-0.088l-0.225,0.177
			l-0.275,0.193L89.026,66.1z M87.234,65.815l0.139,0.308v0.242l0.241-0.036l-0.105-0.139L87.338,65.8L87.234,65.815z
			 M92.402,65.503v-0.05l-0.07,0.011v0.05L92.402,65.503z M97.654,64.313v0.104l0.068,0.076l0.069-0.047v-0.245l-0.206,0.034
			L97.654,64.313z M97.033,64.606l0.07-0.012v-0.038l-0.157,0.027L97.033,64.606z M98.48,64.231l-0.121-0.162v-0.098l-0.223,0.315
			L98.48,64.231z M86.564,66.101l0.241-0.218l0.07,0.168l0.116-0.199l-0.049-0.042v-0.09l-0.067-0.026l-0.124,0.163l-0.256,0.154
			v0.102L86.564,66.101z M100.151,63.861v-0.04l-0.069,0.012v0.04L100.151,63.861z M92.265,65.095v-0.04l-0.051,0.086L92.265,65.095
			z M97.154,63.936l0.087-0.014l-0.138,0.237l0.36,0.058l0.07-0.114L97.792,64v-0.216l-0.515,0.083v-0.092l0.187-0.106v-0.128
			l-0.119,0.022l-0.241,0.242v0.24L97.154,63.936z M98.48,63.747l0.191,0.046l-0.139,0.201l0.139-0.022l0.223-0.201l-0.103-0.188
			l0.17-0.234l-0.103,0.018l-0.188,0.132l-0.191,0.095V63.747z M96.775,64.097v0.179l0.104-0.016v-0.179l-0.104-0.086l-0.068,0.012
			v0.05L96.775,64.097z M90.455,65.297l0.106-0.159v-0.114l0.238,0.037l0.103-0.167l-0.275,0.043l-0.276-0.083l0.07,0.243
			l-0.084,0.218L90.455,65.297z M99.204,63.812l0.172-0.132l-0.121-0.285l0.121-0.112v-0.049l-0.241,0.037l0.053,0.095v0.344
			l-0.122,0.02L99.204,63.812z M98.291,63.93l0.241-0.075l-0.241-0.102l-0.172-0.267v0.396l-0.069,0.087v-0.036L98.291,63.93z
			 M95.452,64.388l0.049-0.045l-0.119-0.069l-0.104,0.144L95.452,64.388z M94.916,64.436v-0.09l-0.052,0.01v0.128L94.916,64.436z
			 M89.578,65.337l0.153-0.025l0.191-0.108v-0.102l0.05-0.111l-0.121,0.018v-0.24l0.088-0.167l-0.278-0.311l-0.067-0.116
			l-0.174,0.157l0.189,0.172l-0.256,0.09v0.078l0.05,0.042v0.128l-0.05,0.06v0.051l0.05-0.009l0.139-0.149v-0.05l0.119-0.21
			l0.141,0.207l-0.141,0.11l-0.067,0.228l-0.397-0.026L89.578,65.337z M91.231,65.043l0.153-0.126l-0.118-0.029l-0.071-0.093
			l-0.121,0.186L91.231,65.043z M100.393,63.553v-0.04l-0.07,0.013L100.393,63.553z M88.904,65.319v-0.243l-0.067,0.008v0.055
			l-0.07,0.098v0.193L88.904,65.319z M96.467,64.147v-0.05l-0.07,0.013v0.05L96.467,64.147z M89.233,65.315v-0.05l-0.087,0.063
			L89.233,65.315z M87.184,65.645v-0.052l-0.067,0.063L87.184,65.645z M86.354,65.575v0.127l0.21-0.108l0.068-0.152l0.243-0.038
			v-0.229l-0.139,0.022l-0.172,0.08l-0.243,0.036v0.179L86.354,65.575z M87.821,65.441V65.39l-0.122,0.021v0.051L87.821,65.441z
			 M100.322,63.372l0.139-0.071l-0.068-0.143l-0.225,0.124L100.322,63.372z M88.458,65.236v-0.14l0.19-0.081v-0.23l-0.313,0.395
			L88.458,65.236z M87.167,65.444l0.085-0.011l0.086-0.105l0.24-0.04l0.071-0.062l-0.14-0.08l-0.171,0.094l-0.086-0.05l0.326-0.284
			l-0.135-0.157l-0.225-0.13l-0.174,0.144l-0.053,0.2l0.053,0.08l-0.053,0.11v-0.05L87.167,65.444z M95.5,63.959l0.191-0.079v-0.078
			l-0.31,0.05v0.178L95.5,63.959z M89.233,64.921l-0.087-0.037l-0.121,0.018v0.051L89.233,64.921z M99.754,63.147l-0.067,0.011
			v0.022L99.754,63.147z M98.359,63.396v-0.026l-0.069-0.04v0.052L98.359,63.396z M91.059,64.576v-0.078L90.99,64.51v0.077
			L91.059,64.576z M87.821,65.097v-0.024l-0.07,0.01v0.025L87.821,65.097z M88.373,64.997l0.085-0.08v-0.05l0.137-0.122v-0.052
			l-0.209,0.084l-0.05-0.03l0.05-0.098v-0.052l0.262-0.143v-0.14l-0.123,0.02l-0.067,0.114l-0.072,0.012l-0.05-0.146l-0.052,0.009
			v0.625L88.373,64.997z M100.322,63.052l0.07-0.06v-0.05l0.121-0.072v-0.05l-0.121-0.018l-0.139,0.212v-0.053L100.322,63.052z
			 M100.083,63.095l0.069-0.115v-0.14l-0.069,0.012l-0.069,0.2L100.083,63.095z M98.17,63.403v-0.242l-0.121,0.018v0.242
			L98.17,63.403z M100.77,62.878l0.244-0.265l-0.174,0.026l-0.136,0.253L100.77,62.878z M96.569,63.559l0.085-0.332l-0.188,0.35
			L96.569,63.559z M86.167,65.236l0.119-0.02l-0.119-0.363l-0.139-0.066v0.14L86.167,65.236z M97.188,63.383l0.089-0.078
			l0.067,0.078l0.07-0.012v-0.126l-0.138-0.08l-0.174,0.166L97.188,63.383z M87.889,64.907l0.104-0.017l-0.104-0.212l-0.084,0.18
			L87.889,64.907z M86.649,65.071l0.226-0.1v-0.077l-0.191,0.119l-0.12,0.021L86.649,65.071z M89.233,64.564v-0.242l-0.157,0.023
			v0.28L89.233,64.564z M95.707,63.099l0.244-0.114l-0.07,0.163l-0.123,0.122l0.055,0.03l0.068,0.194l0.052-0.008V63.28l0.154-0.116
			v-0.102l0.069-0.126l-0.154-0.09l-0.244,0.041l-0.136,0.124L95.707,63.099z M87.683,64.8l0.069-0.201l-0.052,0.008l-0.122,0.12
			L87.683,64.8z M99.188,62.855l-0.053,0.01v0.051L99.188,62.855z M98.602,63.003V62.81l-0.07,0.048v0.152L98.602,63.003z
			 M97.723,63.142l0.156-0.164l0.085,0.074l0.085-0.013v-0.205l-0.395,0.14v0.18L97.723,63.142z M100.513,62.643l0.049-0.009v-0.05
			l-0.101-0.072l-0.068,0.008v0.04L100.513,62.643z M100.083,62.712v-0.103l-0.069-0.026l-0.121,0.081L100.083,62.712z
			 M93.935,63.513l-0.085,0.013v0.141L93.935,63.513z M91.816,63.907v-0.052l-0.07,0.061v0.09L91.816,63.907z M89.852,64.31v-0.05
			l-0.069-0.029v0.039L89.852,64.31z M88.992,64.373l0.154-0.141l-0.07-0.038l-0.24,0.038v0.051L88.992,64.373z M97.534,62.98v-0.05
			l-0.07-0.038v0.1L97.534,62.98z M87.649,64.017l-0.071,0.063v0.128l0.071,0.089v0.127l-0.071,0.063l-0.069-0.039V64.32
			l-0.136,0.023l-0.035,0.13l0.171,0.126l0.14-0.024l0.05-0.056l0.189-0.033v-0.329l-0.223-0.042l0.292-0.15 M93.556,63.597
			l0.189-0.104l-0.103-0.2l-0.174,0.156v0.086L93.556,63.597z M100.014,62.429v-0.037l-0.07,0.01v0.09L100.014,62.429z
			 M86.805,64.613l0.07-0.099l-0.07-0.03l-0.068,0.136L86.805,64.613z M98.155,62.754l0.067-0.165l-0.052,0.008l-0.052,0.061
			l-0.154,0.063L98.155,62.754z M87.044,64.484l0.103,0.036l-0.103-0.278l-0.053,0.11L87.044,64.484z M101.202,62.236v-0.074
			l-0.034,0.005v0.074L101.202,62.236z M100.253,62.389v-0.178l-0.07,0.01v0.104L100.253,62.389z M98.48,62.676V62.5l-0.121,0.018
			v0.181L98.48,62.676z M88.249,63.946l0.087,0.05l0.088,0.204l0.101,0.044l0.07-0.008l-0.07-0.128v-0.142 M89.972,63.819
			l-0.121,0.021v0.154L89.972,63.819z M88.199,64.26v-0.102L88.13,64.12v0.05L88.199,64.26z M98.858,62.488l0.051-0.008
			l-0.051-0.094l-0.05,0.061L98.858,62.488z M86.564,64.282l0.068,0.18l0.172-0.183v-0.074l-0.068,0.048l-0.052,0.008
			 M85.995,64.462v-0.09l-0.069,0.011v0.09L85.995,64.462z M87.252,64.172v-0.039l-0.068,0.009L87.252,64.172z"/>
		<path class="disabled"  d="M113.506,62.218l-0.809,0.078l0.05-0.057l0.208-0.036l-0.154-0.127l-0.104,0.016l-0.103-0.032l-0.139,0.113l0.104,0.148
			l-1.328,0.212l-0.066-0.038l-0.052,0.06l-0.586,0.093v-0.204l-0.242,0.04l0.121,0.084l-0.051,0.106l-4.513,0.73l-0.139-0.222
			l-0.067,0.052v0.204l-1.188,0.19l0.31-0.101v-0.075l-0.19,0.104l0.069-0.11l-0.069-0.042l-0.119,0.123l-0.192,0.029l-0.05,0.111
			l-3.063,0.493l-0.07-0.038l-0.068,0.01v0.049l-0.243,0.038v-0.433l0.102-0.068l-0.102-0.069v-1.126l0.139-0.112v-0.19l-0.139,0.06
			v-0.319l0.139-0.02l0.777-0.188l-0.208,0.146l-0.241,0.041v0.47l-0.293,0.046v0.04l0.154,0.076l0.311-0.125v0.166l0.069-0.011
			l0.119-0.185l0.33-0.169v-0.14l-0.278,0.187l-0.31,0.048v-0.191l0.206-0.186l0.052,0.042l0.259,0.036l0.087-0.18l-0.157-0.014
			v-0.053l0.172-0.027l0.139,0.106l0.156-0.024l0.171-0.156l0.38-0.063l-0.294,0.136l-0.102,0.376l-0.154,0.101l-0.344,0.295
			l0.153,0.361l0.258-0.235l0.241,0.041v-0.208l-0.086-0.099l-0.121,0.096l-0.102,0.014v-0.038l0.29-0.162l0.072,0.054l0.05-0.15
			l0.119-0.096l0.087,0.102l0.051-0.085l0.193-0.182l0.256-0.043l0.258-0.131l0.361-0.056v-0.053l0.273-0.146v-0.062l0.502-0.006
			v0.14l0.138-0.022l0.102-0.298l0.585-0.092v0.231l-0.188,0.169v0.153l0.156-0.153l0.085,0.062l0.137-0.021l0.069-0.063
			l0.121-0.021l0.137-0.164l0.07-0.06v-0.151l-0.07,0.007l-0.137,0.126l-0.121-0.083v-0.075l3.668-0.593l0.087,0.102l0.139-0.113
			l0.309,0.18l0.241-0.166l0.07,0.04l0.122-0.018v-0.18l0.187-0.03v0.316l0.053-0.006l0.067,0.09l0.208-0.031l0.05,0.092
			l0.072,0.028l-0.26,0.092l0.17,0.086l0.142-0.148l0.205,0.016l0.172-0.027v-0.05h-0.242l-0.135-0.17l-0.381-0.23v-0.08l0.447-0.07
			v0.128l0.088,0.05l0.153-0.219l0.381-0.058l0.153,0.05l0.052-0.087l0.431-0.068l0.07,0.042l0.188-0.032v0.127l0.276-0.22
			l1.963-0.318l0.121,0.296l-0.121,0.022v0.151l0.242-0.14v-0.371l0.775-0.122l0.103,0.032l0.137-0.02v1.171l-0.171-0.124
			l-0.139,0.023l0.172,0.176l0.137,0.245 M104.206,61.357l0.05-0.01l-0.05,0.112l-0.156,0.026L104.206,61.357z M102.914,61.667
			L103,61.653l-0.087,0.144v0.141l-0.118,0.12l-0.139,0.022l-0.069-0.154l0.069-0.143l0.067,0.18L102.914,61.667z M103.241,61.615
			l0.26-0.044l-0.138,0.154l-0.071,0.11l-0.051,0.01V61.615z M103.743,61.533l0.067-0.008v0.022L103.743,61.533z M105.395,61.279
			l-0.241,0.156l0.069,0.038l0.172-0.027V61.279z M113.076,60.051l-0.275,0.25v0.089l0.223-0.177l0.276-0.198L113.076,60.051z
			 M114.868,60.339l-0.138-0.313v-0.242l-0.241,0.039l0.104,0.139l0.172,0.392L114.868,60.339z M109.701,60.647V60.7l0.069-0.012
			v-0.051L109.701,60.647z M104.449,61.841v-0.102l-0.069-0.078l-0.07,0.048v0.242l0.208-0.032L104.449,61.841z M105.068,61.551
			l-0.07,0.008v0.04l0.156-0.024L105.068,61.551z M103.622,61.921l0.122,0.162v0.102l0.225-0.317L103.622,61.921z M115.539,60.051
			l-0.241,0.218l-0.069-0.17l-0.122,0.201l0.052,0.041v0.089l0.07,0.026l0.12-0.156l0.259-0.16V60.04L115.539,60.051z
			 M101.95,62.295v0.036l0.069-0.01v-0.038L101.95,62.295z M109.838,61.06v0.039l0.05-0.087L109.838,61.06z M104.948,62.218
			l-0.087,0.016l0.137-0.241l-0.361-0.055l-0.069,0.113l-0.258,0.104v0.217l0.516-0.083v0.09l-0.189,0.109v0.125l0.122-0.018
			l0.24-0.243v-0.245L104.948,62.218z M103.622,62.409l-0.189-0.047l0.139-0.2l-0.139,0.023l-0.223,0.201l0.103,0.187l-0.174,0.232
			l0.104-0.018l0.191-0.132l0.189-0.092V62.409z M105.326,62.058v-0.18l-0.104,0.018v0.18l0.104,0.084l0.069-0.012v-0.053
			L105.326,62.058z M111.648,60.858l-0.105,0.155v0.114l-0.242-0.036l-0.103,0.168l0.275-0.042l0.277,0.082l-0.068-0.242
			l0.083-0.221L111.648,60.858z M102.898,62.348l-0.174,0.127l0.121,0.287l-0.121,0.108v0.052l0.241-0.04l-0.052-0.093v-0.343
			l0.122-0.019L102.898,62.348z M103.811,62.223l-0.24,0.079l0.24,0.102l0.172,0.263v-0.395l0.067-0.086v0.038H103.811z
			 M106.651,61.765l-0.051,0.05l0.12,0.068l0.105-0.146L106.651,61.765z M107.184,61.719v0.09l0.052-0.011v-0.127L107.184,61.719z
			 M112.523,60.817l-0.154,0.025l-0.188,0.108v0.102l-0.05,0.11l0.12-0.018v0.243l-0.089,0.166l0.277,0.313l0.069,0.117l0.172-0.154
			l-0.19-0.174l0.258-0.095v-0.074l-0.05-0.046v-0.124l0.05-0.06v-0.05l-0.05,0.007l-0.138,0.151v0.05l-0.121,0.21l-0.139-0.205
			l0.139-0.11l0.069-0.229l0.397,0.023L112.523,60.817z M110.87,61.11l-0.153,0.127l0.119,0.034l0.07,0.088l0.118-0.184
			L110.87,61.11z M101.71,62.603v0.037l0.067-0.011L101.71,62.603z M113.196,60.838v0.244l0.07-0.011v-0.053l0.067-0.103v-0.19
			L113.196,60.838z M105.636,62.005v0.052l0.067-0.013v-0.052L105.636,62.005z M112.87,60.838v0.052l0.085-0.066L112.87,60.838z
			 M114.918,60.51v0.05l0.069-0.062L114.918,60.51z M115.745,60.578v-0.126l-0.206,0.108l-0.07,0.154l-0.24,0.038v0.23l0.136-0.023
			l0.174-0.078l0.241-0.038v-0.178L115.745,60.578z M114.281,60.714v0.05l0.119-0.018v-0.052L114.281,60.714z M101.778,62.78
			l-0.138,0.075l0.07,0.142l0.224-0.126L101.778,62.78z M113.645,60.92v0.14l-0.189,0.08v0.23l0.31-0.395L113.645,60.92z
			 M114.935,60.71l-0.084,0.015l-0.085,0.101l-0.244,0.04l-0.067,0.063l0.139,0.08l0.172-0.093l0.085,0.053l-0.33,0.28l0.139,0.159
			l0.224,0.128l0.172-0.143l0.051-0.201l-0.051-0.082L115.107,61v0.051L114.935,60.71z M106.601,62.193l-0.188,0.085v0.076
			l0.307-0.048v-0.18L106.601,62.193z M112.87,61.232l0.085,0.04l0.121-0.02V61.2L112.87,61.232z M102.347,63.008l0.069-0.011
			v-0.024L102.347,63.008z M103.743,62.76v0.024l0.067,0.038v-0.051L103.743,62.76z M111.042,61.581v0.074l0.072-0.007v-0.079
			L111.042,61.581z M114.281,61.059v0.025l0.069-0.012v-0.024L114.281,61.059z M113.732,61.158l-0.087,0.079v0.052l-0.139,0.124
			v0.053l0.207-0.084l0.053,0.03l-0.053,0.096v0.052l-0.257,0.145v0.142l0.119-0.022l0.07-0.113l0.067-0.012l0.053,0.148l0.052-0.01
			v-0.625L113.732,61.158z M101.778,63.1l-0.067,0.064v0.046l-0.122,0.072v0.053l0.122,0.022l0.137-0.217v0.05L101.778,63.1z
			 M102.019,63.063l-0.069,0.112v0.142l0.069-0.011l0.07-0.205L102.019,63.063z M103.931,62.754v0.242l0.119-0.022v-0.243
			L103.931,62.754z M101.331,63.275l-0.241,0.267l0.172-0.029l0.139-0.25L101.331,63.275z M105.53,62.596l-0.083,0.334l0.189-0.351
			L105.53,62.596z M115.935,60.92l-0.119,0.018l0.119,0.364l0.139,0.066v-0.142L115.935,60.92z M104.913,62.772l-0.087,0.08
			l-0.067-0.08l-0.07,0.013v0.127l0.137,0.08l0.172-0.169L104.913,62.772z M114.213,61.248l-0.103,0.016l0.103,0.214l0.085-0.178
			L114.213,61.248z M115.451,61.086l-0.222,0.101v0.078l0.189-0.12l0.121-0.022L115.451,61.086z M112.87,61.592v0.243l0.154-0.024
			v-0.281L112.87,61.592z M106.392,63.059l-0.24,0.114l0.07-0.165l0.119-0.119l-0.049-0.03l-0.07-0.194l-0.052,0.008v0.204
			l-0.154,0.114v0.105l-0.07,0.125l0.154,0.09l0.241-0.041l0.139-0.123L106.392,63.059z M114.419,61.357l-0.069,0.2l0.05-0.006
			l0.121-0.123L114.419,61.357z M102.914,63.298l0.052-0.005v-0.05L102.914,63.298z M103.501,63.155v0.192l0.07-0.052v-0.153
			L103.501,63.155z M104.38,63.01l-0.157,0.168l-0.087-0.073l-0.085,0.011v0.206l0.398-0.142v-0.178L104.38,63.01z M101.588,63.513
			l-0.052,0.01v0.052l0.104,0.07l0.07-0.012v-0.036L101.588,63.513z M102.019,63.445v0.103l0.07,0.027l0.121-0.083L102.019,63.445z
			 M108.168,62.643l0.085-0.013v-0.138L108.168,62.643z M110.286,62.252v0.05l0.07-0.063v-0.086L110.286,62.252z M112.251,61.845
			v0.05l0.067,0.031v-0.041L112.251,61.845z M113.111,61.783l-0.156,0.143l0.069,0.037l0.242-0.037v-0.052L113.111,61.783z
			 M104.568,63.173v0.052l0.069,0.041v-0.102L104.568,63.173z M114.454,62.142l0.067-0.063v-0.128l-0.067-0.093v-0.125l0.067-0.062
			l0.072,0.039v0.129l0.137-0.021l0.035-0.135l-0.172-0.126l-0.139,0.02l-0.054,0.061l-0.188,0.03v0.335l0.223,0.038l-0.292,0.15
			 M108.548,62.556l-0.192,0.108l0.104,0.201l0.172-0.154v-0.088L108.548,62.556z M102.089,63.726v0.04l0.067-0.013v-0.086
			L102.089,63.726z M115.298,61.544l-0.069,0.103l0.069,0.025l0.067-0.137L115.298,61.544z M103.948,63.399l-0.069,0.166
			l0.052-0.006l0.052-0.06l0.153-0.066L103.948,63.399z M115.057,61.673l-0.105-0.032l0.105,0.274l0.051-0.11L115.057,61.673z
			 M100.9,63.917v0.079l0.035-0.006v-0.076L100.9,63.917z M101.848,63.766v0.18l0.07-0.013v-0.102L101.848,63.766z M103.622,63.481
			v0.176l0.122-0.018V63.46L103.622,63.481z M113.851,62.211l-0.085-0.046l-0.088-0.208l-0.103-0.045l-0.069,0.008l0.069,0.133
			v0.139 M112.131,62.337l0.12-0.021v-0.15L112.131,62.337z M113.904,61.897v0.102l0.067,0.042v-0.052L113.904,61.897z
			 M103.241,63.669l-0.049,0.006l0.049,0.095l0.051-0.06L103.241,63.669z M115.539,61.877l-0.07-0.18l-0.171,0.18v0.078l0.067-0.052
			l0.053-0.008 M116.107,61.697v0.085l0.069-0.007v-0.091L116.107,61.697z M114.851,61.988v0.04l0.067-0.012L114.851,61.988z"/>
		<path class="disabled"  d="M76.766,90.506l-0.393,0.063l-0.46-1.204l-0.238,0.44v0.874l-0.375,0.06v-2.617l0.375-0.06v1.047l0.61-1.143L76.7,87.9
			l-0.537,1.003L76.766,90.506z"/>
		<path class="disabled"  d="M78.54,89.444c0,0.187-0.034,0.348-0.101,0.475c-0.063,0.117-0.151,0.219-0.266,0.306c-0.115,0.09-0.233,0.14-0.356,0.162
			c-0.127,0.02-0.248,0.006-0.369-0.042c-0.118-0.049-0.209-0.123-0.272-0.224c-0.066-0.108-0.101-0.255-0.101-0.441V87.84
			l0.375-0.06v1.881c0,0.127,0.035,0.223,0.103,0.288c0.066,0.063,0.157,0.087,0.265,0.069c0.103-0.014,0.183-0.066,0.249-0.152
			c0.066-0.09,0.1-0.194,0.1-0.317v-1.884l0.375-0.057V89.444z"/>
		<path class="disabled"  d="M80.434,89.922l-0.378,0.061l-0.181-0.685l-0.558,0.09l-0.177,0.74l-0.375,0.061l0.652-2.724l0.367-0.056L80.434,89.922z
			 M79.785,88.942l-0.191-0.721l-0.184,0.784L79.785,88.942z"/>
		<path class="disabled"  d="M82.053,89.666l-1.325,0.211v-2.618l0.371-0.06v2.25l0.954-0.152V89.666z"/>
		<path class="disabled"  d="M84.022,89.355l-0.379,0.059l-0.182-0.689l-0.56,0.09l-0.174,0.743l-0.374,0.06l0.65-2.721l0.364-0.058L84.022,89.355z
			 M83.368,88.372l-0.188-0.724l-0.184,0.784L83.368,88.372z"/>
		<path class="disabled"  d="M102.995,86.5l-1.332,0.208v-2.621l0.377-0.06v2.254l0.955-0.15V86.5z"/>
		<path class="disabled"  d="M104.838,85.423c0,0.19-0.035,0.349-0.101,0.477c-0.062,0.118-0.151,0.218-0.266,0.308
			c-0.115,0.088-0.236,0.143-0.357,0.161c-0.126,0.02-0.251,0.006-0.371-0.042c-0.116-0.05-0.208-0.125-0.266-0.224
			c-0.072-0.112-0.104-0.259-0.104-0.447v-1.84l0.375-0.06v1.888c0,0.126,0.032,0.22,0.101,0.285
			c0.067,0.066,0.154,0.09,0.265,0.072c0.101-0.016,0.185-0.068,0.248-0.156c0.066-0.086,0.097-0.19,0.097-0.314v-1.889l0.38-0.06
			V85.423z"/>
		<path class="disabled"  d="M106.935,85.872l-0.377,0.062v-1.476l-0.485,1.549l-0.488-1.393v1.472l-0.372,0.06v-2.625l0.372-0.059l0.488,1.394
			l0.485-1.549l0.377-0.061V85.872z"/>
		<path class="disabled"  d="M108.083,84.456l-0.362,0.056v1.233l-0.373,0.062v-2.626l0.78-0.124c0.206-0.032,0.369,0.004,0.498,0.112
			c0.126,0.11,0.189,0.27,0.189,0.481c-0.004,0.188-0.065,0.359-0.186,0.515C108.508,84.322,108.325,84.416,108.083,84.456z
			 M108.447,83.695c0-0.098-0.031-0.17-0.092-0.219c-0.063-0.048-0.147-0.062-0.249-0.048l-0.385,0.06v0.649l0.385-0.063
			c0.094-0.016,0.175-0.06,0.241-0.132C108.415,83.869,108.447,83.789,108.447,83.695z"/>
		<path class="disabled"  d="M110.629,84.5c0,0.193-0.036,0.351-0.102,0.481c-0.065,0.116-0.152,0.22-0.27,0.307c-0.115,0.085-0.232,0.142-0.356,0.162
			c-0.126,0.018-0.25,0.006-0.367-0.044c-0.118-0.05-0.208-0.124-0.273-0.223c-0.066-0.11-0.1-0.259-0.1-0.448v-1.84l0.373-0.063
			v1.891c0,0.126,0.035,0.22,0.102,0.287c0.069,0.063,0.157,0.087,0.265,0.069c0.101-0.016,0.185-0.066,0.248-0.154
			c0.066-0.09,0.1-0.194,0.1-0.315V82.72l0.38-0.06V84.5z"/>
		<path class="disabled"  d="M112.437,84.997l-0.383,0.063l-0.345-1.183l-0.362,0.056v1.237l-0.374,0.061v-2.63l0.781-0.122
			c0.203-0.031,0.369,0.004,0.498,0.114c0.124,0.108,0.186,0.267,0.186,0.479c0,0.139-0.031,0.272-0.101,0.406
			c-0.067,0.133-0.16,0.229-0.275,0.289L112.437,84.997z M112.072,83.118c0-0.099-0.029-0.171-0.093-0.218
			c-0.062-0.05-0.144-0.064-0.247-0.05l-0.386,0.064v0.647l0.386-0.064c0.095-0.015,0.174-0.058,0.241-0.13
			C112.04,83.291,112.072,83.211,112.072,83.118z"/>
	</g>
	<g>
		<path class="disabled"  d="M339.353,172.675c0.417-0.087,1.075-0.153,1.744-0.153c0.954,0,1.569,0.165,2.029,0.538
			c0.385,0.285,0.615,0.724,0.615,1.305c0,0.713-0.473,1.339-1.251,1.624v0.022c0.702,0.175,1.524,0.757,1.524,1.854
			c0,0.636-0.252,1.119-0.625,1.481c-0.516,0.472-1.35,0.691-2.557,0.691c-0.658,0-1.162-0.044-1.48-0.088V172.675z
			 M340.307,175.703h0.867c1.009,0,1.602-0.527,1.602-1.24c0-0.867-0.658-1.207-1.624-1.207c-0.438,0-0.691,0.033-0.845,0.066
			V175.703z M340.307,179.247c0.187,0.033,0.461,0.044,0.801,0.044c0.987,0,1.898-0.362,1.898-1.437c0-1.01-0.867-1.426-1.909-1.426
			h-0.79V179.247z"/>
		<path class="disabled"  d="M346.878,173.394h-2.249v-0.812h5.475v0.812h-2.261v6.583h-0.965V173.394z"/>
		<path class="disabled"  d="M352.001,173.613h-0.021l-1.24,0.669l-0.187-0.735l1.559-0.834h0.822v7.131h-0.933V173.613z"/>
	</g>
	<g>
		<path class="disabled"  d="M360.846,172.579c0.417-0.087,1.075-0.153,1.744-0.153c0.954,0,1.569,0.165,2.029,0.538
			c0.385,0.285,0.615,0.724,0.615,1.305c0,0.713-0.473,1.339-1.251,1.624v0.022c0.702,0.175,1.524,0.757,1.524,1.854
			c0,0.636-0.252,1.119-0.625,1.481c-0.516,0.472-1.35,0.691-2.557,0.691c-0.658,0-1.162-0.044-1.48-0.088V172.579z M361.8,175.607
			h0.867c1.009,0,1.602-0.527,1.602-1.24c0-0.867-0.658-1.207-1.624-1.207c-0.438,0-0.691,0.033-0.845,0.066V175.607z M361.8,179.15
			c0.187,0.033,0.461,0.044,0.801,0.044c0.987,0,1.898-0.362,1.898-1.437c0-1.01-0.867-1.426-1.909-1.426h-0.79V179.15z"/>
		<path class="disabled"  d="M368.371,173.298h-2.249v-0.813h5.475v0.813h-2.261v6.582h-0.965V173.298z"/>
		<path class="disabled"  d="M372.208,179.809v-0.592l0.757-0.735c1.821-1.733,2.644-2.655,2.654-3.73c0-0.724-0.351-1.394-1.415-1.394
			c-0.647,0-1.185,0.329-1.514,0.604l-0.308-0.68c0.494-0.417,1.196-0.725,2.019-0.725c1.536,0,2.184,1.054,2.184,2.074
			c0,1.316-0.954,2.38-2.457,3.828l-0.571,0.527v0.021h3.204v0.801H372.208z"/>
	</g>
	<g>
		<path class="disabled"  d="M384.506,172.578c0.417-0.087,1.075-0.153,1.744-0.153c0.954,0,1.569,0.165,2.029,0.538
			c0.385,0.285,0.615,0.724,0.615,1.305c0,0.714-0.473,1.339-1.251,1.624v0.022c0.702,0.175,1.524,0.757,1.524,1.854
			c0,0.637-0.252,1.119-0.625,1.481c-0.516,0.472-1.35,0.691-2.557,0.691c-0.658,0-1.162-0.044-1.48-0.088V172.578z M385.46,175.606
			h0.867c1.009,0,1.602-0.526,1.602-1.239c0-0.867-0.658-1.207-1.624-1.207c-0.438,0-0.691,0.033-0.845,0.065V175.606z
			 M385.46,179.15c0.187,0.032,0.461,0.044,0.801,0.044c0.987,0,1.898-0.362,1.898-1.438c0-1.01-0.867-1.426-1.909-1.426h-0.79
			V179.15z"/>
		<path class="disabled"  d="M392.031,173.298h-2.249v-0.813h5.475v0.813h-2.261v6.582h-0.965V173.298z"/>
		<path class="disabled"  d="M395.52,178.641c0.274,0.175,0.911,0.449,1.58,0.449c1.24,0,1.624-0.79,1.613-1.382c-0.012-0.999-0.911-1.427-1.844-1.427
			h-0.537v-0.724h0.537c0.702,0,1.591-0.362,1.591-1.207c0-0.57-0.361-1.075-1.25-1.075c-0.571,0-1.119,0.252-1.427,0.472
			l-0.252-0.702c0.373-0.274,1.097-0.549,1.865-0.549c1.404,0,2.04,0.834,2.04,1.701c0,0.734-0.438,1.36-1.316,1.679v0.021
			c0.878,0.176,1.591,0.834,1.591,1.832c0,1.142-0.889,2.14-2.601,2.14c-0.801,0-1.503-0.253-1.854-0.482L395.52,178.641z"/>
	</g>
	<g>
		<path class="disabled"  d="M408.094,172.579c0.417-0.088,1.075-0.153,1.744-0.153c0.954,0,1.569,0.164,2.029,0.537
			c0.385,0.285,0.615,0.725,0.615,1.305c0,0.714-0.473,1.34-1.251,1.625v0.021c0.702,0.176,1.524,0.757,1.524,1.854
			c0,0.637-0.252,1.12-0.625,1.482c-0.516,0.472-1.35,0.69-2.557,0.69c-0.658,0-1.162-0.044-1.48-0.087V172.579z M409.048,175.607
			h0.867c1.009,0,1.602-0.527,1.602-1.24c0-0.867-0.658-1.207-1.624-1.207c-0.438,0-0.691,0.033-0.845,0.066V175.607z
			 M409.048,179.151c0.187,0.032,0.461,0.043,0.801,0.043c0.987,0,1.898-0.361,1.898-1.437c0-1.01-0.867-1.427-1.909-1.427h-0.79
			V179.151z"/>
		<path class="disabled"  d="M415.619,173.297h-2.249v-0.812h5.475v0.812h-2.261v6.583h-0.965V173.297z"/>
		<path class="disabled"  d="M421.306,179.748v-1.941h-3.313v-0.637l3.181-4.553h1.043v4.432h0.998v0.758h-0.998v1.941H421.306z M421.306,177.049
			v-2.381c0-0.372,0.012-0.745,0.033-1.118h-0.033c-0.219,0.416-0.395,0.724-0.592,1.053l-1.745,2.425v0.021H421.306z"/>
	</g>
	<g>
		<path class="disabled"  d="M430.723,172.579c0.417-0.088,1.075-0.153,1.744-0.153c0.954,0,1.569,0.164,2.029,0.537
			c0.385,0.285,0.615,0.725,0.615,1.306c0,0.713-0.473,1.339-1.251,1.624v0.021c0.702,0.176,1.524,0.758,1.524,1.854
			c0,0.637-0.252,1.119-0.625,1.481c-0.516,0.472-1.35,0.69-2.557,0.69c-0.658,0-1.162-0.044-1.48-0.087V172.579z M431.677,175.607
			h0.867c1.009,0,1.602-0.526,1.602-1.24c0-0.866-0.658-1.206-1.624-1.206c-0.438,0-0.691,0.032-0.845,0.065V175.607z
			 M431.677,179.151c0.187,0.032,0.461,0.043,0.801,0.043c0.987,0,1.898-0.361,1.898-1.437c0-1.01-0.867-1.427-1.909-1.427h-0.79
			V179.151z"/>
		<path class="disabled"  d="M438.248,173.297h-2.249v-0.812h5.475v0.812h-2.261v6.583h-0.965V173.297z"/>
		<path class="disabled"  d="M445.596,173.368h-2.721l-0.273,1.832c0.164-0.021,0.317-0.044,0.581-0.044c0.549,0,1.097,0.121,1.536,0.384
			c0.56,0.318,1.021,0.933,1.021,1.833c0,1.393-1.108,2.436-2.655,2.436c-0.779,0-1.438-0.22-1.777-0.439l0.241-0.735
			c0.296,0.176,0.878,0.396,1.525,0.396c0.91,0,1.689-0.593,1.689-1.547c-0.012-0.922-0.626-1.58-2.052-1.58
			c-0.406,0-0.725,0.044-0.987,0.077l0.461-3.423h3.411V173.368z"/>
	</g>
	<g>
		<path class="disabled"  d="M453.829,172.579c0.417-0.088,1.075-0.153,1.744-0.153c0.954,0,1.569,0.164,2.029,0.537
			c0.385,0.285,0.615,0.725,0.615,1.306c0,0.713-0.473,1.339-1.251,1.624v0.021c0.702,0.176,1.524,0.758,1.524,1.854
			c0,0.637-0.252,1.119-0.625,1.481c-0.516,0.472-1.35,0.69-2.557,0.69c-0.658,0-1.162-0.044-1.48-0.087V172.579z M454.783,175.607
			h0.867c1.009,0,1.602-0.526,1.602-1.24c0-0.866-0.658-1.206-1.624-1.206c-0.438,0-0.691,0.032-0.845,0.065V175.607z
			 M454.783,179.151c0.187,0.032,0.461,0.043,0.801,0.043c0.987,0,1.898-0.361,1.898-1.437c0-1.01-0.867-1.427-1.909-1.427h-0.79
			V179.151z"/>
		<path class="disabled"  d="M461.354,173.297h-2.249v-0.812h5.475v0.812h-2.261v6.583h-0.965V173.297z"/>
		<path class="disabled"  d="M468.771,173.292c-0.198-0.011-0.45,0-0.725,0.044c-1.514,0.253-2.314,1.36-2.479,2.534h0.033
			c0.34-0.449,0.933-0.822,1.723-0.822c1.262,0,2.149,0.91,2.149,2.304c0,1.306-0.888,2.513-2.369,2.513
			c-1.525,0-2.523-1.186-2.523-3.039c0-1.404,0.505-2.513,1.207-3.215c0.592-0.581,1.382-0.943,2.281-1.054
			c0.286-0.043,0.527-0.055,0.703-0.055V173.292z M468.497,177.406c0-1.021-0.582-1.635-1.471-1.635
			c-0.581,0-1.119,0.362-1.382,0.878c-0.066,0.109-0.11,0.252-0.11,0.428c0.022,1.174,0.56,2.041,1.569,2.041
			C467.938,179.118,468.497,178.426,468.497,177.406z"/>
	</g>
	<g>
		<path class="disabled"  d="M476.556,172.579c0.417-0.088,1.075-0.153,1.744-0.153c0.954,0,1.569,0.164,2.029,0.537
			c0.385,0.285,0.615,0.725,0.615,1.306c0,0.713-0.473,1.339-1.251,1.624v0.021c0.702,0.176,1.524,0.758,1.524,1.854
			c0,0.637-0.252,1.119-0.625,1.481c-0.516,0.472-1.35,0.69-2.557,0.69c-0.658,0-1.162-0.044-1.48-0.087V172.579z M477.51,175.607
			h0.867c1.009,0,1.602-0.526,1.602-1.24c0-0.866-0.658-1.206-1.624-1.206c-0.438,0-0.691,0.032-0.845,0.065V175.607z
			 M477.51,179.151c0.187,0.032,0.461,0.043,0.801,0.043c0.987,0,1.898-0.361,1.898-1.437c0-1.01-0.867-1.427-1.909-1.427h-0.79
			V179.151z"/>
		<path class="disabled"  d="M484.081,173.297h-2.249v-0.812h5.475v0.812h-2.261v6.583h-0.965V173.297z"/>
		<path class="disabled"  d="M492.805,172.617v0.636l-3.104,6.495h-0.998l3.094-6.309v-0.021h-3.489v-0.801H492.805z"/>
	</g>
	<g>
		<path class="disabled"  d="M500.063,172.579c0.417-0.088,1.075-0.153,1.744-0.153c0.954,0,1.569,0.164,2.029,0.537
			c0.385,0.285,0.615,0.725,0.615,1.306c0,0.713-0.473,1.339-1.251,1.624v0.021c0.702,0.176,1.524,0.758,1.524,1.854
			c0,0.637-0.252,1.119-0.625,1.481c-0.516,0.472-1.35,0.69-2.557,0.69c-0.658,0-1.162-0.044-1.48-0.087V172.579z M501.018,175.607
			h0.867c1.009,0,1.602-0.526,1.602-1.24c0-0.866-0.658-1.206-1.624-1.206c-0.438,0-0.691,0.032-0.845,0.065V175.607z
			 M501.018,179.151c0.187,0.032,0.461,0.043,0.801,0.043c0.987,0,1.898-0.361,1.898-1.437c0-1.01-0.867-1.427-1.909-1.427h-0.79
			V179.151z"/>
		<path class="disabled"  d="M507.589,173.297h-2.249v-0.812h5.475v0.812h-2.261v6.583h-0.965V173.297z"/>
		<path class="disabled"  d="M510.773,177.938c0-0.899,0.537-1.535,1.415-1.908l-0.011-0.033c-0.79-0.373-1.13-0.987-1.13-1.602
			c0-1.131,0.954-1.898,2.205-1.898c1.382,0,2.073,0.867,2.073,1.756c0,0.603-0.296,1.25-1.174,1.667v0.033
			c0.889,0.351,1.438,0.977,1.438,1.843c0,1.24-1.064,2.074-2.425,2.074C511.673,179.869,510.773,178.98,510.773,177.938z
			 M511.958,174.328c0,0.713,0.537,1.098,1.36,1.316c0.614-0.208,1.086-0.646,1.086-1.294c0-0.57-0.34-1.163-1.207-1.163
			C512.396,173.188,511.958,173.714,511.958,174.328z M514.613,177.894c0-0.866-0.604-1.283-1.569-1.558
			c-0.834,0.241-1.283,0.79-1.283,1.471c-0.033,0.724,0.516,1.36,1.426,1.36C514.054,179.167,514.613,178.629,514.613,177.894z"/>
	</g>
	<g>
		<path class="disabled"  d="M522.991,172.579c0.417-0.088,1.075-0.153,1.744-0.153c0.954,0,1.569,0.164,2.029,0.537
			c0.385,0.285,0.615,0.725,0.615,1.306c0,0.713-0.473,1.339-1.251,1.624v0.021c0.702,0.176,1.524,0.758,1.524,1.854
			c0,0.637-0.252,1.119-0.625,1.481c-0.516,0.472-1.35,0.69-2.557,0.69c-0.658,0-1.162-0.044-1.48-0.087V172.579z M523.945,175.607
			h0.867c1.009,0,1.602-0.526,1.602-1.24c0-0.866-0.658-1.206-1.624-1.206c-0.438,0-0.691,0.032-0.845,0.065V175.607z
			 M523.945,179.151c0.187,0.032,0.461,0.043,0.801,0.043c0.987,0,1.898-0.361,1.898-1.437c0-1.01-0.867-1.427-1.909-1.427h-0.79
			V179.151z"/>
		<path class="disabled"  d="M530.517,173.297h-2.249v-0.812h5.475v0.812h-2.261v6.583h-0.965V173.297z"/>
		<path class="disabled"  d="M534.345,179.071c0.209,0.022,0.45,0,0.779-0.032c0.56-0.077,1.086-0.308,1.492-0.691
			c0.472-0.428,0.812-1.053,0.943-1.898h-0.033c-0.395,0.483-0.965,0.769-1.678,0.769c-1.284,0-2.106-0.966-2.106-2.184
			c0-1.35,0.976-2.534,2.436-2.534c1.459,0,2.358,1.185,2.358,3.006c0,1.569-0.526,2.666-1.229,3.347
			c-0.549,0.537-1.306,0.866-2.074,0.954c-0.351,0.055-0.658,0.066-0.889,0.055V179.071z M534.696,174.969
			c0,0.889,0.537,1.514,1.371,1.514c0.647,0,1.152-0.318,1.404-0.746c0.055-0.088,0.088-0.197,0.088-0.351
			c0-1.218-0.449-2.15-1.459-2.15C535.277,173.235,534.696,173.959,534.696,174.969z"/>
	</g>
	<g>
		<path class="disabled"  d="M544.753,172.579c0.418-0.088,1.076-0.153,1.744-0.153c0.955,0,1.57,0.164,2.029,0.537
			c0.385,0.285,0.615,0.725,0.615,1.306c0,0.713-0.473,1.339-1.25,1.624v0.021c0.701,0.176,1.523,0.758,1.523,1.854
			c0,0.637-0.252,1.119-0.625,1.481c-0.516,0.472-1.35,0.69-2.557,0.69c-0.658,0-1.162-0.044-1.48-0.087V172.579z M545.708,175.607
			h0.867c1.008,0,1.602-0.526,1.602-1.24c0-0.866-0.658-1.206-1.625-1.206c-0.438,0-0.691,0.032-0.844,0.065V175.607z
			 M545.708,179.151c0.186,0.032,0.461,0.043,0.801,0.043c0.986,0,1.898-0.361,1.898-1.437c0-1.01-0.867-1.427-1.91-1.427h-0.789
			V179.151z"/>
		<path class="disabled"  d="M552.278,173.297h-2.248v-0.812h5.475v0.812h-2.262v6.583h-0.965V173.297z"/>
		<g>
			<path class="disabled"  d="M557.317,173.517h-0.021l-1.24,0.669l-0.186-0.735l1.559-0.833h0.822v7.131h-0.934V173.517z"/>
			<path class="disabled"  d="M565.864,176.105c0,2.425-0.9,3.764-2.48,3.764c-1.393,0-2.336-1.306-2.359-3.665c0-2.392,1.031-3.708,2.48-3.708
				C565.009,172.496,565.864,173.835,565.864,176.105z M561.991,176.216c0,1.854,0.57,2.907,1.447,2.907
				c0.988,0,1.459-1.152,1.459-2.974c0-1.755-0.449-2.907-1.447-2.907C562.604,173.242,561.991,174.273,561.991,176.216z"/>
		</g>
	</g>
</g>
</svg>';
        
    }
    
    function loadMapByDate(){
        
        var_dump($_POST);
        
        echo '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="821.845px" height="577.171px" viewBox="0 0 821.845 577.171" enable-background="new 0 0 821.845 577.171" xml:space="preserve">
	
</svg>';
        
    }
            
    function get_table_stat($tblNO, $date){
        
        $data['tbl_id'] = $tblNO;
        $data['date'] = $date;
        
        $result = $this->reservation->getBookedInfo($data);
        
        return $result;
        
    }
    
    function welcome(){
        $this->load->view('welcome');
    }
    
}
